/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.interlis.ili2c.generator.Interlis1Generator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.Ili1Format;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.EnumCodeMapper;
import ch.interlis.iom_j.itf.ItfStartTransferEvent;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfRawWriter;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import ch.interlis.iox_j.StartTransferEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ItfWriter
implements IoxWriter {
    private String modelName = null;
    private String topicName = null;
    private String className = null;
    private ArrayList itftablev = null;
    private int currentItfTable = -1;
    private TransferDescription td = null;
    private HashMap tag2class = null;
    private int state = 0;
    private ItfStartTransferEvent itfStart = null;
    private char blankCode = (char)95;
    private ItfRawWriter out = null;
    OutputStream outStream = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private HashMap<Integer, DecimalFormat> numFmt = new HashMap();
    private HashMap typeCache = new HashMap();
    private EnumCodeMapper enumTypes = new EnumCodeMapper();

    public ItfWriter(OutputStream out, TransferDescription td) throws IoxException {
        this.td = td;
        Ili1Format format = td.getIli1Format();
        try {
            this.out = new ItfRawWriter(out, format);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
        try {
            this.blankCode = format == null ? ModelUtilities.code2string(95).charAt(0) : ModelUtilities.code2string(format.blankCode).charAt(0);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public ItfWriter(File outFile, TransferDescription td) throws IoxException {
        try {
            this.outStream = new FileOutputStream(outFile);
        }
        catch (FileNotFoundException ex) {
            throw new IoxException((Throwable)ex);
        }
        this.td = td;
        Ili1Format format = td.getIli1Format();
        try {
            this.out = new ItfRawWriter(this.outStream, format);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
        try {
            this.blankCode = format == null ? ModelUtilities.code2string(95).charAt(0) : ModelUtilities.code2string(td.getIli1Format().blankCode).charAt(0);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public void close() throws IoxException {
        this.flush();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.outStream = null;
        }
        this.td = null;
        this.state = 0;
        this.tag2class = null;
        this.itfStart = null;
    }

    public void flush() throws IoxException {
        if (this.out != null) {
            this.out.flush();
        }
        if (this.outStream != null) {
            try {
                this.outStream.flush();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
        }
    }

    public void write(IoxEvent event) throws IoxException {
        if (event instanceof StartTransferEvent) {
            if (this.state != 0) {
                throw new IllegalStateException();
            }
            StartTransferEvent e = (StartTransferEvent)event;
            try {
                this.out.writeRawText("SCNT");
                this.out.writeNewline();
                this.out.writeExplanation(e.getComment());
                this.out.writeRawText("////");
                this.out.writeNewline();
            }
            catch (IOException ex) {
                throw new IoxException("failed to write SCNT section", (Throwable)ex);
            }
            if (event instanceof ItfStartTransferEvent) {
                this.itfStart = (ItfStartTransferEvent)event;
            }
            this.state = 19;
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent e = (StartBasketEvent)event;
            if (this.state == 19) {
                String[] model;
                if (this.itfStart != null) {
                    if (this.itfStart.getModelDefinition() != null) {
                        try {
                            this.out.writeRawText("MOTR");
                            this.out.writeNewline();
                            this.out.writeExplanation(this.itfStart.getModelDefinition());
                            this.out.writeRawText("////");
                            this.out.writeNewline();
                        }
                        catch (IOException ex) {
                            throw new IoxException("failed to write MOTR section", (Throwable)ex);
                        }
                    } else if (this.itfStart.getModelId() != null) {
                        try {
                            this.out.writeRawText("MTID ");
                            this.out.writeRawText(this.itfStart.getModelId());
                            this.out.writeNewline();
                        }
                        catch (IOException ex) {
                            throw new IoxException("failed to write MTID line", (Throwable)ex);
                        }
                    } else {
                        throw new IllegalArgumentException();
                    }
                    model = e.getType().split("\\.");
                    this.modelName = model[0];
                    try {
                        this.out.writeRawText("MODL ");
                        this.out.writeRawText(this.modelName);
                        this.out.writeNewline();
                    }
                    catch (IOException ex) {
                        throw new IoxException("failed to write MODL line", (Throwable)ex);
                    }
                }
                model = e.getType().split("\\.");
                this.modelName = model[0];
                try {
                    this.out.writeRawText("MTID ");
                    String tdName = this.td.getName();
                    if (tdName == null) {
                        tdName = this.modelName;
                    }
                    this.out.writeRawText(tdName);
                    this.out.writeNewline();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to write MTID line", (Throwable)ex);
                }
                try {
                    this.out.writeRawText("MODL ");
                    this.out.writeRawText(this.modelName);
                    this.out.writeNewline();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to write MODL line", (Throwable)ex);
                }
                this.state = 20;
            }
            if (this.state != 20) {
                throw new IllegalStateException();
            }
            String[] topic = e.getType().split("\\.");
            if (!topic[0].equals(this.modelName)) {
                EhiLogger.logAdaption((String)("unexpected model name <" + topic[0] + ">; ignored"));
            }
            this.topicName = topic[1];
            try {
                this.out.writeRawText("TOPI ");
                this.out.writeRawText(this.topicName);
                this.out.writeNewline();
            }
            catch (IOException ex) {
                throw new IoxException("failed to write TOPI line", (Throwable)ex);
            }
            this.itftablev = ModelUtilities.getItfTables(this.td, this.modelName, this.topicName);
            this.currentItfTable = -1;
            this.className = null;
            this.state = 30;
        } else if (event instanceof ObjectEvent) {
            if (this.state != 30) {
                throw new IllegalStateException();
            }
            ObjectEvent e = (ObjectEvent)event;
            String[] classv = e.getIomObject().getobjecttag().split("\\.");
            if (!classv[0].equals(this.modelName)) {
                EhiLogger.logAdaption((String)("unexpected model name <" + classv[0] + ">; ignored"));
            }
            if (!classv[1].equals(this.topicName)) {
                EhiLogger.logAdaption((String)("unexpected topic name <" + classv[1] + ">; ignored"));
            }
            String nextClassName = classv[2];
            if (this.className == null || !this.className.equals(nextClassName)) {
                int nextTableIdx;
                if (this.className != null) {
                    try {
                        this.out.writeRawText("ETAB");
                        this.out.writeNewline();
                    }
                    catch (IOException ex) {
                        throw new IoxException("failed to write ETAB line", (Throwable)ex);
                    }
                }
                if ((nextTableIdx = this.findItfTable(nextClassName)) == -1) {
                    throw new IoxException("unknown ITF table " + nextClassName);
                }
                if (nextTableIdx < this.currentItfTable) {
                    throw new IoxException("ITF table " + nextClassName + " already done; wrong order of objetcs");
                }
                while (this.currentItfTable + 1 < nextTableIdx) {
                    ++this.currentItfTable;
                    Element tabo = (Element)this.itftablev.get(this.currentItfTable);
                    if (tabo instanceof AttributeDef) {
                        AttributeDef geomattr = (AttributeDef)tabo;
                        Viewable aclass = (Viewable)geomattr.getContainer();
                        if (aclass instanceof Table && ((Table)aclass).isIli1Optional()) continue;
                        this.writeEmptyTable((Element)geomattr);
                        continue;
                    }
                    if (tabo instanceof Table && ((Table)tabo).isIli1Optional()) continue;
                    this.writeEmptyTable(tabo);
                }
                ++this.currentItfTable;
                this.className = nextClassName;
                try {
                    this.out.writeRawText("TABL ");
                    this.out.writeRawText(this.className);
                    this.out.writeNewline();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to write TABL line", (Throwable)ex);
                }
            }
            this.writeObject(e.getIomObject());
        } else if (event instanceof EndBasketEvent) {
            if (this.state != 30) {
                throw new IllegalStateException();
            }
            if (this.className != null) {
                try {
                    this.out.writeRawText("ETAB");
                    this.out.writeNewline();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to write ETAB line", (Throwable)ex);
                }
                ++this.currentItfTable;
            }
            while (this.currentItfTable < this.itftablev.size()) {
                Element tabo;
                if (this.currentItfTable == -1) {
                    this.currentItfTable = 0;
                }
                if ((tabo = (Element)this.itftablev.get(this.currentItfTable)) instanceof AttributeDef) {
                    AttributeDef geomattr = (AttributeDef)tabo;
                    Viewable aclass = (Viewable)geomattr.getContainer();
                    if (!(aclass instanceof Table) || !((Table)aclass).isIli1Optional()) {
                        this.writeEmptyTable((Element)geomattr);
                    }
                } else if (!(tabo instanceof Table) || !((Table)tabo).isIli1Optional()) {
                    this.writeEmptyTable(tabo);
                }
                ++this.currentItfTable;
            }
            try {
                this.out.writeRawText("ETOP");
                this.out.writeNewline();
            }
            catch (IOException ex) {
                throw new IoxException("failed to write ETOP line", (Throwable)ex);
            }
            this.state = 20;
        } else if (event instanceof EndTransferEvent) {
            if (this.state != 19 && this.state != 20) {
                throw new IllegalStateException();
            }
            if (this.state == 20) {
                try {
                    this.out.writeRawText("EMOD");
                    this.out.writeNewline();
                }
                catch (IOException ex) {
                    throw new IoxException("failed to write EMOD line", (Throwable)ex);
                }
            }
            try {
                this.out.writeRawText("ENDE");
                this.out.writeNewline();
            }
            catch (IOException ex) {
                throw new IoxException("failed to write ENDE line", (Throwable)ex);
            }
        }
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    private void writeEmptyTable(Element tabo) throws IoxException {
        String tabName = this.getItfTableName(tabo);
        try {
            this.out.writeRawText("TABL ");
            this.out.writeRawText(tabName);
            this.out.writeNewline();
            this.out.writeRawText("ETAB");
            this.out.writeNewline();
        }
        catch (IOException ex) {
            throw new IoxException("failed to write empty table " + tabName, (Throwable)ex);
        }
    }

    private String getItfTableName(Element tabo) {
        String tabName;
        if (tabo instanceof AttributeDef) {
            AttributeDef geomattr = (AttributeDef)tabo;
            Viewable aclass = (Viewable)geomattr.getContainer();
            tabName = aclass.getName() + "_" + geomattr.getName();
        } else {
            tabName = tabo.getName();
        }
        return tabName;
    }

    private int findItfTable(String tabName) {
        int tabc = this.itftablev.size();
        for (int tabi = 0; tabi < tabc; ++tabi) {
            Element tabo = (Element)this.itftablev.get(tabi);
            String eleName = this.getItfTableName(tabo);
            if (!eleName.equals(tabName)) continue;
            return tabi;
        }
        return -1;
    }

    private void writeObject(IomObject iomObj) throws IoxException {
        block20: {
            try {
                if (this.td != null) {
                    AbstractClassDef aclass;
                    String iliQName = iomObj.getobjecttag();
                    if (this.tag2class == null) {
                        this.tag2class = ModelUtilities.getTagMap(this.td);
                    }
                    if (!this.tag2class.containsKey(iliQName)) {
                        throw new IoxException("unknown class <" + iliQName + ">");
                    }
                    this.out.writeRawText("OBJE");
                    this.out.writeTid(iomObj.getobjectoid());
                    Object aclassObj = this.tag2class.get(iliQName);
                    AttributeDef attrOfHelperTab = null;
                    ArrayList<AttributeDef> linev = null;
                    if (aclassObj instanceof AbstractClassDef) {
                        aclass = (AbstractClassDef)aclassObj;
                        linev = ModelUtilities.getPolylineAttrs(aclass);
                    } else {
                        attrOfHelperTab = (AttributeDef)aclassObj;
                        aclass = (AbstractClassDef)attrOfHelperTab.getContainer();
                        linev = new ArrayList<AttributeDef>();
                        linev.add(attrOfHelperTab);
                    }
                    if (attrOfHelperTab != null) {
                        SurfaceOrAreaType surfaceType;
                        Table lineAttrTable;
                        if (attrOfHelperTab.getDomainResolvingAliases() instanceof SurfaceType) {
                            String maintableref = ModelUtilities.getHelperTableMainTableRef(attrOfHelperTab);
                            IomObject structvalue = iomObj.getattrobj(maintableref, 0);
                            String ref = structvalue.getobjectrefoid();
                            this.out.writeTid(ref);
                        }
                        if ((lineAttrTable = (surfaceType = (SurfaceOrAreaType)attrOfHelperTab.getDomainResolvingAliases()).getLineAttributeStructure()) != null) {
                            Iterator attri = lineAttrTable.getAttributes();
                            while (attri.hasNext()) {
                                AttributeDef lineattr = (AttributeDef)attri.next();
                                this.writeAttributeValue(iomObj, lineattr);
                            }
                        }
                    } else {
                        ArrayList attrv = ModelUtilities.getIli1AttrList(aclass);
                        for (ViewableTransferElement obj : attrv) {
                            String ref;
                            IomObject structvalue;
                            if (obj.obj instanceof AttributeDef) {
                                AttributeDef attr = (AttributeDef)obj.obj;
                                this.writeAttributeValue(iomObj, attr);
                                continue;
                            }
                            if (!(obj.obj instanceof RoleDef)) continue;
                            RoleDef role = (RoleDef)obj.obj;
                            if (!obj.embedded) {
                                structvalue = iomObj.getattrobj(role.getName(), 0);
                                ref = structvalue != null ? structvalue.getobjectrefoid() : null;
                                this.out.writeTid(ref);
                                continue;
                            }
                            structvalue = iomObj.getattrobj(role.getName(), 0);
                            ref = structvalue != null ? structvalue.getobjectrefoid() : null;
                            this.out.writeTid(ref);
                        }
                    }
                    this.out.writeNewline();
                    if (linev != null) {
                        for (AttributeDef polyAttr : linev) {
                            Type type = Type.findReal((Type)polyAttr.getDomain());
                            Domain controlPointDomain = ((LineType)type).getControlPointDomain();
                            CoordType coordType = (CoordType)Type.findReal((Type)controlPointDomain.getType());
                            String polyAttrName = null;
                            String errMsgAttrName = null;
                            if (attrOfHelperTab != null && polyAttr == attrOfHelperTab) {
                                polyAttrName = ModelUtilities.getHelperTableGeomAttrName(attrOfHelperTab);
                                errMsgAttrName = attrOfHelperTab.getName();
                            } else {
                                polyAttrName = polyAttr.getName();
                                errMsgAttrName = polyAttr.getName();
                            }
                            IomObject value = iomObj.getattrobj(polyAttrName, 0);
                            if (value != null) {
                                this.writePolyline(value, errMsgAttrName, coordType);
                            }
                            this.out.writeRawText("ELIN");
                            this.out.writeNewline();
                        }
                    }
                    break block20;
                }
                this.out.writeRawText("OBJE");
                this.out.writeTid(iomObj.getobjectoid());
                this.out.writeNewline();
            }
            catch (IOException ex) {
                throw new IoxException("failed to write OBJE line", (Throwable)ex);
            }
        }
    }

    private void writeAttributeValue(IomObject iomObj, AttributeDef attr) throws IOException, IoxException {
        Type type = Type.findReal((Type)attr.getDomain());
        if (!(type instanceof LineType) || type instanceof AreaType) {
            if (type instanceof AreaType) {
                Domain controlPointDomain = ((AreaType)type).getControlPointDomain();
                CoordType coordType = (CoordType)Type.findReal((Type)controlPointDomain.getType());
                IomObject coord = iomObj.getattrobj(attr.getName(), 0);
                this.writeNum(iomObj, attr.getName(), coord != null ? coord.getattrvalue("C1") : null, coordType.getDimensions()[0]);
                this.writeNum(iomObj, attr.getName(), coord != null ? coord.getattrvalue("C2") : null, coordType.getDimensions()[1]);
            } else if (type instanceof CoordType) {
                CoordType coordType = (CoordType)type;
                boolean is3D = coordType.getDimensions().length == 3;
                IomObject coord = iomObj.getattrobj(attr.getName(), 0);
                this.writeNum(iomObj, attr.getName(), coord != null ? coord.getattrvalue("C1") : null, coordType.getDimensions()[0]);
                this.writeNum(iomObj, attr.getName(), coord != null ? coord.getattrvalue("C2") : null, coordType.getDimensions()[1]);
                if (is3D) {
                    this.writeNum(iomObj, attr.getName(), coord != null ? coord.getattrvalue("C3") : null, coordType.getDimensions()[2]);
                }
            } else if (type instanceof EnumerationType) {
                String enumQName = iomObj.getattrvalue(attr.getName());
                if (enumQName != null) {
                    String itfCode = this.mapXtfCode2ItfCode((EnumerationType)type, enumQName);
                    if (itfCode == null) {
                        EhiLogger.logAdaption((String)(iomObj.getobjecttag() + " " + iomObj.getobjectoid() + ": unexpected code <" + enumQName + "> for attribute " + attr.getName() + "; written without mapping"));
                        itfCode = enumQName;
                    }
                    this.out.writeValue(itfCode, false, this.getFieldSize(type));
                } else {
                    this.out.writeValue(null, false, this.getFieldSize(type));
                }
            } else if (type instanceof TextType) {
                String txt = iomObj.getattrvalue(attr.getName());
                if (txt != null) {
                    txt = txt.replace(' ', this.blankCode);
                    this.out.writeValue(txt, false, ((TextType)type).getMaxLength());
                } else {
                    this.out.writeValue(null, false, ((TextType)type).getMaxLength());
                }
            } else if (type instanceof ReferenceType) {
                String ref = iomObj.getattrvalue(attr.getName());
                this.out.writeTid(ref);
            } else if (type instanceof NumericalType) {
                String val = iomObj.getattrvalue(attr.getName());
                this.writeNum(iomObj, attr.getName(), val, (NumericalType)type);
            } else {
                String txt = iomObj.getattrvalue(attr.getName());
                this.out.writeValue(txt, false, this.getFieldSize(type));
            }
        }
    }

    private DecimalFormat getNumFmt(int accuracy) {
        if (this.numFmt.containsKey(accuracy)) {
            return this.numFmt.get(accuracy);
        }
        DecimalFormat fmt = ItfWriter.buildDecimalFormat(accuracy);
        this.numFmt.put(accuracy, fmt);
        return fmt;
    }

    public static DecimalFormat buildDecimalFormat(int accuracy) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat fmt = null;
        fmt = accuracy == 0 ? new DecimalFormat("#0", symbols) : new DecimalFormat("#0." + StringUtility.STRING((int)accuracy, (char)'0'), symbols);
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        return fmt;
    }

    private void writeNum(IomObject iomObj, String attrName, String numValue, NumericalType type1) throws IOException, IoxException {
        NumericType type = (NumericType)type1;
        if (numValue == null || numValue.length() == 0) {
            this.out.writeValue(null, true, this.getFieldSize((Type)type));
            return;
        }
        int scalePos = numValue.toLowerCase().indexOf(101);
        if (scalePos > 0) {
            numValue = numValue.substring(0, scalePos);
        }
        int accuracy = type.getMinimum().getAccuracy();
        BigDecimal num = null;
        try {
            num = new BigDecimal(numValue);
        }
        catch (NumberFormatException e) {
            throw new IoxException(iomObj.getobjecttag() + " " + iomObj.getobjectoid() + ": unexpected value <" + numValue + "> for attribute " + attrName);
        }
        DecimalFormat numFmt = this.getNumFmt(accuracy);
        numValue = numFmt.format(num);
        this.out.writeValue(numValue, true, this.getFieldSize((Type)type));
    }

    private int getFieldSize(Type type) {
        int size;
        if (this.typeCache.containsKey(type)) {
            return (Integer)this.typeCache.get(type);
        }
        if (type instanceof EnumerationType) {
            ArrayList accu = new ArrayList();
            size = Integer.toString(Interlis1Generator.countEnumLeafs((Enumeration)((EnumerationType)type).getEnumeration())).length();
        } else if (type instanceof NumericType) {
            NumericType numType = (NumericType)type;
            String fmt = Interlis1Generator.genFmtField((int)0, (PrecisionDecimal)numType.getMinimum(), (PrecisionDecimal)numType.getMaximum());
            size = fmt.length();
        } else if (type instanceof FormattedType) {
            FormattedType fmtType = (FormattedType)type;
            String min = fmtType.getMinimum();
            String max = fmtType.getMaximum();
            size = Math.max(min.length(), max.length());
        } else {
            throw new IllegalArgumentException("unknown type " + type.getClass().getName());
        }
        this.typeCache.put(type, new Integer(size));
        return size;
    }

    private void writePolyline(IomObject obj, String errMsgAttrName, CoordType coordType) throws IOException, IoxException {
        boolean clipped;
        if (obj == null) {
            return;
        }
        boolean is3D = coordType.getDimensions().length == 3;
        boolean bl = clipped = obj.getobjectconsistency() == 1;
        if (clipped) {
            throw new IllegalArgumentException("IOM_INCOMPLETE not supported by ITF file format");
        }
        for (int sequencei = 0; sequencei < obj.getattrvaluecount("sequence"); ++sequencei) {
            if (!clipped && sequencei > 0) {
                EhiLogger.logError((String)"unclipped polyline with multi 'sequence' elements");
                break;
            }
            IomObject sequence = obj.getattrobj("sequence", sequencei);
            for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                if (segment.getobjecttag().equals("COORD")) {
                    if (segmenti == 0) {
                        this.out.writeRawText("STPT");
                    } else {
                        this.out.writeRawText("LIPT");
                    }
                    this.writeNum(obj, errMsgAttrName, segment.getattrvalue("C1"), coordType.getDimensions()[0]);
                    this.writeNum(obj, errMsgAttrName, segment.getattrvalue("C2"), coordType.getDimensions()[1]);
                    if (is3D) {
                        this.writeNum(obj, errMsgAttrName, segment.getattrvalue("C3"), coordType.getDimensions()[2]);
                    }
                    this.out.writeNewline();
                    continue;
                }
                if (segment.getobjecttag().equals("ARC")) {
                    this.out.writeRawText("ARCP");
                    this.writeNum(obj, errMsgAttrName, segment.getattrvalue("A1"), coordType.getDimensions()[0]);
                    this.writeNum(obj, errMsgAttrName, segment.getattrvalue("A2"), coordType.getDimensions()[1]);
                    this.out.writeNewline();
                    this.out.writeRawText("LIPT");
                    this.writeNum(obj, errMsgAttrName, segment.getattrvalue("C1"), coordType.getDimensions()[0]);
                    this.writeNum(obj, errMsgAttrName, segment.getattrvalue("C2"), coordType.getDimensions()[1]);
                    if (is3D) {
                        this.writeNum(obj, errMsgAttrName, segment.getattrvalue("C3"), coordType.getDimensions()[2]);
                    }
                    this.out.writeNewline();
                    continue;
                }
                EhiLogger.logAdaption((String)"custom line form not supported; ignored");
            }
            if (!clipped) continue;
        }
    }

    private String mapXtfCode2ItfCode(EnumerationType type, String xtfCode) {
        return this.enumTypes.mapXtfCode2ItfCode(type, xtfCode);
    }
}

