/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ilishaper;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.ErrorTracker;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ilishaper.CreateModel;
import ch.ehi.ilishaper.Main;
import ch.ehi.ilishaper.XtfShaper;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxUtility;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.inifile.IniFileReader;
import ch.interlis.iox_j.logging.FileLogger;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.statistics.IoxStatistics;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DeriveData {
    public static final String MSG_CONVERSION_DONE = "...conversion done";
    public static final String MSG_CONVERSION_FAILED = "...conversion failed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deriveData(File destFile, File[] srcFiles, Settings settings) {
        ErrorTracker logStderr;
        FileLogger logfile;
        int ret;
        block69: {
            block70: {
                int n;
                block66: {
                    block67: {
                        block64: {
                            block65: {
                                int n2;
                                block62: {
                                    block63: {
                                        int n3;
                                        block60: {
                                            block61: {
                                                int n4;
                                                block58: {
                                                    block59: {
                                                        ret = 0;
                                                        if (srcFiles == null || srcFiles.length == 0) {
                                                            EhiLogger.logError((String)"no INTERLIS file given");
                                                            return ret != 0;
                                                        }
                                                        if (settings == null) {
                                                            settings = new Settings();
                                                        }
                                                        logfile = null;
                                                        logStderr = null;
                                                        String logFilename = settings.getValue("ch.ehi.ilishaper.log");
                                                        try {
                                                            block57: {
                                                                if (logFilename != null) {
                                                                    File f = new File(logFilename);
                                                                    try {
                                                                        if (DeriveData.isWriteable(f)) {
                                                                            logfile = new FileLogger(f);
                                                                            EhiLogger.getInstance().addListener((LogListener)logfile);
                                                                            break block57;
                                                                        }
                                                                        EhiLogger.logError((String)("failed to write to logfile <" + f.getPath() + ">"));
                                                                        n4 = ret;
                                                                        if (logfile == null) break block58;
                                                                        break block59;
                                                                    }
                                                                    catch (IOException e) {
                                                                        EhiLogger.logError((String)("failed to write to logfile <" + f.getPath() + ">"), (Throwable)e);
                                                                        int n5 = ret;
                                                                        if (logfile != null) {
                                                                            logfile.close();
                                                                            EhiLogger.getInstance().removeListener((LogListener)logfile);
                                                                            logfile = null;
                                                                        }
                                                                        if (logStderr == null) return n5 != 0;
                                                                        EhiLogger.getInstance().removeListener((LogListener)logStderr);
                                                                        logStderr = null;
                                                                        return n5 != 0;
                                                                    }
                                                                }
                                                            }
                                                            logStderr = new ErrorTracker();
                                                            EhiLogger.getInstance().addListener((LogListener)logStderr);
                                                            EhiLogger.logState((String)("ilishaper-" + Main.getVersion()));
                                                            EhiLogger.logState((String)("ili2c-" + Ili2c.getVersion()));
                                                            EhiLogger.logState((String)("iox-ili-" + ch.interlis.iox_j.utility.IoxUtility.getVersion()));
                                                            EhiLogger.logState((String)("java.version " + System.getProperty("java.version")));
                                                            EhiLogger.logState((String)("User <" + System.getProperty("user.name") + ">"));
                                                            String DATE_FORMAT = "yyyy-MM-dd HH:mm";
                                                            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
                                                            EhiLogger.logState((String)("Start date " + dateFormat.format(new Date())));
                                                            EhiLogger.logState((String)("maxMemory " + Runtime.getRuntime().maxMemory() / 1024L + " KB"));
                                                            for (File dataFile : srcFiles) {
                                                                EhiLogger.logState((String)("dataFile <" + dataFile.getPath() + ">"));
                                                            }
                                                            ArrayList modelnames = new ArrayList();
                                                            for (File dataFile : srcFiles) {
                                                                List modelnameFromFile = IoxUtility.getModels((File)dataFile);
                                                                if (modelnameFromFile == null) {
                                                                    n3 = ret;
                                                                    if (logfile == null) break block60;
                                                                    break block61;
                                                                }
                                                                modelnames.addAll(modelnameFromFile);
                                                            }
                                                            Log2EhiLogger errHandler = new Log2EhiLogger();
                                                            LogEventFactory errFactory = new LogEventFactory();
                                                            errFactory.setLogger((IoxLogging)errHandler);
                                                            String modelVersion = null;
                                                            try {
                                                                String[] fileNames = new String[srcFiles.length];
                                                                int i = 0;
                                                                for (File srcFile : srcFiles) {
                                                                    fileNames[i++] = srcFile.getPath();
                                                                }
                                                                modelVersion = ch.interlis.iox_j.utility.IoxUtility.getModelVersion((String[])fileNames, (LogEventFactory)errFactory, (Settings)settings);
                                                            }
                                                            catch (IoxException ex) {
                                                                EhiLogger.logAdaption((String)("failed to get version from data file; " + ex.toString() + "; ignored"));
                                                            }
                                                            String configFilename = settings.getValue("ch.ehi.ilishaper.config");
                                                            if (configFilename != null) {
                                                                EhiLogger.logState((String)("configFile <" + configFilename + ">"));
                                                            }
                                                            EhiLogger.traceState((String)"read configuration...");
                                                            ValidationConfig trafoConfig = null;
                                                            try {
                                                                trafoConfig = IniFileReader.readFile((File)new File(configFilename));
                                                            }
                                                            catch (IOException e) {
                                                                EhiLogger.logError((String)("failed to read config file <" + configFilename + ">"), (Throwable)e);
                                                                n2 = ret;
                                                                if (logfile != null) {
                                                                    logfile.close();
                                                                    EhiLogger.getInstance().removeListener((LogListener)logfile);
                                                                    logfile = null;
                                                                }
                                                                if (logStderr == null) return n2 != 0;
                                                                EhiLogger.getInstance().removeListener((LogListener)logStderr);
                                                                logStderr = null;
                                                                return n2 != 0;
                                                            }
                                                            EhiLogger.traceState((String)"read source models...");
                                                            Configuration ili2cConfig = new Configuration();
                                                            ili2cConfig.setAutoCompleteModelList(true);
                                                            DeriveData.addModelsFromConfigFile(ili2cConfig, trafoConfig, true);
                                                            if (ili2cConfig.getSizeFileEntry() == 0) {
                                                                EhiLogger.logError((String)"no source models given in config file");
                                                                n2 = ret;
                                                                if (logfile == null) break block62;
                                                                break block63;
                                                            }
                                                            TransferDescription td = ch.interlis.ili2c.Main.runCompiler((Configuration)ili2cConfig, (Settings)settings);
                                                            if (td == null) {
                                                                EhiLogger.logError((String)"failed to read source models");
                                                                n = ret;
                                                                if (logfile == null) break block64;
                                                                break block65;
                                                            }
                                                            if (!CreateModel.validateConfigFile(td, trafoConfig, true)) {
                                                                EhiLogger.logError((String)("config file <" + configFilename + "> contains errors"));
                                                                n = ret;
                                                                if (logfile == null) break block66;
                                                                break block67;
                                                            }
                                                            IoxStatistics readerStat = new IoxStatistics(td, settings);
                                                            IoxStatistics writerStat = new IoxStatistics(td, settings);
                                                            PipelinePool pool = new PipelinePool();
                                                            XtfShaper shaper = new XtfShaper(td, trafoConfig, settings);
                                                            XtfWriter ioxWriter = null;
                                                            try {
                                                                ioxWriter = new XtfWriter(destFile, td);
                                                                ioxWriter.setModels(shaper.buildModelList(td));
                                                                writerStat.setFilename(destFile.getPath());
                                                                File[] startEvent = new StartTransferEvent();
                                                                startEvent.setSender(Main.getVersion());
                                                                ioxWriter.write((IoxEvent)startEvent);
                                                                writerStat.add((IoxEvent)startEvent);
                                                                for (File srcFile : srcFiles) {
                                                                    IoxReader ioxReader = null;
                                                                    try {
                                                                        IoxEvent outEvent;
                                                                        ioxReader = new ReaderFactory().createReader(srcFile, errFactory, settings);
                                                                        if (ioxReader instanceof IoxIliReader) {
                                                                            ((IoxIliReader)ioxReader).setModel(td);
                                                                        }
                                                                        String filename = srcFile.getPath();
                                                                        readerStat.setFilename(filename);
                                                                        errFactory.setDataSource(filename);
                                                                        IoxEvent event = null;
                                                                        do {
                                                                            event = ioxReader.read();
                                                                            shaper.addInput(event);
                                                                            readerStat.add(event);
                                                                            outEvent = shaper.getMappedObject();
                                                                            if (outEvent == null) continue;
                                                                            ioxWriter.write(outEvent);
                                                                            writerStat.add(outEvent);
                                                                        } while (!(event instanceof EndTransferEvent));
                                                                        outEvent = shaper.getMappedObject();
                                                                        while (outEvent != null) {
                                                                            ioxWriter.write(outEvent);
                                                                            writerStat.add(outEvent);
                                                                            outEvent = shaper.getMappedObject();
                                                                        }
                                                                    }
                                                                    finally {
                                                                        if (ioxReader != null) {
                                                                            try {
                                                                                ioxReader.close();
                                                                            }
                                                                            catch (IoxException e) {
                                                                                EhiLogger.logError((Throwable)e);
                                                                            }
                                                                            ioxReader = null;
                                                                        }
                                                                    }
                                                                }
                                                                IoxEvent outEvent = shaper.getMappedObject();
                                                                while (outEvent != null) {
                                                                    ioxWriter.write(outEvent);
                                                                    writerStat.add(outEvent);
                                                                    outEvent = shaper.getMappedObject();
                                                                }
                                                                ch.interlis.iox_j.EndTransferEvent endEvent = new ch.interlis.iox_j.EndTransferEvent();
                                                                ioxWriter.write((IoxEvent)endEvent);
                                                                writerStat.add((IoxEvent)endEvent);
                                                                readerStat.write2logger();
                                                                writerStat.write2logger();
                                                                if (logStderr.hasSeenErrors()) {
                                                                    EhiLogger.logState((String)MSG_CONVERSION_FAILED);
                                                                } else {
                                                                    EhiLogger.logState((String)MSG_CONVERSION_DONE);
                                                                    ret = 1;
                                                                }
                                                            }
                                                            catch (Throwable ex) {
                                                                if (readerStat != null) {
                                                                    readerStat.write2logger();
                                                                }
                                                                EhiLogger.logError((Throwable)ex);
                                                                EhiLogger.logState((String)MSG_CONVERSION_FAILED);
                                                            }
                                                            finally {
                                                                if (shaper != null) {
                                                                    shaper.close();
                                                                    shaper = null;
                                                                }
                                                                if (ioxWriter != null) {
                                                                    ioxWriter.flush();
                                                                    ioxWriter.close();
                                                                    ioxWriter = null;
                                                                }
                                                                EhiLogger.logState((String)("End date " + dateFormat.format(new Date())));
                                                            }
                                                            if (logfile == null) break block69;
                                                            break block70;
                                                        }
                                                        catch (IoxException e) {
                                                            EhiLogger.logError((Throwable)e);
                                                            return ret != 0;
                                                        }
                                                    }
                                                    logfile.close();
                                                    EhiLogger.getInstance().removeListener((LogListener)logfile);
                                                    logfile = null;
                                                }
                                                if (logStderr == null) return n4 != 0;
                                                EhiLogger.getInstance().removeListener((LogListener)logStderr);
                                                return n4 != 0;
                                            }
                                            logfile.close();
                                            EhiLogger.getInstance().removeListener((LogListener)logfile);
                                            logfile = null;
                                        }
                                        if (logStderr == null) return n3 != 0;
                                        EhiLogger.getInstance().removeListener((LogListener)logStderr);
                                        return n3 != 0;
                                    }
                                    logfile.close();
                                    EhiLogger.getInstance().removeListener((LogListener)logfile);
                                    logfile = null;
                                }
                                if (logStderr == null) return n2 != 0;
                                EhiLogger.getInstance().removeListener((LogListener)logStderr);
                                return n2 != 0;
                            }
                            logfile.close();
                            EhiLogger.getInstance().removeListener((LogListener)logfile);
                            logfile = null;
                        }
                        if (logStderr == null) return n != 0;
                        EhiLogger.getInstance().removeListener((LogListener)logStderr);
                        return n != 0;
                    }
                    logfile.close();
                    EhiLogger.getInstance().removeListener((LogListener)logfile);
                    logfile = null;
                }
                if (logStderr == null) return n != 0;
                EhiLogger.getInstance().removeListener((LogListener)logStderr);
                return n != 0;
            }
            logfile.close();
            EhiLogger.getInstance().removeListener((LogListener)logfile);
            logfile = null;
        }
        if (logStderr == null) return ret != 0;
        EhiLogger.getInstance().removeListener((LogListener)logStderr);
        return ret != 0;
        finally {
            if (logfile != null) {
                logfile.close();
                EhiLogger.getInstance().removeListener(logfile);
                logfile = null;
            }
            if (logStderr != null) {
                EhiLogger.getInstance().removeListener((LogListener)logStderr);
                logStderr = null;
            }
        }
    }

    public static void addModelsFromConfigFile(Configuration ili2cConfig, ValidationConfig trafoConfig, boolean includeDestinationModel) {
        for (String entry : trafoConfig.getIliQnames()) {
            String[] filterModelv;
            String filterModels;
            String destModel;
            if (entry.contains(".")) continue;
            String modelName = entry;
            EhiLogger.logState((String)("srcModel <" + modelName + ">"));
            ili2cConfig.addFileEntry(new FileEntry(modelName, 1));
            if (includeDestinationModel && (destModel = trafoConfig.getConfigValue(modelName, "name")) != null) {
                ili2cConfig.addFileEntry(new FileEntry(destModel, 1));
            }
            if ((filterModels = trafoConfig.getConfigValue(modelName, "filterModels")) == null) continue;
            for (String filterModel : filterModelv = filterModels.split(";")) {
                if (filterModel == null) continue;
                ili2cConfig.addFileEntry(new FileEntry(filterModel, 1));
            }
        }
    }

    public static boolean isWriteable(File f) throws IOException {
        f.createNewFile();
        return f.canWrite();
    }
}

