/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.settings;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Settings {
    private HashMap<String, String> values = new HashMap();
    private ArrayList<String> orderedKeys = null;
    private HashMap<String, Object> transientValues = new HashMap();

    public Settings() {
        this(false);
    }

    public Settings(boolean keepOrderOfDefs) {
        if (keepOrderOfDefs) {
            this.orderedKeys = new ArrayList();
        }
    }

    public Settings(Settings src) {
        if (src != null) {
            Object obj;
            Iterator<String> it = src.getValuesIterator();
            while (it.hasNext()) {
                String name = it.next();
                obj = src.values.get(name);
                this.setValue(name, (String)obj);
            }
            for (String name : this.transientValues.keySet()) {
                obj = src.transientValues.get(name);
                this.transientValues.put(name, obj);
            }
        }
    }

    public String getValue(String name) {
        String value = this.values.get(name);
        return value;
    }

    public void setValue(String name, String value) {
        if (value == null) {
            if (this.orderedKeys != null && this.orderedKeys.contains(name)) {
                this.orderedKeys.remove(name);
            }
            this.values.remove(name);
        } else {
            if (this.orderedKeys != null && !this.orderedKeys.contains(name)) {
                this.orderedKeys.add(name);
            }
            this.values.put(name, value);
        }
    }

    public Object getTransientObject(String name) {
        Object value = this.transientValues.get(name);
        return value;
    }

    public void setTransientObject(String name, Object value) {
        if (value == null) {
            this.transientValues.remove(name);
        } else {
            this.transientValues.put(name, value);
        }
    }

    public String getTransientValue(String name) {
        return (String)this.getTransientObject(name);
    }

    public void setTransientValue(String name, String value) {
        this.setTransientObject(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File out, String header) throws IOException {
        OutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(out));
            this.store(stream, header);
        }
        finally {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
    }

    public void store(OutputStream out, String header) throws IOException {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)this.values);
        prop.store(out, header);
    }

    public void load(File inFile) throws IOException {
        InputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(inFile));
            this.load(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
    }

    public void load(InputStream inStream) throws IOException {
        Properties prop = new Properties();
        prop.load(inStream);
        for (String key : prop.stringPropertyNames()) {
            this.setValue(key, prop.getProperty(key));
        }
    }

    public Set<String> getValues() {
        return this.values.keySet();
    }

    public Iterator<String> getValuesIterator() {
        if (this.orderedKeys != null) {
            return this.orderedKeys.iterator();
        }
        return this.values.keySet().iterator();
    }

    public Set<String> getTransientValues() {
        return this.transientValues.keySet();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Iterator<String> it = this.getValuesIterator();
        Iterator<String> it2 = this.transientValues.keySet().iterator();
        if (it.hasNext() || it2.hasNext()) {
            Object obj;
            String name;
            String sep = "";
            ret.append("Settings{");
            while (it.hasNext()) {
                name = it.next();
                obj = this.values.get(name);
                ret.append(sep + name + "=" + obj.toString());
                sep = ";";
            }
            while (it2.hasNext()) {
                name = it2.next();
                obj = this.transientValues.get(name);
                ret.append(sep + name + "=" + obj.toString());
                sep = ";";
            }
            ret.append("}");
        }
        return ret.toString();
    }
}

