/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ilishaper;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ilishaper.CreateModel;
import ch.ehi.ilishaper.DeriveData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Main {
    public static final String APP_NAME = "ilishaper";
    public static final String APP_JAR = "ilishaper.jar";
    private static String version = null;
    private static int FC_NOOP = 0;
    private static int FC_CREATE_MODEL = 1;
    private static int FC_DERIVE_DATA = 2;
    private static final String SETTINGS_FILE = System.getProperty("user.home") + "/.ilishaper";
    public static final String SETTING_ILIDIRS = "ch.interlis.ili2c.ilidirs";
    public static final String SETTING_APPHOME = "ch.ehi.ilishaper.appHome";
    public static final String SETTING_PLUGINFOLDER = "ch.ehi.ilishaper.pluginfolder";
    public static final String SETTING_LOGFILE = "ch.ehi.ilishaper.log";
    public static final String SETTING_CONFIGFILE = "ch.ehi.ilishaper.config";

    public static void main(String[] args) {
        int argi;
        Settings settings = new Settings();
        settings.setValue(SETTING_ILIDIRS, "%ILI_DIR;http://models.interlis.ch/;%JAR_DIR");
        String appHome = Main.getAppHome();
        if (appHome != null) {
            settings.setValue(SETTING_PLUGINFOLDER, new File(appHome, "plugins").getAbsolutePath());
            settings.setValue(SETTING_APPHOME, appHome);
        } else {
            settings.setValue(SETTING_PLUGINFOLDER, new File("plugins").getAbsolutePath());
        }
        Class<?> mainFrame = null;
        try {
            mainFrame = Class.forName(Main.preventOptimziation("ch.ehi.ilishaper.gui.Main"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Method mainFrameMain = null;
        if (mainFrame != null) {
            try {
                mainFrameMain = mainFrame.getMethod("showDialog", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        String outFile = null;
        File[] xtfFile = null;
        if (args.length == 0) {
            Main.readSettings(settings);
            Main.runGui(mainFrameMain, settings);
            return;
        }
        int function = FC_NOOP;
        boolean doGui = false;
        for (argi = 0; argi < args.length; ++argi) {
            String arg = args[argi];
            if (arg.equals("--trace")) {
                EhiLogger.getInstance().setTraceFilter(false);
                continue;
            }
            if (arg.equals("--gui")) {
                Main.readSettings(settings);
                doGui = true;
                continue;
            }
            if (arg.equals("--modeldir")) {
                settings.setValue(SETTING_ILIDIRS, args[++argi]);
                continue;
            }
            if (arg.equals("--createModel")) {
                function = FC_CREATE_MODEL;
                continue;
            }
            if (arg.equals("--deriveData")) {
                function = FC_DERIVE_DATA;
                continue;
            }
            if (arg.equals("--out")) {
                outFile = args[++argi];
                continue;
            }
            if (arg.equals("--config")) {
                settings.setValue(SETTING_CONFIGFILE, args[++argi]);
                continue;
            }
            if (arg.equals("--log")) {
                settings.setValue(SETTING_LOGFILE, args[++argi]);
                continue;
            }
            if (arg.equals("--plugins")) {
                settings.setValue(SETTING_PLUGINFOLDER, args[++argi]);
                continue;
            }
            if (arg.equals("--proxy")) {
                settings.setValue("ch.interlis.ili2c.http_proxy_host", args[++argi]);
                continue;
            }
            if (arg.equals("--proxyPort")) {
                settings.setValue("ch.interlis.ili2c.http_proxy_port", args[++argi]);
                continue;
            }
            if (arg.equals("--version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("--help")) {
                Main.printVersion();
                System.err.println();
                Main.printDescription();
                System.err.println();
                Main.printUsage();
                System.err.println();
                System.err.println("OPTIONS");
                System.err.println();
                System.err.println("--gui                 start GUI.");
                System.err.println("--createModel         creates a simplified ili-model from a source ili-model");
                System.err.println("--deriveData         creates a dervied xtf-file from a source xtf-file");
                System.err.println("--out file            output file");
                System.err.println("--config file         configuration file");
                System.err.println("--log file            text file, that receives validation results.");
                System.err.println("--modeldir %ILI_DIR;http://models.interlis.ch/;%JAR_DIR list of directories/repositories");
                System.err.println("--plugins folder      directory with jar files that contain user defined functions.");
                System.err.println("--proxy host          proxy server to access model repositories.");
                System.err.println("--proxyPort port      proxy port to access model repositories.");
                System.err.println("--trace               enable trace messages.");
                System.err.println("--help                Display this help text.");
                System.err.println("--version             Display the version of ilishaper.");
                System.err.println();
                return;
            }
            if (!arg.startsWith("-")) break;
            EhiLogger.logAdaption((String)(arg + ": unknown option; ignored"));
        }
        int dataFileCount = args.length - argi;
        xtfFile = new File[dataFileCount];
        int fileCount = 0;
        while (argi < args.length) {
            xtfFile[fileCount] = new File(args[argi]);
            ++fileCount;
            ++argi;
        }
        if (doGui) {
            Main.runGui(mainFrameMain, settings);
            return;
        }
        boolean ok = false;
        if (function == FC_NOOP) {
            ok = true;
        } else if (function == FC_CREATE_MODEL) {
            CreateModel cloner = new CreateModel();
            ok = cloner.createModel(new File(outFile), xtfFile, settings);
        } else if (function == FC_DERIVE_DATA) {
            DeriveData cloner = new DeriveData();
            ok = cloner.deriveData(new File(outFile), xtfFile, settings);
        } else {
            throw new IllegalStateException("function==" + function);
        }
        System.exit(ok ? 0 : 1);
    }

    private static String preventOptimziation(String val) {
        StringBuffer buf = new StringBuffer(val.length());
        buf.append(val);
        return buf.toString();
    }

    private static void runGui(Method mainFrameMain, Settings settings) {
        if (mainFrameMain != null) {
            try {
                mainFrameMain.invoke(null, new Object[0]);
                return;
            }
            catch (IllegalArgumentException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                EhiLogger.logError((String)"failed to open GUI", (Throwable)ex);
            }
        } else {
            EhiLogger.logError((String)"ilishaper: no GUI available");
        }
        System.exit(2);
    }

    public static void readSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            if (file.exists()) {
                settings.load(file);
            }
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to load settings from file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    public static void writeSettings(Settings settings) {
        File file = new File(SETTINGS_FILE);
        try {
            settings.store(file, "ilishaper settings");
        }
        catch (IOException ex) {
            EhiLogger.logError((String)("failed to settings settings to file " + SETTINGS_FILE), (Throwable)ex);
        }
    }

    protected static void printVersion() {
        System.err.println("ilishaper, Version " + Main.getVersion());
        System.err.println("  Developed by Eisenhut Informatik AG, CH-3400 Burgdorf");
    }

    protected static void printDescription() {
        System.err.println("DESCRIPTION");
        System.err.println("  creates simplified, derived Interlis data.");
    }

    protected static void printUsage() {
        System.err.println("USAGE");
        System.err.println("  java -jar ilishaper.jar [Options]");
    }

    public static String getVersion() {
        if (version == null) {
            java.util.ResourceBundle resVersion = java.util.ResourceBundle.getBundle(ResourceBundle.class2qpackageName(Main.class) + ".Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }

    public static String getAppHome() {
        String[] classpaths;
        for (String classpath : classpaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"))) {
            File file;
            String jarName;
            if (!classpath.toLowerCase().endsWith(".jar") || !(jarName = (file = new File(classpath)).getName()).toLowerCase().startsWith(APP_NAME) || !(file = new File(file.getAbsolutePath())).exists()) continue;
            return file.getParent();
        }
        return null;
    }
}

