/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.AbstractAttributeRef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;

public class StructAttributeRef
extends AbstractAttributeRef {
    public static final long eFIRST = -1L;
    public static final long eLAST = -2L;
    private long index;
    private AttributeDef attr;

    public StructAttributeRef(AttributeDef attr, long index) {
        this.attr = attr;
        this.index = index;
    }

    @Override
    public String getName() {
        return this.attr.getName() + "[" + this.index + "]";
    }

    public Viewable getViewable() {
        return ((CompositionType)this.attr.getDomainResolvingAliases()).getComponentType();
    }

    @Override
    public Type getDomain() {
        return this.attr.getDomain();
    }

    public AttributeDef getAttr() {
        return this.attr;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public Ili2cSemanticException checkTranslation(PathEl otherPathEl, int sourceLine) {
        Ili2cSemanticException ret = super.checkTranslation(otherPathEl, sourceLine);
        if (ret != null) {
            return ret;
        }
        StructAttributeRef other = (StructAttributeRef)otherPathEl;
        if (!Element.equalElementRef(this.attr, other.attr)) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_referencedAttributeMismatch", this.getName(), other.getName()));
        }
        if (this.index != other.index) {
            return new Ili2cSemanticException(sourceLine, Element.formatMessage("err_diff_referencedAttributeMismatch", this.getName(), other.getName()));
        }
        return null;
    }
}

