/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ilishaper;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ilishaper.IliGenerator;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.ValidationConfig;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class XtfShaper {
    private List<Model> srcModels = new ArrayList<Model>();
    private List<Model> destModels = new ArrayList<Model>();
    private Set<Element> skipElements = new HashSet<Element>();
    private List<IoxEvent> out = new ArrayList<IoxEvent>();
    private boolean ignoreBasket = false;
    private boolean letThroughBasket = false;
    private TransferDescription td = null;
    private ValidationConfig trafoConfig = null;
    private Validator validator = null;
    private Map<String, Long> src2dest = new HashMap<String, Long>();
    private long destOid = 1L;

    public XtfShaper(TransferDescription td, ValidationConfig trafoConfig, Settings settings) {
        this.td = td;
        this.trafoConfig = trafoConfig;
        for (String entry : trafoConfig.getIliQnames()) {
            if (entry.contains(".")) continue;
            String modelName = entry;
            Model model = (Model)td.getElement(Model.class, modelName);
            if (model == null) {
                throw new IllegalStateException("Model <" + modelName + "> nicht vorhanden");
            }
            this.srcModels.add(model);
            String destModelName = this.getElementName((Element)model);
            Model destModel = (Model)td.getElement(Model.class, destModelName);
            if (destModel == null) {
                throw new IllegalStateException("Model <" + destModelName + "> nicht vorhanden");
            }
            this.destModels.add(destModel);
        }
        ValidationConfig validationConfig = new ValidationConfig();
        Log2EhiLogger errs = new Log2EhiLogger();
        LogEventFactory errFact = new LogEventFactory();
        PipelinePool pipelinePool = new PipelinePool();
        this.validator = new Validator(td, validationConfig, errs, errFact, pipelinePool, settings);
        IliGenerator.collectSkipElements(this.skipElements, td, this.srcModels, trafoConfig);
    }

    public void close() {
    }

    private String getElementName(Element elt) {
        if (elt instanceof Model && this.srcModels.contains(elt)) {
            String name = this.trafoConfig.getConfigValue(elt.getScopedName(), "name");
            if (name == null) {
                throw new IllegalStateException("missing config of new name for model " + elt.getScopedName());
            }
            return name;
        }
        return elt.getName();
    }

    private String getDestScopedName(Element elt) {
        Element[] path = elt.getElementPath();
        StringBuffer scopedName = new StringBuffer();
        String sep = "";
        for (Element el : path) {
            String name = this.getElementName(el);
            scopedName.append(sep);
            scopedName.append(name);
            sep = ".";
        }
        return scopedName.toString();
    }

    public XtfModel[] buildModelList(TransferDescription td) {
        ArrayList modelv = new ArrayList();
        for (Object modelo : td) {
            if (modelo instanceof PredefinedModel || !(modelo instanceof Model) || this.srcModels.contains(modelo) || this.skipElements.contains(modelo)) continue;
            modelv.add(modelo);
        }
        XtfModel[] ret = new XtfModel[modelv.size()];
        for (int i = 0; i < modelv.size(); ++i) {
            Model model = (Model)modelv.get(i);
            ret[i] = new XtfModel();
            ret[i].setName(model.getName());
            String version = model.getModelVersion();
            ret[i].setVersion(version == null ? "" : version);
            String issuer = model.getIssuer();
            ret[i].setUri(issuer == null ? "" : issuer);
        }
        return ret;
    }

    public void addInput(IoxEvent srcEvent) {
        if (!(srcEvent instanceof StartTransferEvent)) {
            if (srcEvent instanceof StartBasketEvent) {
                StartBasketEvent startBasket = (StartBasketEvent)srcEvent;
                String topicName = startBasket.getType();
                Topic topic = (Topic)this.td.getElement(topicName);
                if (topic == null) {
                    this.letThroughBasket = true;
                    this.out.add(srcEvent);
                } else if (this.skipElements.contains(topic)) {
                    this.ignoreBasket = true;
                } else {
                    this.letThroughBasket = false;
                    this.ignoreBasket = false;
                    String destName = this.getDestScopedName((Element)topic);
                    ch.interlis.iox_j.StartBasketEvent destEvent = new ch.interlis.iox_j.StartBasketEvent(destName, Long.toString(this.mapId(startBasket.getBid())));
                    this.out.add((IoxEvent)destEvent);
                }
            } else if (srcEvent instanceof ObjectEvent) {
                if (!this.ignoreBasket) {
                    if (this.letThroughBasket) {
                        this.out.add(srcEvent);
                    } else {
                        IomObject srcIomObj = ((ObjectEvent)srcEvent).getIomObject();
                        this.mapObject(srcIomObj);
                    }
                }
            } else if (srcEvent instanceof ch.interlis.iox.EndBasketEvent) {
                EndBasketEvent destEvent = new EndBasketEvent();
                if (!this.ignoreBasket) {
                    this.out.add((IoxEvent)destEvent);
                }
            } else if (srcEvent instanceof EndTransferEvent) {
                // empty if block
            }
        }
    }

    private long mapId(String srcId) {
        Long destId = this.src2dest.get(srcId);
        if (destId == null) {
            destId = this.destOid++;
            this.src2dest.put(srcId, destId);
        }
        return destId;
    }

    private void mapObject(IomObject srcIomObj) {
        IomObject destIomObj;
        String className = srcIomObj.getobjecttag();
        Viewable viewable = (Viewable)this.td.getElement(className);
        if (!this.skipElements.contains(viewable) && (destIomObj = this.translateObject(srcIomObj)) != null) {
            ch.interlis.iox_j.ObjectEvent destEvent = new ch.interlis.iox_j.ObjectEvent(destIomObj);
            this.out.add((IoxEvent)destEvent);
        }
    }

    private IomObject translateObject(IomObject srcIomObj) {
        Iom_jObject destIomObj = null;
        String srcClassName = srcIomObj.getobjecttag();
        Viewable srcClass = (Viewable)this.td.getElement(srcClassName);
        if (!this.skipElements.contains(srcClass)) {
            Value result;
            String filterText = this.trafoConfig.getConfigValue(srcClass.getScopedName(), "filter");
            Evaluable filter = null;
            if (filterText != null) {
                try {
                    filter = Main.parseExpression(srcClass, PredefinedModel.getInstance().BOOLEAN.getType(), filterText, srcClass.getScopedName() + ":" + "filter");
                }
                catch (Ili2cException e) {
                    EhiLogger.logError((String)("failed to parse filter <" + filterText + ">"), (Throwable)e);
                }
            }
            if (filter != null && ((result = this.validator.evaluateExpression(null, null, srcClassName, srcIomObj, filter, null)).skipEvaluation() || !result.isTrue())) {
                return null;
            }
            String destClassName = this.getDestScopedName((Element)srcClass);
            Viewable destClass = (Viewable)this.td.getElement(destClassName);
            destIomObj = destClass instanceof AssociationDef && ((AssociationDef)destClass).getOid() == null && !((AssociationDef)destClass).isIdentifiable() ? new Iom_jObject(destClassName, null) : new Iom_jObject(destClassName, Long.toString(this.mapId(srcIomObj.getobjectoid())));
            Iterator iter = destClass.getAttributesAndRoles2();
            while (iter.hasNext()) {
                String destRoleName;
                RoleDef destRole;
                Type proxyType;
                AttributeDef destAttr;
                ViewableTransferElement destProp = (ViewableTransferElement)iter.next();
                if (!(!(destProp.obj instanceof AttributeDef) || (destAttr = (AttributeDef)destProp.obj).isTransient() || (proxyType = destAttr.getDomain()) != null && proxyType instanceof ObjectType || this.skipElements.contains(destAttr))) {
                    this.translateAttrValue(destIomObj, srcIomObj, destAttr);
                }
                if (!(destProp.obj instanceof RoleDef) || this.skipElements.contains(destRole = (RoleDef)destProp.obj) || srcIomObj.getattrvaluecount(destRoleName = destRole.getName()) <= 0) continue;
                IomObject structValue = srcIomObj.getattrobj(destRoleName, 0);
                String ref = structValue.getobjectrefoid();
                if (this.destModels.contains(destRole.getDestination().getContainer(Model.class))) {
                    ref = Long.toString(this.mapId(ref));
                    structValue.setobjectrefoid(ref);
                }
                if (!structValue.getobjecttag().equals("REF")) {
                    structValue = this.translateObject(structValue);
                }
                if (structValue == null) continue;
                destIomObj.addattrobj(destRoleName, structValue);
            }
        }
        return destIomObj;
    }

    private void translateAttrValue(IomObject destIomObj, IomObject srcIomObj, AttributeDef attr) {
        IomObject structValue;
        String attrValue;
        int attri;
        String attrName = attr.getName();
        int attrc = srcIomObj.getattrvaluecount(attrName);
        if (attrc == 0) {
            return;
        }
        boolean isCompType = attr.getDomain() instanceof CompositionType;
        AttributeDef destAttr = (AttributeDef)attr.getTranslationOfOrSame();
        String destAttrName = destAttr.getName();
        ArrayList<String> attrValues = new ArrayList<String>();
        for (attri = 0; attri < attrc; ++attri) {
            attrValue = srcIomObj.getattrprim(attrName, attri);
            if (attrValue != null) {
                attrValues.add(attrValue);
                continue;
            }
            structValue = srcIomObj.getattrobj(attrName, attri);
            attrValues.add((String)structValue);
        }
        for (attri = 0; attri < attrc; ++attri) {
            attrValue = attrValues.get(attri);
            if (attrValue == null) continue;
            if (attrValue instanceof String) {
                destIomObj.setattrvalue(destAttrName, attrValue);
                continue;
            }
            structValue = (IomObject)attrValue;
            if (isCompType) {
                if ((structValue = this.translateObject(structValue)) == null) continue;
                destIomObj.addattrobj(destAttrName, structValue);
                continue;
            }
            destIomObj.addattrobj(destAttrName, structValue);
        }
    }

    public IoxEvent getMappedObject() {
        if (this.out.size() == 0) {
            return null;
        }
        IoxEvent ret = this.out.remove(0);
        return ret;
    }
}

