/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ilishaper;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AssociationPath;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.AxisAttributeRef;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAbstractClassRole;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.StructAttributeRef;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IliGenerator
extends Interlis2Generator {
    public static final String CONFIG_MODEL_NAME = "name";
    public static final String CONFIG_MODEL_VERISONEXPL = "versionExpl";
    public static final String CONFIG_MODEL_ISSUER = "issuer";
    public static final String CONFIG_MODEL_VERISON = "version";
    public static final String CONFIG_MODEL_DOC = "doc";
    public static final String CONFIG_VIEWABLE_FILTER = "filter";
    public static final String CONFIG_IGNORE = "ignore";
    private List<Model> srcModels = new ArrayList<Model>();
    private Set<Element> skipElements = new HashSet<Element>();
    private ValidationConfig trafoConfig = null;

    public void generate(Writer out, TransferDescription td, ValidationConfig trafoConfig, Settings settings) throws Exception {
        this.trafoConfig = trafoConfig;
        for (String entry : trafoConfig.getIliQnames()) {
            if (entry.contains(".")) continue;
            String modelName = entry;
            Model model = (Model)td.getElement(Model.class, modelName);
            if (model == null) {
                throw new Exception("Model <" + modelName + "> nicht vorhanden");
            }
            this.srcModels.add(model);
        }
        IliGenerator.collectSkipElements(this.skipElements, td, this.srcModels, trafoConfig);
        this.generate(out, td, false);
    }

    public static void collectSkipElements(Set<Element> skipElements, TransferDescription td, List<Model> srcModels, ValidationConfig trafoConfig) {
        for (Model model : td) {
            IliGenerator.collectSkipElements_Helper(skipElements, (Element)model, trafoConfig);
        }
    }

    private static void collectSkipElements_Helper(Set<Element> skipElements, Element elt, ValidationConfig trafoConfig) {
        String scopedName = elt.getScopedName();
        if (elt instanceof AttributeDef && "true".equals(trafoConfig.getConfigValue(elt.getScopedName(), CONFIG_IGNORE))) {
            skipElements.add(elt);
        } else if (elt instanceof Topic) {
            if ("true".equals(trafoConfig.getConfigValue(scopedName, CONFIG_IGNORE))) {
                skipElements.add(elt);
                IliGenerator.skipTopicElements(skipElements, (Topic)elt);
            } else {
                Topic topic = (Topic)elt;
                if (skipElements.contains(topic.getExtending())) {
                    skipElements.add(elt);
                    IliGenerator.skipTopicElements(skipElements, (Topic)elt);
                }
            }
        } else if (elt instanceof Viewable) {
            if ("true".equals(trafoConfig.getConfigValue(scopedName, CONFIG_IGNORE))) {
                skipElements.add(elt);
            } else {
                Viewable viewable = (Viewable)elt;
                if (skipElements.contains(viewable.getExtending())) {
                    skipElements.add(elt);
                }
            }
            if (elt instanceof AssociationDef && IliGenerator.containsRolesWithSkippedClassRefs(skipElements, (AssociationDef)elt)) {
                skipElements.add(elt);
            }
        } else if (elt instanceof Constraint && IliGenerator.containsRefsWithSkippedElements(skipElements, (Constraint)elt)) {
            skipElements.add(elt);
        } else if ("true".equals(trafoConfig.getConfigValue(scopedName, CONFIG_IGNORE))) {
            skipElements.add(elt);
        }
        if (elt instanceof Container) {
            for (Element el : (Container)elt) {
                IliGenerator.collectSkipElements_Helper(skipElements, el, trafoConfig);
            }
        }
    }

    protected void printElements(Container container, String language) {
        if (container instanceof TransferDescription) {
            Class lastClass = null;
            for (Model model : this.srcModels) {
                lastClass = this.printElement(container, lastClass, (Element)model, language);
            }
        } else {
            super.printElements(container, language);
        }
    }

    protected Class printElement(Container container, Class lastClass, Element elt, String language) {
        String scopedName = elt.getScopedName();
        if (elt instanceof AttributeDef && "true".equals(this.trafoConfig.getConfigValue(elt.getScopedName(), CONFIG_IGNORE))) {
            this.skipElements.add(elt);
            return lastClass;
        }
        if (elt instanceof Topic) {
            if ("true".equals(this.trafoConfig.getConfigValue(scopedName, CONFIG_IGNORE))) {
                this.skipElements.add(elt);
                IliGenerator.skipTopicElements(this.skipElements, (Topic)elt);
                return lastClass;
            }
            Topic topic = (Topic)elt;
            if (this.skipElements.contains(topic.getExtending())) {
                this.skipElements.add(elt);
                IliGenerator.skipTopicElements(this.skipElements, (Topic)elt);
                return lastClass;
            }
        } else if (elt instanceof Viewable) {
            if ("true".equals(this.trafoConfig.getConfigValue(scopedName, CONFIG_IGNORE))) {
                this.skipElements.add(elt);
                return lastClass;
            }
            Viewable viewable = (Viewable)elt;
            if (this.skipElements.contains(viewable.getExtending())) {
                this.skipElements.add(elt);
                return lastClass;
            }
            if (elt instanceof AssociationDef && IliGenerator.containsRolesWithSkippedClassRefs(this.skipElements, (AssociationDef)elt)) {
                this.skipElements.add(elt);
                return lastClass;
            }
        } else {
            if (elt instanceof Constraint && IliGenerator.containsRefsWithSkippedElements(this.skipElements, (Constraint)elt)) {
                this.skipElements.add(elt);
                return lastClass;
            }
            if ("true".equals(this.trafoConfig.getConfigValue(scopedName, CONFIG_IGNORE))) {
                this.skipElements.add(elt);
                return lastClass;
            }
        }
        return super.printElement(container, lastClass, elt, language);
    }

    private static boolean containsRefsWithSkippedElements(Set<Element> skipElements, Constraint elt) {
        if (elt instanceof UniquenessConstraint) {
            UniquenessConstraint unique = (UniquenessConstraint)elt;
            UniqueEl unqEles = unique.getElements();
            for (ObjectPath path : unqEles.getAttributes()) {
                if (!IliGenerator.containsRefsWithSkippedElements(skipElements, (Evaluable)path)) continue;
                return true;
            }
            Evaluable condition = unique.getPreCondition();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, condition)) {
                return true;
            }
            ObjectPath prefix = unique.getPrefix();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, (Evaluable)prefix)) {
                return true;
            }
        } else if (elt instanceof MandatoryConstraint) {
            Evaluable condition = elt.getCondition();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, condition)) {
                return true;
            }
        } else if (elt instanceof PlausibilityConstraint) {
            Evaluable condition = elt.getCondition();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, condition)) {
                return true;
            }
        } else if (elt instanceof SetConstraint) {
            Evaluable condition = elt.getCondition();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, condition)) {
                return true;
            }
            Evaluable preCondition = ((SetConstraint)elt).getPreCondition();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, preCondition)) {
                return true;
            }
        } else if (elt instanceof ExistenceConstraint) {
            ObjectPath restrictedAttr = ((ExistenceConstraint)elt).getRestrictedAttribute();
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, (Evaluable)restrictedAttr)) {
                return true;
            }
            Iterator reqIt = ((ExistenceConstraint)elt).iteratorRequiredIn();
            while (reqIt.hasNext()) {
                if (!IliGenerator.containsRefsWithSkippedElements(skipElements, (Evaluable)reqIt.next())) continue;
                return true;
            }
        } else {
            throw new IllegalArgumentException("unexpected Class " + elt.getClass().getName());
        }
        return false;
    }

    private static boolean containsRefsWithSkippedElements(Set<Element> skipElements, Evaluable ev) {
        if (ev == null) {
            return false;
        }
        if (ev instanceof Expression.Addition) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Addition)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Addition)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.Conjunction) {
            for (Evaluable evN : ((Expression.Conjunction)ev).getConjoined()) {
                if (!IliGenerator.containsRefsWithSkippedElements(skipElements, evN)) continue;
                return true;
            }
        } else if (ev instanceof Expression.DefinedCheck) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.DefinedCheck)ev).getArgument())) {
                return true;
            }
        } else if (ev instanceof Expression.Disjunction) {
            for (Evaluable evN : ((Expression.Disjunction)ev).getDisjoined()) {
                if (!IliGenerator.containsRefsWithSkippedElements(skipElements, evN)) continue;
                return true;
            }
        } else if (ev instanceof Expression.Division) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Division)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Division)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.Equality) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Equality)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Equality)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.GreaterThan) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.GreaterThan)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.GreaterThan)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.GreaterThanOrEqual) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.GreaterThanOrEqual)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.GreaterThanOrEqual)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.Implication) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Implication)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Implication)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.LessThan) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.LessThan)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.LessThan)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.LessThanOrEqual) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.LessThanOrEqual)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.LessThanOrEqual)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.Multiplication) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Multiplication)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Multiplication)ev).getRight())) {
                return true;
            }
        } else if (ev instanceof Expression.Negation) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Negation)ev).getNegated())) {
                return true;
            }
        } else if (ev instanceof Expression.Subtraction) {
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Subtraction)ev).getLeft())) {
                return true;
            }
            if (IliGenerator.containsRefsWithSkippedElements(skipElements, ((Expression.Subtraction)ev).getRight())) {
                return true;
            }
        } else {
            if (ev instanceof Expression) {
                throw new IllegalArgumentException("unexpected Class " + ev.getClass().getName());
            }
            if (ev instanceof FunctionCall) {
                for (Evaluable evN : ((FunctionCall)ev).getArguments()) {
                    if (!IliGenerator.containsRefsWithSkippedElements(skipElements, evN)) continue;
                    return true;
                }
            } else if (ev instanceof ParameterValue) {
                if (skipElements.contains(((ParameterValue)ev).getParameter())) {
                    return true;
                }
            } else if (ev instanceof ObjectPath) {
                return IliGenerator.containsObjectPathRefsWithSkippedElements(skipElements, (ObjectPath)ev);
            }
        }
        return false;
    }

    protected static boolean containsObjectPathRefsWithSkippedElements(Set<Element> skipElements, ObjectPath path) {
        PathEl[] pathEls;
        for (PathEl pathEl : pathEls = path.getPathElements()) {
            Viewable v;
            AttributeDef attr;
            if (!(pathEl instanceof AttributeRef ? skipElements.contains((attr = ((AttributeRef)pathEl).getAttr()).getContainer()) || skipElements.contains(attr) : (pathEl instanceof AxisAttributeRef ? skipElements.contains((attr = ((AxisAttributeRef)pathEl).getAttr()).getContainer()) || skipElements.contains(attr) : (pathEl instanceof StructAttributeRef ? skipElements.contains((attr = ((StructAttributeRef)pathEl).getAttr()).getContainer()) || skipElements.contains(attr) : (pathEl instanceof AssociationPath ? skipElements.contains(v = pathEl.getViewable()) : (pathEl instanceof PathElAbstractClassRole ? skipElements.contains(v = pathEl.getViewable()) : pathEl instanceof PathElAssocRole && skipElements.contains(v = pathEl.getViewable()))))))) continue;
            return true;
        }
        return false;
    }

    private static boolean containsRolesWithSkippedClassRefs(Set<Element> skipElements, AssociationDef assoc) {
        Iterator rolei = assoc.getAttributesAndRoles();
        while (rolei.hasNext()) {
            Element obj = (Element)rolei.next();
            if (!(obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)obj;
            Iterator refIt = role.iteratorReference();
            while (refIt.hasNext()) {
                ReferenceType ref = (ReferenceType)refIt.next();
                if (!skipElements.contains(ref.getReferred())) continue;
                return true;
            }
        }
        return false;
    }

    private static void skipTopicElements(Set<Element> skipElements, Topic topic) {
        for (Element ele : topic) {
            skipElements.add(ele);
        }
    }

    public void printDocumentation(Element def, String language) {
        if (def != null && def instanceof Model && this.srcModels.contains(def)) {
            String doc = this.trafoConfig.getConfigValue(def.getScopedName(), CONFIG_MODEL_DOC);
            if (doc != null) {
                this.printDocumentation(doc);
            }
        } else {
            super.printDocumentation(def, language);
        }
    }

    protected void printMetaValues(Object def, Settings values, String language, String scopedNamePrefix) {
        if (def == null || !(def instanceof Model)) {
            super.printMetaValues(def, values, language, scopedNamePrefix);
        }
    }

    protected String getModelVersionExpl(Model elt) {
        if (elt instanceof Model && this.srcModels.contains(elt)) {
            String name = this.trafoConfig.getConfigValue(elt.getScopedName(), CONFIG_MODEL_VERISONEXPL);
            return name;
        }
        return super.getModelVersionExpl(elt);
    }

    protected String getModelIssuer(Model elt) {
        if (elt instanceof Model && this.srcModels.contains(elt)) {
            String name = this.trafoConfig.getConfigValue(elt.getScopedName(), CONFIG_MODEL_ISSUER);
            if (name == null) {
                name = "mailto:" + System.getProperty("user.name") + "@localhost";
            }
            return name;
        }
        return super.getModelIssuer(elt);
    }

    protected String getModelVersion(Model elt) {
        if (elt instanceof Model && this.srcModels.contains(elt)) {
            String name = this.trafoConfig.getConfigValue(elt.getScopedName(), CONFIG_MODEL_VERISON);
            if (name == null) {
                Calendar current = Calendar.getInstance();
                DecimalFormat digit4 = new DecimalFormat("0000");
                DecimalFormat digit2 = new DecimalFormat("00");
                name = digit4.format(current.get(1)) + "-" + digit2.format(current.get(2) + 1) + "-" + digit2.format(current.get(5));
            }
            return name;
        }
        return super.getModelVersion(elt);
    }

    protected String getElementName(Element elt, String language) {
        if (elt instanceof Model && this.srcModels.contains(elt)) {
            String name = this.trafoConfig.getConfigValue(elt.getScopedName(), CONFIG_MODEL_NAME);
            if (name == null) {
                throw new IllegalStateException("missing config of new name for model " + elt.getScopedName());
            }
            return name;
        }
        return super.getElementName(elt, language);
    }

    protected void printRef(Container scope, Element elt, String language) {
        Element[] path = elt.getElementPath();
        StringBuffer scopedName = new StringBuffer();
        String sep = "";
        for (Element el : path) {
            String name = this.getElementName(el, language);
            scopedName.append(sep);
            scopedName.append(name);
            sep = ".";
        }
        this.ipw.print(scopedName.toString());
    }

    protected Domain getTopicClassOid(Topic topic) {
        return null;
    }

    protected Domain getTopicBasketOid(Topic topic) {
        return null;
    }

    protected Domain getAbstarctClassDefOid(AbstractClassDef def) {
        return null;
    }

    protected Iterator getTopicDependsOn(Topic topic) {
        ArrayList<Topic> deps = new ArrayList<Topic>();
        Iterator topicIt = topic.getDependentOn();
        while (topicIt.hasNext()) {
            Topic dep = (Topic)topicIt.next();
            if (this.skipElements.contains(dep)) continue;
            deps.add(dep);
        }
        return deps.iterator();
    }

    protected Unit getTypeUnit(NumericalType type) {
        Unit unit = type.getUnit();
        if (this.skipElements.contains(unit)) {
            return null;
        }
        return unit;
    }
}

