/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ilishaper;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.ilishaper.IliGenerator;
import ch.ehi.ilishaper.Main;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iox_j.inifile.IniFileReader;
import ch.interlis.iox_j.utility.IoxUtility;
import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreateModel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createModel(File destModel, File[] srcFiles, Settings settings) {
        TransferDescription td;
        String configFilename;
        boolean ok = true;
        if (destModel == null) {
            EhiLogger.logError((String)"no destination model file given");
            return !ok;
        }
        if (settings == null) {
            settings = new Settings();
        }
        EhiLogger.logState((String)("ilishaper-" + Main.getVersion()));
        EhiLogger.logState((String)("ili2c-" + Ili2c.getVersion()));
        EhiLogger.logState((String)("iox-ili-" + IoxUtility.getVersion()));
        EhiLogger.logState((String)("java.version " + System.getProperty("java.version")));
        EhiLogger.logState((String)("user.name <" + System.getProperty("user.name") + ">"));
        EhiLogger.logState((String)("maxMemory " + Runtime.getRuntime().maxMemory() / 1024L + " KB"));
        String DATE_FORMAT = "yyyy-MM-dd HH:mm";
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        EhiLogger.logState((String)("Start date " + dateFormat.format(new Date())));
        if (destModel != null) {
            EhiLogger.logState((String)("destModel <" + destModel.getPath() + ">"));
        }
        if ((configFilename = settings.getValue("ch.ehi.ilishaper.config")) != null) {
            EhiLogger.logState((String)("configFile <" + configFilename + ">"));
        }
        EhiLogger.traceState((String)"read configuration...");
        ValidationConfig config = null;
        try {
            config = IniFileReader.readFile(new File(configFilename));
        }
        catch (IOException e) {
            EhiLogger.logError((String)("failed to read config file <" + configFilename + ">"), (Throwable)e);
            return !ok;
        }
        EhiLogger.traceState((String)"read source models...");
        Configuration ili2cConfig = new Configuration();
        ili2cConfig.setAutoCompleteModelList(true);
        for (String entry : config.getIliQnames()) {
            if (entry.contains(".")) continue;
            String modelName = entry;
            EhiLogger.logState((String)("srcModel <" + modelName + ">"));
            ili2cConfig.addFileEntry(new FileEntry(modelName, 1));
        }
        if (ili2cConfig.getSizeFileEntry() == 0) {
            EhiLogger.logError((String)"no source models given in config file");
            return !ok;
        }
        if (srcFiles != null) {
            for (File srcFile : srcFiles) {
                EhiLogger.logState((String)("srcFile <" + srcFile.getPath() + ">"));
                ili2cConfig.addFileEntry(new FileEntry(srcFile.getPath(), 1));
            }
        }
        if ((td = ch.interlis.ili2c.Main.runCompiler(ili2cConfig, settings)) == null) {
            EhiLogger.logError((String)"failed to read source models");
            return !ok;
        }
        EhiLogger.logState((String)"write destination model...");
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(destModel.getPath()), "UTF-8");
            IliGenerator gen = new IliGenerator();
            gen.generate(out, td, config, settings);
        }
        catch (Exception e) {
            EhiLogger.logError((String)"failed to write destination model", (Throwable)e);
            boolean bl = !ok;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        EhiLogger.logState((String)("End date " + dateFormat.format(new Date())));
        return ok;
    }
}

