/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import ch.interlis.iox_j.wkb.LineSegment;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class RingCollector {
    private final boolean repairSelfTouchingRing;
    private final LinkedList<List<LineSegment>> rings;
    private int currentRingIndex = -1;
    private Coordinate startOfCurrentRing;
    private Coordinate carryOverCoordinate;

    public RingCollector(boolean repairSelfTouchingRing) {
        this.repairSelfTouchingRing = repairSelfTouchingRing;
        this.rings = new LinkedList();
    }

    private List<LineSegment> getCurrentRing() {
        return this.currentRingIndex >= 0 ? this.rings.get(this.currentRingIndex) : null;
    }

    private LineSegment getCurrentSegment() {
        List<LineSegment> currentRing = this.getCurrentRing();
        return currentRing != null ? currentRing.get(currentRing.size() - 1) : null;
    }

    public void startNewRing() {
        this.rings.addLast(new ArrayList());
        this.rings.getLast().add(new LineSegment());
        this.currentRingIndex = this.rings.size() - 1;
        this.startOfCurrentRing = null;
        this.carryOverCoordinate = null;
    }

    private void add(Coordinate coordinate, int WkbType) {
        Coordinate lastCoord;
        if (this.carryOverCoordinate != null && this.repairSelfTouchingRing) {
            Coordinate carry = this.carryOverCoordinate;
            this.startNewRing();
            this.getCurrentSegment().add(carry);
            this.startOfCurrentRing = carry;
        }
        List<LineSegment> ring = this.getCurrentRing();
        LineSegment segment = this.getCurrentSegment();
        if (!segment.trySetWkbType(WkbType)) {
            lastCoord = segment.getLast();
            segment = new LineSegment(WkbType);
            segment.add(lastCoord);
            ring.add(segment);
        }
        if (this.startOfCurrentRing == null) {
            this.startOfCurrentRing = coordinate;
        } else if (this.startOfCurrentRing.equals((Object)coordinate)) {
            this.carryOverCoordinate = coordinate;
        } else if (this.repairSelfTouchingRing && this.getSegmentIdx(this.getCurrentRing(), coordinate) != null && !this.startOfCurrentRing.equals((Object)coordinate)) {
            this.extractInnerRing(coordinate);
        }
        segment = this.getCurrentSegment();
        if (!segment.trySetWkbType(WkbType)) {
            lastCoord = segment.getLast();
            segment = new LineSegment(WkbType);
            segment.add(lastCoord);
            ring.add(segment);
        } else {
            segment.add(coordinate);
        }
    }

    private void extractInnerRing(Coordinate coordinate) {
        List<LineSegment> ring = this.getCurrentRing();
        int segmentIdx = this.getSegmentIdx(ring, coordinate);
        LineSegment containingSegment = ring.get(segmentIdx);
        ArrayList<LineSegment> extractedRing = new ArrayList<LineSegment>();
        LineSegment tailSegment = containingSegment.splitTailAt(coordinate);
        if (tailSegment != null) {
            extractedRing.add(tailSegment);
        }
        while (segmentIdx + 1 < ring.size()) {
            LineSegment segment = ring.remove(segmentIdx + 1);
            extractedRing.add(segment);
        }
        ((LineSegment)extractedRing.get(extractedRing.size() - 1)).add(coordinate);
        this.rings.add(extractedRing);
    }

    private Integer getSegmentIdx(List<LineSegment> ring, Coordinate coordinate) {
        for (int idx = 0; idx < ring.size(); ++idx) {
            LineSegment segment = ring.get(idx);
            if (!segment.contains(coordinate)) continue;
            return idx;
        }
        return null;
    }

    public List<List<LineSegment>> getRings() {
        return this.rings;
    }

    public Coordinate getLastCoordinate() {
        List<LineSegment> ring = this.getCurrentRing();
        if (ring == null) {
            return null;
        }
        LineSegment segment = ring.get(ring.size() - 1);
        if (segment.size() == 0) {
            return null;
        }
        return segment.getLast();
    }

    public void addStraight(Coordinate coord) {
        this.add(coord, 2);
    }

    public void addArc(Coordinate midPt, Coordinate endPt) {
        this.add(midPt, 8);
        this.add(endPt, 8);
    }
}

