/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.utility;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.interlis.iom_j.csv.CsvReader;
import ch.interlis.iom_j.iligml.Iligml20Reader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.xtf.Xtf24Reader;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.IoxUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ReaderFactory {
    public static final String CONFIG_CUSTOM_READERS = "ch.interlis.iox_j.utility.customReaders";

    @Deprecated
    public IoxReader createReader(File inputFile, LogEventFactory errFact) throws IoxException {
        return this.createReader(inputFile, errFact, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoxReader createReader(File inputFile, LogEventFactory errFact, Settings settings) throws IoxException {
        if (settings == null) {
            settings = new Settings();
        }
        IoxIliReader reader = null;
        try {
            reader = new ItfReader2(inputFile, null, false);
            IoxEvent event = null;
            try {
                event = reader.read();
                if (event != null) {
                    ItfReader2 reader2;
                    ItfReader2 itfReader2 = reader2 = new ItfReader2(inputFile, null, false);
                    return itfReader2;
                }
            }
            catch (IoxException reader2) {
                // empty catch block
            }
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        String ns = this.getXMLNamespace(inputFile);
        if (ns != null) {
            if (ns.equals("http://www.interlis.ch/INTERLIS2.2") || ns.equals("http://www.interlis.ch/INTERLIS2.3")) {
                reader = new XtfReader(inputFile);
                return reader;
            }
            if (ns.equals("http://www.interlis.ch/xtf/2.4/INTERLIS")) {
                reader = new Xtf24Reader(inputFile);
                return reader;
            }
            if (ns.equals("http://www.interlis.ch/ILIGML-2.0/INTERLIS")) {
                reader = new Iligml20Reader(inputFile);
                return reader;
            }
            throw new IoxException("unknown xml file");
        }
        List customReaders = (List)settings.getTransientObject(CONFIG_CUSTOM_READERS);
        if (customReaders != null) {
            for (Class customReaderClass : customReaders) {
                block31: {
                    try {
                        Constructor<?> cnstr = this.getConstructorForArgs(customReaderClass, new Class[]{File.class, LogEventFactory.class, Settings.class});
                        if (cnstr == null) {
                            EhiLogger.logAdaption((String)(customReaderClass.getName() + " ignored; no matching constructor"));
                            continue;
                        }
                        reader = (IoxReader)cnstr.newInstance(inputFile, errFact, settings);
                    }
                    catch (InstantiationException e) {
                        throw new IoxException("failed to create reader " + customReaderClass.getName(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new IoxException("failed to create reader " + customReaderClass.getName(), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IoxException("failed to create reader " + customReaderClass.getName(), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getTargetException() instanceof IoxException) break block31;
                        throw new IoxException("failed to create reader " + customReaderClass.getName(), e.getTargetException());
                    }
                }
                return reader;
            }
        }
        if (IoxUtility.isCsvFilename(inputFile.getName())) {
            try {
                reader = new CsvReader(inputFile);
                IoxEvent event5 = null;
                try {
                    event5 = reader.read();
                    if (event5 != null) {
                        CsvReader reader2;
                        CsvReader csvReader = reader2 = new CsvReader(inputFile);
                        return csvReader;
                    }
                }
                catch (IoxException ioxException) {
                    // empty catch block
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                    reader = null;
                }
            }
        }
        throw new IoxException("no reader found");
    }

    public Constructor<?> getConstructorForArgs(Class<?> klass, Class[] args) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = klass.getConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length != args.length) continue;
            boolean argumentsMatch = true;
            for (int i = 0; i < args.length; ++i) {
                if (types[i].isAssignableFrom(args[i])) continue;
                argumentsMatch = false;
                break;
            }
            if (!argumentsMatch) continue;
            return constructor;
        }
        return null;
    }

    public String getXMLNamespace(File inputFile) {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader reader = null;
        FileInputStream in = null;
        XMLEvent event = null;
        try {
            in = new FileInputStream(inputFile);
            reader = inputFactory.createXMLEventReader(in);
            event = reader.nextEvent();
            while (event != null && !event.isStartElement()) {
                event = reader.nextEvent();
            }
        }
        catch (XMLStreamException e) {
            String string = null;
            return string;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
                reader = null;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
        if (event != null) {
            String ns = event.asStartElement().getName().getNamespaceURI();
            return ns;
        }
        return null;
    }
}

