/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.utility;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.ItfReader;
import ch.interlis.iom_j.itf.ItfReader2;
import ch.interlis.iom_j.xtf.Xtf23Reader;
import ch.interlis.iom_j.xtf.Xtf24Reader;
import ch.interlis.iom_j.xtf.XtfReader;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartTransferEvent;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.ReaderFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;

public class IoxUtility {
    private static String version = null;

    private IoxUtility() {
    }

    public static boolean isItfFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "itf".equals(xtfExt);
    }

    public static boolean isXtfFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "xtf".equals(xtfExt);
    }

    public static boolean isIliFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "ili".equals(xtfExt);
    }

    public static boolean isCsvFilename(String filename) {
        String xtfExt = GenericFileFilter.getFileExtension((File)new File(filename)).toLowerCase();
        return "csv".equals(xtfExt);
    }

    @Deprecated
    public static List<String> getModels(File xtffile) throws IoxException {
        return IoxUtility.getModels(xtffile, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getModels(File xtffile, LogEventFactory errFactory, Settings settings) throws IoxException {
        ArrayList<String> ret = new ArrayList<String>();
        IoxReader reader = null;
        try {
            reader = new ReaderFactory().createReader(xtffile, errFactory, settings);
            IoxEvent event = null;
            while (true) {
                try {
                    event = reader.read();
                    if (event == null) return ret;
                    if (event instanceof StartBasketEvent) {
                        String topic = ((StartBasketEvent)event).getType();
                        String[] model = topic.split("\\.");
                        IoxUtility.addModel(ret, model[0]);
                        ArrayList<String> arrayList = ret;
                        return arrayList;
                    }
                }
                catch (IoxException ioxException) {
                    // empty catch block
                    return ret;
                }
                {
                    if (!(event instanceof XtfStartTransferEvent)) continue;
                    XtfStartTransferEvent xtfStart = (XtfStartTransferEvent)event;
                    IoxUtility.addModels(ret, xtfStart);
                    continue;
                }
                break;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            reader = null;
        }
    }

    private static void addModels(ArrayList<String> ret, XtfStartTransferEvent xtfStart) {
        HashMap<String, IomObject> objs = xtfStart.getHeaderObjects();
        if (objs != null) {
            for (String tid : objs.keySet()) {
                IomObject obj = objs.get(tid);
                if (!obj.getobjecttag().equals("iom04.metamodel.ModelEntry")) continue;
                IoxUtility.addModel(ret, obj.getattrvalue("model"));
            }
        }
    }

    private static void addModel(ArrayList<String> ret, String model) {
        if (ret.contains(model)) {
            return;
        }
        ret.add(model);
    }

    @Deprecated
    public static String getModelFromXtf(String filename) {
        StartBasketEvent be = null;
        try {
            IoxEvent event;
            IoxIliReader ioxReader = null;
            ioxReader = IoxUtility.isItfFilename(filename) ? new ItfReader(new File(filename)) : new XtfReader(new File(filename));
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                be = (StartBasketEvent)event;
                break;
            } while (!(event instanceof EndTransferEvent));
            ioxReader.close();
            ioxReader = null;
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)("failed to read model from xml file " + filename), (Throwable)ex);
            return null;
        }
        if (be == null) {
            return null;
        }
        String[] qtopic = be.getType().split("\\.");
        String model = qtopic[0];
        return model;
    }

    @Deprecated
    public static String getModelFromXtf(InputStream f, String filename) {
        StartBasketEvent be = null;
        try {
            IoxEvent event;
            IoxIliReader ioxReader = null;
            ioxReader = IoxUtility.isItfFilename(filename) ? new ItfReader(f) : new XtfReader(f);
            do {
                if (!((event = ioxReader.read()) instanceof StartBasketEvent)) continue;
                be = (StartBasketEvent)event;
                break;
            } while (!(event instanceof EndTransferEvent));
            ioxReader.close();
            ioxReader = null;
        }
        catch (IoxException ex) {
            EhiLogger.logError((String)("failed to read model from xml file " + filename), (Throwable)ex);
            return null;
        }
        if (be == null) {
            return null;
        }
        String[] qtopic = be.getType().split("\\.");
        String model = qtopic[0];
        return model;
    }

    @Deprecated
    public static String getModelVersion(String[] dataFiles, LogEventFactory errFactory) throws IoxException {
        return IoxUtility.getModelVersion(dataFiles, errFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getModelVersion(String[] dataFiles, LogEventFactory errFactory, Settings settings) throws IoxException {
        String modelVersion = null;
        String dataFile = dataFiles[0];
        IoxReader ioxReader = null;
        try {
            ioxReader = new ReaderFactory().createReader(new File(dataFile), errFactory, settings);
            if (ioxReader instanceof Xtf24Reader) {
                modelVersion = "2.4";
            } else if (ioxReader instanceof XtfReader) {
                modelVersion = "2.3";
                IoxEvent event = ioxReader.read();
                if (event instanceof StartTransferEvent && ((StartTransferEvent)event).getVersion().equals("2.2")) {
                    modelVersion = "2.2";
                }
            } else if (ioxReader instanceof Xtf23Reader) {
                modelVersion = "2.3";
            } else if (ioxReader instanceof ItfReader) {
                modelVersion = "1";
            } else if (ioxReader instanceof ItfReader2) {
                modelVersion = "1";
            }
        }
        finally {
            if (ioxReader != null) {
                ioxReader.close();
            }
        }
        return modelVersion;
    }

    public static IoxEvent cloneIoxEvent(IoxEvent event) {
        if (event instanceof StartTransferEvent) {
            event = new StartTransferEvent();
        } else if (event instanceof StartBasketEvent) {
            event = new ch.interlis.iox_j.StartBasketEvent(((StartBasketEvent)event).getType(), ((StartBasketEvent)event).getBid());
        } else if (event instanceof ch.interlis.iox.ObjectEvent) {
            event = new ObjectEvent(new Iom_jObject(((ch.interlis.iox.ObjectEvent)event).getIomObject()));
        } else if (event instanceof ch.interlis.iox.EndBasketEvent) {
            event = new EndBasketEvent();
        } else if (event instanceof EndTransferEvent) {
            event = new ch.interlis.iox_j.EndTransferEvent();
        }
        return event;
    }

    public static String getVersion() {
        if (version == null) {
            ResourceBundle resVersion = ResourceBundle.getBundle("ch.interlis.iox_j.Version");
            StringBuffer ret = new StringBuffer(20);
            ret.append(resVersion.getString("version"));
            ret.append('-');
            ret.append(resVersion.getString("versionCommit"));
            version = ret.toString();
        }
        return version;
    }
}

