/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColJson;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class GeneratorPostgresql
extends GeneratorJdbc {
    private boolean createGeomIdx = false;
    private ArrayList<DbColumn> indexColumns = null;

    @Override
    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        super.visitSchemaBegin(config, schema);
        if ("True".equals(config.getValue("ch.ehi.sqlgen.createGeomIndex"))) {
            this.createGeomIdx = true;
        }
    }

    @Override
    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String isNull;
        String type = "";
        String size = "";
        Object notSupported = null;
        boolean createColNow = true;
        if (column instanceof DbColBoolean) {
            type = "boolean";
        } else if (column instanceof DbColDateTime) {
            type = "timestamp";
        } else if (column instanceof DbColDate) {
            type = "date";
        } else if (column instanceof DbColTime) {
            type = "time";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "decimal(" + Integer.toString(col.getSize()) + "," + Integer.toString(col.getPrecision()) + ")";
        } else if (column instanceof DbColGeometry) {
            DbColGeometry geo = (DbColGeometry)column;
            if (!geo.getSrsAuth().equals("EPSG")) {
                throw new IllegalArgumentException("unexpected SrsAuth <" + geo.getSrsAuth() + ">");
            }
            type = "geometry(" + GeneratorPostgresql.getPostgisType(geo.getType()) + (geo.getDimension() == 3 ? "Z" : "") + "," + geo.getSrsId() + ")";
        } else if (column instanceof DbColId) {
            type = "bigint";
        } else if (column instanceof DbColUuid) {
            type = "uuid";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "integer";
        } else {
            int colsize;
            type = column instanceof DbColVarchar ? ((colsize = ((DbColVarchar)column).getSize()) == -1 ? "text" : "varchar(" + Integer.toString(colsize) + ")") : (column instanceof DbColBlob ? "bytea" : (column instanceof DbColXml ? "xml" : (column instanceof DbColJson ? "jsonb" : "text")));
        }
        String array = "";
        if (column.getArraySize() != 0) {
            array = column.getArraySize() == -1 ? "ARRAY " : "ARRAY[" + column.getArraySize() + "] ";
        }
        String string = isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        if (column.isPrimaryKey()) {
            isNull = "PRIMARY KEY";
        }
        String sep = " ";
        String defaultValue = "";
        if (column.getDefaultValue() != null) {
            defaultValue = sep + "DEFAULT " + column.getDefaultValue();
            sep = " ";
        }
        if (column.isIndex() || this.createGeomIdx && column instanceof DbColGeometry) {
            this.indexColumns.add(column);
        }
        if (createColNow) {
            String name = column.getName();
            this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + array + isNull + defaultValue + this.newline());
            this.colSep = ",";
        }
    }

    @Override
    public void visit1TableBegin(DbTable tab) throws IOException {
        super.visit1TableBegin(tab);
        this.indexColumns = new ArrayList();
    }

    @Override
    public void visitTableEndColumn(DbTable tab) throws IOException {
        boolean tableExists = DbUtility.tableExists(this.conn, tab.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIndex(DbIndex idx) throws IOException {
        if (idx.isUnique()) {
            StringWriter out = new StringWriter();
            DbTable tab = idx.getTable();
            String tableName = tab.getName().getQName();
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            out.write(this.getIndent() + "CREATE UNIQUE INDEX " + constraintName + " ON " + tableName + " (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                if (attr instanceof DbColGeometry) {
                    if (((DbColGeometry)attr).getType() == 0) {
                        // empty if block
                    }
                    out.write(sep + "ST_AsBinary(" + attr.getName() + ")");
                } else {
                    out.write(sep + attr.getName());
                }
                sep = ",";
            }
            out.write(")" + this.newline());
            String stmt = out.toString();
            this.addCreateLine(new GeneratorJdbc.Stmt(this, stmt));
            out = null;
            if (this.conn != null && this.createdTables.contains(tab.getName())) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt);
                        dbstmt.executeUpdate(stmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add UNIQUE to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit1TableEnd(DbTable tab) throws IOException {
        String sqlTabName = tab.getName().getName();
        if (tab.getName().getSchema() != null) {
            sqlTabName = tab.getName().getSchema() + "." + sqlTabName;
        }
        boolean tableExists = DbUtility.tableExists(this.conn, tab.getName());
        super.visit1TableEnd(tab);
        for (DbColumn idxcol : this.indexColumns) {
            String idxstmt = null;
            String idxName = this.createConstraintName(tab, "idx", idxcol.getName().toLowerCase());
            idxstmt = idxcol instanceof DbColGeometry ? "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " USING GIST ( " + idxcol.getName().toLowerCase() + " )" : "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " ( " + idxcol.getName().toLowerCase() + " )";
            this.addCreateLine(new GeneratorJdbc.Stmt(this, idxstmt));
            if (this.conn == null || tableExists) continue;
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)idxstmt);
                    dbstmt.execute(idxstmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add index on column " + tab.getName() + "." + idxcol.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
        this.indexColumns = null;
        String cmt = tab.getComment();
        if (cmt != null) {
            cmt = "COMMENT ON TABLE " + sqlTabName + " IS '" + GeneratorPostgresql.escapeString(cmt) + "'";
            this.addCreateLine(new GeneratorJdbc.Stmt(this, cmt));
            if (this.conn != null && !tableExists) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)cmt);
                        dbstmt.execute(cmt);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add comment to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
        Iterator coli = tab.iteratorColumn();
        while (coli.hasNext()) {
            DbColumn col = (DbColumn)coli.next();
            cmt = col.getComment();
            if (cmt == null) continue;
            cmt = "COMMENT ON COLUMN " + sqlTabName + "." + col.getName() + " IS '" + GeneratorPostgresql.escapeString(cmt) + "'";
            this.addCreateLine(new GeneratorJdbc.Stmt(this, cmt));
            if (this.conn == null || tableExists) continue;
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)cmt);
                    dbstmt.execute(cmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add comment to table " + tab.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
    }

    public static String escapeString(String cmt) {
        StringBuilder ret = new StringBuilder(cmt.length());
        for (int i = 0; i < cmt.length(); ++i) {
            char c = cmt.charAt(i);
            ret.append(c);
            if (c != '\'') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getPostgisType(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMETRYCOLLECTION";
            }
            case 8: {
                return "CIRCULARSTRING";
            }
            case 9: {
                return "COMPOUNDCURVE";
            }
            case 10: {
                return "CURVEPOLYGON";
            }
            case 11: {
                return "MULTICURVE";
            }
            case 12: {
                return "MULTISURFACE";
            }
            case 15: {
                return "POLYHEDRALSURFACE";
            }
            case 16: {
                return "TIN";
            }
            case 17: {
                return "TRIANGLE";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void visitTableBeginConstraint(DbTable dbTab) throws IOException {
        super.visitTableBeginConstraint(dbTab);
        String sqlTabName = dbTab.getName().getQName();
        Iterator dbColi = dbTab.iteratorColumn();
        while (dbColi.hasNext()) {
            String constraintName;
            CharSequence action;
            String createstmt;
            DbColumn dbColNum;
            DbColumn dbCol = (DbColumn)dbColi.next();
            if (dbCol.getReferencedTable() != null && dbCol.getArraySize() == 0) {
                String createstmt2 = null;
                String action2 = "";
                if (dbCol.getOnUpdateAction() != null) {
                    action2 = action2 + " ON UPDATE " + dbCol.getOnUpdateAction();
                }
                if (dbCol.getOnDeleteAction() != null) {
                    action2 = action2 + " ON DELETE " + dbCol.getOnDeleteAction();
                }
                String constraintName2 = this.createConstraintName(dbTab, "fkey", dbCol.getName());
                createstmt2 = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName2 + " FOREIGN KEY ( " + dbCol.getName() + " ) REFERENCES " + dbCol.getReferencedTable().getQName() + action2 + " DEFERRABLE INITIALLY DEFERRED";
                String dropstmt2 = null;
                dropstmt2 = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName2;
                this.addConstraint(dbTab, constraintName2, createstmt2, dropstmt2);
            }
            if (dbCol instanceof DbColNumber && (((DbColNumber)dbCol).getMinValue() != null || ((DbColNumber)dbCol).getMaxValue() != null)) {
                if (dbCol.getArraySize() == 0) {
                    dbColNum = (DbColNumber)dbCol;
                    createstmt = null;
                    action = "";
                    if (((DbColNumber)dbColNum).getMinValue() != null || ((DbColNumber)dbColNum).getMaxValue() != null) {
                        action = ((DbColNumber)dbColNum).getMaxValue() == null ? ">=" + ((DbColNumber)dbColNum).getMinValue() : (((DbColNumber)dbColNum).getMinValue() == null ? "<=" + ((DbColNumber)dbColNum).getMaxValue() : "BETWEEN " + ((DbColNumber)dbColNum).getMinValue() + " AND " + ((DbColNumber)dbColNum).getMaxValue());
                    }
                    constraintName = this.createConstraintName(dbTab, "check", dbCol.getName());
                    createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " CHECK( " + dbCol.getName() + " " + (String)action + ")";
                    Object var9_10 = null;
                    String string = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
                    this.addConstraint(dbTab, constraintName, createstmt, string);
                }
            } else if (dbCol instanceof DbColDecimal && (((DbColDecimal)dbCol).getMinValue() != null || ((DbColDecimal)dbCol).getMaxValue() != null) && dbCol.getArraySize() == 0) {
                dbColNum = (DbColDecimal)dbCol;
                createstmt = null;
                action = "";
                if (((DbColDecimal)dbColNum).getMinValue() != null || ((DbColDecimal)dbColNum).getMaxValue() != null) {
                    action = ((DbColDecimal)dbColNum).getMaxValue() == null ? ">=" + ((DbColDecimal)dbColNum).getMinValue() : (((DbColDecimal)dbColNum).getMinValue() == null ? "<=" + ((DbColDecimal)dbColNum).getMaxValue() : "BETWEEN " + ((DbColDecimal)dbColNum).getMinValue() + " AND " + ((DbColDecimal)dbColNum).getMaxValue());
                }
                constraintName = this.createConstraintName(dbTab, "check", dbCol.getName());
                createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + constraintName + " CHECK( " + dbCol.getName() + " " + (String)action + ")";
                Object var9_12 = null;
                String string = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + constraintName;
                this.addConstraint(dbTab, constraintName, createstmt, string);
            }
            if (!(dbCol instanceof DbColVarchar) || ((DbColVarchar)dbCol).getValueRestriction() == null || dbCol.getArraySize() != 0) continue;
            DbColVarchar dbColTxt = (DbColVarchar)dbCol;
            createstmt = null;
            action = new StringBuffer("IN (");
            String sep = "";
            for (String restrictedValue : dbColTxt.getValueRestriction()) {
                ((StringBuffer)action).append(sep);
                ((StringBuffer)action).append("'");
                ((StringBuffer)action).append(GeneratorPostgresql.escapeString(restrictedValue));
                ((StringBuffer)action).append("'");
                sep = ",";
            }
            ((StringBuffer)action).append(")");
            String string = this.createConstraintName(dbTab, "check", dbCol.getName());
            createstmt = "ALTER TABLE " + sqlTabName + " ADD CONSTRAINT " + string + " CHECK( " + dbCol.getName() + " " + ((StringBuffer)action).toString() + ")";
            String dropstmt3 = null;
            dropstmt3 = "ALTER TABLE " + sqlTabName + " DROP CONSTRAINT " + string;
            this.addConstraint(dbTab, string, createstmt, dropstmt3);
        }
    }
}

