/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.sqlgen.SqlReader;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbUtility {
    private DbUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tableExists(Connection conn, DbTableName tableName) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            if (meta.getURL().startsWith("jdbc:postgresql:")) {
                return DbUtility.pgTableExists(conn, tableName);
            }
            if (meta.getURL().startsWith("jdbc:ili2fgdb:")) {
                return DbUtility.fgdbTableExists(conn, tableName);
            }
            String catalog = conn.getCatalog();
            String schema = tableName.getSchema();
            if (schema == null) {
                schema = meta.getUserName();
                if (conn.getMetaData().getURL().startsWith("jdbc:postgresql:")) {
                    schema = "public";
                }
            }
            ResultSet rs = null;
            try {
                String db_tableName;
                String db_schemaName;
                rs = meta.getTables(null, null, null, null);
                do {
                    if (!rs.next()) return false;
                    String db_catalogName = rs.getString("TABLE_CAT");
                    db_schemaName = rs.getString("TABLE_SCHEM");
                    db_tableName = rs.getString("TABLE_NAME");
                } while (db_schemaName != null && !db_schemaName.equalsIgnoreCase(schema) || !db_tableName.equalsIgnoreCase(tableName.getName()));
                boolean bl = true;
                return bl;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if table " + tableName + " exists", ex);
        }
    }

    private static boolean fgdbTableExists(Connection conn, DbTableName tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("SELECT NULL AS dy FROM " + tableName.getName() + "");
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -2147220655) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean pgTableExists(Connection conn, DbTableName tableName) {
        String schema = tableName.getSchema();
        schema = schema == null ? "public" : schema.toLowerCase();
        String table = tableName.getName().toLowerCase();
        try {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement("SELECT 1 FROM pg_catalog.pg_class c JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace  WHERE  n.nspname = ? AND c.relname = ? ");
                stmt.setString(1, schema);
                stmt.setString(2, table);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    boolean bl2 = true;
                    return bl2;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if table " + tableName + " exists", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sequenceExists(Connection conn, DbTableName tableName) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            if (meta.getURL().startsWith("jdbc:postgresql:")) {
                return DbUtility.pgTableExists(conn, tableName);
            }
            String schema = tableName.getSchema();
            if (schema == null) {
                schema = conn.getMetaData().getURL().startsWith("jdbc:postgresql:") ? "public" : meta.getUserName();
            }
            ResultSet rs = null;
            try {
                String db_tableName;
                String db_schemaName;
                rs = meta.getTables(null, null, null, null);
                do {
                    if (!rs.next()) return false;
                    String db_catalogName = rs.getString("TABLE_CAT");
                    db_schemaName = rs.getString("TABLE_SCHEM");
                    db_tableName = rs.getString("TABLE_NAME");
                } while (db_schemaName != null && !db_schemaName.equalsIgnoreCase(schema) || !db_tableName.equalsIgnoreCase(tableName.getName()));
                boolean bl = true;
                return bl;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if sequence " + tableName + " exists");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean schemaExists(Connection conn, String schemaName) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = null;
            try {
                String db_schemaName;
                rs = meta.getSchemas();
                do {
                    if (!rs.next()) return false;
                    String db_catalogName = rs.getString("TABLE_CATALOG");
                } while (!(db_schemaName = rs.getString("TABLE_SCHEM")).equalsIgnoreCase(schemaName));
                boolean bl = true;
                return bl;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if schema " + schemaName + " exists", ex);
        }
    }

    public static void createSchema(Connection conn, String schemaName) {
        try {
            Statement stmt = conn.createStatement();
            String sql = "CREATE SCHEMA " + schemaName;
            EhiLogger.traceBackendCmd((String)sql);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("failed to create schema " + schemaName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlScript(Connection conn, InputStreamReader script) {
        PushbackReader reader = null;
        reader = new PushbackReader(script);
        try {
            String line = SqlReader.readSqlStmt(reader, null);
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    Statement dbstmt = null;
                    try {
                        try {
                            dbstmt = conn.createStatement();
                            EhiLogger.traceBackendCmd((String)line);
                            dbstmt.execute(line);
                        }
                        finally {
                            dbstmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                line = SqlReader.readSqlStmt(reader, null);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static String readSqlStmt(PushbackReader reader) throws IOException {
        return SqlReader.readSqlStmt(reader, null);
    }
}

