/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.sqlgen.repository.DbTableName;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbUtility {
    private DbUtility() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tableExists(Connection conn, DbTableName tableName) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            if (meta.getURL().startsWith("jdbc:postgresql:")) {
                return DbUtility.pgTableExists(conn, tableName);
            }
            if (meta.getURL().startsWith("jdbc:ili2fgdb:")) {
                return DbUtility.fgdbTableExists(conn, tableName);
            }
            String catalog = conn.getCatalog();
            String schema = tableName.getSchema();
            if (schema == null) {
                schema = meta.getUserName();
                if (conn.getMetaData().getURL().startsWith("jdbc:postgresql:")) {
                    schema = "public";
                }
            }
            ResultSet rs = null;
            try {
                String db_tableName;
                String db_schemaName;
                rs = meta.getTables(null, null, null, null);
                do {
                    if (!rs.next()) {
                        return false;
                    }
                    String db_catalogName = rs.getString("TABLE_CAT");
                    db_schemaName = rs.getString("TABLE_SCHEM");
                    db_tableName = rs.getString("TABLE_NAME");
                } while (db_schemaName != null && !db_schemaName.equalsIgnoreCase(schema) || !db_tableName.equalsIgnoreCase(tableName.getName()));
                return true;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if table " + tableName + " exists", ex);
        }
    }

    private static boolean fgdbTableExists(Connection conn, DbTableName tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("SELECT NULL AS dy FROM " + tableName.getName());
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -2147220655) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    return false;
                }
                throw e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            if (stmt != null) {
                stmt.close();
                stmt = null;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean pgTableExists(Connection conn, DbTableName tableName) {
        String schema = tableName.getSchema();
        schema = schema == null ? "public" : schema.toLowerCase();
        String table = tableName.getName().toLowerCase();
        try {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.prepareStatement("SELECT 1 FROM pg_catalog.pg_class c JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace  WHERE  n.nspname = ? AND c.relname = ? ");
                stmt.setString(1, schema);
                stmt.setString(2, table);
                rs = stmt.executeQuery();
                if (!rs.next()) return false;
                return true;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if table " + tableName + " exists", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean sequenceExists(Connection conn, DbTableName tableName) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            if (meta.getURL().startsWith("jdbc:postgresql:")) {
                return DbUtility.pgTableExists(conn, tableName);
            }
            String schema = tableName.getSchema();
            if (schema == null) {
                schema = conn.getMetaData().getURL().startsWith("jdbc:postgresql:") ? "public" : meta.getUserName();
            }
            ResultSet rs = null;
            try {
                String db_tableName;
                String db_schemaName;
                rs = meta.getTables(null, null, null, null);
                do {
                    if (!rs.next()) {
                        return false;
                    }
                    String db_catalogName = rs.getString("TABLE_CAT");
                    db_schemaName = rs.getString("TABLE_SCHEM");
                    db_tableName = rs.getString("TABLE_NAME");
                } while (db_schemaName != null && !db_schemaName.equalsIgnoreCase(schema) || !db_tableName.equalsIgnoreCase(tableName.getName()));
                return true;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if sequence " + tableName + " exists");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean schemaExists(Connection conn, String schemaName) {
        try {
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = null;
            try {
                String db_schemaName;
                rs = meta.getSchemas();
                do {
                    if (!rs.next()) {
                        return false;
                    }
                    String db_catalogName = rs.getString("TABLE_CATALOG");
                } while (!(db_schemaName = rs.getString("TABLE_SCHEM")).equalsIgnoreCase(schemaName));
                return true;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed to check if schema " + schemaName + " exists", ex);
        }
    }

    public static void createSchema(Connection conn, String schemaName) {
        try {
            Statement stmt = conn.createStatement();
            String sql = "CREATE SCHEMA " + schemaName;
            EhiLogger.traceBackendCmd((String)sql);
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new IllegalStateException("failed to create schema " + schemaName, e);
        }
    }

    public static void executeSqlScript(Connection conn, InputStreamReader script) {
        PushbackReader reader = null;
        reader = new PushbackReader(script);
        try {
            try {
                String line = DbUtility.readSqlStmt(reader);
                while (line != null) {
                    if ((line = line.trim()).length() > 0) {
                        Statement dbstmt = null;
                        try {
                            try {
                                dbstmt = conn.createStatement();
                                EhiLogger.traceBackendCmd((String)line);
                                dbstmt.execute(line);
                            }
                            finally {
                                dbstmt.close();
                            }
                        }
                        catch (SQLException ex) {
                            throw new IllegalStateException(ex);
                        }
                    }
                    line = DbUtility.readSqlStmt(reader);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static String readSqlStmt(PushbackReader reader) throws IOException {
        StringBuffer stmt = new StringBuffer();
        int c = reader.read();
        while (c != -1) {
            if (c == 45) {
                c = reader.read();
                if (c == -1) {
                    stmt.append('-');
                    break;
                }
                if (c == 45) {
                    c = reader.read();
                    while (c != -1) {
                        if (c == 10) {
                            c = reader.read();
                            if (c != -1 && c != 13) {
                                reader.unread(c);
                            }
                            break;
                        }
                        if (c == 13) {
                            c = reader.read();
                            if (c != -1 && c != 10) {
                                reader.unread(c);
                            }
                            break;
                        }
                        c = reader.read();
                    }
                } else {
                    stmt.append('-');
                    stmt.append((char)c);
                }
            } else if (c == 39) {
                stmt.append((char)c);
                while ((c = reader.read()) != -1) {
                    if (c == 39) {
                        c = reader.read();
                        if (c == -1) break;
                        if (c == 39) {
                            stmt.append('\'');
                            stmt.append('\'');
                            continue;
                        }
                        reader.unread(c);
                        break;
                    }
                    stmt.append((char)c);
                }
                stmt.append('\'');
            } else {
                if (c == 59) {
                    stmt.append((char)c);
                    c = reader.read();
                    if (c == 10) {
                        c = reader.read();
                        if (c == -1 || c == 13) break;
                        reader.unread(c);
                        break;
                    }
                    if (c == 13) {
                        c = reader.read();
                        if (c == -1 || c == 10) break;
                        reader.unread(c);
                        break;
                    }
                    if (c == -1) break;
                    reader.unread(c);
                    break;
                }
                if (c == 10) {
                    c = reader.read();
                    if (c != -1 && c != 13) {
                        reader.unread(c);
                    }
                } else if (c == 13) {
                    c = reader.read();
                    if (c != -1 && c != 10) {
                        reader.unread(c);
                    }
                } else {
                    stmt.append((char)c);
                }
            }
            c = reader.read();
        }
        if (stmt.length() == 0) {
            return null;
        }
        return stmt.toString();
    }
}

