/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import java.io.IOException;

public class GeneratorMdb
extends GeneratorJdbc {
    public void visitColumn(DbColumn column) throws IOException {
        String type = "";
        String size = "";
        Object notSupported = null;
        if (column instanceof DbColBoolean) {
            type = "BIT";
        } else if (column instanceof DbColDateTime) {
            type = "TIMESTAMP";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "DOUBLE";
        } else if (column instanceof DbColGeometry) {
            DbColGeometry geocol = (DbColGeometry)column;
            type = "BINARY";
        } else if (column instanceof DbColId) {
            type = "LONG";
        } else if (column instanceof DbColUuid) {
            type = "TEXT(36)";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "LONG";
        } else {
            int colsize;
            type = column instanceof DbColVarchar ? ((colsize = ((DbColVarchar)column).getSize()) == -1 || colsize > 255 ? "MEMO" : "TEXT(" + Integer.toString(colsize) + ")") : "TEXT(20)";
        }
        String isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        String name = column.getName();
        this.out.write(String.valueOf(this.getIndent()) + this.colSep + name + " " + type + " " + isNull + this.newline());
        this.colSep = ",";
    }
}

