/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.TopoSort;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class GeneratorGeoPackage
extends GeneratorJdbc {
    private boolean createGeomIdx = false;
    private String today = "";
    private ArrayList<DbColumn> indexColumns = null;
    private ArrayList<DbColGeometry> geomColumns = null;

    @Override
    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        super.visitSchemaBegin(config, schema);
        this.today = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss.S'Z'").format(new Date());
        if ("True".equals(config.getValue("ch.ehi.sqlgen.createGeomIndex"))) {
            this.createGeomIdx = true;
        }
        TopoSort topoSort = new TopoSort();
        for (DbTable table : schema.getTables()) {
            topoSort.add((Object)table);
            Iterator dbColi = table.iteratorColumn();
            while (dbColi.hasNext()) {
                DbTable refTable;
                DbColumn dbCol = (DbColumn)dbColi.next();
                if (dbCol.getReferencedTable() == null || (refTable = schema.findTable(dbCol.getReferencedTable())) == null) continue;
                topoSort.addcond((Object)refTable, (Object)table);
            }
        }
        topoSort.sort();
        schema.setTables(topoSort.getResult());
    }

    @Override
    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String isNull;
        String constraintName;
        String constraintAction;
        String type = "";
        String size = "";
        Object notSupported = null;
        boolean createColNow = true;
        String createConstraintStmt = "";
        if (column instanceof DbColBoolean) {
            type = "BOOLEAN";
        } else if (column instanceof DbColDateTime) {
            type = "DATETIME";
        } else if (column instanceof DbColDate) {
            type = "DATE";
        } else if (column instanceof DbColTime) {
            type = "TIME";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "DOUBLE";
            constraintAction = null;
            if (col.getMaxValue() != null || col.getMinValue() != null) {
                constraintAction = col.getMaxValue() == null ? ">=" + col.getMinValue() : (col.getMinValue() == null ? "<=" + col.getMaxValue() : "BETWEEN " + col.getMinValue() + " AND " + col.getMaxValue());
            }
            if (constraintAction != null) {
                constraintName = this.createConstraintName(dbTab, "check", col.getName());
                createConstraintStmt = " CONSTRAINT " + constraintName + " CHECK( " + col.getName() + " " + constraintAction + ")";
            }
        } else if (column instanceof DbColGeometry) {
            this.geomColumns.add((DbColGeometry)column);
            type = GeneratorGeoPackage.getGpkgGeometryTypename(((DbColGeometry)column).getType());
        } else if (column instanceof DbColId) {
            type = "INTEGER";
        } else if (column instanceof DbColUuid) {
            type = "TEXT(36)";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "INTEGER";
            constraintAction = null;
            if (col.getMaxValue() != null || col.getMinValue() != null) {
                constraintAction = col.getMaxValue() == null ? ">=" + col.getMinValue() : (col.getMinValue() == null ? "<=" + col.getMaxValue() : "BETWEEN " + col.getMinValue() + " AND " + col.getMaxValue());
            }
            if (constraintAction != null) {
                constraintName = this.createConstraintName(dbTab, "check", col.getName());
                createConstraintStmt = " CONSTRAINT " + constraintName + " CHECK( " + col.getName() + " " + constraintAction + ")";
            }
        } else {
            int colsize;
            type = column instanceof DbColVarchar ? ((colsize = ((DbColVarchar)column).getSize()) == -1 ? "TEXT" : "TEXT(" + Integer.toString(colsize) + ")") : (column instanceof DbColBlob ? "BLOB" : (column instanceof DbColXml ? "TEXT" : "TEXT"));
        }
        String string = isNull = column.isNotNull() ? "NOT NULL" : "NULL";
        if (column.isPrimaryKey()) {
            isNull = "NOT NULL PRIMARY KEY";
        }
        String sep = " ";
        String defaultValue = "";
        if (column.getDefaultValue() != null) {
            defaultValue = String.valueOf(sep) + "DEFAULT " + column.getDefaultValue();
            sep = " ";
        }
        if (column.isIndex() || this.createGeomIdx && column instanceof DbColGeometry) {
            this.indexColumns.add(column);
        }
        String fkConstraint = "";
        if (column.getReferencedTable() != null) {
            String action = "";
            if (column.getOnUpdateAction() != null) {
                action = String.valueOf(action) + " ON UPDATE " + column.getOnUpdateAction();
            }
            if (column.getOnDeleteAction() != null) {
                action = String.valueOf(action) + " ON DELETE " + column.getOnDeleteAction();
            }
            String constraintName2 = this.createConstraintName(dbTab, "fkey", column.getName());
            fkConstraint = " CONSTRAINT " + constraintName2 + " REFERENCES " + column.getReferencedTable().getQName() + action + " DEFERRABLE INITIALLY DEFERRED";
        }
        if (createColNow) {
            String name = column.getName();
            this.out.write(String.valueOf(this.getIndent()) + this.colSep + name + " " + type + " " + isNull + defaultValue + fkConstraint + createConstraintStmt + this.newline());
            this.colSep = ",";
        }
    }

    @Override
    public void visit1TableBegin(DbTable tab) throws IOException {
        super.visit1TableBegin(tab);
        this.geomColumns = new ArrayList();
        this.indexColumns = new ArrayList();
    }

    @Override
    public void visitTableEndColumn(DbTable tab) throws IOException {
        Iterator idxi = tab.iteratorIndex();
        while (idxi.hasNext()) {
            DbIndex idx = (DbIndex)idxi.next();
            if (!idx.isUnique()) continue;
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            this.out.write(String.valueOf(this.getIndent()) + this.colSep + "CONSTRAINT " + constraintName + " UNIQUE (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                this.out.write(String.valueOf(sep) + attr.getName());
                sep = ",";
            }
            this.out.write(")" + this.newline());
            this.colSep = ",";
        }
    }

    @Override
    public void visit1TableEnd(DbTable tab) throws IOException {
        String sqlTabName = tab.getName().getName();
        if (tab.getName().getSchema() != null) {
            sqlTabName = String.valueOf(tab.getName().getSchema()) + "." + sqlTabName;
        }
        boolean tableExists = DbUtility.tableExists(this.conn, tab.getName());
        super.visit1TableEnd(tab);
        if (this.geomColumns.size() > 0) {
            DbColGeometry geo = this.geomColumns.get(0);
            String srsId = "(SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization='" + geo.getSrsAuth() + "' AND organization_coordsys_id=" + geo.getSrsId() + ")";
            String cmt = tab.getComment() == null ? "null" : "'" + tab.getComment() + "'";
            String stmt1 = "INSERT INTO gpkg_contents (table_name,data_type,identifier,description,last_change,min_x,min_y,max_x,max_y,srs_id)VALUES ('" + tab.getName().getName() + "','features','" + tab.getName().getName() + "'," + cmt + ",'" + this.today + "'," + geo.getMin1() + "," + geo.getMin2() + "," + geo.getMax1() + "," + geo.getMax2() + "," + srsId + ")";
            String stmt2 = "INSERT INTO gpkg_geometry_columns (table_name,column_name,geometry_type_name,srs_id,z,m)VALUES ('" + tab.getName().getName() + "','" + geo.getName() + "' ,'" + GeneratorGeoPackage.getGpkgGeometryTypename(geo.getType()) + "'," + srsId + "," + (geo.getDimension() == 2 ? "0" : "1") + ",0)";
            this.addCreateLine(new GeneratorJdbc.Stmt(this, stmt1));
            this.addCreateLine(new GeneratorJdbc.Stmt(this, stmt2));
            String dropstmt1 = "DELETE FROM gpkg_contents WHERE table_name='" + tab.getName().getName() + "'";
            this.addDropLine(new GeneratorJdbc.Stmt(this, dropstmt1));
            String dropstmt2 = "DELETE FROM gpkg_geometry_columns WHERE table_name='" + tab.getName().getName() + "' AND column_name='" + geo.getName() + "'";
            this.addDropLine(new GeneratorJdbc.Stmt(this, dropstmt2));
            if (!tableExists) {
                Statement dbstmt = null;
                try {
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt1);
                        dbstmt.execute(stmt1);
                    }
                    finally {
                        dbstmt.close();
                    }
                    try {
                        dbstmt = this.conn.createStatement();
                        EhiLogger.traceBackendCmd((String)stmt2);
                        dbstmt.execute(stmt2);
                    }
                    finally {
                        dbstmt.close();
                    }
                }
                catch (SQLException ex) {
                    IOException iox = new IOException("failed to add geometry column " + geo.getName() + " to table " + tab.getName());
                    iox.initCause(ex);
                    throw iox;
                }
            }
        }
        this.geomColumns = null;
        for (DbColumn idxcol : this.indexColumns) {
            String idxstmt = null;
            String idxName = this.createConstraintName(tab, "idx", idxcol.getName().toLowerCase());
            if (!(idxcol instanceof DbColGeometry)) {
                idxstmt = "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " ( " + idxcol.getName().toLowerCase() + " )";
            }
            if (idxstmt == null) continue;
            this.addCreateLine(new GeneratorJdbc.Stmt(this, idxstmt));
            if (tableExists) continue;
            Statement dbstmt = null;
            try {
                try {
                    dbstmt = this.conn.createStatement();
                    EhiLogger.traceBackendCmd((String)idxstmt);
                    dbstmt.execute(idxstmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed to add index on column " + tab.getName() + "." + idxcol.getName());
                iox.initCause(ex);
                throw iox;
            }
        }
        this.indexColumns = null;
    }

    @Override
    public void visitIndex(DbIndex idx) throws IOException {
    }

    public static String escapeString(String cmt) {
        StringBuilder ret = new StringBuilder(cmt.length());
        int i = 0;
        while (i < cmt.length()) {
            char c = cmt.charAt(i);
            ret.append(c);
            if (c == '\'') {
                ret.append(c);
            }
            ++i;
        }
        return ret.toString();
    }

    public static String getGpkgGeometryTypename(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMCOLLECTION";
            }
            case 8: {
                return "CIRCULARSTRING";
            }
            case 9: {
                return "COMPOUNDCURVE";
            }
            case 10: {
                return "CURVEPOLYGON";
            }
            case 11: {
                return "MULTICURVE";
            }
            case 12: {
                return "MULTISURFACE";
            }
        }
        throw new IllegalArgumentException();
    }
}

