/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen;

import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.repository.DbTableName;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Test;

public class DbUtilityTest {
    public static final String DBSCHEMA = "DbUtilityTest";
    String dburl = System.getProperty("dburl");
    String dbuser = System.getProperty("dbusr");
    String dbpwd = System.getProperty("dbpwd");

    @Test
    public void tableExists() throws SQLException, ClassNotFoundException {
        Class<?> driverClass = Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection(this.dburl, this.dbuser, this.dbpwd);
        Statement stmt = conn.createStatement();
        String TABLE1 = "DbUtility1";
        String TABLE2 = "DbUtility2";
        String TABLE_XXX = "TableXXXX234012";
        stmt.execute("DROP SCHEMA IF EXISTS DbUtilityTest CASCADE;");
        stmt.execute("CREATE SCHEMA DbUtilityTest;");
        stmt.execute("CREATE TABLE DbUtilityTest.DbUtility1()");
        stmt.execute("CREATE TABLE IF NOT EXISTS DbUtility2()");
        stmt.close();
        Assert.assertTrue((boolean)DbUtility.tableExists(conn, new DbTableName(DBSCHEMA, "DbUtility1")));
        Assert.assertFalse((boolean)DbUtility.tableExists(conn, new DbTableName(DBSCHEMA, "TableXXXX234012")));
        Assert.assertTrue((boolean)DbUtility.tableExists(conn, new DbTableName("DbUtility2")));
        Assert.assertFalse((boolean)DbUtility.tableExists(conn, new DbTableName("TableXXXX234012")));
        conn.close();
    }

    @Test
    public void sequenceExists() throws SQLException, ClassNotFoundException {
        Class<?> driverClass = Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection(this.dburl, this.dbuser, this.dbpwd);
        Statement stmt = conn.createStatement();
        String SEQ1 = "t_ili2db_seq";
        String SEQ_XXX = "SeqXXXX234012";
        stmt.execute("DROP SCHEMA IF EXISTS DbUtilityTest CASCADE;");
        stmt.execute("CREATE SCHEMA DbUtilityTest;");
        stmt.execute("CREATE SEQUENCE DbUtilityTest.t_ili2db_seq");
        stmt.close();
        Assert.assertTrue((boolean)DbUtility.sequenceExists(conn, new DbTableName(DBSCHEMA, "t_ili2db_seq")));
        Assert.assertFalse((boolean)DbUtility.sequenceExists(conn, new DbTableName(DBSCHEMA, "SeqXXXX234012")));
        conn.close();
    }

    @Test
    public void schemaExists() throws SQLException, ClassNotFoundException {
        Class<?> driverClass = Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection(this.dburl, this.dbuser, this.dbpwd);
        Statement stmt = conn.createStatement();
        String SCHEMA_XXX = "SeqXXXX234012";
        stmt.execute("DROP SCHEMA IF EXISTS DbUtilityTest CASCADE;");
        stmt.execute("CREATE SCHEMA DbUtilityTest;");
        stmt.close();
        Assert.assertTrue((boolean)DbUtility.schemaExists(conn, DBSCHEMA));
        Assert.assertFalse((boolean)DbUtility.schemaExists(conn, "SeqXXXX234012"));
        conn.close();
    }

    @Test
    public void createSchema() throws SQLException, ClassNotFoundException {
        Class<?> driverClass = Class.forName("org.postgresql.Driver");
        Connection conn = DriverManager.getConnection(this.dburl, this.dbuser, this.dbpwd);
        Statement stmt = conn.createStatement();
        stmt.execute("DROP SCHEMA IF EXISTS DbUtilityTest CASCADE;");
        stmt.close();
        DbUtility.createSchema(conn, DBSCHEMA);
        Assert.assertTrue((boolean)DbUtility.schemaExists(conn, DBSCHEMA));
        conn.close();
    }
}

