/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.GraphicalCompositeFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.SeparatorFigure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;

public class PackageFigure
extends NodeFigure {
    private TextFigure packageNameFigure;
    private TextFigure packagePathFigure;

    public PackageFigure() {
        this((Figure)new RectangleFigure());
    }

    private PackageFigure(Figure newPresentationFigure) {
        super(newPresentationFigure);
    }

    public void draw(Graphics g) {
        g.setColor((Color)this.getAttribute("FillColor"));
        g.fillPolygon(this.getPolygon());
        g.setColor((Color)this.getAttribute("FrameColor"));
        g.drawPolygon(this.getPolygon());
        this.packageNameFigure.draw(g);
        this.packagePathFigure.draw(g);
    }

    private Polygon getPolygon() {
        Rectangle r = this.displayBox();
        Polygon p = new Polygon();
        int widthUpperRectangle = 13 * r.width / 32;
        int heightUpperRectangle = 6 * r.height / 26;
        int dx = r.x;
        int dy = r.y;
        p.addPoint(0 + dx, heightUpperRectangle + dy);
        p.addPoint(r.width + dx - 1, heightUpperRectangle + dy);
        p.addPoint(r.width + dx - 1, r.height + dy - 1);
        p.addPoint(0 + dx, r.height + dy - 1);
        p.addPoint(0 + dx, 0 + dy);
        p.addPoint(widthUpperRectangle + dx, 0 + dy);
        p.addPoint(widthUpperRectangle + dx, heightUpperRectangle + dy);
        return p;
    }

    @Override
    protected void initialize() {
        this.removeAll();
        this.packageNameFigure = new TextFigure(){

            public void setText(String newText) {
                if (PackageFigure.this.updateName(newText)) {
                    super.setText(newText);
                }
                PackageFigure.this.update();
            }
        };
        this.packageNameFigure.setFont(this.getFont());
        this.packagePathFigure = new TextFigure(){

            public void setText(String newText) {
                super.setText(newText);
                PackageFigure.this.update();
            }
        };
        this.packagePathFigure.setFont(this.getFont());
        this.packagePathFigure.setReadOnly(true);
        SeparatorFigure separator = new SeparatorFigure();
        separator.setLineVisible(false);
        GraphicalCompositeFigure nameFigure = new GraphicalCompositeFigure((Figure)separator);
        nameFigure.add((Figure)this.packageNameFigure);
        nameFigure.add((Figure)this.packagePathFigure);
        nameFigure.getLayouter().setInsets(new Insets(15, 4, 0, 0));
        this.add((Figure)nameFigure);
        super.initialize();
    }

    @Override
    public void updateView() {
        if (this.getModelElement() != null) {
            if (!this.getModelElement().containsNamespace()) {
                this.removeVisually();
            } else {
                super.updateView();
                this.packageNameFigure.setText(this.getModelElement().getDefLangName());
            }
        }
    }
}

