/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.IliImport;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.modeltopicclass.TopicDepends;
import ch.ehi.interlis.tools.ModelElementUtility;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.ModelElementComparator;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ModelElementSelectionDialog
extends BaseDialog {
    private static ResourceBundle resModelElementSelectionDialog = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/ModelElementSelectionDialog");
    private Iterator iterator = null;
    private TreeSet referencables = null;
    private ModelDef modelDef = null;
    private RoleDef roleDef = null;
    private TopicDef topicDef = null;
    private AbstractClassDef abstractClassDef = null;
    private DomainDef domainDef = null;
    private ArrayList selectedItems = new ArrayList();
    private JPanel ivjBaseDialogContentPane = null;
    private JButton ivjBtnAssign = null;
    private JButton ivjBtnCancel = null;
    private JLabel ivjLblClassName = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JList ivjLstModelElements = null;
    private JScrollPane ivjScpModelElements = null;

    public ModelElementSelectionDialog(Dialog owner, String title, boolean modal, RoleDef roleDef) {
        super((Component)owner, title, modal);
        this.initialize();
        this.addEscapeKey();
        this.setRestrictedRoleList(roleDef);
        this.show();
    }

    public ModelElementSelectionDialog(Dialog owner, String title, boolean modal, AbstractClassDef abstractClassDef) {
        super((Component)owner, title, modal);
        this.initialize();
        this.setDomainList(abstractClassDef);
        this.show();
    }

    private void addEscapeKey() {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -2972481431614869047L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ModelElementSelectionDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    public ModelElementSelectionDialog(Dialog owner, String title, boolean modal, ModelDef modelDef) {
        super((Component)owner, title, modal);
        this.initialize();
        this.setImportList(modelDef);
        this.show();
    }

    public ModelElementSelectionDialog(Dialog owner, String title, boolean modal, TopicDef topicDef) {
        super((Component)owner, title, modal);
        this.initialize();
        this.setTopicDependsList(topicDef);
        this.show();
    }

    public ModelElementSelectionDialog(Dialog owner, String title, boolean modal, ModelElement context, Class aclass) {
        super((Component)owner, title, modal);
        this.initialize();
        this.getLblClassName().setText(ElementUtils.getDisplayName(aclass));
        this.fillList(context, aclass);
        this.show();
    }

    public ModelElementSelectionDialog(Dialog owner, String dlgTitle, String lstTitle, boolean modal, ModelElement context, Set referenceableElements) {
        super((Component)owner, dlgTitle, modal);
        this.initialize();
        this.getLblClassName().setText(lstTitle);
        this.fillList(context, referenceableElements);
        this.show();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.okPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ListSelectionEvent arg1) {
        try {
            this.lstModelElements_ValueChanged();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void fillList(ModelElement modelElement, Set set) {
        this.referencables = new TreeSet(new ModelElementComparator());
        this.referencables.addAll(set);
        Vector<String> names = new Vector<String>();
        names.add(new String());
        for (ModelElement refModelElement : this.referencables) {
            names.add(ElementUtils.formatWithPackageName(refModelElement));
        }
        this.getLstModelElements().setListData(names);
    }

    private void fillList(ModelElement modelElement, Class referenceClass) {
        HashSet set = new HashSet();
        Set candidates = ModelElementUtility.getReferencableElements(modelElement, referenceClass);
        for (Object referencableObject : candidates) {
            if (referenceClass == TopicDef.class || referenceClass == ModelDef.class) {
                Iterator iteratorDependency = null;
                iteratorDependency = referenceClass == ModelDef.class ? ((ModelDef)modelElement).iteratorIliImport() : modelElement.iteratorClientDependency();
                boolean found = false;
                while (!found && iteratorDependency.hasNext()) {
                    Dependency dependency = (Dependency)iteratorDependency.next();
                    Iterator iteratorSupplier = dependency.iteratorSupplier();
                    while (!found && iteratorSupplier.hasNext()) {
                        Object supplier = iteratorSupplier.next();
                        if (!supplier.equals(referencableObject)) continue;
                        found = true;
                    }
                }
                if (found) continue;
                set.add(referencableObject);
                continue;
            }
            set.add(referencableObject);
        }
        this.fillList(modelElement, set);
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblClassName = new GridBagConstraints();
                constraintsLblClassName.gridx = 1;
                constraintsLblClassName.gridy = 1;
                constraintsLblClassName.ipadx = 67;
                constraintsLblClassName.insets = new Insets(17, 13, 5, 22);
                this.getBaseDialogContentPane().add((Component)this.getLblClassName(), constraintsLblClassName);
                GridBagConstraints constraintsBtnAssign = new GridBagConstraints();
                constraintsBtnAssign.gridx = 1;
                constraintsBtnAssign.gridy = 3;
                constraintsBtnAssign.fill = 2;
                constraintsBtnAssign.ipadx = 21;
                constraintsBtnAssign.insets = new Insets(9, 30, 12, 11);
                this.getBaseDialogContentPane().add((Component)this.getBtnAssign(), constraintsBtnAssign);
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 2;
                constraintsBtnCancel.gridy = 3;
                constraintsBtnCancel.fill = 2;
                constraintsBtnCancel.ipadx = 29;
                constraintsBtnCancel.insets = new Insets(9, 11, 12, 54);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsScpModelElements = new GridBagConstraints();
                constraintsScpModelElements.gridx = 1;
                constraintsScpModelElements.gridy = 2;
                constraintsScpModelElements.gridwidth = 2;
                constraintsScpModelElements.fill = 1;
                constraintsScpModelElements.weightx = 1.0;
                constraintsScpModelElements.weighty = 1.0;
                constraintsScpModelElements.ipadx = 293;
                constraintsScpModelElements.ipady = 128;
                constraintsScpModelElements.insets = new Insets(5, 15, 8, 12);
                this.getBaseDialogContentPane().add((Component)this.getScpModelElements(), constraintsScpModelElements);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnAssign() {
        if (this.ivjBtnAssign == null) {
            try {
                this.ivjBtnAssign = new JButton();
                this.ivjBtnAssign.setName("BtnAssign");
                this.ivjBtnAssign.setText(ModelElementSelectionDialog.getAssignString());
                this.ivjBtnAssign.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnAssign;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText(ModelElementSelectionDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    public DomainDef getDomainDef() {
        return this.domainDef;
    }

    private JLabel getLblClassName() {
        if (this.ivjLblClassName == null) {
            try {
                this.ivjLblClassName = new JLabel();
                this.ivjLblClassName.setName("LblClassName");
                this.ivjLblClassName.setText("<Class>:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblClassName;
    }

    private JList getLstModelElements() {
        if (this.ivjLstModelElements == null) {
            try {
                this.ivjLstModelElements = new JList();
                this.ivjLstModelElements.setName("LstModelElements");
                this.ivjLstModelElements.setBounds(0, 0, 311, 160);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLstModelElements;
    }

    private JScrollPane getScpModelElements() {
        if (this.ivjScpModelElements == null) {
            try {
                this.ivjScpModelElements = new JScrollPane();
                this.ivjScpModelElements.setName("ScpModelElements");
                this.ivjScpModelElements.setAutoscrolls(true);
                this.getScpModelElements().setViewportView(this.getLstModelElements());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScpModelElements;
    }

    public ArrayList getSelectedItems() {
        return this.selectedItems;
    }

    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getBtnAssign().addActionListener(this.ivjEventHandler);
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getLstModelElements().addListSelectionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ModelElementSelectionDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(425, 245);
            this.setTitle(resModelElementSelectionDialog.getString("ModelElementSelectionDialog_title"));
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void lstModelElements_ValueChanged() {
        this.getBtnAssign().setEnabled(!this.getLstModelElements().isSelectionEmpty());
    }

    protected boolean save() {
        int i;
        this.selectedItems = new ArrayList();
        int[] indices = this.getLstModelElements().getSelectedIndices();
        Object[] sortedArray = this.referencables.toArray();
        for (i = 0; i < indices.length; ++i) {
            this.selectedItems.add(sortedArray[indices[i] - 1]);
        }
        if (this.modelDef != null) {
            try {
                for (i = 0; i < this.selectedItems.size(); ++i) {
                    ModelDef supplier = (ModelDef)this.selectedItems.get(i);
                    ElementFactory.createDependency(IliImport.class, this.modelDef, supplier);
                }
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        } else if (this.topicDef != null) {
            try {
                for (i = 0; i < this.selectedItems.size(); ++i) {
                    TopicDef supplier = (TopicDef)this.selectedItems.get(i);
                    ElementFactory.createDependency(TopicDepends.class, this.topicDef, supplier);
                }
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        } else if (this.abstractClassDef != null) {
            this.domainDef = null;
            i = 0;
            if (i < this.selectedItems.size()) {
                this.domainDef = (DomainDef)this.selectedItems.get(i);
            }
        } else if (this.roleDef != null) {
            try {
                for (i = 0; i < this.selectedItems.size(); ++i) {
                    AbstractClassDef restriction = (AbstractClassDef)this.selectedItems.get(i);
                    this.roleDef.addRestriction(restriction);
                }
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return super.save();
    }

    public void setDomainList(AbstractClassDef abstractClassDef) {
        this.getLblClassName().setText(ElementUtils.getDisplayName(DomainDef.class));
        this.abstractClassDef = abstractClassDef;
        this.getLstModelElements().setSelectionMode(0);
        this.fillList((ModelElement)abstractClassDef, DomainDef.class);
    }

    public void setImportList(ModelDef modelDef) {
        this.getLblClassName().setText(ElementUtils.getDisplayName(ModelDef.class));
        this.modelDef = modelDef;
        this.fillList((ModelElement)modelDef, ModelDef.class);
    }

    public void setRestrictedRoleList(RoleDef roleDef) {
        this.getLblClassName().setText(ElementUtils.getDisplayName(ClassDef.class));
        this.roleDef = roleDef;
        this.fillList((ModelElement)roleDef.getAssociation(), AbstractClassDef.class);
    }

    public void setTopicDependsList(TopicDef topicDef) {
        this.getLblClassName().setText(ElementUtils.getDisplayName(TopicDef.class));
        this.topicDef = topicDef;
        this.fillList((ModelElement)topicDef, TopicDef.class);
    }

    class IvjEventHandler
    implements ActionListener,
    ListSelectionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ModelElementSelectionDialog.this.getBtnAssign()) {
                ModelElementSelectionDialog.this.connEtoC1(e);
            }
            if (e.getSource() == ModelElementSelectionDialog.this.getBtnCancel()) {
                ModelElementSelectionDialog.this.connEtoC2(e);
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == ModelElementSelectionDialog.this.getLstModelElements()) {
                ModelElementSelectionDialog.this.connEtoC3(e);
            }
        }
    }
}

