/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.ehi.basics.view.BrowserControl;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.BeanReflector;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.NlsUtils;
import ch.softenvironment.util.ParserCSV;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.CommonUserAccess;
import ch.softenvironment.view.ListMenuChoice;
import ch.softenvironment.view.SplashScreen;
import ch.softenvironment.view.ViewOptions;
import ch.softenvironment.view.WaitDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public abstract class BaseFrame
extends JFrame {
    public static final int X_CHILD_OFFSET = 50;
    public static final int Y_CHILD_OFFSET = 50;
    private ViewOptions viewOptions = null;
    private List objects = null;

    public BaseFrame() {
    }

    public BaseFrame(ViewOptions viewOptions) {
        this.viewOptions = viewOptions;
    }

    public BaseFrame(ViewOptions viewOptions, List objects) {
        this.viewOptions = viewOptions;
        this.objects = objects;
    }

    public BaseFrame(String title) {
        super(title);
    }

    protected void closeOnSave() {
        if ((this.getViewOptions() == null || this.getViewOptions().getCloseOnSave()) && this.getObjects().size() == 1) {
            this.dispose();
        }
    }

    protected final void createLookAndFeelMenu(JMenu lookAndFeelMenu) {
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        JRadioButtonMenuItem menuItem = null;
        ButtonGroup buttons = new ButtonGroup();
        for (int i = 0; i < lafs.length; ++i) {
            menuItem = new JRadioButtonMenuItem(lafs[i].getName());
            buttons.add(menuItem);
            final String lnfClassName = lafs[i].getClassName();
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BaseFrame.this.setLookAndFeel(lnfClassName);
                }
            });
            lookAndFeelMenu.add(menuItem);
        }
    }

    @Override
    public void dispose() {
        if (this.getViewOptions() != null) {
            this.getViewOptions().getViewManager().checkOut(this);
        }
        super.dispose();
    }

    protected void disposeApplication() {
        Tracer.getInstance().stop();
        super.dispose();
        System.exit(0);
    }

    public static String exceptionToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        exception.printStackTrace(writer);
        return stringWriter.toString();
    }

    protected final String exportTableData(final JTable table, final char separator) {
        final FileChooser saveDialog = new FileChooser();
        saveDialog.setDialogTitle(CommonUserAccess.getMniFileSaveAsText());
        saveDialog.addChoosableFileFilter((FileFilter)GenericFileFilter.createCsvFilter());
        if (saveDialog.showSaveDialog((Component)this) == 0) {
            this.showBusy(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PrintStream stream = null;
                    try {
                        FileOutputStream outStream = new FileOutputStream(saveDialog.getSelectedFile());
                        stream = new PrintStream(outStream);
                        ParserCSV.writeFile(stream, table, separator);
                        outStream.flush();
                        outStream.close();
                    }
                    catch (Throwable e) {
                        BaseFrame.this.handleException(e);
                    }
                    finally {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
            });
            if (saveDialog != null && saveDialog.getSelectedFile() != null) {
                try {
                    BrowserControl.displayURL((String)saveDialog.getSelectedFile().getAbsolutePath());
                }
                catch (Throwable ex) {
                    Tracer.getInstance().runtimeWarning("could not open CSV by platform spreadshet application: " + ex.getLocalizedMessage());
                }
                return saveDialog.getSelectedFile().getAbsolutePath();
            }
        }
        return null;
    }

    public final void fatalError(JFrame frame, String title, String message, Throwable exception) {
        BaseDialog.showError(frame, title, message + "\n" + ResourceManager.getResource(BaseFrame.class, "CEFatalError"), exception);
    }

    protected final void genericPopupDisplay(MouseEvent event, JPopupMenu popupMenu) {
        BaseFrame.popupDisplay(this, event, popupMenu);
    }

    protected static final void popupDisplay(Component owner, MouseEvent event, JPopupMenu popupMenu) {
        try {
            if (owner instanceof ListMenuChoice) {
                ((ListMenuChoice)((Object)owner)).adaptUserAction(event, popupMenu);
                if (event.getClickCount() == 2) {
                    ((ListMenuChoice)((Object)owner)).changeObjects(event.getSource());
                }
            }
            if (event.isPopupTrigger() && popupMenu != null) {
                popupMenu.show(event.getComponent(), event.getX(), event.getY());
            }
        }
        catch (Throwable e) {
            BaseFrame.showException(owner, e);
        }
    }

    protected final List getObjects() {
        return this.objects;
    }

    protected final String getResourceString(String propertyName) {
        return ResourceManager.getResource(this.getClass(), propertyName);
    }

    protected static final Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public final ViewOptions getViewOptions() {
        return this.viewOptions;
    }

    protected void handleException(Throwable exception) {
        BaseFrame.showException(this, exception);
    }

    protected abstract void initializeView() throws Throwable;

    public final void nyi(String title) {
        this.nyi(title, ResourceManager.getResource(BaseFrame.class, "CWNotYetImplemented"));
    }

    public final void nyi(String title, String message) {
        BaseDialog.showWarning(this, title, message);
    }

    public final void setCenterLocation() {
        BaseFrame.setCenterLocation(this);
    }

    public static final void setCenterLocation(Window window) {
        Dimension screenSize = BaseFrame.getScreenSize();
        Dimension frameSize = window.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        window.setLocation(new Point((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2));
    }

    protected void setLookAndFeel(String style) {
        try {
            if (style == null || style.length() == 0) {
                UIManager.getSystemLookAndFeelClassName();
            } else {
                UIManager.setLookAndFeel(style);
            }
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Throwable e) {
            BaseDialog.showWarning(this, ResourceManager.getResource(BaseFrame.class, "CTlookAndFeel"), NlsUtils.formatMessage(ResourceManager.getResource(BaseFrame.class, "CWManagerNotAvailable"), style) + "\n" + ResourceManager.getResource(BaseFrame.class, "CWSuppressManager"));
        }
    }

    public final void setRelativeLocation(Component parent) {
        if (parent != null) {
            this.setLocation(new Point(parent.getX() + 50, parent.getY() + 50));
        }
    }

    public static final void setSystemLookAndFeel() throws Throwable {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getViewOptions() != null && visible) {
            this.getViewOptions().getViewManager().checkIn(this.getObjects(), this);
        }
    }

    public final void showBusy(Runnable block) {
        WaitDialog.showBusy(this, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void showException(Component owner, Throwable exception) {
        try {
            Tracer.getInstance().runtimeWarning("In: " + owner + " -> stackTrace follows..." + exception.getLocalizedMessage());
            exception.printStackTrace(System.out);
            String title = null;
            String message = ResourceManager.getResource(BaseFrame.class, "CWTopLevelHandler");
            if (exception instanceof NumberFormatException) {
                if (exception.getMessage().length() == 0 || exception.getMessage().equals("empty String") || exception.getMessage().equals("-")) {
                    Tracer.getInstance().developerWarning("exception message might change -> use another recognition");
                    Tracer.getInstance().runtimeWarning("NumberFormatException ignored: " + exception.toString());
                    return;
                }
                title = ResourceManager.getResource(BaseFrame.class, "CTInputError");
                message = ResourceManager.getResource(BaseFrame.class, "CENumberFormat") + "\n  => " + exception.getLocalizedMessage();
            } else if (exception instanceof DeveloperException) {
                title = ((DeveloperException)exception).getTitle();
                message = exception.getMessage();
            } else if (exception instanceof MissingResourceException) {
                Tracer.getInstance().developerError("MissingResourceException ignored: " + exception.getLocalizedMessage());
                return;
            }
            BaseDialog.showError(owner, title, message, exception);
        }
        catch (Throwable e) {
            Tracer.getInstance().developerError("should not have been reached => " + e.getLocalizedMessage());
        }
    }

    protected static final void showSplashScreen(Dimension preferredWindowSize, String image) {
        try {
            SplashScreen window = new SplashScreen(preferredWindowSize, image);
            window.pack();
            BaseFrame.setCenterLocation(window);
            window.setVisible(true);
            Thread.sleep(5000L);
            window.dispose();
        }
        catch (Throwable e) {
            Tracer.getInstance().runtimeWarning("<image=" + image + "> " + e.getLocalizedMessage());
        }
    }

    protected static final void showSplashScreen(Dimension preferredWindowSize, ImageIcon image) {
        BaseFrame.showSplashScreen(preferredWindowSize, image, 5000L);
    }

    protected static final void showSplashScreen(Dimension preferredWindowSize, ImageIcon image, long timeOut) {
        try {
            SplashScreen window = new SplashScreen(preferredWindowSize, image);
            window.pack();
            BaseFrame.setCenterLocation(window);
            window.setVisible(true);
            Thread.sleep(timeOut);
            window.dispose();
        }
        catch (Throwable e) {
            Tracer.getInstance().runtimeWarning("<image=" + image + ">)" + e.getLocalizedMessage());
        }
    }

    protected void updateStringComponent(Component component) {
        Class<?> resource = null;
        Component[] children = null;
        if (component instanceof JMenu) {
            children = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            children = ((Container)component).getComponents();
            if (!component.getClass().getName().startsWith("javax.swing") && !component.getClass().getName().startsWith("java.awt")) {
                resource = component.getClass();
            }
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                Component child = children[i];
                this.updateStringProperty(resource, child, "text");
                this.updateStringProperty(resource, child, "toolTipText");
                this.updateStringComponent(child);
            }
        }
    }

    private void updateStringProperty(Class resource, Component component, String property) {
        block5: {
            BeanReflector bean;
            if (component.getName() != null && (bean = new BeanReflector(component, property)).hasProperty() == 3) {
                try {
                    String nls = null;
                    nls = resource == null ? this.getResourceString(component.getName() + "_" + property) : ResourceManager.getResource(resource, component.getName() + "_" + property);
                    bean.setValue(nls);
                }
                catch (Throwable e) {
                    if (!(e instanceof MissingResourceException) || !(component instanceof JMenuItem)) break block5;
                    try {
                        String nls = ResourceManager.getResource(CommonUserAccess.class, component.getName() + "_" + property);
                        bean.setValue(nls);
                    }
                    catch (Throwable cua) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

