/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Factory;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ReaderAdapter;
import com.ibm.xmi.framework.TagValue2Handler;
import com.ibm.xmi.framework.TagValueHandler;
import com.ibm.xmi.framework.Value;
import com.ibm.xmi.framework.ValueInfo;
import com.ibm.xmi.framework.Workspace;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import org.xml.sax.ContentHandler;

public class ReaderAdapterImpl
implements ReaderAdapter {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999-2002. All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean debug = false;
    protected Factory factory = FactoryRegister.getFactory();
    protected Hashtable objectsToXMINames = new Hashtable();
    protected Hashtable uuidsToObjects = new Hashtable();
    protected Hashtable hrefsToObjects = new Hashtable();
    protected XMIFile file;
    private XMIFiles files;
    protected Workspace workspace;

    public ContentHandler createExtension(Object object, String string, String string2) {
        if (string.equals("IXAF TVS") && object instanceof XMIObject) {
            return new TagValueHandler((XMIObject)object);
        }
        if (string.equals("IXT") && object instanceof XMIObject) {
            return new TagValue2Handler((XMIObject)object);
        }
        return null;
    }

    public Object createObject(ObjectInfo objectInfo) {
        Object object;
        if (this.debug) {
            System.out.println("createObject: " + objectInfo);
            if (objectInfo.getModel() != null) {
                object = objectInfo.getModel();
                if (object instanceof XMIFile.Metametamodel) {
                    System.out.print("Metametamodel: ");
                } else if (object instanceof XMIFile.Metamodel) {
                    System.out.print("Metamodel: ");
                } else if (object instanceof XMIFile.Model) {
                    System.out.print("Model: ");
                }
                System.out.println("name: " + ((XMIFile.Model)object).getName() + " version: " + ((XMIFile.Model)object).getVersion() + " href: " + ((XMIFile.Model)object).getHref());
            }
        }
        if (objectInfo.getHref() != null) {
            object = null;
            if (objectInfo.getUUID() != null) {
                object = (XMIObject)this.uuidsToObjects.get(objectInfo.getUUID());
            }
            if (object == null) {
                object = (XMIObject)this.hrefsToObjects.get(objectInfo.getHref());
            }
            if (object == null && this.files != null && (object = this.files.get(objectInfo.getUUID())) == null) {
                object = this.files.get(objectInfo.getHref());
            }
            if (object == null) {
                object = objectInfo.getNamespace() != null ? this.factory.makeXMIObject(objectInfo.getXMIName(), objectInfo.getNamespace()) : this.factory.makeXMIObject(objectInfo.getXMIName());
                object.setXMIProxy(true);
                if (objectInfo.getId() == null) {
                    String string = objectInfo.getHref();
                    int n = string.indexOf("#");
                    if (n != -1) {
                        object.setXMIId(string.substring(n + 1));
                    }
                } else {
                    object.setXMIId(objectInfo.getId());
                }
                if (objectInfo.getUUID() != null) {
                    object.setXMIUUID(objectInfo.getUUID());
                    this.uuidsToObjects.put(objectInfo.getUUID(), object);
                }
                object.setXMILabel(objectInfo.getLabel());
                if (objectInfo.getUUID() == null) {
                    this.hrefsToObjects.put(objectInfo.getHref(), object);
                }
                object.setXMIHref(objectInfo.getHref());
                object.setXMIFile(this.file);
                object.setXMINamespace(objectInfo.getNamespace());
                if (objectInfo.getXMIName() != null) {
                    this.objectsToXMINames.put(object, objectInfo.getXMIName());
                }
                if (this.debug) {
                    System.out.println("Made object: ");
                    System.out.println(object);
                }
            } else if (this.debug) {
                System.out.println("Returned object: ");
                System.out.println(object);
            }
            if (object != null) {
                this.handleDeclaration(objectInfo, object);
            }
            return object;
        }
        if (objectInfo.getIdref() == null) {
            object = null;
            boolean bl = false;
            if (objectInfo.getUUID() != null || objectInfo.getId() != null) {
                if (objectInfo.getUUID() != null) {
                    object = (XMIObject)this.uuidsToObjects.get(objectInfo.getUUID());
                }
                if (object == null && this.files != null) {
                    if (objectInfo.getUUID() != null) {
                        object = this.files.get(objectInfo.getUUID());
                    }
                    if (object == null && objectInfo.getId() != null) {
                        String string = this.file.getEntry();
                        if (string == null) {
                            string = this.file.getLoadFilename();
                        }
                        if (string == null) {
                            string = this.file.getFilename();
                        }
                        string = string + "#" + objectInfo.getId();
                        object = this.files.get(string);
                    }
                }
                if (object == null) {
                    object = objectInfo.getNamespace() != null ? this.factory.makeXMIObject(objectInfo.getXMIName(), objectInfo.getNamespace()) : this.factory.makeXMIObject(objectInfo.getXMIName());
                    object.setXMIUUID(objectInfo.getUUID());
                    bl = true;
                    if (objectInfo.getUUID() != null) {
                        this.uuidsToObjects.put(objectInfo.getUUID(), object);
                    }
                } else if (object.isXMIProxy()) {
                    object.setXMIProxy(false);
                    if (object.getXMIName() == null && objectInfo.getXMIName() != null) {
                        try {
                            object.setXMIName(objectInfo.getXMIName());
                        }
                        catch (XMIException xMIException) {}
                    }
                } else if (this.debug) {
                    System.out.println("Duplicate object with uuid: " + objectInfo.getUUID());
                }
            } else {
                object = objectInfo.getNamespace() != null ? this.factory.makeXMIObject(objectInfo.getXMIName(), objectInfo.getNamespace()) : this.factory.makeXMIObject(objectInfo.getXMIName());
                bl = true;
            }
            object.setXMIId(objectInfo.getId());
            object.setXMILabel(objectInfo.getLabel());
            object.setXMINamespace(objectInfo.getNamespace());
            object.setXMIFile(this.file);
            if (objectInfo.getXMIName() != null) {
                this.objectsToXMINames.put(object, objectInfo.getXMIName());
            }
            if (this.debug && bl) {
                System.out.println("Made object: ");
                System.out.println(object);
            } else if (this.debug) {
                System.out.println("Returned object: ");
                System.out.println(object);
            }
            if (object != null) {
                this.handleDeclaration(objectInfo, object);
            }
            return object;
        }
        return null;
    }

    private void handleDeclaration(ObjectInfo objectInfo, Object object) {
        if (this.workspace == null) {
            return;
        }
        if (!(object instanceof XMIObject)) {
            return;
        }
        Data data = null;
        data = this.file.getXMIVersion().equals("1.0") ? this.workspace.getDeclaration(objectInfo, (XMIObject)object, true) : this.workspace.getDeclaration(objectInfo, (XMIObject)object, false);
        try {
            if (data != null) {
                ((XMIObject)object).setXMIDefiner(data);
                data.addXMIDefined((Data)object);
            } else {
                this.file.addUnmatchedElement((Data)object);
            }
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
    }

    public int getType(ValueInfo valueInfo) {
        if (this.debug) {
            System.out.println("MatchReaderAdapterImpl getType");
            System.out.println("name: " + valueInfo.getXMIName());
            System.out.println("className: " + valueInfo.getClassName());
        }
        if (this.workspace == null) {
            return -1;
        }
        Data data = null;
        data = this.file.getXMIVersion().equals("1.0") || this.file.getXMIVersion().equals("2.0") ? this.workspace.getDeclaration(valueInfo, null, true) : this.workspace.getDeclaration(valueInfo, null, false);
        if (data == null) {
            return -1;
        }
        valueInfo.setDefiner(data);
        if (data instanceof Feature) {
            return ((Feature)data).getXMIValueType();
        }
        return -1;
    }

    public void setValue(Object object, Object object2, Object object3) {
        Value value = (Value)object2;
        if (value.getXMIValue() == null) {
            value.setXMIValue(object3);
        } else if (value.getXMIValue() instanceof Collection) {
            ((Collection)value.getXMIValue()).add(object3);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(5);
            arrayList.add(value.getXMIValue());
            arrayList.add(object3);
            value.setXMIValue(arrayList);
        }
    }

    public void setXMIFile(XMIFile xMIFile) {
        this.file = xMIFile;
        if (xMIFile.getXMIFiles() != null) {
            this.files = xMIFile.getXMIFiles();
            this.workspace = xMIFile.getXMIFiles().getWorkspace();
        }
    }

    public void endFile() {
        if (this.debug) {
            System.out.println("End of file.");
        }
    }

    public int getType(ObjectInfo objectInfo) {
        if (this.workspace == null) {
            return -1;
        }
        Data data = null;
        data = this.file.getXMIVersion().equals("1.0") ? this.workspace.getDeclaration(objectInfo, null, true) : this.workspace.getDeclaration(objectInfo, null, false);
        if (data == null || !(data instanceof XMIClass)) {
            return -1;
        }
        return 10;
    }

    private void getDefiner(ValueInfo valueInfo) {
        if (valueInfo.getDefiner() != null) {
            return;
        }
        if (this.workspace == null) {
            return;
        }
        Data data = null;
        if (this.file.getXMIVersion().equals("1.0")) {
            int n;
            if (valueInfo.getClassName() == null && (n = valueInfo.getXMIName().lastIndexOf(".")) != -1) {
                String string = valueInfo.getXMIName().substring(n + 1);
                String string2 = valueInfo.getXMIName().substring(0, n);
                valueInfo.setXMIName(string);
                valueInfo.setClassName(string2);
            }
            data = this.workspace.getDeclaration(valueInfo, null, true);
        } else {
            data = this.workspace.getDeclaration(valueInfo, null, false);
        }
        if (data != null) {
            valueInfo.setDefiner(data);
        }
    }

    private void handleDeclaration(ValueInfo valueInfo, Object object) {
        if (this.workspace == null) {
            return;
        }
        if (!(object instanceof Data)) {
            return;
        }
        Data data = (Data)valueInfo.getDefiner();
        if (data == null && this.file.getXMIVersion().equals("1.0")) {
            int n;
            if (valueInfo.getClassName() == null && (n = valueInfo.getXMIName().lastIndexOf(".")) != -1) {
                String string = valueInfo.getXMIName().substring(n + 1);
                String string2 = valueInfo.getXMIName().substring(0, n);
                valueInfo.setXMIName(string);
                valueInfo.setClassName(string2);
            }
            data = this.workspace.getDeclaration(valueInfo, (Data)object, true);
        } else if (data == null) {
            data = this.workspace.getDeclaration(valueInfo, (Data)object, false);
        }
        try {
            if (data != null) {
                ((Data)object).setXMIDefiner(data);
                data.addXMIDefined((Data)object);
            } else {
                this.file.addUnmatchedElement((Data)object);
            }
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
    }

    public Object setValue(ValueInfo valueInfo) {
        if (this.debug) {
            System.out.println("MatchReaderAdapter setValue");
            System.out.println("value: " + valueInfo.getValue());
        }
        String string = valueInfo.getClassName() == null ? valueInfo.getXMIName() : (valueInfo.getClassName().equals(this.objectsToXMINames.get(valueInfo.getObject())) || valueInfo.getClassName().endsWith((String)this.objectsToXMINames.get(valueInfo.getObject())) ? valueInfo.getXMIName() : valueInfo.getClassName() + "." + valueInfo.getXMIName());
        Value value = null;
        this.getDefiner(valueInfo);
        value = this.factory.makeValue(valueInfo.getObject(), string, valueInfo.getValue(), valueInfo.getType());
        if (value instanceof Data) {
            ((Data)value).setXMINamespace(valueInfo.getNamespace());
        }
        this.handleDeclaration(valueInfo, (Object)value);
        if (this.debug) {
            System.out.println("Made property: ");
            System.out.println(value);
        }
        return value;
    }
}

