/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.umleditor.application.NavigationTreeCellRenderer;
import ch.ehi.umleditor.application.NavigationTreeModel;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeSelectionModel;

public class PackageSelectionDialog
extends BaseDialog {
    private JTree tree;
    private Namespace selectedPackage = null;
    private JPanel ivjBaseDialogContentPane = null;
    private JButton ivjBtnCancel = null;
    private JButton ivjBtnOk = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JScrollPane ivjScpTree = null;
    private JTree ivjTreTree = null;

    public PackageSelectionDialog(Dialog owner, String title, boolean modal, Namespace apackage) {
        super((Component)owner, title, modal);
        this.initialize();
        this.addEscapeKey();
        this.fillTreeView(apackage);
        this.initializeTree();
        if (title != null) {
            this.setTitle(title);
        }
        this.show();
    }

    public PackageSelectionDialog(Frame owner, String title, boolean modal, Namespace apackage) {
        super((Component)owner, title, modal);
        this.initialize();
        this.fillTreeView(apackage);
        this.initializeTree();
        if (title != null) {
            this.setTitle(title);
        }
        this.show();
    }

    private void addEscapeKey() {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -2972481431614869047L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PackageSelectionDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.okPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void fillTreeView(Namespace apackage) {
        this.getTreTree().setModel(new NavigationTreeModel(apackage, true));
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 2;
                constraintsBtnCancel.gridy = 2;
                constraintsBtnCancel.ipadx = 18;
                constraintsBtnCancel.insets = new Insets(3, 6, 17, 97);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsBtnOk = new GridBagConstraints();
                constraintsBtnOk.gridx = 1;
                constraintsBtnOk.gridy = 2;
                constraintsBtnOk.ipadx = 64;
                constraintsBtnOk.insets = new Insets(3, 88, 17, 5);
                this.getBaseDialogContentPane().add((Component)this.getBtnOk(), constraintsBtnOk);
                GridBagConstraints constraintsScpTree = new GridBagConstraints();
                constraintsScpTree.gridx = 1;
                constraintsScpTree.gridy = 1;
                constraintsScpTree.gridwidth = 2;
                constraintsScpTree.fill = 1;
                constraintsScpTree.weightx = 1.0;
                constraintsScpTree.weighty = 1.0;
                constraintsScpTree.ipadx = 383;
                constraintsScpTree.ipady = 160;
                constraintsScpTree.insets = new Insets(10, 12, 3, 9);
                this.getBaseDialogContentPane().add((Component)this.getScpTree(), constraintsScpTree);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText("Abbrechen");
                this.ivjBtnCancel.setText(PackageSelectionDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnOk() {
        if (this.ivjBtnOk == null) {
            try {
                this.ivjBtnOk = new JButton();
                this.ivjBtnOk.setName("BtnOk");
                this.ivjBtnOk.setText("OK");
                this.ivjBtnOk.setText(PackageSelectionDialog.getOKString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnOk;
    }

    private JScrollPane getScpTree() {
        if (this.ivjScpTree == null) {
            try {
                this.ivjScpTree = new JScrollPane();
                this.ivjScpTree.setName("ScpTree");
                this.getScpTree().setViewportView(this.getTreTree());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjScpTree;
    }

    public Namespace getSelectedPackage() {
        return this.selectedPackage;
    }

    private JTree getTreTree() {
        if (this.ivjTreTree == null) {
            try {
                this.ivjTreTree = new JTree();
                this.ivjTreTree.setName("TreTree");
                this.ivjTreTree.setBounds(0, 0, 78, 72);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTreTree;
    }

    private void initConnections() throws Exception {
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getBtnOk().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("PackageSelectionDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 240);
            this.setTitle("<PackageSelection>");
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void initializeTree() {
        this.getTreTree().setCellRenderer(new NavigationTreeCellRenderer());
        this.getTreTree().setRowHeight(-1);
        this.getTreTree().setRootVisible(true);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.getTreTree().setSelectionModel(selectionModel);
        ToolTipManager.sharedInstance().registerComponent(this.getTreTree());
        this.getTreTree().putClientProperty("JTree.lineStyle", "Angled");
    }

    protected boolean save() {
        this.selectedPackage = (Namespace)this.getTreTree().getSelectionPath().getLastPathComponent();
        return super.save();
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PackageSelectionDialog.this.getBtnCancel()) {
                PackageSelectionDialog.this.connEtoC1(e);
            }
            if (e.getSource() == PackageSelectionDialog.this.getBtnOk()) {
                PackageSelectionDialog.this.connEtoC2(e);
            }
        }
    }
}

