/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.interlis.logicalexpressions;

import ch.ehi.basics.tools.AbstractVisitor;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.IliSyntax;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.logicalexpressions.Term;
import ch.ehi.uml1_4.changepropagation.MetaModel;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.implementation.AbstractEditorElement;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FunctionCall
extends AbstractEditorElement
implements IliSyntax,
Serializable {
    private Set argument = new HashSet();
    private FunctionDef functionDef;
    private NlsString model = null;
    private NlsString function = null;
    private NlsString syntax = null;

    @Override
    public void unlinkAll() {
        this.clearArgument();
        this.detachFunctionDef();
        this.setModel(null);
        this.setFunction(null);
        this.setSyntax(null);
        super.unlinkAll();
    }

    @Override
    public void enumerateChildren(AbstractVisitor visitor) {
        Iterator it = null;
        it = this.iteratorArgument();
        while (it.hasNext()) {
            visitor.visit(it.next());
        }
        visitor.visit((Object)this.getModel());
        visitor.visit((Object)this.getFunction());
        visitor.visit((Object)this.getSyntax());
        super.enumerateChildren(visitor);
    }

    public void addArgument(Term argument1) {
        this.argument.add(argument1);
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "addArgument"));
    }

    public Term removeArgument(Term argument1) {
        Term ret = null;
        if (argument1 == null || !this.argument.contains(argument1)) {
            throw new IllegalArgumentException("cannot remove null or unknown object");
        }
        ret = argument1;
        this.argument.remove(argument1);
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "removeArgument"));
        return ret;
    }

    public boolean containsArgument(Term argument1) {
        return this.argument.contains(argument1);
    }

    public Iterator iteratorArgument() {
        return this.argument.iterator();
    }

    public void clearArgument() {
        if (this.sizeArgument() > 0) {
            this.argument.clear();
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "clearArgument"));
        }
    }

    public int sizeArgument() {
        return this.argument.size();
    }

    public void attachFunctionDef(FunctionDef functionDef1) {
        if (this.functionDef != null) {
            throw new IllegalStateException("already a functionDef attached");
        }
        if (functionDef1 == null) {
            throw new IllegalArgumentException("null may not be attached as functionDef");
        }
        this.functionDef = functionDef1;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "attachFunctionDef"));
    }

    public FunctionDef detachFunctionDef() {
        FunctionDef ret = null;
        ret = this.functionDef;
        this.functionDef = null;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "detachFunctionDef"));
        return ret;
    }

    public FunctionDef getFunctionDef() {
        if (this.functionDef == null) {
            throw new IllegalStateException("no functionDef attached");
        }
        return this.functionDef;
    }

    public boolean containsFunctionDef() {
        return this.functionDef != null;
    }

    public NlsString getModel() {
        return this.model;
    }

    public void setModel(NlsString value1) {
        if (!(this.model == value1 || this.model != null && this.model.equals((Object)value1))) {
            this.model = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setModel"));
        }
    }

    public NlsString getFunction() {
        return this.function;
    }

    public void setFunction(NlsString value1) {
        if (!(this.function == value1 || this.function != null && this.function.equals((Object)value1))) {
            this.function = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setFunction"));
        }
    }

    @Override
    public NlsString getSyntax() {
        return this.syntax;
    }

    @Override
    public void setSyntax(NlsString value1) {
        if (!(this.syntax == value1 || this.syntax != null && this.syntax.equals((Object)value1))) {
            this.syntax = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setSyntax"));
        }
    }
}

