/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.translationxml;

import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.constraints.ConstraintDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicParameterDef;
import ch.ehi.interlis.metaobjects.MetaDataUseDef;
import ch.ehi.interlis.metaobjects.ParameterDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.tools.AbstractClassDefUtility;
import ch.ehi.interlis.units.UnitDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.uml1_4.foundation.core.Constraint;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.foundation.extensionmechanisms.TaggedValue;
import ch.ehi.uml1_4.modelmanagement.Model;
import ch.ehi.umleditor.translationxml.ModelElementUtility;
import ch.interlis.ili2c.generator.nls.Ili2TranslationXml;
import ch.interlis.ili2c.generator.nls.ModelElements;
import ch.interlis.ili2c.generator.nls.TranslationElement;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TransferToXml {
    public void export(Model model, File xmlfile) throws Exception {
        ModelElements modelElements = new ModelElements();
        Iterator modelI = model.iteratorOwnedElement();
        while (modelI.hasNext()) {
            Object obj = modelI.next();
            if (obj instanceof INTERLIS2Def) {
                this.modelElementHelper(modelElements, obj);
                continue;
            }
            for (Object objnew : ch.ehi.interlis.tools.ModelElementUtility.getChildElements((Namespace)obj, null)) {
                this.modelElementHelper(modelElements, objnew);
            }
        }
        modelElements.sort();
        Ili2TranslationXml.writeModelElementsAsXML((ModelElements)modelElements, (File)xmlfile);
    }

    private void modelElementHelper(ModelElements modelElements, Object obj) {
        if (!ModelElementUtility.isInternal((INTERLIS2Def)obj) && obj instanceof INTERLIS2Def) {
            String scopedNamePrefix = null;
            boolean showAllFields = true;
            HashSet languages = new HashSet();
            String baselanguage = this.findTheLanguages((INTERLIS2Def)obj, languages);
            for (ModelElement modelElement : ch.ehi.interlis.tools.ModelElementUtility.getChildElements((Namespace)obj, null)) {
                this.visitModelElement(modelElements, modelElement, scopedNamePrefix, baselanguage, languages, showAllFields);
                showAllFields = false;
            }
        }
    }

    private void visitModelElement(ModelElements modelElements, ModelElement modelDef, String scopedNamePrefix, String baselanguage, Set languages, boolean showAllFields) {
        DomainAttribute attrType;
        AttributeDef def;
        TranslationElement translationElement = new TranslationElement();
        if (showAllFields) {
            this.allFieldsMakeEmpty(translationElement);
        }
        translationElement.setElementType(this.getElementType(modelDef));
        scopedNamePrefix = this.getScopedName(scopedNamePrefix, modelDef, baselanguage);
        if (scopedNamePrefix != null) {
            translationElement.setScopedName(scopedNamePrefix);
        }
        Map name = null;
        if (modelDef.getName() != null) {
            name = modelDef.getName().getAllValues();
        }
        Map documentation = null;
        if (modelDef.getDocumentation() != null) {
            documentation = modelDef.getDocumentation().getAllValues();
        }
        this.printMetaValues(modelElements, modelDef.iteratorTaggedValue(), scopedNamePrefix, languages);
        Iterator languagei = languages.iterator();
        while (languagei.hasNext() && name != null) {
            String language = (String)languagei.next();
            this.setName((String)name.get(language), translationElement, language);
            if (modelDef.getDocumentation() == null) continue;
            this.setDocumentation((String)documentation.get(language), translationElement, language);
        }
        if (scopedNamePrefix != null) {
            modelElements.add(translationElement);
        }
        if (modelDef instanceof AbstractClassDef) {
            for (Object object : AbstractClassDefUtility.getIliAttributes((AbstractClassDef)modelDef)) {
                if (!(object instanceof AttributeDef)) continue;
                this.visitModelElement(modelElements, (ModelElement)object, scopedNamePrefix, baselanguage, languages, false);
            }
            if (modelDef instanceof ClassDef) {
                ClassDef classDef = (ClassDef)modelDef;
                Iterator iterator = classDef.iteratorParameterDef();
                while (iterator.hasNext()) {
                    ParameterDef next = (ParameterDef)iterator.next();
                    this.visitModelElement(modelElements, next, scopedNamePrefix, baselanguage, languages, false);
                }
            }
            if (modelDef instanceof AssociationDef) {
                Iterator assoDefI = ((AssociationDef)modelDef).iteratorConnection();
                while (assoDefI.hasNext()) {
                    RoleDef roleDef = (RoleDef)assoDefI.next();
                    this.visitModelElement(modelElements, roleDef, scopedNamePrefix, baselanguage, languages, false);
                }
            }
            Iterator contstraintI = modelDef.iteratorConstraint();
            while (contstraintI.hasNext()) {
                Constraint constraint = (Constraint)contstraintI.next();
                this.visitModelElement(modelElements, constraint, scopedNamePrefix, baselanguage, languages, false);
            }
        } else if (modelDef instanceof Namespace) {
            Type type;
            DomainDef domain;
            for (ModelElement modelElement : ch.ehi.interlis.tools.ModelElementUtility.getChildElements((Namespace)modelDef, null)) {
                this.visitModelElement(modelElements, modelElement, scopedNamePrefix, baselanguage, languages, false);
            }
            if (modelDef instanceof DomainDef && (domain = (DomainDef)modelDef).containsType() && (type = domain.getType()) instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)type;
                this.printAllEnumeration(modelElements, scopedNamePrefix, baselanguage, languages, enumeration);
            }
        } else if (modelDef instanceof AttributeDef && (def = (AttributeDef)modelDef).containsAttrType() && (attrType = (DomainAttribute)def.getAttrType()).containsDirect() && attrType.getDirect() instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)attrType.getDirect();
            this.printAllEnumeration(modelElements, scopedNamePrefix, baselanguage, languages, enumeration);
        }
    }

    private void printMetaValues(ModelElements modelElements, Iterator iteratorTaggedValue, String scopedNamePrefix, Set languages) {
        TaggedValue umlTag = null;
        while (iteratorTaggedValue.hasNext()) {
            umlTag = (TaggedValue)iteratorTaggedValue.next();
            String value = umlTag.getDataValue();
            String name = umlTag.getName().getValue();
            if (!name.contains(":")) continue;
            String[] split = name.split(":");
            String scopedName = scopedNamePrefix + ".METAOBJECT." + split[1];
            TranslationElement metaValue = new TranslationElement();
            Iterator languagei = languages.iterator();
            while (languagei.hasNext() && name != null) {
                String language = (String)languagei.next();
                this.setName(value, metaValue, language);
            }
            metaValue.setScopedName(scopedName);
            metaValue.setElementType("METAATTRIBUTE");
            modelElements.add(metaValue);
        }
    }

    private void printAllEnumeration(ModelElements modelElements, String scopedNamePrefix, String baselanguage, Set languages, Enumeration enumeration) {
        Iterator enumEle = enumeration.iteratorEnumElement();
        while (enumEle.hasNext()) {
            EnumElement enumElement = (EnumElement)enumEle.next();
            this.visitModelElement(modelElements, enumElement, scopedNamePrefix, baselanguage, languages, false);
            if (!enumElement.containsChild()) continue;
            String scopedName = scopedNamePrefix + "." + enumElement.getName().getValue(baselanguage);
            this.printAllEnumeration(modelElements, scopedName, baselanguage, languages, enumElement.getChild());
        }
    }

    private void allFieldsMakeEmpty(TranslationElement translationElement) {
        translationElement.setDocumentation_de("");
        translationElement.setDocumentation_en("");
        translationElement.setDocumentation_fr("");
        translationElement.setDocumentation_it("");
        translationElement.setName_de("");
        translationElement.setName_en("");
        translationElement.setName_fr("");
        translationElement.setName_it("");
        translationElement.setScopedName("");
    }

    private void setDocumentation(String documentation, TranslationElement translationElement, String language) {
        if (language.equalsIgnoreCase("de")) {
            translationElement.setDocumentation_de(documentation);
        } else if (language.equalsIgnoreCase("en")) {
            translationElement.setDocumentation_en(documentation);
        } else if (language.equalsIgnoreCase("fr")) {
            translationElement.setDocumentation_fr(documentation);
        } else if (language.equalsIgnoreCase("it")) {
            translationElement.setDocumentation_it(documentation);
        }
    }

    private void setName(String name, TranslationElement translationElement, String language) {
        if (language.equalsIgnoreCase("de")) {
            translationElement.setName_de(name);
        } else if (language.equalsIgnoreCase("fr")) {
            translationElement.setName_fr(name);
        } else if (language.equalsIgnoreCase("it")) {
            translationElement.setName_it(name);
        } else if (language.equalsIgnoreCase("en")) {
            translationElement.setName_en(name);
        }
    }

    private String findTheLanguages(INTERLIS2Def modelDef, Set languages) {
        Set set = ch.ehi.interlis.tools.ModelElementUtility.getChildElements(modelDef, ModelDef.class);
        Iterator iterator = set.iterator();
        String baseLanguage = "";
        while (iterator.hasNext()) {
            ModelDef modelDefLangu = (ModelDef)iterator.next();
            if (modelDefLangu.getBaseLanguage() != null) {
                baseLanguage = modelDefLangu.getBaseLanguage();
                languages.add(modelDefLangu.getBaseLanguage());
            }
            languages.addAll(modelDefLangu.getValidSecondLanguages());
        }
        return baseLanguage;
    }

    private String getScopedName(String scopedNamePrefix, ModelElement modelElement, String language) {
        if (modelElement.getName() != null) {
            scopedNamePrefix = scopedNamePrefix == null ? modelElement.getName().getValue(language) : scopedNamePrefix + "." + modelElement.getName().getValue(language);
            return scopedNamePrefix;
        }
        return null;
    }

    public String getElementType(Object obj) {
        if (obj instanceof MetaDataUseDef) {
            return "META DATA BASKET";
        }
        if (obj instanceof ViewDef) {
            return "VIEW";
        }
        if (obj instanceof UnitDef) {
            return "UNIT";
        }
        if (obj instanceof FunctionDef) {
            return "FUNCTION";
        }
        if (obj instanceof LineFormTypeDef) {
            return "LINE FORM";
        }
        if (obj instanceof ConstraintDef) {
            return "CONSTRAINT";
        }
        if (obj instanceof ParameterDef) {
            return "PARAMETER";
        }
        if (obj instanceof AttributeDef) {
            return "ATTRIBUTE";
        }
        if (obj instanceof RoleDef) {
            return "ROLE";
        }
        if (obj instanceof DomainDef) {
            return "DOMAIN";
        }
        if (obj instanceof GraphicParameterDef) {
            return "GRAPHIC";
        }
        if (obj instanceof ClassDef) {
            if (((ClassDef)obj).getKind() == 2) {
                return "STRUCTURE";
            }
            return "CLASS";
        }
        if (obj instanceof AssociationDef) {
            return "ASSOCIATION";
        }
        if (obj instanceof ModelDef) {
            return "MODEL";
        }
        if (obj instanceof Constraint) {
            return "CONSTRAINT";
        }
        if (obj instanceof EnumElement) {
            return "ENUMERATION ELEMENT";
        }
        if (obj instanceof TopicDef) {
            return "TOPIC";
        }
        return null;
    }
}

