/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.framework.Figure;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.EdgeFigure;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.NoteFigure;
import ch.ehi.umleditor.umlpresentation.NoteEdge;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;

public class NoteAnchorLineConnection
extends EdgeFigure {
    private static ResourceBundle resNoteAnchorLineConnection = ResourceBundle.getBundle("ch/ehi/umleditor/umldrawingtools/resources/NoteAnchorLineConnection");

    public NoteAnchorLineConnection() {
    }

    public NoteAnchorLineConnection(ClassDiagramView classDiagram, PresentationEdge edge) {
        super(classDiagram);
        this.setLineColor(this.determineForegroundColor(edge));
        this.edge = edge;
    }

    @Override
    public JPopupMenu adaptPopupMenu(JPopupMenu popupMenu) {
        this.addFormatMenu(popupMenu);
        this.addEditMenu(popupMenu);
        popupMenu.setLightWeightPopupEnabled(true);
        return popupMenu;
    }

    @Override
    protected void addSpecialMenu(JPopupMenu popupMenu) {
    }

    public boolean canConnect(Figure start, Figure end) {
        if (!(start instanceof NoteFigure) && !(end instanceof NoteFigure)) {
            this.shouldWarn(resNoteAnchorLineConnection.getString("CWNoteNeeded"));
            return false;
        }
        if (!(start instanceof NodeFigure) || !(end instanceof NodeFigure)) {
            this.shouldWarn(resNoteAnchorLineConnection.getString("CWNodeType"));
            return false;
        }
        return true;
    }

    protected void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        NoteAnchorLineConnection.drawNoteLine(g, x1, y1, x2, y2);
    }

    protected static void drawNoteLine(Graphics g, int x1, int y1, int x2, int y2) {
        int xDistance = x2 - x1;
        int yDistance = y2 - y1;
        double direction = 1.5707963267948966 - Math.atan2(xDistance, yDistance);
        double xAngle = Math.cos(direction);
        double yAngle = Math.sin(direction);
        int lineLength = (int)Math.sqrt(xDistance * xDistance + yDistance * yDistance);
        int i = 0;
        while (i + 5 < lineLength) {
            int p1x = x1 + (int)((double)i * xAngle);
            int p1y = y1 + (int)((double)i * yAngle);
            int p2x = x1 + (int)((double)(i + 2) * xAngle);
            int p2y = y1 + (int)((double)(i + 2) * yAngle);
            g.drawLine(p1x, p1y, p2x, p2y);
            i += 7;
        }
    }

    @Override
    protected Element getEndElement() {
        Iterator iterator = this.getEdge().iteratorEndpoint();
        if (iterator.hasNext()) {
            iterator.next();
            if (iterator.hasNext()) {
                return (Element)iterator.next();
            }
        }
        return null;
    }

    @Override
    protected Element getStartElement() {
        Iterator iteratorNote = this.getEdge().iteratorEndpoint();
        if (iteratorNote.hasNext()) {
            return (Element)iteratorNote.next();
        }
        return null;
    }

    protected void handleConnect(Figure start, Figure end) {
        try {
            if (this.getEdge() == null) {
                NodeFigure child = (NodeFigure)start;
                if (child instanceof NoteFigure) {
                    this.setEdge(new NoteEdge(), start, end);
                } else {
                    this.setEdge(new NoteEdge(), end, start);
                }
                this.setToolView();
                this.getClassDiagram().getDiagram().addPresentationElement(this.getEdge());
            }
        }
        catch (Throwable e) {
            BaseDialog.showError((Component)((Object)LauncherView.getInstance()), (String)CREATION_ERROR, (Object)resNoteAnchorLineConnection.getString("CENoteNotConnected"), (Throwable)e);
        }
    }

    @Override
    protected void showIllegalRelationship(String warning) {
        BaseDialog.showWarning((Component)((Object)LauncherView.getInstance()), (String)resNoteAnchorLineConnection.getString("CWConnectionNotEstablished"), (Object)warning);
    }

    @Override
    public final void showSpecification() {
        throw new DeveloperException("no Dialog assumed");
    }
}

