/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.GraphicalCompositeFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.ColorConverter;
import ch.ehi.umleditor.umldrawingtools.LinkFigure;
import ch.ehi.umleditor.umldrawingtools.ModelElementUI;
import ch.ehi.umleditor.umlpresentation.Note;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.view.ColorChooserDialog;
import ch.softenvironment.view.CommonUserAccess;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

abstract class NodeFigure
extends GraphicalCompositeFigure
implements ModelElementUI {
    protected Vector handles = null;
    protected PresentationNode node;
    private ClassDiagramView classDiagram = null;
    private boolean creating = true;

    public NodeFigure(Figure newPresentationFigure) {
        super(newPresentationFigure);
        this.setCreating(true);
    }

    public Vector handles() {
        if (this.handles == null) {
            this.handles = new Vector(4);
            this.handles.addElement(new NullHandle((Figure)this, RelativeLocator.northWest()));
            this.handles.addElement(new NullHandle((Figure)this, RelativeLocator.northEast()));
            this.handles.addElement(new NullHandle((Figure)this, RelativeLocator.southWest()));
            this.handles.addElement(new NullHandle((Figure)this, RelativeLocator.southEast()));
        }
        return this.handles;
    }

    protected JPopupMenu adaptPopupMenu(JPopupMenu popupMenu) {
        this.addSpecificationMenu(popupMenu);
        this.addSpecialMenu(popupMenu);
        this.addSelectionMenu(popupMenu);
        popupMenu.add(new JSeparator());
        this.addFormatMenu(popupMenu);
        this.addEditMenu(popupMenu);
        popupMenu.setLightWeightPopupEnabled(true);
        return popupMenu;
    }

    protected final void addSelectionMenu(JPopupMenu popupMenu) {
        popupMenu.add(new JSeparator());
        popupMenu.add(new AbstractAction(ModelElementUI.SELECT_IN_BROWSER){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.selectInBrowser();
            }
        });
    }

    protected void addEditMenu(JPopupMenu popupMenu) {
        JMenu editMenu = new JMenu(CommonUserAccess.getMnuEditText());
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditCutText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.mniCut();
            }
        });
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditCopyText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.mniCopy();
            }
        });
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditPasteText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.mniPaste();
            }
        });
        editMenu.add(new AbstractAction(CommonUserAccess.getMniEditRemoveText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.removeVisually();
            }
        });
        editMenu.add(new JSeparator());
        editMenu.add(new AbstractAction(REMOVE_IN_MODEL){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.removeInModel();
            }
        });
        popupMenu.add(editMenu);
    }

    protected void addFormatMenu(JPopupMenu popupMenu) {
        JMenu formatMenu = new JMenu(CommonUserAccess.getMnuFormatText());
        formatMenu.add(new AbstractAction(CommonUserAccess.getMniFormatFontText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.mniFont();
            }
        });
        formatMenu.add(new AbstractAction(CommonUserAccess.getMniFormatLineColorText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.mniLineColor();
            }
        });
        formatMenu.add(new AbstractAction(CommonUserAccess.getMniFormatFillColorText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.mniFillColor();
            }
        });
        popupMenu.add(formatMenu);
    }

    protected void addSpecialMenu(JPopupMenu popupMenu) {
    }

    protected void addSpecificationMenu(JPopupMenu popupMenu) {
        popupMenu.add(new AbstractAction(CommonUserAccess.getMniEditChangeWindowText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeFigure.this.showSpecification();
            }
        });
    }

    public void basicDisplayBox(Point origin, Point corner) {
        super.basicDisplayBox(origin, corner);
        if (LauncherView.getInstance().tool() instanceof CreationTool || this instanceof LinkFigure) {
            this.updateCoordinates();
        }
    }

    protected void basicMoveBy(int dx, int dy) {
        super.basicMoveBy(dx, dy);
        this.updateCoordinates();
    }

    public Object getAttribute(String name) {
        if (name.equals("FontName") && this.getNode() != null && this.getNode().getFont() != null) {
            return this.getNode().getFont();
        }
        return super.getAttribute(name);
    }

    protected ClassDiagramView getClassDiagram() {
        return this.classDiagram;
    }

    protected Color getFillColor() {
        Color color = (Color)this.getAttribute("FillColor");
        if (color == null) {
            return LauncherView.getSettings().getBackgroundColor();
        }
        return color;
    }

    protected Font getFont() {
        String font = (String)this.getAttribute("FontName");
        if (font == null) {
            return LauncherView.getSettings().getFont();
        }
        return Font.decode(font);
    }

    protected Color getLineColor() {
        Color color = (Color)this.getAttribute("FrameColor");
        if (color == null) {
            return LauncherView.getSettings().getForegroundColor();
        }
        return color;
    }

    @Override
    public ModelElement getModelElement() {
        if (this.node != null && this.node.iteratorSubject().hasNext()) {
            return (ModelElement)this.node.iteratorSubject().next();
        }
        return null;
    }

    public PresentationNode getNode() {
        return this.node;
    }

    protected void handleException(Throwable exception) {
        LauncherView.getInstance().handleException(exception);
    }

    protected static void handleException(Throwable exception, String title, String message, Object source) {
        String text = message;
        if (message == null) {
            text = ResourceManager.getResource(DeveloperException.class, (String)"CTDevelopmentError");
        }
        LauncherView.getInstance().handleException(exception, title, text + " [" + source.toString() + "]");
    }

    protected void initialize() {
        super.initialize();
        this.setAttribute("POPUP_MENU", this.adaptPopupMenu(new JPopupMenu()));
        this.setAttribute("FillColor", LauncherView.getSettings().getBackgroundColor());
        this.setAttribute("FrameColor", LauncherView.getSettings().getForegroundColor());
    }

    protected boolean isCreating() {
        return this.creating;
    }

    protected void mniCopy() {
        LauncherView.getInstance().nyi("Copy");
    }

    protected void mniCut() {
        LauncherView.getInstance().nyi("Cut");
    }

    private void mniFillColor() {
        ColorChooserDialog dialog = new ColorChooserDialog((Frame)((Object)LauncherView.getInstance()), true);
        if (dialog.isSaved()) {
            this.setFillColor(dialog.getChosenColor());
        }
    }

    private void mniFont() {
        LauncherView.getInstance().nyi("Font");
    }

    private void mniLineColor() {
        ColorChooserDialog dialog = new ColorChooserDialog((Frame)((Object)LauncherView.getInstance()), true);
        if (dialog.isSaved()) {
            this.setLineColor(dialog.getChosenColor());
        }
    }

    protected void mniPaste() {
        LauncherView.getInstance().nyi("Paste");
    }

    @Override
    public void removeInModel() {
        try {
            ModelElement tmp = this.getModelElement();
            this.removeVisually();
            if (tmp != null) {
                ElementFactory.removeElement(tmp);
            }
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, REMOVE_IN_MODEL, null, this);
        }
    }

    @Override
    public void removeVisually() {
        try {
            this.getClassDiagram().remove((Figure)this);
            if (this.getClassDiagram().getDiagram().containsPresentationElement(this.node)) {
                if (this.node instanceof Note) {
                    this.node.clearPresentationEdge();
                }
                this.getClassDiagram().getDiagram().deletePresentationElement(this.node);
            }
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, CommonUserAccess.getMniEditRemoveText(), null, this);
        }
    }

    public void selectInBrowser() {
        LauncherView.getInstance().getPnlNavigation().selectElement(this.getModelElement());
    }

    protected void setClassDiagram(ClassDiagramView classDiagram) {
        this.classDiagram = classDiagram;
    }

    protected void setCreating(boolean creating) {
        this.creating = creating;
        if (!creating) {
            this.updateView();
        }
    }

    protected void setFillColor(Color color) {
        this.setAttribute("FillColor", color);
        if (this.getNode() != null && !ColorConverter.isSame(this.getNode().getBackground(), color)) {
            this.getNode().setBackground(ColorConverter.createColor(color));
        }
    }

    protected void setFont(String font) {
        this.setAttribute("FontName", font);
        if (this.getNode() != null && !this.getNode().getFont().equalsIgnoreCase(font)) {
            this.getNode().setFont(font);
        }
    }

    protected void setLineColor(Color color) {
        this.setAttribute("FrameColor", color);
        if (this.getNode() != null && !ColorConverter.isSame(this.getNode().getForeground(), color)) {
            this.getNode().setForeground(ColorConverter.createColor(color));
        }
    }

    public void setNode(PresentationNode node) {
        this.node = node;
    }

    @Override
    public void showSpecification() {
        LauncherView.getInstance().showSpecification(this.getModelElement());
    }

    public void updateCoordinates() {
        Rectangle rectangle = this.getPresentationFigure().displayBox();
        this.node.setEast((int)rectangle.getX());
        this.node.setSouth((int)rectangle.getY());
        this.node.setWidth((int)rectangle.getWidth());
        this.node.setHeight((int)rectangle.getHeight());
    }

    protected boolean updateName(String newName) {
        return newName.equals(this.getModelElement().getDefLangName()) || ElementUtils.trySetName(this.getModelElement(), newName);
    }

    public void updateView() {
        if (this.getNode().getBackground() != null) {
            this.setFillColor(ColorConverter.createColor(this.getNode().getBackground()));
        }
        if (this.getNode().getForeground() != null) {
            this.setLineColor(ColorConverter.createColor(this.getNode().getForeground()));
        }
    }

    protected static String getResourceString(Class resource, String property) {
        return ResourceManager.getResource((Class)resource, (String)property);
    }
}

