/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.Figure;
import ch.ehi.interlis.modeltopicclass.IliImport;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.modeltopicclass.TopicDepends;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.implementation.UmlUsage;
import ch.ehi.uml1_4.modelmanagement.Package;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.ClassFigure;
import ch.ehi.umleditor.umldrawingtools.EdgeFigure;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;

public class DependencyLineConnection
extends EdgeFigure {
    private static ResourceBundle resDependencyLineConnection = ResourceBundle.getBundle("ch/ehi/umleditor/umldrawingtools/resources/DependencyLineConnection");

    public DependencyLineConnection() {
    }

    public DependencyLineConnection(ClassDiagramView classDiagram, PresentationEdge edge) {
        super(classDiagram);
        this.setLineColor(this.determineForegroundColor(edge));
        this.edge = edge;
        this.setModelElement((ModelElement)edge.iteratorSubject().next());
    }

    public DependencyLineConnection(ClassDiagramView classDiagram, Figure start, Figure end, Dependency dependency) {
        super(classDiagram);
        this.setEdge(new ch.ehi.umleditor.umlpresentation.Dependency(), start, end);
        this.addModelElement(dependency);
    }

    @Override
    protected void addSelectInBrowserMenu(JPopupMenu popupMenu) {
    }

    @Override
    protected void addSpecialMenu(JPopupMenu popupMenu) {
    }

    @Override
    protected void addSpecificationMenu(JPopupMenu popupMenu) {
    }

    public boolean canConnect(Figure start, Figure end) {
        ModelElement client = ((NodeFigure)start).getModelElement();
        ModelElement supplier = ((NodeFigure)end).getModelElement();
        if (!((client instanceof Classifier || ClassFigure.isPseudoClassifier(client)) && (supplier instanceof Classifier || ClassFigure.isPseudoClassifier(supplier)) || client instanceof Package && supplier instanceof Package)) {
            this.shouldWarn(resDependencyLineConnection.getString("CWNodesMustBeClassifier"));
            return false;
        }
        return true;
    }

    protected void drawLine(Graphics g, int x1, int y1, int x2, int y2) {
        int xDistance = x2 - x1;
        int yDistance = y2 - y1;
        double direction = 1.5707963267948966 - Math.atan2(xDistance, yDistance);
        double xAngle = Math.cos(direction);
        double yAngle = Math.sin(direction);
        int lineLength = (int)Math.sqrt(xDistance * xDistance + yDistance * yDistance);
        int i = 0;
        while (i + 5 < lineLength) {
            int p1x = x1 + (int)((double)i * xAngle);
            int p1y = y1 + (int)((double)i * yAngle);
            int p2x = x1 + (int)((double)(i + 5) * xAngle);
            int p2y = y1 + (int)((double)(i + 5) * yAngle);
            g.drawLine(p1x, p1y, p2x, p2y);
            i += 10;
        }
    }

    @Override
    protected Element getEndElement() {
        if (this.getModelElement() == null) {
            return null;
        }
        return (Element)((Dependency)this.getModelElement()).iteratorSupplier().next();
    }

    @Override
    protected Element getStartElement() {
        if (this.getModelElement() == null) {
            return null;
        }
        Iterator it = ((Dependency)this.getModelElement()).iteratorClient();
        if (it.hasNext()) {
            return (Element)it.next();
        }
        Tracer.getInstance().developerError("Dependency should have had at least a client => modelling problem?");
        return null;
    }

    protected void handleConnect(Figure start, Figure end) {
        try {
            if (this.getEdge() == null) {
                this.setEdge(new ch.ehi.umleditor.umlpresentation.Dependency(), start, end);
                ModelElement client = ((NodeFigure)start).getModelElement();
                ModelElement supplier = ((NodeFigure)end).getModelElement();
                Dependency dependency = null;
                dependency = client instanceof ModelDef && supplier instanceof ModelDef ? ElementFactory.createDependency(IliImport.class, client, supplier) : (client instanceof TopicDef && supplier instanceof TopicDef ? ElementFactory.createDependency(TopicDepends.class, client, supplier) : ElementFactory.createDependency(UmlUsage.class, client, supplier));
                this.setToolView();
                this.addModelElement(dependency);
            }
        }
        catch (Throwable e) {
            BaseDialog.showError((Component)((Object)LauncherView.getInstance()), (String)CREATION_ERROR, (Object)resDependencyLineConnection.getString("CEDependencyNotEstablished"), (Throwable)e);
        }
    }

    @Override
    protected void showDecoration() {
        this.setStartDecoration(null);
        ArrowTip arrow = new ArrowTip(0.4, 12.0, 0.0);
        arrow.setBorderColor(this.getLineColor());
        this.setEndDecoration((LineDecoration)arrow);
    }

    @Override
    protected void showIllegalRelationship(String warning) {
        BaseDialog.showWarning((Component)((Object)LauncherView.getInstance()), (String)resDependencyLineConnection.getString("CTUnallowedDependency"), (Object)warning);
    }

    @Override
    public void showSpecification() {
        LauncherView.getInstance().showSpecification(this.getModelElement());
    }

    @Override
    public void updateView() {
        if (this.getModelElement() != null && !((Dependency)this.getModelElement()).iteratorSupplier().hasNext()) {
            this.removeVisually();
        } else {
            super.updateView();
        }
    }
}

