/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.translationxml;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.translationxml.TransferFromXml;
import ch.ehi.umleditor.translationxml.TransferToXml;
import java.awt.Component;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class TranslationXmlMenu {
    public static void doImport() {
        String function = "Import Translation-XML";
        LauncherView editor = LauncherView.getInstance();
        String xmlFile = TranslationXmlMenu.doImportFileSelector();
        if (xmlFile != null) {
            try {
                TransferFromXml trsf = new TransferFromXml();
                trsf.merge(editor.getModel(), new File(xmlFile));
                editor.refreshModel();
                editor.log("Import Translation-XML", "done");
            }
            catch (Exception e) {
                EhiLogger.logError((String)"Import Translation-XML failed", (Throwable)e);
            }
        }
    }

    public static void doExport() {
        String function = "Export Translation-XML";
        LauncherView editor = LauncherView.getInstance();
        String file = TranslationXmlMenu.doExportFileSelector();
        if (file != null) {
            try {
                TransferToXml trsf = new TransferToXml();
                trsf.export(editor.getModel(), new File(file));
                editor.log("Export Translation-XML", "done");
            }
            catch (Exception e) {
                EhiLogger.logError((String)"Export Translation-XML failed", (Throwable)e);
            }
        }
    }

    private static String doExportFileSelector() {
        FileChooser importDialog = new FileChooser(LauncherView.getSettings().getImportDirectory());
        importDialog.setDialogTitle("Export Translation-XML");
        GenericFileFilter xmlFilter = LauncherView.createXmlFilter();
        importDialog.setFileFilter((FileFilter)xmlFilter);
        if (importDialog.showSaveDialog((Component)((Object)LauncherView.getInstance())) == 0) {
            LauncherView.getSettings().setImportDirectory(importDialog.getCurrentDirectory().getAbsolutePath());
            return importDialog.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public static String doImportFileSelector() {
        FileChooser importDialog = new FileChooser(LauncherView.getSettings().getImportDirectory());
        importDialog.setDialogTitle("Import Translation-XML");
        GenericFileFilter xmlFilter = LauncherView.createXmlFilter();
        importDialog.setFileFilter((FileFilter)xmlFilter);
        if (importDialog.showOpenDialog((Component)((Object)LauncherView.getInstance())) == 0) {
            LauncherView.getSettings().setImportDirectory(importDialog.getCurrentDirectory().getAbsolutePath());
            return importDialog.getSelectedFile().getAbsolutePath();
        }
        return null;
    }
}

