/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.rose;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.domainsandconstants.basetypes.Text;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.ClassExtends;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.foundation.core.Operation;
import ch.ehi.uml1_4.foundation.core.PresentationElement;
import ch.ehi.uml1_4.foundation.datatypes.Multiplicity;
import ch.ehi.uml1_4.foundation.datatypes.MultiplicityRange;
import ch.ehi.uml1_4.implementation.UmlMultiplicity;
import ch.ehi.uml1_4.implementation.UmlMultiplicityRange;
import ch.ehi.uml1_4.implementation.UmlOperation;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.uml1_4.implementation.UmlParameter;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umlpresentation.Association;
import ch.ehi.umleditor.umlpresentation.Class;
import ch.ehi.umleditor.umlpresentation.Diagram;
import ch.ehi.umleditor.umlpresentation.Generalization;
import ch.ehi.umleditor.umlpresentation.Note;
import ch.ehi.umleditor.umlpresentation.NoteEdge;
import ch.ehi.umleditor.umlpresentation.Package;
import ch.ehi.umleditor.umlpresentation.PresentationAssocClass;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import ch.ehi.umleditor.umlpresentation.PresentationRole;
import com.ibm.xmi.framework.XMIContainer;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIObject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class TransferFromXmiRoseMetamodel {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(TransferFromXmiRoseMetamodel.class);
    private XMIContainer cont = null;
    private int pass = 0;
    private HashMap xmi2imp = null;
    private HashMap id2xmiobj = null;
    private HashMap domain2struct = null;

    public String findStereotype(String id) {
        Collection topv = this.cont.getData("UML:Stereotype");
        for (XMIObject obj : topv) {
            String elev = (String)obj.getXMIValueOfValue("extendedElement");
            int start = 0;
            int pos = elev.indexOf(32);
            while (pos > 0) {
                String value = elev.substring(start, pos).trim();
                if (value.equals(id)) {
                    return (String)obj.getXMIValueOfValue("name");
                }
                start = pos + 1;
                pos = elev.indexOf(32, start);
            }
            if (!elev.substring(start).trim().equals(id)) continue;
            return (String)obj.getXMIValueOfValue("name");
        }
        return null;
    }

    public String findTaggedValue(String id, String tag) {
        Collection topv = this.cont.getData("UML:TaggedValue");
        for (XMIObject obj : topv) {
            if (!obj.getXMIValueOfValue("modelElement").equals(id) || !obj.getXMIValueOfValue("tag").equals(tag)) continue;
            return (String)obj.getXMIValueOfValue("value");
        }
        return null;
    }

    public Object visitValue(Object obj, Object arg) {
        block20: {
            if (obj == null) {
                return null;
            }
            if (obj instanceof XMIObject) {
                XMIObject oneobj = (XMIObject)obj;
                try {
                    if (oneobj.getXMIName().equals("UML:Class")) {
                        return this.visitAbstractClass(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Association")) {
                        return this.visitAbstractClass(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:AssociationClass")) {
                        return this.visitAbstractClass(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Package")) {
                        return this.visitPackage(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:DataType")) {
                        return this.visitDatatype(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Generalization")) {
                        return this.visitGeneralization(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:AssociationEnd")) {
                        return this.visitAssociationEnd(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Multiplicity")) {
                        return this.visitMultiplicity(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:MultiplicityRange")) {
                        return this.visitMultiplicityRange(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Diagram")) {
                        return this.visitDiagram(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Attribute")) {
                        return this.visitAttribute(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Operation")) {
                        return this.visitOperation(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:Parameter")) {
                        return this.visitParameter(oneobj, arg);
                    }
                    if (oneobj.getXMIName().equals("UML:DiagramElement")) {
                        return this.visitDiagramElement(oneobj, arg);
                    }
                    break block20;
                }
                catch (RuntimeException ex) {
                    System.err.println("Id " + oneobj.getXMIId() + " :" + ex.getCause());
                    throw ex;
                }
            }
            if (obj instanceof Collection) {
                Collection elev = (Collection)obj;
                for (XMIObject oneobj : elev) {
                    this.visitValue(oneobj, arg);
                }
            }
        }
        return null;
    }

    public Object visitAttribute(XMIObject attr, Object arg) {
        if (arg instanceof AbstractClassDef) {
            if (this.pass == 2) {
                String typeId = (String)attr.getXMIValueOfValue("type");
                XMIObject type = (XMIObject)this.id2xmiobj.get(typeId);
                if (type.getXMIName().equals("UML:DataType") || type.getXMIName().equals("UML:Class") && "enumeration".equals(this.findStereotype(typeId))) {
                    AttributeDef impattr = new AttributeDef();
                    impattr.setDefLangName((String)attr.getXMIValueOfValue("name"));
                    String docu = this.findTaggedValue(attr.getXMIId(), "documentation");
                    if (docu != null) {
                        impattr.setDocumentation(new NlsString(docu));
                    }
                    DomainAttribute attrtype = new DomainAttribute();
                    attrtype.attachDomainDef((DomainDef)this.xmi2imp.get(type));
                    Object obj = attr.getXMIValueOfValue("UML:StructuralFeature.multiplicity");
                    this.visitValue(obj, impattr);
                    impattr.attachAttrType(attrtype);
                    ((Classifier)arg).addFeature(impattr);
                } else if (type.getXMIName().equals("UML:Class")) {
                    ClassDef dest = null;
                    dest = (ClassDef)this.xmi2imp.get(type);
                    AssociationDef assoc = new AssociationDef();
                    ch.ehi.uml1_4.foundation.core.Class thisclass = (ch.ehi.uml1_4.foundation.core.Class)arg;
                    String name = (String)attr.getXMIValueOfValue("name");
                    assoc.setDefLangName(thisclass.getDefLangName() + name);
                    RoleDef destRole = new RoleDef();
                    assoc.addConnection(destRole);
                    destRole.setDefLangName(name);
                    String docu = this.findTaggedValue(attr.getXMIId(), "documentation");
                    if (docu != null) {
                        destRole.setDocumentation(new NlsString(docu));
                    }
                    destRole.attachParticipant(dest);
                    Object obj = attr.getXMIValueOfValue("UML:StructuralFeature.multiplicity");
                    this.visitValue(obj, destRole);
                    RoleDef srcRole = new RoleDef();
                    assoc.addConnection(srcRole);
                    srcRole.attachParticipant(thisclass);
                    srcRole.setName(thisclass.getName());
                    srcRole.setAggregation(3);
                    if (dest.getKind() == 2) {
                        srcRole.setIliAttributeKind(2);
                    }
                    thisclass.getNamespace().addOwnedElement(assoc);
                } else {
                    this.log(rsrc.getString("CIerrAttrIgnored"));
                }
            }
        } else if (arg instanceof DomainDef && this.pass == 1) {
            DomainDef imptype = (DomainDef)arg;
            Enumeration enumeration = (Enumeration)imptype.getType();
            EnumElement ele = new EnumElement();
            ele.setDefLangName((String)attr.getXMIValueOfValue("name"));
            String docu = this.findTaggedValue(attr.getXMIId(), "documentation");
            if (docu != null) {
                ele.setDocumentation(new NlsString(docu));
            }
            enumeration.addEnumElement(ele);
        }
        return null;
    }

    public Object visitAbstractClass(XMIObject aclass, Object arg) {
        ModelElement impclass = null;
        String name = null;
        if (this.pass == 1) {
            String docu;
            if (aclass.getXMIName().equals("UML:Class")) {
                impclass = new ClassDef();
                String stereotype = this.findStereotype(aclass.getXMIId());
                if ("ILISTRUCTURE".equals(stereotype)) {
                    ((ClassDef)impclass).setKind(2);
                } else if ("enumeration".equals(stereotype)) {
                    DomainDef imptype = new DomainDef();
                    impclass = imptype;
                    Enumeration enumeration = new Enumeration();
                    enumeration.setKind(1);
                    imptype.attachType(enumeration);
                } else {
                    ((ClassDef)impclass).setKind(1);
                }
            } else if (aclass.getXMIName().equals("UML:Association") || aclass.getXMIName().equals("UML:AssociationClass")) {
                impclass = new AssociationDef();
            }
            name = (String)aclass.getXMIValueOfValue("name");
            if (name != null) {
                if (name.startsWith("{")) {
                    name = null;
                } else {
                    int pos = name.indexOf(123);
                    if (pos > 0) {
                        name = name.substring(0, pos - 1);
                    }
                    impclass.setDefLangName(name);
                }
            }
            if ((docu = this.findTaggedValue(aclass.getXMIId(), "documentation")) != null) {
                impclass.setDocumentation(new NlsString(docu));
            }
            if (aclass.getXMIValueOfValue("isAbstract").equals("true") && impclass instanceof AbstractClassDef) {
                ((AbstractClassDef)impclass).setAbstract(true);
            }
            ((Namespace)arg).addOwnedElement(impclass);
            this.xmi2imp.put(aclass, impclass);
        } else {
            impclass = (ModelElement)this.xmi2imp.get(aclass);
        }
        Object obj = aclass.getXMIValueOfValue("UML:Classifier.feature");
        this.visitValue(obj, impclass);
        if (impclass instanceof AbstractClassDef) {
            obj = aclass.getXMIValueOfValue("UML:Namespace.ownedElement");
            this.visitValue(obj, impclass);
        }
        if (impclass instanceof AssociationDef) {
            obj = aclass.getXMIValueOfValue("UML:Association.connection");
            this.visitValue(obj, impclass);
            if (this.pass == 2 && impclass.getName() == null) {
                Iterator rolei = ((AssociationDef)impclass).iteratorConnection();
                StringBuffer namebuf = new StringBuffer();
                while (rolei.hasNext()) {
                    RoleDef role = (RoleDef)rolei.next();
                    namebuf.append(role.getDefLangName());
                }
                impclass.setDefLangName(namebuf.toString());
            }
        }
        return null;
    }

    public Object visitPackage(XMIObject apackage, Object arg) {
        Namespace imppackage;
        if (this.pass == 1) {
            String stereotype = this.findStereotype(apackage.getXMIId());
            imppackage = "ILIMODEL".equals(stereotype) ? new ModelDef() : ("ILITOPIC".equals(stereotype) ? new TopicDef() : new UmlPackage());
            imppackage.setDefLangName((String)apackage.getXMIValueOfValue("name"));
            String docu = this.findTaggedValue(apackage.getXMIId(), "documentation");
            if (docu != null) {
                imppackage.setDocumentation(new NlsString(docu));
            }
            ((Namespace)arg).addOwnedElement(imppackage);
            this.xmi2imp.put(apackage, imppackage);
        } else {
            imppackage = (ch.ehi.uml1_4.modelmanagement.Package)this.xmi2imp.get(apackage);
        }
        Object obj = apackage.getXMIValueOfValue("UML:Namespace.ownedElement");
        this.visitValue(obj, imppackage);
        return null;
    }

    public Object visitModel(XMIObject model, Object arg) {
        Namespace impmodel;
        if (this.pass == 1) {
            impmodel = new INTERLIS2Def();
            impmodel.setDefLangName((String)model.getXMIValueOfValue("name"));
            String docu = this.findTaggedValue(model.getXMIId(), "documentation");
            if (docu != null) {
                impmodel.setDocumentation(new NlsString(docu));
            }
            ((Namespace)arg).addOwnedElement(impmodel);
            this.xmi2imp.put(model, impmodel);
            boolean createmodel = true;
            Collection topv = this.cont.getData("UML:Stereotype");
            for (XMIObject obj : topv) {
                if (!obj.getXMIValueOfValue("name").equals("ILIMODEL")) continue;
                createmodel = false;
            }
            if (createmodel) {
                ModelDef impmodel2 = new ModelDef();
                impmodel2.setDefLangName((String)model.getXMIValueOfValue("name"));
                impmodel.addOwnedElement(impmodel2);
                this.xmi2imp.put(model, impmodel2);
                impmodel = impmodel2;
            }
        } else {
            impmodel = (Namespace)this.xmi2imp.get(model);
        }
        Object obj = model.getXMIValueOfValue("UML:Namespace.ownedElement");
        this.visitValue(obj, impmodel);
        return null;
    }

    public Object visitGeneralization(XMIObject gen, Object arg) {
        if (this.pass == 2) {
            String childId = (String)gen.getXMIValueOfValue("child");
            XMIObject child = (XMIObject)this.id2xmiobj.get(childId);
            String parentId = (String)gen.getXMIValueOfValue("parent");
            XMIObject parent = (XMIObject)this.id2xmiobj.get(parentId);
            ModelElement ele = (ModelElement)this.xmi2imp.get(child);
            if (!(ele instanceof ClassDef)) {
                this.log(MessageFormat.format(rsrc.getString("CIerrGenIgnored"), (String)parent.getXMIValueOfValue("name"), (String)child.getXMIValueOfValue("name")));
                return null;
            }
            ClassDef impchild = (ClassDef)ele;
            ele = (ModelElement)this.xmi2imp.get(parent);
            if (!(ele instanceof ClassDef)) {
                this.log(MessageFormat.format(rsrc.getString("CIerrGenIgnored"), (String)parent.getXMIValueOfValue("name"), (String)child.getXMIValueOfValue("name")));
                return null;
            }
            ClassDef impparent = (ClassDef)ele;
            ClassExtends impgen = new ClassExtends();
            if (impparent.getDefLangName().equals(impchild.getDefLangName())) {
                impgen.setExtended(true);
            }
            impgen.attachChild(impchild);
            impgen.attachParent(impparent);
            this.xmi2imp.put(gen, impgen);
        }
        return null;
    }

    public Object visitAssociationEnd(XMIObject role, Object arg) {
        RoleDef improle = null;
        if (this.pass == 2) {
            improle = new RoleDef();
            ((AssociationDef)arg).addConnection(improle);
            String name = (String)role.getXMIValueOfValue("name");
            String docu = this.findTaggedValue(role.getXMIId(), "documentation");
            if (docu != null) {
                improle.setDocumentation(new NlsString(docu));
            }
            String participantId = (String)role.getXMIValueOfValue("type");
            XMIObject participant = (XMIObject)this.id2xmiobj.get(participantId);
            ModelElement impele = (ModelElement)this.xmi2imp.get(participant);
            if (name != null && name.length() > 0) {
                improle.setDefLangName(name);
            } else {
                improle.setDefLangName(impele.getDefLangName());
            }
            ClassDef impparticipant = null;
            impparticipant = impele instanceof DomainDef ? this.findStructure((DomainDef)impele) : (ClassDef)impele;
            improle.attachParticipant(impparticipant);
            String aggregation = (String)role.getXMIValueOfValue("aggregation");
            if (aggregation.equals("aggregate")) {
                improle.setAggregation(2);
            } else if (aggregation.equals("composite")) {
                improle.setAggregation(3);
            }
            String ordering = (String)role.getXMIValueOfValue("ordering");
            if (ordering.equals("ordered")) {
                improle.setOrdering(2);
            }
            this.xmi2imp.put(role, improle);
        }
        Object obj = role.getXMIValueOfValue("UML:AssociationEnd.multiplicity");
        this.visitValue(obj, improle);
        return null;
    }

    public Object visitMultiplicity(XMIObject multiplicity, Object arg) {
        UmlMultiplicity m = null;
        if (this.pass == 2) {
            m = new UmlMultiplicity();
        }
        Object obj = multiplicity.getXMIValueOfValue("UML:Multiplicity.range");
        this.visitValue(obj, m);
        if (this.pass == 2 && m.sizeRange() > 0) {
            if (arg instanceof RoleDef) {
                ((RoleDef)arg).setMultiplicity(m);
            } else {
                ((AttributeDef)arg).setMultiplicity(m);
            }
        }
        return null;
    }

    public Object visitMultiplicityRange(XMIObject range, Object arg) {
        if (this.pass == 2) {
            String lower = (String)range.getXMIValueOfValue("lower");
            String upper = (String)range.getXMIValueOfValue("upper");
            UmlMultiplicityRange mr = new UmlMultiplicityRange();
            mr.setLower(Long.parseLong(lower));
            if (upper.equals("-1")) {
                mr.setUpper(Long.MAX_VALUE);
            } else {
                mr.setUpper(Long.parseLong(upper));
            }
            ((UmlMultiplicity)arg).addRange(mr);
        }
        return null;
    }

    public Object visitDiagram(XMIObject diagram, Object arg) {
        if ("Rational Rose 98".equals(diagram.getXMIValueOfValue("toolName")) && "ClassDiagram".equals(diagram.getXMIValueOfValue("diagramType"))) {
            Diagram impdiagram = null;
            if (this.pass == 1) {
                String ownerId = (String)diagram.getXMIValueOfValue("owner");
                XMIObject owner = (XMIObject)this.id2xmiobj.get(ownerId);
                Namespace impowner = (Namespace)this.xmi2imp.get(owner);
                impdiagram = new Diagram();
                impdiagram.setName(new NlsString((String)diagram.getXMIValueOfValue("name")));
                String docu = (String)diagram.getXMIValueOfValue("style");
                if (docu != null && docu.startsWith("Doc:")) {
                    impdiagram.setDocumentation(new NlsString(docu.substring(4)));
                }
                impowner.addDiagram(impdiagram);
                this.xmi2imp.put(diagram, impdiagram);
            } else {
                impdiagram = (Diagram)this.xmi2imp.get(diagram);
            }
            Object obj = diagram.getXMIValueOfValue("UML:Diagram.element");
            this.visitValue(obj, impdiagram);
        }
        return null;
    }

    public Object visitDiagramElement(XMIObject diagele, Object arg) {
        Diagram impdiag = (Diagram)arg;
        String style = (String)diagele.getXMIValueOfValue("style");
        if (style.startsWith("Association:")) {
            if (this.pass == 2) {
                String subjectId = (String)diagele.getXMIValueOfValue("subject");
                XMIObject subject = (XMIObject)this.id2xmiobj.get(subjectId);
                ModelElement impsubject = (ModelElement)this.xmi2imp.get(subject);
                if (!(impsubject instanceof AssociationDef)) {
                    return null;
                }
                AssociationDef assocdef = (AssociationDef)impsubject;
                Iterator rolei = assocdef.iteratorConnection();
                boolean skipAssoc = false;
                while (!skipAssoc && rolei.hasNext()) {
                    Object objD = rolei.next();
                    if (!(objD instanceof RoleDef)) {
                        skipAssoc = true;
                        continue;
                    }
                    RoleDef role = (RoleDef)objD;
                    if (!role.containsParticipant()) {
                        skipAssoc = true;
                        continue;
                    }
                    ClassDef end = (ClassDef)role.getParticipant();
                    if (TransferFromXmiRoseMetamodel.findPresentationElement(impdiag, end) != null) continue;
                    skipAssoc = true;
                }
                if (!skipAssoc) {
                    Association assocFig = new Association();
                    PresentationAssocClass linkFig = new PresentationAssocClass();
                    linkFig.addSubject(assocdef);
                    assocFig.attachLinkPresentation(linkFig);
                    rolei = assocdef.iteratorConnection();
                    while (rolei.hasNext()) {
                        RoleDef role = (RoleDef)rolei.next();
                        AbstractClassDef end = (AbstractClassDef)role.getParticipant();
                        PresentationRole roleFig = new PresentationRole();
                        roleFig.addEndpoint(linkFig);
                        roleFig.addEndpoint((Class)TransferFromXmiRoseMetamodel.findPresentationElement(impdiag, end));
                        roleFig.addSubject(role);
                        assocFig.addRolePresentation(roleFig);
                    }
                    assocFig.addSubject(assocdef);
                    impdiag.addPresentationElement(assocFig);
                }
            }
        } else if (!style.equals("Role")) {
            if (style.startsWith("Note:")) {
                if (this.pass == 2) {
                    String subjectId = (String)diagele.getXMIValueOfValue("subject");
                    XMIObject subject = (XMIObject)this.id2xmiobj.get(subjectId);
                    String annotatedElementId = (String)subject.getXMIValueOfValue("annotatedElement");
                    XMIObject annotatedElement = (XMIObject)this.id2xmiobj.get(annotatedElementId);
                    ModelElement impannotatedElement = (ModelElement)this.xmi2imp.get(annotatedElement);
                    Note note = new Note();
                    note.setContent(new NlsString((String)subject.getXMIValueOfValue("name")));
                    String geometry = (String)diagele.getXMIValueOfValue("geometry");
                    int start = 0;
                    int pos = geometry.indexOf(44);
                    String value = geometry.substring(start, pos).trim();
                    note.setEast(Integer.parseInt(value));
                    start = pos + 2;
                    pos = geometry.indexOf(44, start);
                    value = geometry.substring(start, pos).trim();
                    note.setSouth(Integer.parseInt(value));
                    impdiag.addPresentationElement(note);
                    PresentationElement fig = TransferFromXmiRoseMetamodel.findPresentationElement(impdiag, impannotatedElement);
                    if (fig != null) {
                        NoteEdge edge = null;
                        edge = new NoteEdge();
                        edge.addEndpoint(fig);
                        edge.addEndpoint(note);
                        impdiag.addPresentationElement(edge);
                    }
                }
            } else if (style.equals("Inheritance")) {
                if (this.pass == 2) {
                    String subjectId = (String)diagele.getXMIValueOfValue("subject");
                    XMIObject subject = (XMIObject)this.id2xmiobj.get(subjectId);
                    ModelElement impsubject = (ModelElement)this.xmi2imp.get(subject);
                    if (impsubject == null) {
                        return null;
                    }
                    Generalization edge = null;
                    edge = new Generalization();
                    ((PresentationEdge)edge).addSubject(impsubject);
                    PresentationNode node = null;
                    node = (PresentationNode)TransferFromXmiRoseMetamodel.findPresentationElement(impdiag, ((ch.ehi.uml1_4.foundation.core.Generalization)impsubject).getChild());
                    edge.addEndpoint(node);
                    node = (PresentationNode)TransferFromXmiRoseMetamodel.findPresentationElement(impdiag, ((ch.ehi.uml1_4.foundation.core.Generalization)impsubject).getParent());
                    edge.addEndpoint(node);
                    impdiag.addPresentationElement(edge);
                }
            } else {
                String subjectId = (String)diagele.getXMIValueOfValue("subject");
                XMIObject subject = (XMIObject)this.id2xmiobj.get(subjectId);
                ModelElement impsubject = (ModelElement)this.xmi2imp.get(subject);
                if (this.pass == 1) {
                    PresentationNode node = null;
                    if (impsubject instanceof ClassDef) {
                        node = new Class();
                    } else {
                        if (impsubject instanceof AssociationDef) {
                            return null;
                        }
                        if (impsubject instanceof ModelDef || impsubject instanceof TopicDef || impsubject instanceof UmlPackage) {
                            node = new Package();
                        } else {
                            return null;
                        }
                    }
                    node.addSubject(impsubject);
                    String geometry = (String)diagele.getXMIValueOfValue("geometry");
                    int start = 0;
                    int pos = geometry.indexOf(44);
                    String value = geometry.substring(start, pos).trim();
                    node.setEast(Integer.parseInt(value));
                    start = pos + 2;
                    pos = geometry.indexOf(44, start);
                    value = geometry.substring(start, pos).trim();
                    node.setSouth(Integer.parseInt(value));
                    impdiag.addPresentationElement(node);
                } else if (this.pass == 2 && impsubject instanceof AssociationDef) {
                    PresentationElement fig = TransferFromXmiRoseMetamodel.findPresentationElement(impdiag, impsubject);
                    if (fig instanceof Association) {
                        fig = ((Association)fig).getLinkPresentation();
                    }
                    PresentationAssocClass node = (PresentationAssocClass)fig;
                    String geometry = (String)diagele.getXMIValueOfValue("geometry");
                    int start = 0;
                    int pos = geometry.indexOf(44);
                    String value = geometry.substring(start, pos).trim();
                    int x = Integer.parseInt(value);
                    start = pos + 2;
                    pos = geometry.indexOf(44, start);
                    value = geometry.substring(start, pos).trim();
                    int y = Integer.parseInt(value);
                    node.setClassAngle(x);
                    node.setClassRadius(y);
                }
            }
        }
        return null;
    }

    public void doXmiFile(String filename) {
        try {
            this.domain2struct = new HashMap();
            this.xmi2imp = new HashMap();
            this.id2xmiobj = new HashMap();
            XMIFile f = XMIFile.load((String)filename, (int)1, (boolean)false);
            this.cont = new XMIContainer(f.getObjects().iterator());
            for (XMIObject obj : this.cont.getObjects()) {
                String id = obj.getXMIId();
                if (id == null) continue;
                this.id2xmiobj.put(id, obj);
            }
            this.pass = 1;
            while (this.pass <= 2) {
                Collection topv = this.cont.getData("UML:Model");
                for (XMIObject obj : topv) {
                    this.visitModel(obj, LauncherView.getInstance().getModel());
                }
                Collection diagv = this.cont.getData("UML:Diagram");
                for (XMIObject obj : diagv) {
                    this.visitDiagram(obj, null);
                }
                ++this.pass;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LauncherView.getInstance().refreshModel();
    }

    public Object visitDatatype(XMIObject type, Object arg) {
        if (this.pass == 1) {
            DomainDef imptype = new DomainDef();
            imptype.setDefLangName((String)type.getXMIValueOfValue("name"));
            String docu = this.findTaggedValue(type.getXMIId(), "documentation");
            if (docu != null) {
                imptype.setDocumentation(new NlsString(docu));
            }
            Text text = new Text();
            text.setKind(2);
            text.setMaxLength(40L);
            imptype.attachType(text);
            ((Namespace)arg).addOwnedElement(imptype);
            this.xmi2imp.put(type, imptype);
        } else {
            DomainDef imptype = (DomainDef)this.xmi2imp.get(type);
        }
        return null;
    }

    private void log(String logmsg) {
        LauncherView.getInstance().log("xmirose", logmsg);
    }

    private static PresentationElement findPresentationElement(Diagram diagram, ModelElement subject) {
        Iterator elei = diagram.iteratorPresentationElement();
        while (elei.hasNext()) {
            PresentationElement ele = (PresentationElement)elei.next();
            Iterator subi = ele.iteratorSubject();
            while (subi.hasNext()) {
                if (subi.next() != subject) continue;
                return ele;
            }
        }
        return null;
    }

    private ClassDef findStructure(DomainDef impele) {
        ClassDef impparticipant = (ClassDef)this.domain2struct.get(impele);
        if (impparticipant == null) {
            Namespace domainPackage = impele.getNamespace();
            ClassDef newstruct = new ClassDef();
            newstruct.setDefLangName(impele.getDefLangName() + "_");
            newstruct.setKind(2);
            AttributeDef attr = new AttributeDef();
            attr.setDefLangName("value");
            DomainAttribute attrtype = new DomainAttribute();
            attrtype.attachDomainDef(impele);
            attr.attachAttrType(attrtype);
            newstruct.addFeature(attr);
            domainPackage.addOwnedElement(newstruct);
            this.domain2struct.put(impele, newstruct);
            impparticipant = newstruct;
        }
        return impparticipant;
    }

    private boolean isMaxCardOne(XMIObject attr) {
        RoleDef improle = null;
        improle = new RoleDef();
        Object obj = attr.getXMIValueOfValue("UML:StructuralFeature.multiplicity");
        this.visitValue(obj, improle);
        Multiplicity m = improle.getMultiplicity();
        Iterator mri = m.iteratorRange();
        long max = 0L;
        while (mri.hasNext()) {
            MultiplicityRange mr = (MultiplicityRange)mri.next();
            max = mr.getUpper();
        }
        return max == 1L;
    }

    private boolean isMinCardOne(XMIObject attr) {
        RoleDef improle = null;
        improle = new RoleDef();
        Object obj = attr.getXMIValueOfValue("UML:StructuralFeature.multiplicity");
        this.visitValue(obj, improle);
        Multiplicity m = improle.getMultiplicity();
        Iterator mri = m.iteratorRange();
        long min = 0L;
        while (mri.hasNext()) {
            MultiplicityRange mr = (MultiplicityRange)mri.next();
            min = mr.getLower();
        }
        return min == 1L;
    }

    public Object visitOperation(XMIObject ops, Object aclass) {
        if (aclass instanceof AbstractClassDef && this.pass == 2) {
            String visibility;
            UmlOperation impop = new UmlOperation();
            impop.setDefLangName((String)ops.getXMIValueOfValue("name"));
            String docu = this.findTaggedValue(ops.getXMIId(), "documentation");
            if (docu != null) {
                impop.setDocumentation(new NlsString(docu));
            }
            if ((visibility = (String)ops.getXMIValueOfValue("visibility")).equals("public")) {
                impop.setVisibility(1);
            } else if (visibility.equals("private")) {
                impop.setVisibility(3);
            } else if (visibility.equals("protected")) {
                impop.setVisibility(2);
            } else if (visibility.equals("package")) {
                impop.setVisibility(4);
            }
            String ownerScope = (String)ops.getXMIValueOfValue("ownerScope");
            if (ownerScope.equals("instance")) {
                impop.setOwnerScope(1);
            } else if (ownerScope.equals("classifier")) {
                impop.setOwnerScope(2);
            }
            String isQuery = (String)ops.getXMIValueOfValue("isQuery");
            impop.setQuery(isQuery.equals("true"));
            String concurrency = (String)ops.getXMIValueOfValue("concurrency");
            if (concurrency.equals("sequential")) {
                impop.setConcurrency(1);
            } else if (concurrency.equals("quarded")) {
                impop.setConcurrency(2);
            } else if (concurrency.equals("concurrent")) {
                impop.setConcurrency(3);
            }
            String isRoot = (String)ops.getXMIValueOfValue("isRoot");
            impop.setRoot(isRoot.equals("true"));
            String isLeaf = (String)ops.getXMIValueOfValue("isLeaf");
            impop.setLeaf(isLeaf.equals("true"));
            String isAbstract = (String)ops.getXMIValueOfValue("isAbstract");
            impop.setAbstract(isAbstract.equals("true"));
            String specification = (String)ops.getXMIValueOfValue("specification");
            impop.setSpecification(new NlsString(specification));
            Object obj = ops.getXMIValueOfValue("UML:BehavioralFeature.parameter");
            this.visitValue(obj, impop);
            ((Classifier)aclass).addFeature(impop);
        }
        return null;
    }

    public Object visitParameter(XMIObject param, Object ops) {
        if (ops instanceof Operation && this.pass == 2) {
            String kind;
            UmlParameter impparam = new UmlParameter();
            impparam.setDefLangName((String)param.getXMIValueOfValue("name"));
            String docu = this.findTaggedValue(param.getXMIId(), "documentation");
            if (docu != null) {
                impparam.setDocumentation(new NlsString(docu));
            }
            if ((kind = (String)param.getXMIValueOfValue("kind")).equals("inout")) {
                impparam.setKind(3);
            } else if (kind.equals("in")) {
                impparam.setKind(1);
            } else if (kind.equals("out")) {
                impparam.setKind(2);
            } else if (kind.equals("return")) {
                impparam.setKind(4);
            }
            ((Operation)ops).addParameter(impparam);
        }
        return null;
    }
}

