/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.domainsandconstants.linetypes.LineForm;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.Contract;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.Translation;
import ch.ehi.interlis.tools.AbstractClassDefUtility;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Attribute;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.implementation.UmlParameter;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.IliBaseTypeKind;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.application.MultiplicityConverter;
import ch.ehi.umleditor.umldrawingtools.PresentationRoleFigure;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.Tracer;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class EditorTableModel
extends DefaultTableModel {
    private static ResourceBundle resEditorTableModel = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/EditorTableModel");
    private Vector elementVector = new Vector();
    private static final int OTHER = 1;
    private static final int ATTRIBUTE = 2;
    private int tableKind = 1;

    public EditorTableModel() {
    }

    public EditorTableModel(Vector data, Vector columnNames) {
        this();
        this.setDataVector(this.elementVector, columnNames);
        for (int i = 0; i < data.size(); ++i) {
            Vector row = new Vector();
            row.add(data.get(i));
            this.elementVector.add(row);
        }
        this.fireTableRowsInserted(this.elementVector.size() - 1, this.elementVector.size() - 1);
    }

    public Vector addRowElement(Object object) {
        Vector row = new Vector();
        if (object instanceof AttributeDef) {
            row = this.createRow((AttributeDef)object);
        } else if (object instanceof AbstractClassDef) {
            row = this.createRow((AbstractClassDef)object);
        } else if (object instanceof RoleDef) {
            row = this.createRow((RoleDef)object);
        } else if (object instanceof Contract) {
            row = this.createRow((Contract)object);
        } else if (object instanceof Dependency) {
            row = this.createRow((Dependency)object);
        } else if (object instanceof LineFormTypeDef) {
            row = this.createRow((LineFormTypeDef)object);
        } else if (object instanceof Translation) {
            row = this.createRow((Translation)object);
        } else if (object instanceof UmlParameter) {
            row = this.createRow((UmlParameter)object);
        } else if (object instanceof Vector) {
            row = this.createRow((Vector)object);
        } else {
            throw new DeveloperException("unsupported type <" + object.toString() + ">");
        }
        row.add(object);
        this.elementVector.add(row);
        this.fireTableRowsInserted(this.elementVector.size() - 1, this.elementVector.size() - 1);
        return row;
    }

    private Vector createRow(RoleDef roleDef) {
        if (this.tableKind == 2) {
            Vector<String> row = new Vector<String>(4);
            row.add(roleDef.getDefLangName());
            row.add(MultiplicityConverter.getRange(roleDef.getMultiplicity()));
            if (roleDef.containsParticipant()) {
                row.add(roleDef.getParticipant().getDefLangName());
            } else {
                row.add(null);
            }
            return row;
        }
        Vector<String> row = new Vector<String>(5);
        row.add(roleDef.getDefLangName());
        if (roleDef.getAggregation() == 2) {
            row.add(PresentationRoleFigure.AGGREGATION);
        } else if (roleDef.getAggregation() == 3) {
            row.add(PresentationRoleFigure.COMPOSITE);
        } else {
            row.add(PresentationRoleFigure.ASSOCIATION);
        }
        row.add(MultiplicityConverter.getRange(roleDef.getMultiplicity()));
        if (roleDef.containsParticipant()) {
            String className = roleDef.getParticipant().getDefLangName();
            Iterator xori = roleDef.iteratorXorParticipant();
            while (xori.hasNext()) {
                Participant xor = (Participant)xori.next();
                if (!xor.containsParticipant()) continue;
                className = className + "|" + xor.getParticipant().getDefLangName();
            }
            row.add(className);
        } else {
            row.add(null);
        }
        return row;
    }

    private Vector createRow(AttributeDef attributeDef) {
        Vector<String> row = new Vector<String>(4);
        row.add(attributeDef.getDefLangName());
        row.add(MultiplicityConverter.getRange(attributeDef.getMultiplicity()));
        row.add(IliBaseTypeKind.getTypeName(attributeDef, true));
        return row;
    }

    private Vector createRow(LineFormTypeDef lineFormTypeDef) {
        Vector<String> row = new Vector<String>(2);
        row.add(lineFormTypeDef.getDefLangName());
        return row;
    }

    private Vector createRow(AbstractClassDef classDef) {
        Vector<String> row = new Vector<String>(2);
        row.add(classDef.getDefLangName());
        return row;
    }

    private Vector createRow(Contract contract) {
        Vector<String> row = new Vector<String>(2);
        row.add(ElementUtils.mapNlsString(contract.getIssuer()));
        return row;
    }

    private Vector createRow(Translation translation) {
        Vector<String> row = new Vector<String>(3);
        row.add(translation.getLanguage());
        row.add(translation.getBaseLanguage());
        return row;
    }

    private Vector createRow(Dependency dependency) {
        Vector<String> row = new Vector<String>(2);
        Iterator iterator = dependency.iteratorSupplier();
        if (iterator.hasNext()) {
            ModelElement element = (ModelElement)iterator.next();
            row.add(element.getDefLangName());
        } else {
            Tracer.getInstance().developerError("Bad modelled Dependency discovered!");
        }
        return row;
    }

    private Vector createRow(UmlParameter parameter) {
        Vector<String> row = new Vector<String>(4);
        row.add(parameter.getDefLangName());
        row.add("NYI");
        row.add(this.getParameterTypeString(parameter.getKind()));
        return row;
    }

    private Vector createRow(Vector vector) {
        Vector row = new Vector(3);
        row.add(vector.get(0));
        row.add(vector.get(1));
        return row;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void removeRows(int[] selectedRows) {
        for (int i = selectedRows.length; i > 0; --i) {
            int rowIndex = selectedRows[i - 1];
            Vector currentDataRow = (Vector)this.elementVector.get(rowIndex);
            Element element = (Element)currentDataRow.get(currentDataRow.size() - 1);
            if (element instanceof LineFormTypeDef) {
                if (((LineFormTypeDef)element).containsLineForm()) {
                    LineForm lineForm = ((LineFormTypeDef)element).getLineForm();
                    lineForm.removeLineFormTypeDef((LineFormTypeDef)element);
                }
            } else {
                ElementFactory.removeElement(element);
            }
            this.elementVector.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    public void setAttributeDef(AbstractClassDef aclass) {
        this.tableKind = 2;
        Iterator iteratorFeature = aclass.iteratorFeature();
        Vector<String> columns = new Vector<String>(3);
        columns.add(resEditorTableModel.getString("TbcAttributeName_text"));
        columns.add(resEditorTableModel.getString("TbcAttributeCardinality_text"));
        columns.add(resEditorTableModel.getString("TbcAttributeType_text"));
        this.setDataVector(this.elementVector, columns);
        List attrlist = AbstractClassDefUtility.getIliAttributes(aclass);
        for (Object obj : attrlist) {
            if (obj instanceof RoleDef) {
                this.addRowElement((RoleDef)obj);
                continue;
            }
            if (!(obj instanceof AttributeDef)) continue;
            this.addRowElement((AttributeDef)obj);
        }
    }

    public void setClientDependency(Iterator iteratorClientDependency, String columnName) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(1);
        columns.add(columnName);
        this.setDataVector(this.elementVector, columns);
        while (iteratorClientDependency != null && iteratorClientDependency.hasNext()) {
            this.addRowElement((Dependency)iteratorClientDependency.next());
        }
    }

    public void setContract(Iterator iteratorContract) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(1);
        columns.add(resEditorTableModel.getString("TbcContractIssuer_text"));
        this.setDataVector(this.elementVector, columns);
        while (iteratorContract != null && iteratorContract.hasNext()) {
            this.addRowElement((Contract)iteratorContract.next());
        }
    }

    public void setLineFormTypeDef(Iterator iteratorLineFormTypeDef) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(1);
        columns.add(resEditorTableModel.getString("TbcLineFormTypeDef_text"));
        this.setDataVector(this.elementVector, columns);
        while (iteratorLineFormTypeDef != null && iteratorLineFormTypeDef.hasNext()) {
            this.addRowElement((LineFormTypeDef)iteratorLineFormTypeDef.next());
        }
    }

    public void setRestrictedClassDef(Iterator iteratorRestrictedTo) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(1);
        columns.add(resEditorTableModel.getString("TbcRestrictedClassDef_text"));
        this.setDataVector(this.elementVector, columns);
        while (iteratorRestrictedTo != null && iteratorRestrictedTo.hasNext()) {
            this.addRowElement((AbstractClassDef)iteratorRestrictedTo.next());
        }
    }

    public void setRoleDef(Iterator iteratorConnection) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(4);
        columns.add(resEditorTableModel.getString("TbcRoleName_text"));
        columns.add(resEditorTableModel.getString("TbcRoleKind_text"));
        columns.add(resEditorTableModel.getString("TbcRoleCardinality_text"));
        columns.add(resEditorTableModel.getString("TbcRoleClass_text"));
        this.setDataVector(this.elementVector, columns);
        while (iteratorConnection != null && iteratorConnection.hasNext()) {
            this.addRowElement((RoleDef)iteratorConnection.next());
        }
    }

    public void moveRowDown(int current) {
        Object nextElement;
        Vector nextDataRow;
        if (current + 1 == this.elementVector.size()) {
            return;
        }
        Vector currentDataRow = (Vector)this.elementVector.get(current);
        Element element = (Element)currentDataRow.get(currentDataRow.size() - 1);
        if (element instanceof AssociationEnd) {
            nextDataRow = (Vector)this.elementVector.get(current + 1);
            if (this.tableKind != 2) {
                nextElement = (AssociationEnd)nextDataRow.get(nextDataRow.size() - 1);
                AssociationDef assoc = (AssociationDef)nextElement.getAssociation();
                assoc.swapConnection((AssociationEnd)element, (AssociationEnd)nextElement);
            }
            this.elementVector.set(current + 1, currentDataRow);
            this.elementVector.set(current, nextDataRow);
            this.fireTableRowsUpdated(current, current + 1);
        } else if (element instanceof Attribute) {
            nextDataRow = (Vector)this.elementVector.get(current + 1);
            nextElement = nextDataRow.get(nextDataRow.size() - 1);
            if (nextElement instanceof Attribute) {
                AbstractClassDef aclass = (AbstractClassDef)((Attribute)nextElement).getOwner();
                aclass.swapFeature((Attribute)element, (Attribute)nextElement);
            }
            this.elementVector.set(current + 1, currentDataRow);
            this.elementVector.set(current, nextDataRow);
            this.fireTableRowsUpdated(current, current + 1);
        }
        if (this.tableKind == 2) {
            for (int i = 0; i < this.elementVector.size(); ++i) {
                Vector dataRow = (Vector)this.elementVector.get(i);
                Object role = dataRow.get(dataRow.size() - 1);
                if (!(role instanceof RoleDef)) continue;
                ((RoleDef)role).setIliAttributeIdx(i);
            }
        }
    }

    public void setTranslation(Iterator iteratorTranslation) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(2);
        columns.add(resEditorTableModel.getString("TbcTranslationLanguage_text"));
        columns.add(resEditorTableModel.getString("TbcTranslationBaseLanguage_text"));
        this.setDataVector(this.elementVector, columns);
        while (iteratorTranslation != null && iteratorTranslation.hasNext()) {
            this.addRowElement((Translation)iteratorTranslation.next());
        }
    }

    public void setTranslationFile(Iterator iteratorTranslation) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(2);
        columns.add(resEditorTableModel.getString("TbcTranslationFileLanguage_text"));
        columns.add(resEditorTableModel.getString("TbcTranslationFileName_text"));
        this.setDataVector(this.elementVector, columns);
        while (iteratorTranslation != null && iteratorTranslation.hasNext()) {
            this.addRowElement(iteratorTranslation.next());
        }
    }

    protected void showDependencySpecification(int[] selectedRows) {
        for (int i = 0; i < selectedRows.length; ++i) {
            int currentRowIndex = selectedRows[i];
            Vector currentDataRow = (Vector)this.elementVector.get(currentRowIndex);
            Element element = (Element)currentDataRow.get(currentDataRow.size() - 1);
            Iterator it = ((Dependency)element).iteratorSupplier();
            if (!it.hasNext()) {
                Tracer.getInstance().developerError("Corrupt model -> Dependendency has no supplier");
                throw new DeveloperException(ResourceManager.getResource(EditorTableModel.class, "CMDependencyProblem"), ResourceManager.getResource(EditorTableModel.class, "CTDependencyProblem"));
            }
            LauncherView.getInstance().showSpecification((Element)it.next());
            this.updateRow(currentRowIndex, currentDataRow, element);
        }
    }

    protected void showSpecification(int[] selectedRows) {
        for (int i = 0; i < selectedRows.length; ++i) {
            int currentRowIndex = selectedRows[i];
            Vector currentDataRow = (Vector)this.elementVector.get(currentRowIndex);
            Element element = (Element)currentDataRow.get(currentDataRow.size() - 1);
            LauncherView.getInstance().showSpecification(element);
            this.updateRow(currentRowIndex, currentDataRow, element);
        }
    }

    private void updateRow(int rowIndex, Vector currentDataRow, Object object) {
        if (object instanceof AttributeDef) {
            currentDataRow.set(0, ((AttributeDef)object).getDefLangName());
            currentDataRow.set(1, MultiplicityConverter.getRange(((AttributeDef)object).getMultiplicity()));
            currentDataRow.set(2, IliBaseTypeKind.getTypeName(object, true));
        } else if (object instanceof ClassDef) {
            currentDataRow.set(0, ((ClassDef)object).getDefLangName());
        } else if (object instanceof RoleDef) {
            RoleDef roleDef = (RoleDef)object;
            if (this.tableKind == 2) {
                currentDataRow.set(0, roleDef.getDefLangName());
                currentDataRow.set(1, MultiplicityConverter.getRange(roleDef.getMultiplicity()));
                if (roleDef.containsParticipant()) {
                    currentDataRow.set(2, roleDef.getParticipant().getDefLangName());
                } else {
                    currentDataRow.set(2, null);
                }
            } else {
                currentDataRow.set(0, roleDef.getDefLangName());
                if (roleDef.getAggregation() == 2) {
                    currentDataRow.set(1, PresentationRoleFigure.AGGREGATION);
                } else if (roleDef.getAggregation() == 3) {
                    currentDataRow.set(1, PresentationRoleFigure.COMPOSITE);
                } else {
                    currentDataRow.set(1, PresentationRoleFigure.ASSOCIATION);
                }
                currentDataRow.set(2, MultiplicityConverter.getRange(roleDef.getMultiplicity()));
                if (roleDef.containsParticipant()) {
                    String className = roleDef.getParticipant().getDefLangName();
                    Iterator xori = roleDef.iteratorXorParticipant();
                    while (xori.hasNext()) {
                        Participant xor = (Participant)xori.next();
                        if (!xor.containsParticipant()) continue;
                        className = className + "|" + xor.getParticipant().getDefLangName();
                    }
                    currentDataRow.set(3, className);
                } else {
                    currentDataRow.set(3, null);
                }
            }
        } else if (object instanceof Contract) {
            currentDataRow.set(0, ElementUtils.mapNlsString(((Contract)object).getIssuer()));
        } else if (object instanceof ModelDef) {
            currentDataRow.set(0, ((ModelDef)object).getDefLangName());
        } else if (object instanceof Dependency) {
            currentDataRow.set(0, ((ModelElement)((Dependency)object).iteratorSupplier().next()).getDefLangName());
        } else if (object instanceof LineFormTypeDef) {
            currentDataRow.set(0, ((LineFormTypeDef)object).getDefLangName());
        } else if (object instanceof Translation) {
            currentDataRow.set(0, ((Translation)object).getLanguage());
            currentDataRow.set(1, ((Translation)object).getBaseLanguage());
        } else if (object instanceof UmlParameter) {
            currentDataRow.set(0, ((UmlParameter)object).getDefLangName());
            currentDataRow.set(2, this.getParameterTypeString(((UmlParameter)object).getKind()));
        } else {
            throw new DeveloperException("type <" + object.toString() + "> not updated");
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    private String getParameterTypeString(int kind) {
        if (kind == 1) {
            return "IN";
        }
        if (kind == 2) {
            return "OUT";
        }
        if (kind == 3) {
            return "IN/OUT";
        }
        Tracer.getInstance().developerWarning("non-supported kind: " + kind);
        return "" + kind;
    }

    public UmlParameter setUmlParameter(Iterator iteratorParameter) {
        this.tableKind = 1;
        Vector<String> columns = new Vector<String>(3);
        columns.add(resEditorTableModel.getString("TbcAttributeName_text"));
        columns.add(resEditorTableModel.getString("TbcAttributeType_text"));
        columns.add(resEditorTableModel.getString("TbcRoleKind_text"));
        this.setDataVector(this.elementVector, columns);
        UmlParameter returnValue = null;
        while (iteratorParameter != null && iteratorParameter.hasNext()) {
            Object feature = iteratorParameter.next();
            if (!(feature instanceof UmlParameter)) continue;
            if (((UmlParameter)feature).getKind() == 4) {
                if (returnValue != null) {
                    Tracer.getInstance().developerError("there is more than 1 Return Parameter in Model");
                }
                returnValue = (UmlParameter)feature;
                continue;
            }
            this.addRowElement((UmlParameter)feature);
        }
        return returnValue;
    }
}

