/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.uml1_4.foundation.core.Association;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.AssociationLineDecoration;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.ClassFigure;
import ch.ehi.umleditor.umldrawingtools.EdgeFigure;
import ch.ehi.umleditor.umldrawingtools.LinkFigure;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.NoteAnchorLineConnection;
import ch.ehi.umleditor.umldrawingtools.RoleDefFigure;
import ch.ehi.umleditor.umlpresentation.PresentationAssocClass;
import ch.ehi.umleditor.umlpresentation.PresentationRole;
import ch.ehi.umleditor.umlpresentation.WayPoint;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.CommonUserAccess;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class PresentationRoleFigure
extends EdgeFigure
implements ActionListener {
    private static ResourceBundle resPresentationRoleFigure = ResourceBundle.getBundle("ch/ehi/umleditor/umldrawingtools/resources/PresentationRoleFigure");
    public static final String AGGREGATION = resPresentationRoleFigure.getString("ChxAggregation_text");
    public static final String ASSOCIATION = resPresentationRoleFigure.getString("ChxAssociation_text");
    public static final String COMPOSITE = resPresentationRoleFigure.getString("ChxComposition_text");
    private static final String NAVIGABLE_LABEL = resPresentationRoleFigure.getString("ChxNavigation_text");
    private static final String AGGREGABLE_LABEL = resPresentationRoleFigure.getString("ChxAggregable_text");
    private static final String COMPOSITE_LABEL = resPresentationRoleFigure.getString("ChxComposite_text");
    private static final String NAVIGATION_END = "NAVIGATION_END_MENU";
    private static final String AGGREGATION_END = "AGGREGATION_END";
    private static final String COMPOSITE_END = "COMPOSITE_END";
    private static final String SHOW_ROLE = "SHOW_ROLE";
    private static final String SHOW_MULTIPLICITY = "SHOW_MULTIPLICITY";
    private static final String SHOW_ASSOCIATION_NAME = "SHOW_ASSOCIATION_NAME";
    private JCheckBoxMenuItem chxNavigableEnd = null;
    private JCheckBoxMenuItem chxAggregableEnd = null;
    private JCheckBoxMenuItem chxCompositeEnd = null;
    private JCheckBoxMenuItem chxShowRole = null;
    private JCheckBoxMenuItem chxShowMultiplicity = null;
    private JCheckBoxMenuItem chxShowAssociationName = null;
    private RoleDefFigure roleDefFigure = null;
    private RoleDefFigure multiplicityFigure = null;

    public PresentationRoleFigure(ClassDiagramView classDiagram, PresentationRole edge) {
        super(classDiagram);
        this.edge = edge;
        this.setLineColor(this.determineForegroundColor(edge));
        this.chxNavigableEnd = new JCheckBoxMenuItem(NAVIGABLE_LABEL);
        this.initalizeCheckBox(this.chxNavigableEnd, NAVIGATION_END);
        this.chxAggregableEnd = new JCheckBoxMenuItem(AGGREGABLE_LABEL);
        this.initalizeCheckBox(this.chxAggregableEnd, AGGREGATION_END);
        this.chxCompositeEnd = new JCheckBoxMenuItem(COMPOSITE_LABEL);
        this.initalizeCheckBox(this.chxCompositeEnd, COMPOSITE_END);
        this.chxShowRole = new JCheckBoxMenuItem(resPresentationRoleFigure.getString("ChxShowRoles_text"));
        this.initalizeCheckBox(this.chxShowRole, SHOW_ROLE);
        this.chxShowMultiplicity = new JCheckBoxMenuItem(resPresentationRoleFigure.getString("ChxShowCardinality_text"));
        this.initalizeCheckBox(this.chxShowMultiplicity, SHOW_MULTIPLICITY);
        this.chxShowAssociationName = new JCheckBoxMenuItem(resPresentationRoleFigure.getString("ChxShowAssociationName_text"));
        this.initalizeCheckBox(this.chxShowAssociationName, SHOW_ASSOCIATION_NAME);
        this.setModelElement((ModelElement)edge.iteratorSubject().next());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(NAVIGATION_END)) {
            this.setNavigableEnd(((JCheckBoxMenuItem)e.getSource()).getState());
        } else if (e.getActionCommand().equals(AGGREGATION_END)) {
            if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                this.setAggregationEnd(2);
                this.chxCompositeEnd.setSelected(false);
            } else {
                this.setAggregationEnd(1);
            }
        } else if (e.getActionCommand().equals(COMPOSITE_END)) {
            if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                this.setAggregationEnd(3);
                this.chxAggregableEnd.setSelected(false);
            } else {
                this.setAggregationEnd(1);
            }
        } else if (e.getActionCommand().equals(SHOW_ROLE)) {
            ((PresentationRole)this.getEdge()).setNameVisible(this.chxShowRole.isSelected());
        } else if (e.getActionCommand().equals(SHOW_MULTIPLICITY)) {
            ((PresentationRole)this.getEdge()).setMultiplicityVisible(this.chxShowMultiplicity.isSelected());
        } else if (e.getActionCommand().equals(SHOW_ASSOCIATION_NAME)) {
            ((PresentationRole)this.getEdge()).getAssociation().setShowName(this.chxShowAssociationName.isSelected());
        }
    }

    @Override
    protected void addEditMenu(JPopupMenu popupMenu) {
        JMenu editMenu = new JMenu(CommonUserAccess.getMnuEditText());
        if (!this.isXorEdge()) {
            editMenu.add(new AbstractAction(CommonUserAccess.getMniEditRemoveText()){

                @Override
                public void actionPerformed(ActionEvent event) {
                    PresentationRoleFigure.this.removeVisually();
                }
            });
            editMenu.add(new JSeparator());
        }
        editMenu.add(new AbstractAction(REMOVE_IN_MODEL){

            @Override
            public void actionPerformed(ActionEvent event) {
                PresentationRoleFigure.this.removeInModel();
            }
        });
        popupMenu.add(editMenu);
    }

    @Override
    protected void addSpecialMenu(JPopupMenu popupMenu) {
        popupMenu.add(new JSeparator());
        popupMenu.add(this.chxNavigableEnd);
        popupMenu.add(this.chxAggregableEnd);
        popupMenu.add(this.chxCompositeEnd);
        popupMenu.add(new JSeparator());
        this.chxShowRole.setSelected(((PresentationRole)this.getEdge()).isNameVisible());
        popupMenu.add(this.chxShowRole);
        this.chxShowMultiplicity.setSelected(((PresentationRole)this.getEdge()).isMultiplicityVisible());
        popupMenu.add(this.chxShowMultiplicity);
        this.chxShowAssociationName.setSelected(this.isShowAssociationName());
        popupMenu.add(this.chxShowAssociationName);
        this.updateCheckBoxes();
    }

    private Point calculateMultiplicityPosition(Rectangle nodeDisplayBox, Point connectionPoint) {
        Point p = this.calculateRolePosition(nodeDisplayBox, connectionPoint);
        p.x += 20;
        p.y += 14;
        return p;
    }

    private Point calculateRolePosition(Rectangle nodeDisplayBox, Point connectionPoint) {
        int x = connectionPoint.x;
        int y = connectionPoint.y;
        int nodeCenterX = (int)nodeDisplayBox.getCenterX();
        int nodeCenterY = (int)nodeDisplayBox.getCenterY();
        if (connectionPoint.x < nodeCenterX) {
            x = nodeDisplayBox.x - (nodeDisplayBox.x - connectionPoint.x) - 40;
        } else if (connectionPoint.x >= nodeCenterX) {
            x = nodeDisplayBox.x + nodeDisplayBox.width + 5;
        }
        if (connectionPoint.y < nodeCenterY) {
            y = connectionPoint.y - 20;
        } else if (connectionPoint.y >= nodeCenterY) {
            y = nodeDisplayBox.y + nodeDisplayBox.height + 15;
        }
        return new Point(x, y);
    }

    public void draw(Graphics g) {
        try {
            Point p;
            PresentationRole role;
            Figure figure;
            super.draw(g);
            if (this.roleDefFigure == null) {
                if (this.getEndAssociationEnd() != null && (figure = this.getClassDiagram().findFigure(this.getEndElement())) != null && ((PresentationRole)this.getEdge()).isNameVisible()) {
                    role = (PresentationRole)this.getEdge();
                    this.roleDefFigure = new RoleDefFigure(this, 0);
                    p = null;
                    p = role.getNameAngle() > 0.0 && role.getNameRadius() > 0.0 ? new Point((int)role.getNameAngle(), (int)role.getNameRadius()) : this.calculateRolePosition(figure.displayBox(), this.endPoint());
                    this.roleDefFigure.displayBox(p, p);
                    this.getClassDiagram().add((Figure)this.roleDefFigure);
                    this.roleDefFigure.draw(g);
                    this.roleDefFigure.setCreating(false);
                }
            } else if (!((PresentationRole)this.getEdge()).isNameVisible()) {
                this.removeRole();
            }
            if (this.multiplicityFigure == null) {
                if (this.getEndAssociationEnd() != null && this.getEndAssociationEnd().getMultiplicity() != null && (figure = this.getClassDiagram().findFigure(this.getEndElement())) != null && ((PresentationRole)this.getEdge()).isMultiplicityVisible()) {
                    role = (PresentationRole)this.getEdge();
                    this.multiplicityFigure = new RoleDefFigure(this, 1);
                    p = null;
                    p = role.getMultiplicityAngle() > 0.0 && role.getMultiplicityRadius() > 0.0 ? new Point((int)role.getMultiplicityAngle(), (int)role.getMultiplicityRadius()) : this.calculateMultiplicityPosition(figure.displayBox(), this.endPoint());
                    this.multiplicityFigure.displayBox(p, p);
                    this.getClassDiagram().add((Figure)this.multiplicityFigure);
                    this.multiplicityFigure.draw(g);
                    this.multiplicityFigure.setCreating(false);
                }
            } else if (this.getEndAssociationEnd() == null || this.getEndAssociationEnd().getMultiplicity() == null || !((PresentationRole)this.getEdge()).isMultiplicityVisible()) {
                this.removeMultiplicity();
            }
            if (this.isXorEdge()) {
                Participant participant = (Participant)this.getModelElement();
                LinkFigure linkFigure = (LinkFigure)this.getClassDiagram().findFigure(participant.getAssociation().getAssociation());
                ClassFigure xorStartNode = (ClassFigure)this.getClassDiagram().findFigure(participant.getAssociation().getParticipant());
                ClassFigure xorEndNode = (ClassFigure)this.getClassDiagram().findFigure(participant.getParticipant());
                int xorStartEdgeX = xorStartNode.center().x;
                int xorStartEdgeY = xorStartNode.center().y;
                int xorEndEdgeX = xorEndNode.center().x;
                int xorEndEdgeY = xorEndNode.center().y;
                WayPoint startWayPoint = null;
                Figure roleDefFig = this.getClassDiagram().findFigure(participant.getAssociation());
                if (roleDefFig == null) {
                    this.getClassDiagram().removeXorNote(participant.getAssociation());
                    return;
                }
                Iterator iterator = ((PresentationRoleFigure)roleDefFig).getEdge().iteratorWayPoint();
                if (iterator.hasNext()) {
                    startWayPoint = (WayPoint)iterator.next();
                    xorStartEdgeX = startWayPoint.getEast();
                    xorStartEdgeY = startWayPoint.getSouth();
                }
                WayPoint endWayPoint = null;
                iterator = this.getEdge().iteratorWayPoint();
                if (iterator.hasNext()) {
                    endWayPoint = (WayPoint)iterator.next();
                    xorEndEdgeX = endWayPoint.getEast();
                    xorEndEdgeY = endWayPoint.getSouth();
                }
                int noteX = (xorStartEdgeX + xorEndEdgeX) / 2;
                int noteY = (xorStartEdgeY + xorEndEdgeY) / 2 - 20;
                Dimension dim = this.getClassDiagram().getXorNote(participant.getAssociation());
                if (dim == null) {
                    this.getClassDiagram().addXorNote(participant.getAssociation(), new Dimension(noteX, noteY));
                } else {
                    noteX = dim.width;
                    noteY = dim.height;
                }
                noteX += 10;
                noteY -= 5;
                if (startWayPoint == null) {
                    NoteAnchorLineConnection.drawNoteLine(g, (linkFigure.center().x + xorStartEdgeX) / 2, (linkFigure.center().y + xorStartEdgeY) / 2, noteX, noteY);
                } else {
                    NoteAnchorLineConnection.drawNoteLine(g, xorStartEdgeX, xorStartEdgeY, noteX, noteY);
                }
                if (endWayPoint == null) {
                    NoteAnchorLineConnection.drawNoteLine(g, (linkFigure.center().x + xorEndEdgeX) / 2, (linkFigure.center().y + xorEndEdgeY) / 2, noteX, noteY);
                } else {
                    NoteAnchorLineConnection.drawNoteLine(g, endWayPoint.getEast(), endWayPoint.getSouth(), noteX, noteY);
                }
                g.drawString("{XOR}", noteX - 10, noteY + 5);
            }
        }
        catch (Throwable e) {
            Tracer.getInstance().debug(e.getLocalizedMessage());
        }
    }

    public void layoutMultiplicity() {
        if (this.multiplicityFigure != null) {
            Figure figure = this.getClassDiagram().findFigure(this.getEndElement());
            Point p = this.calculateMultiplicityPosition(figure.displayBox(), this.endPoint());
            this.multiplicityFigure.updateCoordinates();
            this.multiplicityFigure.displayBox(p, p);
        }
    }

    public void layoutRolename() {
        if (this.roleDefFigure != null) {
            Figure figure = this.getClassDiagram().findFigure(this.getEndElement());
            Point p = this.calculateRolePosition(figure.displayBox(), this.endPoint());
            this.roleDefFigure.updateCoordinates();
            this.roleDefFigure.displayBox(p, p);
        }
    }

    public void figureRemoved(FigureChangeEvent e) {
        this.removeLabels();
        super.figureRemoved(e);
    }

    protected AssociationEnd getEndAssociationEnd() {
        if (this.getModelElement() instanceof AssociationEnd) {
            return (AssociationEnd)this.getModelElement();
        }
        if (this.getModelElement() instanceof Participant) {
            return ((Participant)this.getModelElement()).getAssociation();
        }
        return null;
    }

    @Override
    protected Element getEndElement() {
        if (this.getModelElement() != null) {
            if (this.getModelElement() instanceof AssociationEnd) {
                if (((AssociationEnd)this.getModelElement()).containsParticipant()) {
                    return ((AssociationEnd)this.getModelElement()).getParticipant();
                }
            } else if (this.getModelElement() instanceof Participant) {
                return ((Participant)this.getModelElement()).getParticipant();
            }
        }
        return null;
    }

    @Override
    protected Element getStartElement() {
        Iterator iterator;
        if (this.edge != null && ((PresentationRole)this.edge).containsAssociation() && (iterator = ((PresentationRole)this.edge).getAssociation().iteratorSubject()).hasNext()) {
            return (Association)iterator.next();
        }
        return null;
    }

    private JCheckBoxMenuItem initalizeCheckBox(JCheckBoxMenuItem checkBox, String actionCommand) {
        checkBox.setActionCommand(actionCommand);
        checkBox.addActionListener(this);
        checkBox.setSelected(false);
        return checkBox;
    }

    private boolean isShowAssociationName() {
        return ((PresentationRole)this.getEdge()).getAssociation().isShowName();
    }

    private boolean isXorEdge() {
        return this.getModelElement() instanceof Participant;
    }

    protected void moveRelative(int dx, int dy) {
        if (this.roleDefFigure != null) {
            this.roleDefFigure.basicMoveBy(dx, dy);
        }
        if (this.multiplicityFigure != null) {
            this.multiplicityFigure.basicMoveBy(dx, dy);
        }
    }

    protected void removeLabels() {
        this.removeRole();
        this.removeMultiplicity();
    }

    protected void removeMultiplicity() {
        if (this.multiplicityFigure != null) {
            this.getClassDiagram().remove((Figure)this.multiplicityFigure);
            this.multiplicityFigure = null;
            if (this.getEdge() != null) {
                ((PresentationRole)this.getEdge()).setMultiplicityAngle(0.0);
                ((PresentationRole)this.getEdge()).setMultiplicityRadius(0.0);
            }
        }
    }

    protected void removeRole() {
        if (this.roleDefFigure != null) {
            this.getClassDiagram().remove((Figure)this.roleDefFigure);
            this.roleDefFigure = null;
            if (this.getEdge() != null) {
                ((PresentationRole)this.getEdge()).setNameAngle(0.0);
                ((PresentationRole)this.getEdge()).setNameRadius(0.0);
            }
        }
    }

    @Override
    public void removeInModel() {
        try {
            Association associationDef = (Association)this.getStartElement();
            this.removeVisually(associationDef);
            if (associationDef != null) {
                ElementFactory.removeElement(associationDef);
                this.setModelElement(null);
            }
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, NodeFigure.REMOVE_IN_MODEL, null, this);
        }
    }

    private void removeVisually(Association associationDef) {
        this.removeLabels();
        if (associationDef != null) {
            Iterator iterator = associationDef.iteratorPresentation();
            while (iterator.hasNext()) {
                Object presentation = iterator.next();
                if (!(presentation instanceof PresentationAssocClass) || !((PresentationAssocClass)presentation).containsAssociation() || this.getEdge() == null || !((PresentationAssocClass)presentation).getAssociation().containsRolePresentation((PresentationRole)this.getEdge())) continue;
                ((PresentationAssocClass)presentation).getAssociation().removeRolePresentation((PresentationRole)this.getEdge());
                break;
            }
            this.getClassDiagram().remove((Figure)this);
            this.updateLinkFigure(associationDef);
        }
    }

    @Override
    public void removeVisually() {
        try {
            this.removeVisually((Association)this.getStartElement());
        }
        catch (Throwable e) {
            NodeFigure.handleException(e, CommonUserAccess.getMniEditRemoveText(), null, this);
        }
    }

    @Override
    public void selectInBrowser() {
        LauncherView.getInstance().getPnlNavigation().selectElement(((RoleDef)this.getModelElement()).getAssociation());
    }

    private void setAggregationEnd(int aggregationKind) {
        AssociationEnd associationEnd = this.getEndAssociationEnd();
        if (associationEnd != null && associationEnd.getAggregation() != aggregationKind) {
            associationEnd.setAggregation(aggregationKind);
            this.showDecoration();
        }
    }

    @Override
    protected void setModelElement(ModelElement modelElement) {
        super.setModelElement(modelElement);
        this.updateCheckBoxes();
        this.showDecoration();
    }

    private void updateCheckBoxes() {
        if (this.modelElement != null) {
            AssociationEnd associationEnd = this.getEndAssociationEnd();
            this.chxNavigableEnd.setSelected(associationEnd.isNavigable());
            this.chxAggregableEnd.setSelected(associationEnd.getAggregation() == 2);
            this.chxCompositeEnd.setSelected(associationEnd.getAggregation() == 3);
            this.chxShowAssociationName.setSelected(this.isShowAssociationName());
        }
    }

    private void setNavigable(boolean isNavigable, AssociationEnd associationEnd) {
        if (associationEnd != null && associationEnd.isNavigable() != isNavigable) {
            associationEnd.setNavigable(isNavigable);
            this.showDecoration();
        }
    }

    private void setNavigableEnd(boolean isNavigable) {
        this.setNavigable(isNavigable, this.getEndAssociationEnd());
    }

    @Override
    protected void showDecoration() {
        this.setStartDecoration(null);
        AssociationEnd associationEnd = this.getEndAssociationEnd();
        if (associationEnd == null) {
            this.setEndDecoration(null);
        } else {
            this.setEndDecoration((LineDecoration)AssociationLineDecoration.createDecoration(associationEnd, this.getLineColor()));
        }
        this.updateImmediately();
    }

    @Override
    protected void showIllegalRelationship(String warning) {
    }

    @Override
    public void showSpecification() {
        LauncherView.getInstance().showSpecification(this.getStartElement());
    }

    protected void updateLabels() {
        if (this.roleDefFigure != null) {
            this.roleDefFigure.updateView();
        }
        if (this.multiplicityFigure != null) {
            this.multiplicityFigure.updateView();
        }
    }

    private void updateLinkFigure(Association associationDef) {
        Figure linkFigure = this.getClassDiagram().findFigure(associationDef);
        if (linkFigure != null) {
            ((LinkFigure)linkFigure).updateView();
        }
    }

    @Override
    public void updateView() {
        Association associationDef = (Association)this.getStartElement();
        if (associationDef != null) {
            if (!associationDef.containsNamespace()) {
                this.removeVisually();
            } else {
                this.updateLabels();
                this.showDecoration();
                this.updateLinkFigure(associationDef);
            }
        }
    }
}

