/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.CustomSelectionTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.UndoableTool;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.GeneralizableElement;
import ch.ehi.uml1_4.foundation.core.Generalization;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.format.LayoutDiagram;
import ch.ehi.umleditor.objectcatalog.ObjectCatalog;
import ch.ehi.umleditor.umldrawingtools.ClassDiagramView;
import ch.ehi.umleditor.umldrawingtools.DependencyLineConnection;
import ch.ehi.umleditor.umldrawingtools.EdgeFigure;
import ch.ehi.umleditor.umldrawingtools.GeneralizationLineConnection;
import ch.ehi.umleditor.umldrawingtools.JHotDrawDragTracker;
import ch.ehi.umleditor.umldrawingtools.JHotDrawTextTool;
import ch.ehi.umleditor.umldrawingtools.ModelElementUI;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.NoteAnchorLineConnection;
import ch.ehi.umleditor.umldrawingtools.NoteFigure;
import ch.ehi.umleditor.umldrawingtools.PresentationRoleFigure;
import ch.ehi.umleditor.umlpresentation.Class;
import ch.ehi.umleditor.umlpresentation.Note;
import ch.ehi.umleditor.umlpresentation.Package;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.CommonUserAccess;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class DelegationSelectionTool
extends CustomSelectionTool
implements ActionListener {
    private JHotDrawTextTool textTool = null;
    private static final int NONE = 0;
    private static final int ADD_WAYPOINT = 1;
    private static final int MOVE_ENDPOINT = 2;
    private static final int MOVE_WAYPOINT = 4;
    private int dragCase = 0;
    private int endPointIndex = -1;
    private int wayPointIndex = -1;
    private PresentationNode dragSourceNode = null;
    private int splitX = -1;
    private int splitY = -1;
    private int splitIndex = -1;
    private ConnectionFigure editedConnection = null;
    private static String ROLES_ACTION_COMMAND = "DISPLAY_ROLES";
    private static String CARDINALITY_ACTION_COMMAND = "DISPLAY_CARDINALITY";
    private static String ASSOCIATION_NAME_ACTION_COMMAND = "DISPLAY_ASSOCIATION_NAME";
    private static String ATTRIBUTES_ACTION_COMMAND = "DISPLAY_ATTRIBUTES";
    private static String ATTRIBUTE_TYPES_ACTION_COMMAND = "DISPLAY_ATTRIBUTE_TYPES";
    private static String ATTRIBUTE_CARDINALITY_ACTION_COMMAND = "DISPLAY_ATTRIBUTE_CARDINALITY";
    private static String LINK_FIGURE_ACTION_COMMAND = "DISPLAY_LINK_FIGURE";
    private static String OPERATION_ACTION_COMMAND = "DISPLAY_OPERATIONS";
    private JCheckBoxMenuItem chxShowRole = null;
    private JCheckBoxMenuItem chxShowMultiplicity = null;
    private JCheckBoxMenuItem chxShowAssociationNames = null;
    private JCheckBoxMenuItem chxShowAttributes = null;
    private JCheckBoxMenuItem chxShowAttributeTypes = null;
    private JCheckBoxMenuItem chxShowAttributeCardinality = null;
    private JCheckBoxMenuItem chxShowLinkFigure = null;
    private JCheckBoxMenuItem chxShowOperations = null;
    private JMenu mnuFormat = null;

    public DelegationSelectionTool(DrawingEditor editor) {
        super(editor);
        this.textTool = new JHotDrawTextTool(editor, (Figure)new TextFigure());
        this.chxShowRole = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowRole_text"));
        this.chxShowRole.setActionCommand(ROLES_ACTION_COMMAND);
        this.chxShowRole.addActionListener(this);
        this.chxShowRole.setSelected(((ClassDiagramView)this.view()).isShowAllRoles());
        this.chxShowMultiplicity = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowMultiplicity_text"));
        this.chxShowMultiplicity.setActionCommand(CARDINALITY_ACTION_COMMAND);
        this.chxShowMultiplicity.addActionListener(this);
        this.chxShowMultiplicity.setSelected(((ClassDiagramView)this.view()).isShowMultiplicities());
        this.chxShowAssociationNames = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowAssociationNames_text"));
        this.chxShowAssociationNames.setActionCommand(ASSOCIATION_NAME_ACTION_COMMAND);
        this.chxShowAssociationNames.addActionListener(this);
        this.chxShowAssociationNames.setSelected(((ClassDiagramView)this.view()).isShowAssociationNames());
        this.chxShowAttributes = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowAttributes_text"));
        this.chxShowAttributes.setActionCommand(ATTRIBUTES_ACTION_COMMAND);
        this.chxShowAttributes.addActionListener(this);
        this.chxShowAttributes.setSelected(((ClassDiagramView)this.view()).isShowAttributes());
        this.chxShowAttributeTypes = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowAttributeTypes_text"));
        this.chxShowAttributeTypes.setActionCommand(ATTRIBUTE_TYPES_ACTION_COMMAND);
        this.chxShowAttributeTypes.addActionListener(this);
        this.chxShowAttributeTypes.setSelected(((ClassDiagramView)this.view()).isShowAttributeTypes());
        this.chxShowAttributeCardinality = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowAttributeCardinality_text"));
        this.chxShowAttributeCardinality.setActionCommand(ATTRIBUTE_CARDINALITY_ACTION_COMMAND);
        this.chxShowAttributeCardinality.addActionListener(this);
        this.chxShowAttributeCardinality.setSelected(((ClassDiagramView)this.view()).isShowAttributeMultiplicity());
        this.chxShowLinkFigure = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowLinkFigure_text"));
        this.chxShowLinkFigure.setActionCommand(LINK_FIGURE_ACTION_COMMAND);
        this.chxShowLinkFigure.addActionListener(this);
        this.chxShowLinkFigure.setSelected(((ClassDiagramView)this.view()).isShowLinkFigure());
        this.chxShowOperations = new JCheckBoxMenuItem(NodeFigure.getResourceString(DelegationSelectionTool.class, "ChxShowOperations_text"));
        this.chxShowOperations.setActionCommand(OPERATION_ACTION_COMMAND);
        this.chxShowOperations.addActionListener(this);
        this.chxShowOperations.setSelected(true);
        this.mnuFormat = new JMenu();
        this.mnuFormat.setName("MnuFormat");
        this.mnuFormat.setText("Format");
        this.mnuFormat.setText(CommonUserAccess.getMnuFormatText());
        this.mnuFormat.add(new AbstractAction(CommonUserAccess.getMniWindowOrderAutomaticallyText()){

            @Override
            public void actionPerformed(ActionEvent event) {
                DelegationSelectionTool.this.mniLayoutDiagram();
            }
        });
        this.mnuFormat.add(new AbstractAction(ResourceBundle.getBundle(DelegationSelectionTool.class).getString("MenuLayoutRolesCardinalities")){

            @Override
            public void actionPerformed(ActionEvent event) {
                DelegationSelectionTool.this.mniLayoutRolesAndMultiplicities();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals(ROLES_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllRoles(this.chxShowRole.isSelected());
            } else if (e.getActionCommand().equals(CARDINALITY_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllMultiplicities(this.chxShowMultiplicity.isSelected());
            } else if (e.getActionCommand().equals(ASSOCIATION_NAME_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllAssociationNames(this.chxShowAssociationNames.isSelected());
            } else if (e.getActionCommand().equals(ATTRIBUTES_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllAttributes(this.chxShowAttributes.isSelected());
            } else if (e.getActionCommand().equals(ATTRIBUTE_TYPES_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllAttributeTypes(this.chxShowAttributeTypes.isSelected());
            } else if (e.getActionCommand().equals(ATTRIBUTE_CARDINALITY_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllAttributeMultiplicity(this.chxShowAttributeCardinality.isSelected());
            } else if (e.getActionCommand().equals(OPERATION_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllOperations(this.chxShowOperations.isSelected());
            } else if (e.getActionCommand().equals(LINK_FIGURE_ACTION_COMMAND)) {
                ((ClassDiagramView)this.view()).showAllLinkFigures(this.chxShowLinkFigure.isSelected());
            }
        }
        catch (Throwable exception) {
            Tracer.getInstance().runtimeError(e.toString(), exception);
            LauncherView.getInstance().handleException(exception);
        }
    }

    private int checkDragCase(ConnectionFigure edgeFigure, int x, int y) {
        this.wayPointIndex = ((EdgeFigure)edgeFigure).getWayPointIndex(x, y);
        if (this.wayPointIndex > 0) {
            ((EdgeFigure)edgeFigure).getClassDiagram().removeXorNote(((EdgeFigure)edgeFigure).getModelElement());
            return 4;
        }
        if (edgeFigure instanceof PresentationRoleFigure || edgeFigure instanceof GeneralizationLineConnection || edgeFigure instanceof DependencyLineConnection || edgeFigure instanceof NoteAnchorLineConnection) {
            Iterator iterator = ((EdgeFigure)edgeFigure).getEdge().iteratorEndpoint();
            if (iterator.hasNext()) {
                this.dragSourceNode = (PresentationNode)iterator.next();
                if ((this.dragSourceNode instanceof Class || this.dragSourceNode instanceof Package || this.dragSourceNode instanceof Note) && this.isWithinRange(edgeFigure.startPoint(), x, y)) {
                    this.endPointIndex = 0;
                    return 2;
                }
            } else {
                throw new DeveloperException("start-Node should be set");
            }
            if (iterator.hasNext()) {
                this.dragSourceNode = (PresentationNode)iterator.next();
                if ((this.dragSourceNode instanceof Class || this.dragSourceNode instanceof Package || this.dragSourceNode instanceof Note) && this.isWithinRange(edgeFigure.endPoint(), x, y)) {
                    this.endPointIndex = 1;
                    return 2;
                }
            } else {
                throw new DeveloperException("end-Node should be set");
            }
        }
        this.splitIndex = -1;
        return 1;
    }

    protected Tool createDragTracker(Figure f) {
        if (f instanceof ModelElementUI) {
            LauncherView.getInstance().setDescription(((ModelElementUI)f).getModelElement());
        }
        return new UndoableTool((Tool)new JHotDrawDragTracker(this.editor(), f));
    }

    public void deactivate() {
        super.deactivate();
        if (this.getTextTool().isActivated()) {
            this.getTextTool().deactivate();
        }
    }

    private void dragAssociation(Connector end, Figure targetFigure, int x, int y) {
        ((RoleDef)((EdgeFigure)this.editedConnection).getModelElement()).changeParticipant((Classifier)((NodeFigure)targetFigure).getModelElement());
    }

    private void dragDependency(Connector end, Figure targetFigure, int x, int y) {
        Dependency dependency = (Dependency)((EdgeFigure)this.editedConnection).getModelElement();
        if (this.endPointIndex == 0) {
            dependency.changeClient((ModelElement)dependency.iteratorClient().next(), (GeneralizableElement)((NodeFigure)targetFigure).getModelElement());
        } else {
            dependency.changeSupplier((ModelElement)dependency.iteratorSupplier().next(), ((NodeFigure)targetFigure).getModelElement());
        }
    }

    private void dragGeneralization(Connector end, Figure targetFigure, int x, int y) {
        Generalization generalization = (Generalization)((EdgeFigure)this.editedConnection).getModelElement();
        if (this.endPointIndex == 0) {
            generalization.changeChild((GeneralizableElement)((NodeFigure)targetFigure).getModelElement());
        } else {
            generalization.changeParent((GeneralizableElement)((NodeFigure)targetFigure).getModelElement());
        }
    }

    private void dragNoteAnchor(Connector end, Figure targetFigure, int x, int y) {
        if (this.endPointIndex == 0) {
            if (targetFigure instanceof NoteFigure) {
                ((EdgeFigure)this.editedConnection).getEdge().setEndpoint(this.endPointIndex, ((NodeFigure)targetFigure).getNode());
                ((EdgeFigure)this.editedConnection).willChange();
                ((EdgeFigure)this.editedConnection).setStartConnector(end);
                ((EdgeFigure)this.editedConnection).changed();
            } else {
                BaseDialog.showWarning((Component)((Object)LauncherView.getInstance()), (String)NodeFigure.getResourceString(DelegationSelectionTool.class, "CTModellingError"), (Object)NodeFigure.getResourceString(DelegationSelectionTool.class, "CENoteToNoteError"));
            }
        } else {
            ((EdgeFigure)this.editedConnection).getEdge().setEndpoint(this.endPointIndex, ((NodeFigure)targetFigure).getNode());
            ((EdgeFigure)this.editedConnection).willChange();
            ((EdgeFigure)this.editedConnection).setEndConnector(end);
            ((EdgeFigure)this.editedConnection).changed();
        }
    }

    private JHotDrawTextTool getTextTool() {
        return this.textTool;
    }

    protected void handleMouseClick(MouseEvent e, int x, int y) {
        this.deactivate();
    }

    protected void handleMouseDoubleClick(MouseEvent e, int x, int y) {
        int splitX = e.getX();
        int splitY = e.getY();
        this.editedConnection = ((ClassDiagramView)this.view()).findConnection(splitX, splitY);
        if (this.editedConnection != null) {
            this.wayPointIndex = ((EdgeFigure)this.editedConnection).getWayPointIndex(x, y);
            if (this.wayPointIndex > 0) {
                ((EdgeFigure)this.editedConnection).removePointAt(this.wayPointIndex);
            }
        } else {
            Figure figure = this.drawing().findFigureInside(e.getX(), e.getY());
            if (figure != null && figure instanceof TextFigure) {
                this.getTextTool().activate();
                this.getTextTool().mouseDown(e, x, y);
            }
        }
    }

    protected void handleMouseDown(MouseEvent e, int x, int y) {
        try {
            this.dragCase = 0;
            if (this.view() instanceof ClassDiagramView) {
                Figure figure;
                this.splitX = e.getX();
                this.splitY = e.getY();
                this.editedConnection = ((ClassDiagramView)this.view()).findConnection(this.splitX, this.splitY);
                if (this.editedConnection != null) {
                    this.dragCase = this.checkDragCase(this.editedConnection, this.splitX, this.splitY);
                }
                if ((figure = this.drawing().findFigure(e.getX(), e.getY())) == null && !e.isShiftDown()) {
                    LauncherView.getInstance().setDescription(((ClassDiagramView)this.view()).getDiagram());
                }
            }
        }
        catch (Throwable exception) {
            BaseDialog.showError((Component)((Object)LauncherView.getInstance()), null, (Object)exception.getMessage(), (Throwable)exception);
        }
    }

    protected void handlePopupMenu(MouseEvent e, int x, int y) {
        Figure figure = this.drawing().findFigure(e.getX(), e.getY());
        if (figure != null) {
            super.handlePopupMenu(e, x, y);
        } else {
            JPopupMenu menu = new JPopupMenu();
            menu.add(this.chxShowRole);
            menu.add(this.chxShowMultiplicity);
            menu.add(this.chxShowAssociationNames);
            menu.add(this.chxShowAttributes);
            menu.add(this.chxShowAttributeTypes);
            menu.add(this.chxShowAttributeCardinality);
            menu.add(this.chxShowLinkFigure);
            menu.add(this.chxShowOperations);
            menu.add(new JSeparator());
            menu.add(new AbstractAction(CommonUserAccess.getMniFilePrintWindowText()){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DelegationSelectionTool.this.mniPrintDiagram();
                }
            });
            menu.add(new AbstractAction(NodeFigure.getResourceString(DelegationSelectionTool.class, "MenuSaveDiagram")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    DelegationSelectionTool.this.mniSaveDiagram();
                }
            });
            menu.add(this.mnuFormat);
            double scale = ((ClassDiagramView)this.view()).getScale();
            menu.show(e.getComponent(), (int)((double)e.getX() * scale), (int)((double)e.getY() * scale));
        }
    }

    private boolean isWithinRange(Point p, int x, int y) {
        int sensitiveSquareLength = LauncherView.getSettings().getConnectorZone();
        return Math.abs(p.x - x) < sensitiveSquareLength && Math.abs(p.y - y) < sensitiveSquareLength;
    }

    private void mniFindModel() {
        LauncherView.getInstance().nyi("Modell in NavTree selektieren");
    }

    private void mniLayoutDiagram() {
        LayoutDiagram.layoutCurrentDiagram();
    }

    private void mniLayoutRolesAndMultiplicities() {
        ((ClassDiagramView)this.view()).layoutAllVisibleMultiplicities();
        ((ClassDiagramView)this.view()).layoutAllVisibleRolenames();
    }

    private void mniPrintDiagram() {
        LauncherView.getInstance().printClassDiagram((ClassDiagramView)this.view());
    }

    private void mniSaveDiagram() {
        ObjectCatalog.writeDiagram((ClassDiagramView)this.view());
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        try {
            if (!e.isPopupTrigger()) {
                if (this.editedConnection == null) {
                    super.mouseDrag(e, x, y);
                } else {
                    switch (this.dragCase) {
                        case 4: {
                            this.editedConnection.setPointAt(new Point(x, y), this.wayPointIndex);
                            this.view().checkDamage();
                            break;
                        }
                        case 2: {
                            Figure targetFigure = ((ClassDiagramView)this.view()).findConnectableFigure(x, y, this.editedConnection);
                            if (targetFigure == null) break;
                            Connector newEnd = ((ClassDiagramView)this.view()).findNodeConnector(((NodeFigure)targetFigure).getModelElement(), x, y);
                            if (this.editedConnection instanceof NoteAnchorLineConnection) {
                                this.dragNoteAnchor(newEnd, targetFigure, x, y);
                            }
                            if (((NodeFigure)targetFigure).getNode().getClass().equals(this.dragSourceNode.getClass())) {
                                if (this.editedConnection instanceof PresentationRoleFigure) {
                                    this.dragAssociation(newEnd, targetFigure, x, y);
                                } else if (this.editedConnection instanceof GeneralizationLineConnection) {
                                    this.dragGeneralization(newEnd, targetFigure, x, y);
                                } else if (this.editedConnection instanceof DependencyLineConnection) {
                                    this.dragDependency(newEnd, targetFigure, x, y);
                                }
                            } else {
                                BaseDialog.showWarning((Component)((Object)LauncherView.getInstance()), (String)NodeFigure.getResourceString(DelegationSelectionTool.class, "CTModellingError"), (Object)NodeFigure.getResourceString(DelegationSelectionTool.class, "CEDragNodeIncompatibility"));
                            }
                            this.editedConnection.changed();
                            this.view().checkDamage();
                            break;
                        }
                        case 1: {
                            if (this.splitIndex < 0) {
                                this.splitIndex = this.editedConnection.splitSegment(this.splitX, this.splitY);
                            }
                            this.editedConnection.setPointAt(new Point(x, y), this.splitIndex);
                            this.view().checkDamage();
                        }
                    }
                }
            }
        }
        catch (Throwable exception) {
            BaseDialog.showError((Component)((Object)LauncherView.getInstance()), (String)NodeFigure.getResourceString(DelegationSelectionTool.class, "CTModellingError"), (Object)exception.getMessage(), (Throwable)exception);
        }
    }
}

