/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umldrawingtools;

import CH.ifa.draw.contrib.GraphicalCompositeFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.Figure;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicDef;
import ch.ehi.interlis.graphicdescriptions.GraphicParameterDef;
import ch.ehi.interlis.metaobjects.MetaDataUseDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.units.UnitDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.implementation.AbstractModelElement;
import ch.ehi.uml1_4.implementation.UmlOperation;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umldrawingtools.AttributeFigure;
import ch.ehi.umleditor.umldrawingtools.NodeFigure;
import ch.ehi.umleditor.umldrawingtools.OperationFigure;
import ch.ehi.umleditor.umldrawingtools.PresentationRoleFigure;
import ch.ehi.umleditor.umldrawingtools.SeparatorFigure;
import ch.ehi.umleditor.umlpresentation.PresentationAbstractClass;
import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import ch.softenvironment.util.Tracer;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class ClassFigure
extends NodeFigure
implements ActionListener {
    private static ResourceBundle resources = ResourceBundle.getBundle("ch/ehi/umleditor/umldrawingtools/resources/ClassFigure");
    private GraphicalCompositeFigure nameFigure;
    private TextFigure classNameFigure;
    private SeparatorFigure attributeSeparator;
    private SeparatorFigure operationSeparator;
    private GraphicalCompositeFigure attributesFigure;
    private GraphicalCompositeFigure operationsFigure;
    private static String SUPPRESS_ATTRIBUTES_ACTION_COMMAND = "SUPPRESS_ATTRIBUTES";
    private static String SUPPRESS_OPERATIONS_ACTION_COMMAND = "SUPPRESS_OPERATIONS";
    private static String SHOW_INHERITED_ATTRIBUTES_ACTION_COMMAND = "SHOW_INHERITED_ATTRIBUTES";
    private JCheckBoxMenuItem chxSuppressAttributes = null;
    private JCheckBoxMenuItem chxSuppressOperations = null;
    private JCheckBoxMenuItem chxShowInheritedAttributes = null;

    public ClassFigure() {
        this((Figure)new RectangleFigure());
    }

    private ClassFigure(Figure newPresentationFigure) {
        super(newPresentationFigure);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals(SUPPRESS_ATTRIBUTES_ACTION_COMMAND)) {
                ((PresentationAbstractClass)this.getNode()).setSuppressAttributes(this.chxSuppressAttributes.isSelected());
            } else if (e.getActionCommand().equals(SUPPRESS_OPERATIONS_ACTION_COMMAND)) {
                ((PresentationAbstractClass)this.getNode()).setSuppressOperations(this.chxSuppressOperations.isSelected());
            } else if (e.getActionCommand().equals(SHOW_INHERITED_ATTRIBUTES_ACTION_COMMAND)) {
                ((PresentationAbstractClass)this.getNode()).setShowInheritedAttributes(this.chxShowInheritedAttributes.isSelected());
            }
        }
        catch (Throwable exception) {
            Tracer.getInstance().runtimeError(e.toString(), exception);
            LauncherView.getInstance().handleException(exception);
        }
    }

    private void addAttribute() {
        try {
            ElementFactory.createAttributeDef((AbstractClassDef)this.getModelElement());
        }
        catch (Throwable e) {
            LauncherView.getInstance().handleException(e);
        }
    }

    private void addOperation() {
        try {
            ElementFactory.createUmlOperation((AbstractClassDef)this.getModelElement());
        }
        catch (Throwable e) {
            LauncherView.getInstance().handleException(e);
        }
    }

    @Override
    protected void addSpecialMenu(JPopupMenu popupMenu) {
        if (this.getModelElement() instanceof AbstractClassDef) {
            popupMenu.add(new JSeparator());
            popupMenu.add(new AbstractAction(resources.getString("MniNewAttributeDef_text")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ClassFigure.this.addAttribute();
                }
            });
            popupMenu.add(new AbstractAction(resources.getString("MniNewMethod_text")){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ClassFigure.this.addOperation();
                }
            });
            this.chxSuppressAttributes = new JCheckBoxMenuItem(resources.getString("MniSuppressAttributes_text"));
            this.chxSuppressAttributes.setActionCommand(SUPPRESS_ATTRIBUTES_ACTION_COMMAND);
            this.chxSuppressAttributes.addActionListener(this);
            this.chxShowInheritedAttributes = new JCheckBoxMenuItem(resources.getString("MniShowInheritedAttributes_text"));
            this.chxShowInheritedAttributes.setActionCommand(SHOW_INHERITED_ATTRIBUTES_ACTION_COMMAND);
            this.chxShowInheritedAttributes.addActionListener(this);
            this.chxSuppressOperations = new JCheckBoxMenuItem(resources.getString("MniSuppressOperations_text"));
            this.chxSuppressOperations.setActionCommand(SUPPRESS_OPERATIONS_ACTION_COMMAND);
            this.chxSuppressOperations.addActionListener(this);
            if (this.getNode() == null) {
                this.chxSuppressAttributes.setSelected(false);
                this.chxShowInheritedAttributes.setSelected(false);
                this.chxSuppressOperations.setSelected(false);
            } else {
                this.chxSuppressAttributes.setSelected(((PresentationAbstractClass)this.getNode()).isSuppressAttributes());
                this.chxShowInheritedAttributes.setSelected(((PresentationAbstractClass)this.getNode()).isShowInheritedAttributes());
                this.chxSuppressOperations.setSelected(((PresentationAbstractClass)this.getNode()).isSuppressOperations());
            }
            this.chxShowInheritedAttributes.setEnabled(!this.chxSuppressAttributes.isSelected());
            popupMenu.add(this.chxSuppressAttributes);
            popupMenu.add(this.chxShowInheritedAttributes);
            popupMenu.add(this.chxSuppressOperations);
        }
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        super.basicMoveBy(dx, dy);
        Iterator edges = this.getNode().iteratorPresentationEdge();
        while (edges.hasNext()) {
            PresentationEdge edge = (PresentationEdge)edges.next();
            Figure figure = this.getClassDiagram().findFigure(edge);
            if (figure != null && figure instanceof PresentationRoleFigure && ((PresentationRoleFigure)figure).getEndElement().equals(this.getModelElement())) {
                ((PresentationRoleFigure)figure).moveRelative(dx, dy);
            }
            Iterator assocs = edge.iteratorSubject();
            while (assocs.hasNext()) {
                this.getClassDiagram().removeXorNote(assocs.next());
            }
        }
    }

    private Figure createAttributeFigure(final AttributeDef attributeDef) {
        AttributeFigure attributeFigure = new AttributeFigure(attributeDef, this.getClassDiagram()){

            public void setText(String newName) {
                String name = this.getPureAttributeName(newName);
                ElementUtils.trySetName(attributeDef, name);
                this.updateModel();
            }
        };
        attributeFigure.setText(attributeDef.getDefLangName());
        attributeFigure.setFont(this.getFont());
        return attributeFigure;
    }

    private Figure createOperationFigure(final UmlOperation operation) {
        OperationFigure operationFigure = new OperationFigure(operation, this.getClassDiagram()){

            public void setText(String newName) {
                String name = this.getPureOperationName(newName);
                ElementUtils.trySetName(operation, name);
                this.updateModel();
            }
        };
        operationFigure.setText(operation.getDefLangName());
        operationFigure.setFont(this.getFont());
        return operationFigure;
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("POPUP_MENU")) {
            return this.adaptPopupMenu(new JPopupMenu());
        }
        return super.getAttribute(name);
    }

    @Override
    protected void initialize() {
        this.removeAll();
        this.classNameFigure = new TextFigure(){

            public void setText(String newText) {
                String name = newText;
                if (!ClassFigure.this.updateName(newText)) {
                    name = ClassFigure.this.getModelElement().getDefLangName();
                }
                super.setText(name);
                ClassFigure.this.update();
            }
        };
        this.classNameFigure.setFont(this.getFont());
        this.nameFigure = new GraphicalCompositeFigure((Figure)new SeparatorFigure());
        this.nameFigure.add((Figure)this.classNameFigure);
        this.nameFigure.getLayouter().setInsets(new Insets(0, 4, 0, 0));
        this.add((Figure)this.nameFigure);
        this.attributeSeparator = new SeparatorFigure();
        this.attributesFigure = new GraphicalCompositeFigure((Figure)this.attributeSeparator);
        this.attributesFigure.getLayouter().setInsets(new Insets(4, 4, 4, 0));
        this.add((Figure)this.attributesFigure);
        this.operationSeparator = new SeparatorFigure();
        this.operationsFigure = new GraphicalCompositeFigure((Figure)this.operationSeparator);
        this.operationsFigure.getLayouter().setInsets(new Insets(4, 4, 4, 0));
        this.operationSeparator.setLineVisible(false);
        this.add((Figure)this.operationsFigure);
        super.initialize();
    }

    public boolean isEmpty() {
        return this.figureCount() == 0;
    }

    private void updateAttributeFigure() {
        this.attributesFigure.removeAll();
        if (((PresentationAbstractClass)this.getNode()).isSuppressAttributes()) {
            this.attributeSeparator.setLineVisible(false);
        } else {
            this.attributeSeparator.setLineVisible(true);
            Iterator iterator = null;
            if (((PresentationAbstractClass)this.getNode()).isShowInheritedAttributes()) {
                List inheritedAttributes = ((AbstractClassDef)this.getModelElement()).getConsolidatedAttributes();
                iterator = inheritedAttributes.iterator();
            } else if (this.getModelElement() instanceof Classifier) {
                iterator = ((Classifier)this.getModelElement()).iteratorFeature();
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Object feature = iterator.next();
                    if (!(feature instanceof AttributeDef)) continue;
                    this.attributesFigure.add(this.createAttributeFigure((AttributeDef)feature));
                }
            }
        }
        this.attributesFigure.update();
        this.update();
    }

    private void updateOperationFigure() {
        this.operationsFigure.removeAll();
        this.operationSeparator.setLineVisible(false);
        if (this.getModelElement() instanceof Classifier && !((PresentationAbstractClass)this.getNode()).isSuppressOperations()) {
            Iterator iterator = ((Classifier)this.getModelElement()).iteratorFeature();
            while (iterator.hasNext()) {
                Object feature = iterator.next();
                if (!(feature instanceof UmlOperation)) continue;
                this.operationSeparator.setLineVisible(true);
                this.operationsFigure.add(this.createOperationFigure((UmlOperation)feature));
            }
        }
        this.operationsFigure.update();
        this.update();
    }

    private void updateEnumerationFigure() {
        this.attributesFigure.removeAll();
        Type type = ((DomainDef)this.getModelElement()).getType();
        if (type != null && type instanceof Enumeration) {
            this.attributeSeparator.setLineVisible(true);
            this.createEnumerationFigure((Enumeration)type, "");
        }
        this.attributesFigure.update();
        this.update();
    }

    private void createEnumerationFigure(Enumeration type, String offset) {
        Iterator iterator = type.iteratorEnumElement();
        while (iterator.hasNext()) {
            EnumElement element = (EnumElement)iterator.next();
            TextFigure enumFigure = new TextFigure();
            enumFigure.setFont(this.getFont());
            enumFigure.setText(offset + element.getName().getValue());
            enumFigure.setReadOnly(true);
            this.attributesFigure.add((Figure)enumFigure);
            if (!element.containsChild()) continue;
            this.createEnumerationFigure(element.getChild(), offset + "  ");
        }
    }

    @Override
    public void updateView() {
        ModelElement element = this.getModelElement();
        if (element != null) {
            if (!element.containsNamespace()) {
                this.removeVisually();
            } else {
                super.updateView();
                Font font = this.classNameFigure.getFont();
                font = element instanceof Classifier && ((Classifier)element).isAbstract() ? new Font(font.getName(), 2, font.getSize()) : new Font(font.getName(), 0, font.getSize());
                this.classNameFigure.setFont(font);
                this.classNameFigure.setText(element.getDefLangName());
                if (element instanceof DomainDef && ((DomainDef)element).containsType()) {
                    this.updateEnumerationFigure();
                } else if (element instanceof AbstractModelElement) {
                    this.updateAttributeFigure();
                    this.updateOperationFigure();
                }
            }
        }
    }

    @Override
    public void setNode(PresentationNode node) {
        super.setNode(node);
        this.updateStereotype();
    }

    private void updateStereotype() {
        ModelElement element = this.getModelElement();
        String stereotypName = null;
        if (element instanceof MetaDataUseDef) {
            this.attributeSeparator.setLineVisible(false);
            MetaDataUseDef metadata = (MetaDataUseDef)element;
            stereotypName = metadata.getKind() == 1 ? "ILISIGN" : (metadata.getKind() == 2 ? "ILICRS" : "ILISIGN | ILICRS");
        } else if (element instanceof UnitDef) {
            this.attributeSeparator.setLineVisible(false);
            stereotypName = "ILIUNIT";
        } else if (element instanceof FunctionDef) {
            this.attributeSeparator.setLineVisible(false);
            stereotypName = "ILIFUNCTION";
        } else if (element instanceof LineFormTypeDef) {
            this.attributeSeparator.setLineVisible(false);
            stereotypName = "ILILINEFORM";
        } else if (element instanceof DomainDef) {
            Type type = ((DomainDef)element).getType();
            if (type != null && type instanceof Enumeration) {
                stereotypName = "enumeration";
            } else {
                this.attributeSeparator.setLineVisible(false);
                stereotypName = "ILIDOMAIN";
            }
        } else if (element instanceof GraphicParameterDef) {
            this.attributeSeparator.setLineVisible(false);
            stereotypName = "ILIRUNTIMEPARAM";
        } else if (element instanceof ViewDef) {
            this.attributeSeparator.setLineVisible(false);
            stereotypName = "ILIVIEW";
        } else if (element instanceof GraphicDef) {
            this.attributeSeparator.setLineVisible(false);
            stereotypName = "ILIGRAPHIC";
        }
        if (stereotypName != null) {
            TextFigure stereotypeFigure = new TextFigure();
            stereotypeFigure.setFont(this.getFont());
            stereotypeFigure.setText("<<" + stereotypName + ">>");
            stereotypeFigure.setReadOnly(true);
            this.nameFigure.add((Figure)stereotypeFigure);
        }
    }

    protected static boolean isPseudoClassifier(Object element) {
        return element instanceof RoleDef || element instanceof MetaDataUseDef || element instanceof UnitDef || element instanceof FunctionDef || element instanceof LineFormTypeDef || element instanceof GraphicParameterDef || element instanceof ViewDef || element instanceof GraphicDef || element instanceof TopicDef;
    }
}

