/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.domainsandconstants.basetypes.CoordinateType;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericalType;
import ch.ehi.interlis.domainsandconstants.basetypes.RotationDef;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.IliBaseTypeNumericPanel;
import ch.ehi.umleditor.application.LauncherView;
import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.view.BasePanel;
import ch.softenvironment.view.DataPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class IliBaseTypeCoordPanel
extends BasePanel
implements DataPanel {
    private boolean secondEvent = false;
    private static String TAB_TITLE = IliBaseTypeCoordPanel.getResourceString(IliBaseTypeCoordPanel.class, (String)"CINumeric");
    private JLabel ivjLblPiHalfAxis = null;
    private JLabel ivjLblZeroAxis = null;
    private IliBaseTypeNumericPanel ivjPnlNumeric1D = null;
    private IliBaseTypeNumericPanel ivjPnlNumeric2D = null;
    private IliBaseTypeNumericPanel ivjPnlNumeric3D = null;
    private JRadioButton ivjRbt1D = null;
    private JRadioButton ivjRbt2D = null;
    private JRadioButton ivjRbt3D = null;
    private JTextField ivjTxtPiHalfAxis = null;
    private JTextField ivjTxtZeroAxis = null;
    private JTabbedPane ivjTbpNumericTypes = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JLabel ivjLblDimensions = null;
    private JCheckBox ivjChxRotationDef = null;
    private JLabel ivjLblEpsgCode = null;
    private JTextField ivjTxtEpsgCode = null;
    private boolean isMulti;

    public IliBaseTypeCoordPanel() {
        this.initialize();
    }

    private void addDimensionPanel(IliBaseTypeNumericPanel panel, int dimension) {
        this.getTbpNumericTypes().add((Component)((Object)panel));
        this.getTbpNumericTypes().setTitleAt(dimension - 1, dimension + TAB_TITLE);
    }

    private void chxRotationDef_ItemStateChanged(ItemEvent itemEvent) {
        if (this.getChxRotationDef().isSelected()) {
            this.getTxtPiHalfAxis().setEditable(true);
            this.getTxtZeroAxis().setEditable(true);
        } else {
            this.getTxtPiHalfAxis().setEditable(false);
            this.getTxtPiHalfAxis().setText(null);
            this.getTxtZeroAxis().setEditable(false);
            this.getTxtZeroAxis().setText(null);
        }
    }

    private void connEtoC1(ItemEvent arg1) {
        try {
            this.dimensionChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.dimensionChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ItemEvent arg1) {
        try {
            this.dimensionChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ItemEvent arg1) {
        try {
            this.chxRotationDef_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(FocusEvent arg1) {
        try {
            this.getTxtZeroAxis().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(FocusEvent arg1) {
        try {
            this.getTxtPiHalfAxis().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void dimensionChanged(ItemEvent itemEvent) {
        if (this.secondEvent) {
            this.secondEvent = false;
            this.getTbpNumericTypes().remove((Component)((Object)this.getPnlNumeric2D()));
            this.getTbpNumericTypes().remove((Component)((Object)this.getPnlNumeric3D()));
            if (!this.getRbt1D().isSelected()) {
                if (this.getRbt2D().isSelected()) {
                    this.addDimensionPanel(this.getPnlNumeric2D(), 2);
                } else if (this.getRbt3D().isSelected()) {
                    this.addDimensionPanel(this.getPnlNumeric2D(), 2);
                    this.addDimensionPanel(this.getPnlNumeric3D(), 3);
                }
            }
        } else {
            this.secondEvent = true;
        }
    }

    private JCheckBox getChxRotationDef() {
        if (this.ivjChxRotationDef == null) {
            try {
                this.ivjChxRotationDef = new JCheckBox();
                this.ivjChxRotationDef.setName("ChxRotationDef");
                this.ivjChxRotationDef.setToolTipText("");
                this.ivjChxRotationDef.setText("Rotation");
                this.ivjChxRotationDef.setToolTipText(this.getResourceString("ChxRotationDef_toolTipText"));
                this.ivjChxRotationDef.setText(this.getResourceString("ChxRotationDef_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjChxRotationDef;
    }

    private JLabel getLblDimensions() {
        if (this.ivjLblDimensions == null) {
            try {
                this.ivjLblDimensions = new JLabel();
                this.ivjLblDimensions.setName("LblDimensions");
                this.ivjLblDimensions.setText("Dimensionen:");
                this.ivjLblDimensions.setText(this.getResourceString("LblDimensions_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblDimensions;
    }

    private JLabel getLblEpsg() {
        if (this.ivjLblEpsgCode == null) {
            try {
                this.ivjLblEpsgCode = new JLabel();
                this.ivjLblEpsgCode.setName("LblEpsg");
                this.ivjLblEpsgCode.setText("EPSG Code");
                this.ivjLblEpsgCode.setBounds(416, 6, 136, 20);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblEpsgCode;
    }

    public JTextField getTxtEpsgCode() {
        if (this.ivjTxtEpsgCode == null) {
            try {
                this.ivjTxtEpsgCode = new JTextField();
                this.ivjTxtEpsgCode.setName("TxtEpsgCode");
                this.ivjTxtEpsgCode.setBounds(168, 133, 153, 22);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ivjTxtEpsgCode;
    }

    private JLabel getLblPiHalfAxis() {
        if (this.ivjLblPiHalfAxis == null) {
            try {
                this.ivjLblPiHalfAxis = new JLabel();
                this.ivjLblPiHalfAxis.setName("LblPiHalfAxis");
                this.ivjLblPiHalfAxis.setToolTipText("PI-Halbachse");
                this.ivjLblPiHalfAxis.setText("PiHalfAxis:");
                this.ivjLblPiHalfAxis.setToolTipText(this.getResourceString("LblPiHalfAxis_toolTipText"));
                this.ivjLblPiHalfAxis.setText(this.getResourceString("LblPiHalfAxist_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblPiHalfAxis;
    }

    private JLabel getLblZeroAxis() {
        if (this.ivjLblZeroAxis == null) {
            try {
                this.ivjLblZeroAxis = new JLabel();
                this.ivjLblZeroAxis.setName("LblZeroAxis");
                this.ivjLblZeroAxis.setToolTipText("0-Achse");
                this.ivjLblZeroAxis.setText("NullAxis:");
                this.ivjLblZeroAxis.setToolTipText(this.getResourceString("LblZeroAxis_toolTipText"));
                this.ivjLblZeroAxis.setText(this.getResourceString("LblZeroAxis_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblZeroAxis;
    }

    public Object getObject() {
        CoordinateType type = new CoordinateType();
        if (this.getChxRotationDef().isSelected()) {
            RotationDef rotationDef = new RotationDef();
            rotationDef.setNullAxis(new Long(this.getTxtZeroAxis().getText()));
            rotationDef.setPihalfAxis(new Long(this.getTxtPiHalfAxis().getText()));
            type.attachRotationDef(rotationDef);
        }
        type.addDim((NumericalType)this.getPnlNumeric1D().getObject());
        if (this.getRbt2D().isSelected()) {
            type.addDim((NumericalType)this.getPnlNumeric2D().getObject());
        } else if (this.getRbt3D().isSelected()) {
            type.addDim((NumericalType)this.getPnlNumeric2D().getObject());
            type.addDim((NumericalType)this.getPnlNumeric3D().getObject());
        }
        type.setMulti(this.isMulti);
        return type;
    }

    private IliBaseTypeNumericPanel getPnlNumeric1D() {
        if (this.ivjPnlNumeric1D == null) {
            try {
                this.ivjPnlNumeric1D = new IliBaseTypeNumericPanel();
                this.ivjPnlNumeric1D.setName("PnlNumeric1D");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlNumeric1D;
    }

    private IliBaseTypeNumericPanel getPnlNumeric2D() {
        if (this.ivjPnlNumeric2D == null) {
            try {
                this.ivjPnlNumeric2D = new IliBaseTypeNumericPanel();
                this.ivjPnlNumeric2D.setName("PnlNumeric2D");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlNumeric2D;
    }

    private IliBaseTypeNumericPanel getPnlNumeric3D() {
        if (this.ivjPnlNumeric3D == null) {
            try {
                this.ivjPnlNumeric3D = new IliBaseTypeNumericPanel();
                this.ivjPnlNumeric3D.setName("PnlNumeric3D");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlNumeric3D;
    }

    private JRadioButton getRbt1D() {
        if (this.ivjRbt1D == null) {
            try {
                this.ivjRbt1D = new JRadioButton();
                this.ivjRbt1D.setName("Rbt1D");
                this.ivjRbt1D.setText("1D");
                this.ivjRbt1D.setText(this.getResourceString("Rbt1D_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbt1D;
    }

    private JRadioButton getRbt2D() {
        if (this.ivjRbt2D == null) {
            try {
                this.ivjRbt2D = new JRadioButton();
                this.ivjRbt2D.setName("Rbt2D");
                this.ivjRbt2D.setText("2D");
                this.ivjRbt2D.setText(this.getResourceString("Rbt2D_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbt2D;
    }

    private JRadioButton getRbt3D() {
        if (this.ivjRbt3D == null) {
            try {
                this.ivjRbt3D = new JRadioButton();
                this.ivjRbt3D.setName("Rbt3D");
                this.ivjRbt3D.setText("3D");
                this.ivjRbt3D.setText(this.getResourceString("Rbt3D_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjRbt3D;
    }

    private JTabbedPane getTbpNumericTypes() {
        if (this.ivjTbpNumericTypes == null) {
            try {
                this.ivjTbpNumericTypes = new JTabbedPane();
                this.ivjTbpNumericTypes.setName("TbpNumericTypes");
                this.ivjTbpNumericTypes.setAlignmentY(0.0f);
                this.ivjTbpNumericTypes.insertTab(this.getResourceString("Tbp1D_title"), null, (Component)((Object)this.getPnlNumeric1D()), null, 0);
                this.ivjTbpNumericTypes.insertTab(this.getResourceString("Tbp2D_title"), null, (Component)((Object)this.getPnlNumeric2D()), null, 1);
                this.ivjTbpNumericTypes.insertTab(this.getResourceString("Tbp3D_title"), null, (Component)((Object)this.getPnlNumeric3D()), null, 2);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbpNumericTypes;
    }

    private JTextField getTxtPiHalfAxis() {
        if (this.ivjTxtPiHalfAxis == null) {
            try {
                this.ivjTxtPiHalfAxis = new JTextField();
                this.ivjTxtPiHalfAxis.setName("TxtPiHalfAxis");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtPiHalfAxis;
    }

    private JTextField getTxtZeroAxis() {
        if (this.ivjTxtZeroAxis == null) {
            try {
                this.ivjTxtZeroAxis = new JTextField();
                this.ivjTxtZeroAxis.setName("TxtZeroAxis");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtZeroAxis;
    }

    protected void handleException(Throwable exception) {
        LauncherView.getInstance().handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getRbt1D().addItemListener(this.ivjEventHandler);
        this.getRbt2D().addItemListener(this.ivjEventHandler);
        this.getRbt3D().addItemListener(this.ivjEventHandler);
        this.getTxtZeroAxis().addFocusListener(this.ivjEventHandler);
        this.getTxtPiHalfAxis().addFocusListener(this.ivjEventHandler);
        this.getChxRotationDef().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("IliBaseTypeTextPanel");
            this.setToolTipText("INTERLIS Basistyp <COORD>");
            this.setLayout(new GridBagLayout());
            this.setSize(526, 390);
            GridBagConstraints constraintsRbt1D = new GridBagConstraints();
            constraintsRbt1D.gridx = 2;
            constraintsRbt1D.gridy = 1;
            constraintsRbt1D.ipadx = 1;
            constraintsRbt1D.ipady = -2;
            constraintsRbt1D.insets = new Insets(14, 7, 5, 5);
            this.add(this.getRbt1D(), constraintsRbt1D);
            GridBagConstraints constraintsRbt3D = new GridBagConstraints();
            constraintsRbt3D.gridx = 4;
            constraintsRbt3D.gridy = 1;
            constraintsRbt3D.ipadx = 1;
            constraintsRbt3D.ipady = -2;
            constraintsRbt3D.insets = new Insets(14, 4, 5, 10);
            this.add(this.getRbt3D(), constraintsRbt3D);
            GridBagConstraints constraintsRbt2D = new GridBagConstraints();
            constraintsRbt2D.gridx = 3;
            constraintsRbt2D.gridy = 1;
            constraintsRbt2D.ipadx = 1;
            constraintsRbt2D.ipady = -2;
            constraintsRbt2D.insets = new Insets(14, 5, 5, 4);
            this.add(this.getRbt2D(), constraintsRbt2D);
            GridBagConstraints constraintsTbpNumericTypes = new GridBagConstraints();
            constraintsTbpNumericTypes.gridx = 1;
            constraintsTbpNumericTypes.gridy = 2;
            constraintsTbpNumericTypes.gridwidth = 5;
            constraintsTbpNumericTypes.fill = 1;
            constraintsTbpNumericTypes.weightx = 1.0;
            constraintsTbpNumericTypes.weighty = 1.0;
            constraintsTbpNumericTypes.ipadx = 16;
            constraintsTbpNumericTypes.ipady = 2;
            constraintsTbpNumericTypes.insets = new Insets(25, 3, 4, 14);
            this.add(this.getTbpNumericTypes(), constraintsTbpNumericTypes);
            GridBagConstraints constraintsLblDimensions = new GridBagConstraints();
            constraintsLblDimensions.gridx = 1;
            constraintsLblDimensions.gridy = 1;
            constraintsLblDimensions.ipadx = 63;
            constraintsTbpNumericTypes.ipady = 2;
            constraintsLblDimensions.insets = new Insets(18, 11, 7, 3);
            this.add(this.getLblDimensions(), constraintsLblDimensions);
            GridBagConstraints constraintsLblEpsgCode = new GridBagConstraints();
            constraintsLblEpsgCode.gridx = 1;
            constraintsLblEpsgCode.gridy = 2;
            constraintsLblEpsgCode.anchor = 18;
            constraintsLblEpsgCode.ipadx = 10;
            constraintsLblEpsgCode.insets = new Insets(5, 11, 6, 15);
            this.add(this.getLblEpsg(), constraintsLblEpsgCode);
            GridBagConstraints constraintsTxtEpsgCode = new GridBagConstraints();
            constraintsTxtEpsgCode.gridx = 2;
            constraintsTxtEpsgCode.gridy = 2;
            constraintsTxtEpsgCode.anchor = 18;
            constraintsTxtEpsgCode.fill = 2;
            constraintsTxtEpsgCode.gridwidth = 2;
            constraintsTxtEpsgCode.ipadx = 80;
            constraintsTxtEpsgCode.ipady = -2;
            constraintsTxtEpsgCode.insets = new Insets(5, 11, 6, 15);
            this.add(this.getTxtEpsgCode(), constraintsTxtEpsgCode);
            GridBagConstraints constraintsTxtZeroAxis = new GridBagConstraints();
            constraintsTxtZeroAxis.gridx = 5;
            constraintsTxtZeroAxis.gridy = 3;
            constraintsTxtZeroAxis.fill = 2;
            constraintsTxtZeroAxis.weightx = 1.0;
            constraintsTxtZeroAxis.ipadx = 104;
            constraintsTxtZeroAxis.insets = new Insets(4, 11, 8, 95);
            this.add(this.getTxtZeroAxis(), constraintsTxtZeroAxis);
            GridBagConstraints constraintsChxRotationDef = new GridBagConstraints();
            constraintsChxRotationDef.gridx = 1;
            constraintsChxRotationDef.gridy = 3;
            constraintsChxRotationDef.ipadx = 49;
            constraintsChxRotationDef.ipady = -8;
            constraintsChxRotationDef.insets = new Insets(6, 8, 5, 6);
            this.add(this.getChxRotationDef(), constraintsChxRotationDef);
            GridBagConstraints constraintsLblZeroAxis = new GridBagConstraints();
            constraintsLblZeroAxis.gridx = 2;
            constraintsLblZeroAxis.gridy = 3;
            constraintsLblZeroAxis.gridwidth = 3;
            constraintsLblZeroAxis.ipadx = 91;
            constraintsLblZeroAxis.insets = new Insets(4, 4, 7, 14);
            this.add(this.getLblZeroAxis(), constraintsLblZeroAxis);
            GridBagConstraints constraintsLblPiHalfAxis = new GridBagConstraints();
            constraintsLblPiHalfAxis.gridx = 2;
            constraintsLblPiHalfAxis.gridy = 4;
            constraintsLblPiHalfAxis.gridwidth = 3;
            constraintsLblPiHalfAxis.ipadx = 79;
            constraintsLblPiHalfAxis.insets = new Insets(2, 4, 13, 14);
            this.add(this.getLblPiHalfAxis(), constraintsLblPiHalfAxis);
            GridBagConstraints constraintsTxtPiHalfAxis = new GridBagConstraints();
            constraintsTxtPiHalfAxis.gridx = 5;
            constraintsTxtPiHalfAxis.gridy = 4;
            constraintsTxtPiHalfAxis.fill = 2;
            constraintsTxtPiHalfAxis.weightx = 1.0;
            constraintsTxtPiHalfAxis.ipadx = 104;
            constraintsTxtPiHalfAxis.insets = new Insets(3, 11, 6, 95);
            this.add(this.getTxtPiHalfAxis(), constraintsTxtPiHalfAxis);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setToolTipText(this.getResourceString("PnlBaseType_toolTipText"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRbt1D());
        group.add(this.getRbt2D());
        group.add(this.getRbt3D());
        this.getTxtPiHalfAxis().setText("0");
        this.getTxtZeroAxis().setText("0");
        this.getTbpNumericTypes().setTitleAt(0, "1" + TAB_TITLE);
        this.getRbt1D().setSelected(true);
        this.dimensionChanged(null);
        this.getChxRotationDef().setSelected(false);
        this.getTxtEpsgCode().setText("");
    }

    public final void setObject(Object object) throws DeveloperException {
        throw new DeveloperException("call setObject(Object, ModelElement) instead");
    }

    public void setObject(Object object, ModelElement modelElement, ModelElement baseElement) {
        this.getPnlNumeric1D().setObject(ElementFactory.createNumericType(), modelElement);
        this.getPnlNumeric2D().setObject(ElementFactory.createNumericType(), modelElement);
        this.getPnlNumeric3D().setObject(ElementFactory.createNumericType(), modelElement);
        this.getTxtEpsgCode().setText(ElementUtils.getIliTaggedValue(baseElement, "CRS"));
        if (object != null) {
            CoordinateType type = (CoordinateType)object;
            if (type.containsRotationDef()) {
                this.getChxRotationDef().setSelected(true);
                this.getTxtZeroAxis().setText(new Long(type.getRotationDef().getNullAxis()).toString());
                this.getTxtPiHalfAxis().setText(new Long(type.getRotationDef().getPihalfAxis()).toString());
            } else {
                this.getChxRotationDef().setSelected(false);
            }
            Iterator iterator = type.iteratorDim();
            if (!iterator.hasNext()) {
                throw new DeveloperException("unexpected Dimension");
            }
            this.getPnlNumeric1D().setObject(iterator.next(), modelElement);
            this.getRbt1D().setSelected(true);
            if (iterator.hasNext()) {
                this.getPnlNumeric2D().setObject(iterator.next(), modelElement);
                this.getRbt2D().setSelected(true);
                if (iterator.hasNext()) {
                    this.getPnlNumeric3D().setObject(iterator.next(), modelElement);
                    this.getRbt3D().setSelected(true);
                } else {
                    this.getTbpNumericTypes().remove((Component)((Object)this.getPnlNumeric3D()));
                }
            } else {
                this.getTbpNumericTypes().remove((Component)((Object)this.getPnlNumeric2D()));
                this.getTbpNumericTypes().remove((Component)((Object)this.getPnlNumeric3D()));
            }
            this.isMulti = type.isMulti();
        }
    }

    public void setMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    class IvjEventHandler
    implements FocusListener,
    ItemListener {
        IvjEventHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == IliBaseTypeCoordPanel.this.getTxtZeroAxis()) {
                IliBaseTypeCoordPanel.this.connEtoM1(e);
            }
            if (e.getSource() == IliBaseTypeCoordPanel.this.getTxtPiHalfAxis()) {
                IliBaseTypeCoordPanel.this.connEtoM2(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == IliBaseTypeCoordPanel.this.getRbt1D()) {
                IliBaseTypeCoordPanel.this.connEtoC1(e);
            }
            if (e.getSource() == IliBaseTypeCoordPanel.this.getRbt2D()) {
                IliBaseTypeCoordPanel.this.connEtoC2(e);
            }
            if (e.getSource() == IliBaseTypeCoordPanel.this.getRbt3D()) {
                IliBaseTypeCoordPanel.this.connEtoC3(e);
            }
            if (e.getSource() == IliBaseTypeCoordPanel.this.getChxRotationDef()) {
                IliBaseTypeCoordPanel.this.connEtoC4(e);
            }
        }
    }
}

