/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.uml1_4.changepropagation.MetaModelListener;
import ch.ehi.umleditor.application.ElementUtils;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class EnumTreeModel
implements TreeModel,
MetaModelListener {
    private Vector<TreeModelListener> treeModelListeners = new Vector();
    private Enumeration root = new Enumeration();

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.addElement(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.removeElement(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        EnumElement node = (EnumElement)path.getLastPathComponent();
        ElementUtils.trySetName(node, (String)newValue);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.root.getEnumElementAt(index);
        }
        return ((EnumElement)parent).getChild().getEnumElementAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.root.sizeEnumElement();
        }
        if (((EnumElement)parent).containsChild()) {
            return ((EnumElement)parent).getChild().sizeEnumElement();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            return this.root.findEnumElement((EnumElement)child);
        }
        return ((EnumElement)parent).getChild().findEnumElement((EnumElement)child);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return false;
    }

    private void fireTreeNodesChanged(EnumElement node) {
        TreePath path = this.getTreePathOrNull(node);
        if (path == null) {
            return;
        }
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        for (int i = 0; i < len; ++i) {
            this.treeModelListeners.elementAt(i).treeNodesChanged(e);
        }
    }

    private void fireTreeStructureChanged(Enumeration node) {
        TreePath path = this.getTreePathOrNull(node);
        if (path == null) {
            return;
        }
        int len = this.treeModelListeners.size();
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        for (int i = 0; i < len; ++i) {
            this.treeModelListeners.elementAt(i).treeStructureChanged(e);
        }
    }

    @Override
    public void metaModelChanged(MetaModelChange event) {
        Object source = event.getSource();
        String ops = event.getOperation();
        if (source instanceof EnumElement) {
            if (MetaModelChange.isAttribute(ops, "Name")) {
                this.fireTreeNodesChanged((EnumElement)source);
            } else if (MetaModelChange.isAttribute(ops, "Enumeration")) {
                this.fireTreeNodesChanged((EnumElement)source);
            }
        }
        if (source instanceof Enumeration && MetaModelChange.isAttribute(ops, "EnumElement")) {
            this.fireTreeStructureChanged((Enumeration)source);
        }
    }

    protected TreePath getTreePath(Object node) {
        ArrayList<Object> path = new ArrayList<Object>();
        if (node != this.root && node instanceof Enumeration) {
            node = ((Enumeration)node).getParent();
        }
        path.add(node);
        if (node != this.root) {
            Enumeration next = ((EnumElement)node).getEnumeration();
            while (next != this.root) {
                path.add(0, next.getParent());
                next = next.getParent().getEnumeration();
            }
            path.add(0, next);
        }
        return new TreePath(path.toArray());
    }

    private TreePath getTreePathOrNull(Object node) {
        ArrayList<Object> path = new ArrayList<Object>();
        if (node != this.root && node instanceof Enumeration) {
            if (!((Enumeration)node).containsParent()) {
                return null;
            }
            node = ((Enumeration)node).getParent();
        }
        path.add(node);
        if (node != this.root) {
            if (!((EnumElement)node).containsEnumeration()) {
                return null;
            }
            Enumeration next = ((EnumElement)node).getEnumeration();
            while (next != this.root) {
                if (!next.containsParent()) {
                    return null;
                }
                path.add(0, next.getParent());
                if (!next.getParent().containsEnumeration()) {
                    return null;
                }
                next = next.getParent().getEnumeration();
            }
            path.add(0, next);
        }
        return new TreePath(path.toArray());
    }

    public void setRoot(Enumeration root1) {
        this.root = root1;
        this.fireTreeStructureChanged(this.root);
    }
}

