/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.interlis.iliexport;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.interlis.iliexport.TransferFromUmlMetamodel;
import ch.interlis.ili2c.config.Configuration;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ExportInterlis {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(ExportInterlis.class);

    public static void writeFileset() {
        TransferFromUmlMetamodel writer = new TransferFromUmlMetamodel();
        try {
            List fileList = writer.getFileList(LauncherView.getInstance().getModel());
            if (ExportInterlis.checkFiles(fileList, writer.getFuncDesc())) {
                writer.writeIliFiles(LauncherView.getInstance().getModel());
            }
        }
        catch (IOException ex) {
            LauncherView.getInstance().log(writer.getFuncDesc(), ex.getLocalizedMessage());
        }
    }

    public static void writeIli(INTERLIS2Def ili) {
        TransferFromUmlMetamodel writer = new TransferFromUmlMetamodel();
        try {
            writer.getFileList(ili.getNamespace());
            writer.writeIliFile(ili);
        }
        catch (IOException ex) {
            LauncherView.getInstance().log("Export interlis file", ex.getLocalizedMessage());
        }
    }

    public static void writeXSD() {
        FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
        saveDialog.setDialogTitle("XML-Schema exportieren...");
        saveDialog.setFileFilter((FileFilter)GenericFileFilter.createXmlSchemaFilter());
        if (saveDialog.showSaveDialog((Component)LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
            String xsdFileName = saveDialog.getSelectedFile().getAbsolutePath();
            TransferFromUmlMetamodel writer = new TransferFromUmlMetamodel();
            try {
                Settings settings = LauncherView.getIli2cSettings();
                Configuration ili2cConfig = new Configuration();
                ili2cConfig.setAutoCompleteModelList(true);
                ili2cConfig.setOutputKind(4);
                ili2cConfig.setOutputFile(xsdFileName);
                writer.runCompiler(LauncherView.getInstance().getModel(), ili2cConfig, settings);
            }
            catch (IOException ex) {
                LauncherView.getInstance().log(writer.getFuncDesc(), ex.getLocalizedMessage());
            }
        }
    }

    public static void writeXmi() {
        FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
        saveDialog.setDialogTitle("XMI export ...");
        saveDialog.setFileFilter((FileFilter)ExportInterlis.createXmiFilter());
        if (saveDialog.showSaveDialog((Component)LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
            String xmiFileName = saveDialog.getSelectedFile().getAbsolutePath();
            TransferFromUmlMetamodel writer = new TransferFromUmlMetamodel();
            try {
                Settings settings = LauncherView.getIli2cSettings();
                Configuration ili2cConfig = new Configuration();
                ili2cConfig.setAutoCompleteModelList(true);
                ili2cConfig.setOutputKind(10);
                ili2cConfig.setOutputFile(xmiFileName);
                writer.runCompiler(LauncherView.getInstance().getModel(), ili2cConfig, settings);
            }
            catch (IOException ex) {
                LauncherView.getInstance().log(writer.getFuncDesc(), ex.getLocalizedMessage());
            }
        }
    }

    public static void writeGML() {
        FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
        if (saveDialog.showOutputDirDialog((Component)LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
            String xsdFileName = saveDialog.getSelectedFile().getAbsolutePath();
            TransferFromUmlMetamodel writer = new TransferFromUmlMetamodel();
            try {
                Settings settings = LauncherView.getIli2cSettings();
                Configuration ili2cConfig = new Configuration();
                ili2cConfig.setAutoCompleteModelList(true);
                ili2cConfig.setOutputKind(6);
                ili2cConfig.setOutputFile(xsdFileName);
                writer.runCompiler(LauncherView.getInstance().getModel(), ili2cConfig, settings);
            }
            catch (IOException ex) {
                LauncherView.getInstance().log(writer.getFuncDesc(), ex.getLocalizedMessage());
            }
        }
    }

    public static void writeIli1Fmt() {
        FileChooser saveDialog = new FileChooser(LauncherView.getSettings().getWorkingDirectory());
        saveDialog.setDialogTitle("INTERLIS 1-Format exportieren...");
        saveDialog.setFileFilter((FileFilter)new GenericFileFilter("ILI1 Format (*.fmt)", "fmt"));
        if (saveDialog.showSaveDialog((Component)LauncherView.getInstance()) == 0) {
            LauncherView.getSettings().setWorkingDirectory(saveDialog.getCurrentDirectory().getAbsolutePath());
            String fmtFileName = saveDialog.getSelectedFile().getAbsolutePath();
            TransferFromUmlMetamodel writer = new TransferFromUmlMetamodel();
            try {
                Settings settings = LauncherView.getIli2cSettings();
                Configuration ili2cConfig = new Configuration();
                ili2cConfig.setAutoCompleteModelList(true);
                ili2cConfig.setOutputKind(5);
                ili2cConfig.setOutputFile(fmtFileName);
                writer.runCompiler(LauncherView.getInstance().getModel(), ili2cConfig, settings);
            }
            catch (IOException ex) {
                LauncherView.getInstance().log(writer.getFuncDesc(), ex.getLocalizedMessage());
            }
        }
    }

    private static boolean checkFiles(List filev, String funcdesc) {
        ArrayList<Object> apprv = new ArrayList<Object>();
        for (File selectedFile : filev) {
            if (!selectedFile.exists()) continue;
            apprv.add(selectedFile);
        }
        if (apprv.size() == 0) {
            return true;
        }
        apprv.add(0, rsrc.getString("CTfileexists"));
        int response = JOptionPane.showConfirmDialog(LauncherView.getInstance(), apprv.toArray(), funcdesc, 1, 3);
        if (response == -1 || response == 2) {
            return false;
        }
        return response == 0;
    }

    public static GenericFileFilter createXmiFilter() {
        return new GenericFileFilter("XMI format (*.xmi)", "xmi");
    }
}

