/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.UnknownType;
import ch.ehi.interlis.domainsandconstants.basetypes.BooleanType;
import ch.ehi.interlis.domainsandconstants.basetypes.ClassType;
import ch.ehi.interlis.domainsandconstants.basetypes.CoordinateType;
import ch.ehi.interlis.domainsandconstants.basetypes.DateTimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.DateType;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.domainsandconstants.basetypes.HorizAlignment;
import ch.ehi.interlis.domainsandconstants.basetypes.InterlisDateTimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.InterlisDateType;
import ch.ehi.interlis.domainsandconstants.basetypes.InterlisTimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericalType;
import ch.ehi.interlis.domainsandconstants.basetypes.OidType;
import ch.ehi.interlis.domainsandconstants.basetypes.RefAttrType;
import ch.ehi.interlis.domainsandconstants.basetypes.StructAttrType;
import ch.ehi.interlis.domainsandconstants.basetypes.Text;
import ch.ehi.interlis.domainsandconstants.basetypes.TimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.VertAlignment;
import ch.ehi.interlis.domainsandconstants.linetypes.IliPolyline;
import ch.ehi.interlis.domainsandconstants.linetypes.IndividualSurface;
import ch.ehi.interlis.domainsandconstants.linetypes.LineType;
import ch.ehi.interlis.domainsandconstants.linetypes.Tesselation;
import ch.softenvironment.util.Tracer;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class IliBaseTypeKind {
    private static ResourceBundle resIliBaseTypeKind = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/IliBaseTypeKind");
    protected static final String NULL_TYPE = resIliBaseTypeKind.getString("CINullType");
    protected static final String BOOLEAN = resIliBaseTypeKind.getString("CIBoolean");
    protected static final String ALIGNMENT = resIliBaseTypeKind.getString("CIAlignment");
    protected static final String TEXT = resIliBaseTypeKind.getString("CIText");
    protected static final String ENUM = resIliBaseTypeKind.getString("CIEnum");
    protected static final String NUMERIC = resIliBaseTypeKind.getString("CINumeric");
    protected static final String COORD = resIliBaseTypeKind.getString("CICoord");
    protected static final String MULTI_COORD = resIliBaseTypeKind.getString("CIMultiCoord");
    protected static final String BASKET = resIliBaseTypeKind.getString("CiBasket");
    protected static final String POLYLINE = resIliBaseTypeKind.getString("CIPolyline");
    protected static final String SURFACE = resIliBaseTypeKind.getString("CISurface");
    protected static final String AREA = resIliBaseTypeKind.getString("CIArea");
    protected static final String MULTI_POLYLINE = resIliBaseTypeKind.getString("CIMultiPolyline");
    protected static final String MULTI_SURFACE = resIliBaseTypeKind.getString("CIMultiSurface");
    protected static final String MULTI_AREA = resIliBaseTypeKind.getString("CIMultiArea");
    protected static final String OID_TYPE = resIliBaseTypeKind.getString("CIOidType");
    protected static final String CLASS_TYPE = resIliBaseTypeKind.getString("CIClassType");
    protected static final String DOMAINDEF = resIliBaseTypeKind.getString("CIDomainDef");
    protected static final String UNKNOWN = resIliBaseTypeKind.getString("CIUnknown");
    protected static final String DATE = resIliBaseTypeKind.getString("CIDate");
    protected static final String DATETIME = resIliBaseTypeKind.getString("CIDateTime");
    protected static final String TIME = resIliBaseTypeKind.getString("CITime");
    protected static final String ILI_DATE = resIliBaseTypeKind.getString("CIIliDate");
    protected static final String ILI_DATETIME = resIliBaseTypeKind.getString("CIIliDateTime");
    protected static final String ILI_TIME = resIliBaseTypeKind.getString("CIIliTime");
    protected static final String REFERENCE = resIliBaseTypeKind.getString("CIReference");
    protected static final String STRUCTURE = resIliBaseTypeKind.getString("CIStructure");

    public static Vector getAttributeDefTypes() {
        Vector attributeDefTypes = IliBaseTypeKind.getStandardTypes();
        attributeDefTypes.add(DOMAINDEF);
        attributeDefTypes.add(REFERENCE);
        attributeDefTypes.add(STRUCTURE);
        return attributeDefTypes;
    }

    public static Vector getDomainDefTypes() {
        return IliBaseTypeKind.getStandardTypes();
    }

    public static String getNullType() {
        return NULL_TYPE;
    }

    private static Vector getStandardTypes() {
        Vector<String> standardTypes = new Vector<String>(14);
        standardTypes.add(NULL_TYPE);
        standardTypes.add(BOOLEAN);
        standardTypes.add(ALIGNMENT);
        standardTypes.add(TEXT);
        standardTypes.add(ENUM);
        standardTypes.add(NUMERIC);
        standardTypes.add(DATE);
        standardTypes.add(DATETIME);
        standardTypes.add(TIME);
        standardTypes.add(ILI_DATE);
        standardTypes.add(ILI_DATETIME);
        standardTypes.add(ILI_TIME);
        standardTypes.add(COORD);
        standardTypes.add(MULTI_COORD);
        standardTypes.add(POLYLINE);
        standardTypes.add(MULTI_POLYLINE);
        standardTypes.add(SURFACE);
        standardTypes.add(MULTI_SURFACE);
        standardTypes.add(AREA);
        standardTypes.add(MULTI_AREA);
        standardTypes.add(OID_TYPE);
        standardTypes.add(CLASS_TYPE);
        standardTypes.add(UNKNOWN);
        return standardTypes;
    }

    public static String getTypeName(Object object, boolean tagDomainDef) {
        if (object != null && object instanceof AttributeDef && ((AttributeDef)object).containsAttrType() && ((AttributeDef)object).getAttrType() instanceof DomainAttribute) {
            DomainAttribute domainAttribute = (DomainAttribute)((AttributeDef)object).getAttrType();
            if (domainAttribute.containsDirect()) {
                Type type = domainAttribute.getDirect();
                if (type instanceof BooleanType) {
                    return BOOLEAN;
                }
                if (type instanceof VertAlignment || type instanceof HorizAlignment) {
                    return ALIGNMENT;
                }
                if (type instanceof Text) {
                    return TEXT;
                }
                if (type instanceof Enumeration) {
                    return ENUM;
                }
                if (type instanceof NumericalType) {
                    return NUMERIC;
                }
                if (type instanceof DateType) {
                    return DATE;
                }
                if (type instanceof DateTimeType) {
                    return DATETIME;
                }
                if (type instanceof TimeType) {
                    return TIME;
                }
                if (type instanceof InterlisDateType) {
                    return ILI_DATE;
                }
                if (type instanceof InterlisDateTimeType) {
                    return ILI_DATETIME;
                }
                if (type instanceof InterlisTimeType) {
                    return ILI_TIME;
                }
                if (type instanceof CoordinateType) {
                    return ((CoordinateType)type).isMulti() ? MULTI_COORD : COORD;
                }
                if (type instanceof ClassType) {
                    return CLASS_TYPE;
                }
                if (type instanceof StructAttrType) {
                    StructAttrType structAttrType = (StructAttrType)type;
                    if (structAttrType.containsParticipant()) {
                        return structAttrType.getParticipant().getDefLangName();
                    }
                    return "ANYSTRUCTURE";
                }
                if (type instanceof RefAttrType) {
                    RefAttrType refAttrType = (RefAttrType)type;
                    if (refAttrType.containsParticipant()) {
                        return refAttrType.getParticipant().getDefLangName();
                    }
                    return "ANYCLASS";
                }
                if (type instanceof OidType) {
                    return OID_TYPE;
                }
                if (type instanceof UnknownType) {
                    return UNKNOWN;
                }
                if (type instanceof LineType) {
                    LineType line = (LineType)type;
                    if (type instanceof IliPolyline) {
                        return line.isMulti() ? MULTI_POLYLINE : POLYLINE;
                    }
                    if (type instanceof IndividualSurface) {
                        return line.isMulti() ? MULTI_SURFACE : SURFACE;
                    }
                    if (type instanceof Tesselation) {
                        return line.isMulti() ? MULTI_AREA : AREA;
                    }
                    return resIliBaseTypeKind.getString("CEUndefinedLinetype");
                }
            } else {
                if (domainAttribute.containsDomainDef()) {
                    return domainAttribute.getDomainDef().getDefLangName() + (tagDomainDef ? resIliBaseTypeKind.getString("CIDomainDefSuffix") : "");
                }
                Tracer.getInstance().runtimeWarning("DomainAttribute contains neiter directType nor DomainDef");
            }
        }
        return resIliBaseTypeKind.getString("CINoType");
    }
}

