/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.types.NlsString;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.Generalization;
import ch.ehi.umleditor.application.DescriptionPanel;
import ch.ehi.umleditor.application.ElementUtils;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class GeneralizationDialog
extends BaseDialog {
    private static ResourceBundle resGeneralizationDialog = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/GeneralizationDialog");
    Generalization generalization = null;
    private JPanel ivjBaseDialogContentPane = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjBtnCancel = null;
    private JButton ivjBtnOk = null;
    private JTabbedPane ivjTbpGeneral = null;
    private JLabel ivjLblName = null;
    private JTextField ivjTxtName = null;
    private JButton ivjBtnApply = null;
    private DescriptionPanel ivjPnlDescription = null;
    private JTextField ivjTxtDiskriminator = null;
    private JLabel ivjLblDiskriminator = null;

    public GeneralizationDialog(Frame owner, Element element) {
        super(owner, true);
        this.initialize();
        this.addEscapeKey();
        this.setRelativeLocation(owner);
        this.setElement(element);
        this.show();
    }

    private void addEscapeKey() {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -2972481431614869047L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GeneralizationDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.okPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.applyPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(FocusEvent arg1) {
        try {
            this.getTxtName().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(FocusEvent arg1) {
        try {
            this.getTxtDiskriminator().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblName = new GridBagConstraints();
                constraintsLblName.gridx = 1;
                constraintsLblName.gridy = 1;
                constraintsLblName.ipadx = 49;
                constraintsLblName.insets = new Insets(22, 19, 8, 2);
                this.getBaseDialogContentPane().add((Component)this.getLblName(), constraintsLblName);
                GridBagConstraints constraintsTxtName = new GridBagConstraints();
                constraintsTxtName.gridx = 2;
                constraintsTxtName.gridy = 1;
                constraintsTxtName.gridwidth = 3;
                constraintsTxtName.fill = 2;
                constraintsTxtName.weightx = 1.0;
                constraintsTxtName.ipadx = 299;
                constraintsTxtName.insets = new Insets(19, 2, 5, 7);
                this.getBaseDialogContentPane().add((Component)this.getTxtName(), constraintsTxtName);
                GridBagConstraints constraintsTbpGeneral = new GridBagConstraints();
                constraintsTbpGeneral.gridx = 1;
                constraintsTbpGeneral.gridy = 3;
                constraintsTbpGeneral.gridwidth = 4;
                constraintsTbpGeneral.fill = 1;
                constraintsTbpGeneral.weightx = 1.0;
                constraintsTbpGeneral.weighty = 1.0;
                constraintsTbpGeneral.ipadx = 370;
                constraintsTbpGeneral.ipady = 112;
                constraintsTbpGeneral.insets = new Insets(6, 9, 4, 8);
                this.getBaseDialogContentPane().add((Component)this.getTbpGeneral(), constraintsTbpGeneral);
                GridBagConstraints constraintsBtnOk = new GridBagConstraints();
                constraintsBtnOk.gridx = 1;
                constraintsBtnOk.gridy = 4;
                constraintsBtnOk.gridwidth = 2;
                constraintsBtnOk.ipadx = 64;
                constraintsBtnOk.insets = new Insets(4, 31, 10, 3);
                this.getBaseDialogContentPane().add((Component)this.getBtnOk(), constraintsBtnOk);
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 3;
                constraintsBtnCancel.gridy = 4;
                constraintsBtnCancel.ipadx = 18;
                constraintsBtnCancel.insets = new Insets(4, 3, 10, 3);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsBtnApply = new GridBagConstraints();
                constraintsBtnApply.gridx = 4;
                constraintsBtnApply.gridy = 4;
                constraintsBtnApply.ipadx = 8;
                constraintsBtnApply.insets = new Insets(4, 3, 10, 30);
                this.getBaseDialogContentPane().add((Component)this.getBtnApply(), constraintsBtnApply);
                GridBagConstraints constraintsLblDiskriminator = new GridBagConstraints();
                constraintsLblDiskriminator.gridx = 1;
                constraintsLblDiskriminator.gridy = 2;
                constraintsLblDiskriminator.ipadx = 5;
                constraintsLblDiskriminator.insets = new Insets(9, 19, 9, 2);
                this.getBaseDialogContentPane().add((Component)this.getLblDiskriminator(), constraintsLblDiskriminator);
                GridBagConstraints constraintsTxtDiskriminator = new GridBagConstraints();
                constraintsTxtDiskriminator.gridx = 2;
                constraintsTxtDiskriminator.gridy = 2;
                constraintsTxtDiskriminator.gridwidth = 3;
                constraintsTxtDiskriminator.fill = 2;
                constraintsTxtDiskriminator.weightx = 1.0;
                constraintsTxtDiskriminator.ipadx = 299;
                constraintsTxtDiskriminator.insets = new Insets(6, 3, 6, 6);
                this.getBaseDialogContentPane().add((Component)this.getTxtDiskriminator(), constraintsTxtDiskriminator);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnApply() {
        if (this.ivjBtnApply == null) {
            try {
                this.ivjBtnApply = new JButton();
                this.ivjBtnApply.setName("BtnApply");
                this.ivjBtnApply.setText(GeneralizationDialog.getApplyString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnApply;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText(GeneralizationDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnOk() {
        if (this.ivjBtnOk == null) {
            try {
                this.ivjBtnOk = new JButton();
                this.ivjBtnOk.setName("BtnOk");
                this.ivjBtnOk.setText(GeneralizationDialog.getOKString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnOk;
    }

    private JLabel getLblDiskriminator() {
        if (this.ivjLblDiskriminator == null) {
            try {
                this.ivjLblDiskriminator = new JLabel();
                this.ivjLblDiskriminator.setName("LblDiskriminator");
                this.ivjLblDiskriminator.setText(resGeneralizationDialog.getString("LblDiscriminator_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblDiskriminator;
    }

    private JLabel getLblName() {
        if (this.ivjLblName == null) {
            try {
                this.ivjLblName = new JLabel();
                this.ivjLblName.setName("LblName");
                this.ivjLblName.setText(resGeneralizationDialog.getString("LblName_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblName;
    }

    private DescriptionPanel getPnlDescription() {
        if (this.ivjPnlDescription == null) {
            try {
                this.ivjPnlDescription = new DescriptionPanel();
                this.ivjPnlDescription.setName("PnlDescription");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlDescription;
    }

    private JTabbedPane getTbpGeneral() {
        if (this.ivjTbpGeneral == null) {
            try {
                this.ivjTbpGeneral = new JTabbedPane();
                this.ivjTbpGeneral.setName("TbpGeneral");
                this.ivjTbpGeneral.insertTab(this.getDescriptionString(), null, this.getPnlDescription(), null, 0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbpGeneral;
    }

    private JTextField getTxtDiskriminator() {
        if (this.ivjTxtDiskriminator == null) {
            try {
                this.ivjTxtDiskriminator = new JTextField();
                this.ivjTxtDiskriminator.setName("TxtDiskriminator");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtDiskriminator;
    }

    private JTextField getTxtName() {
        if (this.ivjTxtName == null) {
            try {
                this.ivjTxtName = new JTextField();
                this.ivjTxtName.setName("TxtName");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtName;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getBtnOk().addActionListener(this.ivjEventHandler);
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getBtnApply().addActionListener(this.ivjEventHandler);
        this.getTxtName().addFocusListener(this.ivjEventHandler);
        this.getTxtDiskriminator().addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("DlgGeneralization");
            this.setDefaultCloseOperation(2);
            this.setSize(418, 289);
            this.setTitle(resGeneralizationDialog.getString("CTDialog"));
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    protected boolean save() {
        if (!ElementUtils.trySetName(this.generalization, this.getTxtName().getText())) {
            return false;
        }
        this.getPnlDescription().getObject();
        this.generalization.setDiscriminator(new NlsString(this.generalization.getDiscriminator(), this.getTxtDiskriminator().getText()));
        return super.save();
    }

    private void setElement(Element element) {
        this.generalization = (Generalization)element;
        this.getTxtName().setText(this.generalization.getDefLangName());
        this.getPnlDescription().setObject(element);
        this.getTxtDiskriminator().setText(ElementUtils.mapNlsString(this.generalization.getDiscriminator()));
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == GeneralizationDialog.this.getBtnOk()) {
                GeneralizationDialog.this.connEtoC1(e);
            }
            if (e.getSource() == GeneralizationDialog.this.getBtnCancel()) {
                GeneralizationDialog.this.connEtoC2(e);
            }
            if (e.getSource() == GeneralizationDialog.this.getBtnApply()) {
                GeneralizationDialog.this.connEtoC3(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == GeneralizationDialog.this.getTxtName()) {
                GeneralizationDialog.this.connEtoM1(e);
            }
            if (e.getSource() == GeneralizationDialog.this.getTxtDiskriminator()) {
                GeneralizationDialog.this.connEtoM2(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

