/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassExtends;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.uml1_4.foundation.core.GeneralizableElement;
import ch.ehi.uml1_4.foundation.core.Generalization;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.application.ReferencableComboBox;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ExtendedPanel
extends JPanel {
    private static ResourceBundle resExtendedPanel = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/ExtendedPanel");
    private Generalization currentGeneralization = null;
    private GeneralizableElement generalizableElement = null;
    private ReferencableComboBox ivjCbxExtends = null;
    private JCheckBox ivjChxExtended = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JLabel ivjLblExtends = null;

    public ExtendedPanel() {
        this.initialize();
    }

    public ExtendedPanel(LayoutManager layout) {
        super(layout);
    }

    public ExtendedPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ExtendedPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    private void cbxExtends_ItemStateChanged(ItemEvent itemEvent) {
        if (this.getCbxExtends().getSelectedIndex() <= 0) {
            this.getChxExtended().setEnabled(false);
            this.getChxExtended().setSelected(false);
        } else {
            this.getChxExtended().setEnabled(true);
        }
    }

    private boolean checkNameExtension(String name) {
        if (this.getChxExtended().isSelected()) {
            String errorMessage = null;
            TopicDef topicDef = null;
            if (!((AbstractClassDef)this.generalizableElement).containsParentTopicDef()) {
                errorMessage = resExtendedPanel.getString("CEClassWithinTopicDef");
            } else {
                topicDef = ((AbstractClassDef)this.generalizableElement).getParentTopicDef();
            }
            AbstractClassDef baseClass = null;
            if (errorMessage == null && !name.equals((baseClass = (AbstractClassDef)this.getCbxExtends().getElement()).getDefLangName())) {
                errorMessage = resExtendedPanel.getString("CENameNotEqual");
            }
            TopicDef topicDefBase = null;
            if (errorMessage == null) {
                if (!baseClass.containsParentTopicDef()) {
                    errorMessage = resExtendedPanel.getString("CEBaseClassOutsideTopicDef");
                } else {
                    topicDefBase = baseClass.getParentTopicDef();
                }
            }
            if (errorMessage == null) {
                TopicDef current = topicDef;
                do {
                    if (current.containsBaseTopicDef()) continue;
                    errorMessage = resExtendedPanel.getString("CETopicDefNoExtension");
                    break;
                } while ((current = current.getBaseTopicDef()) != topicDefBase);
            }
            if (errorMessage != null) {
                BaseDialog.showError(this, resExtendedPanel.getString("CTInvalidExtension"), errorMessage + "\n" + resExtendedPanel.getString("CWResetExtension"), null);
                this.getChxExtended().setSelected(false);
                return false;
            }
        }
        return true;
    }

    private void connEtoC2(ItemEvent arg1) {
        try {
            this.cbxExtends_ItemStateChanged(arg1);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private ReferencableComboBox getCbxExtends() {
        if (this.ivjCbxExtends == null) {
            try {
                this.ivjCbxExtends = new ReferencableComboBox();
                this.ivjCbxExtends.setName("CbxExtends");
                this.ivjCbxExtends.setEditable(false);
                this.ivjCbxExtends.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCbxExtends;
    }

    private JCheckBox getChxExtended() {
        if (this.ivjChxExtended == null) {
            try {
                this.ivjChxExtended = new JCheckBox();
                this.ivjChxExtended.setName("ChxExtended");
                this.ivjChxExtended.setText(resExtendedPanel.getString("ChxExtended_text"));
                this.ivjChxExtended.setEnabled(true);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjChxExtended;
    }

    public boolean getClassifierExtension(String name) {
        return this.checkNameExtension(name) && this.getExtension();
    }

    public boolean getExtension() {
        if (this.getCbxExtends().hasElementChanged()) {
            GeneralizableElement parent;
            if (this.currentGeneralization != null) {
                this.generalizableElement.removeGeneralization(this.currentGeneralization);
                this.currentGeneralization = null;
            }
            if ((parent = (GeneralizableElement)this.getCbxExtends().getElement()) != null) {
                String error = ElementUtils.checkInheritance(parent, this.generalizableElement);
                if (error != null) {
                    BaseDialog.showWarning(this, resExtendedPanel.getString("CTNoGeneralization"), error);
                    return false;
                }
                try {
                    this.currentGeneralization = ElementFactory.createGeneralization(parent, this.generalizableElement);
                }
                catch (Throwable e) {
                    this.handleException(e);
                    return false;
                }
            }
        }
        if (this.currentGeneralization != null && this.currentGeneralization instanceof ClassExtends) {
            ((ClassExtends)this.currentGeneralization).setExtended(this.getChxExtended().isSelected());
        }
        return true;
    }

    private JLabel getLblExtends() {
        if (this.ivjLblExtends == null) {
            try {
                this.ivjLblExtends = new JLabel();
                this.ivjLblExtends.setName("LblExtends");
                this.ivjLblExtends.setToolTipText(resExtendedPanel.getString("LblExtends_toolTipText"));
                this.ivjLblExtends.setText("EXTENDS:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblExtends;
    }

    private void handleException(Throwable exception) {
        LauncherView.getInstance().handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getCbxExtends().addItemListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ExtendedPanel");
            this.setLayout(new GridBagLayout());
            this.setAlignmentY(0.0f);
            GridBagConstraints constraintsChxExtended = new GridBagConstraints();
            constraintsChxExtended.gridx = 1;
            constraintsChxExtended.gridy = 1;
            constraintsChxExtended.anchor = 18;
            constraintsChxExtended.insets = new Insets(0, 0, 2, 5);
            this.add((Component)this.getChxExtended(), constraintsChxExtended);
            GridBagConstraints constraintsLblExtends = new GridBagConstraints();
            constraintsLblExtends.gridx = 2;
            constraintsLblExtends.gridy = 1;
            constraintsLblExtends.anchor = 18;
            constraintsLblExtends.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.getLblExtends(), constraintsLblExtends);
            GridBagConstraints constraintsCbxExtends = new GridBagConstraints();
            constraintsCbxExtends.gridx = 3;
            constraintsCbxExtends.gridy = 1;
            constraintsCbxExtends.fill = 2;
            constraintsCbxExtends.anchor = 18;
            constraintsCbxExtends.weightx = 1.0;
            constraintsCbxExtends.insets = new Insets(1, 5, 3, 6);
            this.add((Component)this.getCbxExtends(), constraintsCbxExtends);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.getChxExtended().setEnabled(false);
    }

    public void setClassifierExtension(GeneralizableElement generalizableElement) {
        this.setExtendables(generalizableElement);
        boolean extended = false;
        if (this.currentGeneralization != null && ((AbstractClassDef)generalizableElement).containsParentTopicDef()) {
            TopicDef topicDefThis = ((AbstractClassDef)generalizableElement).getParentTopicDef();
            if (this.currentGeneralization instanceof ClassExtends && topicDefThis.containsBaseTopicDef()) {
                extended = ((ClassExtends)this.currentGeneralization).isExtended();
            }
        }
        this.getChxExtended().setSelected(extended);
    }

    private void setExtendables(GeneralizableElement generalizableElement) {
        this.generalizableElement = generalizableElement;
        if (generalizableElement instanceof TopicDef) {
            this.getLblExtends().setText(resExtendedPanel.getString("LblExtends1_text"));
        } else {
            this.getLblExtends().setText(resExtendedPanel.getString("LblExtends2_text"));
        }
        GeneralizableElement parent = null;
        Iterator iterator = generalizableElement.iteratorGeneralization();
        if (iterator.hasNext()) {
            this.currentGeneralization = (Generalization)iterator.next();
            parent = this.currentGeneralization.getParent();
            if (iterator.hasNext()) {
                Tracer.getInstance().developerWarning("INTERLIS implements 1 Generalization only");
            }
        }
        this.getCbxExtends().setElement(generalizableElement.getClass(), (ModelElement)generalizableElement, parent);
    }

    public void setExtension(DomainDef generalizableElement) {
        this.setExtendables(generalizableElement);
        this.getChxExtended().setVisible(false);
    }

    public void setExtension(TopicDef generalizableElement) {
        this.setExtendables(generalizableElement);
        this.getChxExtended().setVisible(false);
        this.getLblExtends().setVisible(false);
    }

    class IvjEventHandler
    implements ItemListener {
        IvjEventHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == ExtendedPanel.this.getCbxExtends()) {
                ExtendedPanel.this.connEtoC2(e);
            }
        }
    }
}

