/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.constraints.ConstraintDef;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.UnknownType;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicDef;
import ch.ehi.interlis.graphicdescriptions.GraphicParameterDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.ContextDef;
import ch.ehi.interlis.modeltopicclass.Contract;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.interlis.views.ViewProjectionDef;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.GeneralizableElement;
import ch.ehi.uml1_4.foundation.core.Generalization;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.extensionmechanisms.TaggedValue;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.uml1_4.implementation.UmlTaggedValue;
import ch.ehi.uml1_4.tools.GeneralizableElementUtility;
import ch.ehi.uml1_4.tools.ModelElementUtility;
import ch.ehi.umleditor.application.CommonSpecificationDialog;
import ch.ehi.umleditor.application.DependencyDialog;
import ch.ehi.umleditor.application.ElementFactory;
import ch.ehi.umleditor.application.GeneralizationDialog;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.interlis.iliexport.TransferFromUmlMetamodel;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import ch.softenvironment.view.BaseDialog;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.ResourceBundle;

public abstract class ElementUtils {
    private static ResourceBundle resElementMapper = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/ElementUtils");

    public static String checkInheritance(GeneralizableElement parent, GeneralizableElement child) {
        if (child == parent) {
            return resElementMapper.getString("CESelfInheritance");
        }
        if (GeneralizableElementUtility.deepContainsGeneralizationParent(parent, child)) {
            return resElementMapper.getString("CECyclicInheritance");
        }
        if (child.iteratorGeneralization().hasNext()) {
            return resElementMapper.getString("CEMultipleInheritance");
        }
        return null;
    }

    public static String formatWithPackageName(ModelElement modelElement) {
        return modelElement.getDefLangName() + " (" + ModelElementUtility.getUmlPath(modelElement, null) + ")";
    }

    public static String getDisplayName(Element element) {
        return ElementUtils.getDisplayName(element.getClass());
    }

    public static String getDisplayName(Class type) {
        if (type.equals(DomainDef.class)) {
            return resElementMapper.getString("CTDomainDef");
        }
        if (type.equals(ModelDef.class)) {
            return resElementMapper.getString("CTModelDef");
        }
        if (type.equals(ClassDef.class)) {
            return resElementMapper.getString("CTClassDef");
        }
        if (type.equals(AbstractClassDef.class)) {
            return resElementMapper.getString("CTAbstractClassDef");
        }
        if (type.equals(TopicDef.class)) {
            return resElementMapper.getString("CTTopicDef");
        }
        if (type.equals(FunctionDef.class)) {
            return resElementMapper.getString("CTFunctionDef");
        }
        if (type.equals(GraphicDef.class)) {
            return resElementMapper.getString("CTGraphicDef");
        }
        if (type.equals(GraphicParameterDef.class)) {
            return resElementMapper.getString("CTGraphicParameterDef");
        }
        if (type.equals(LineFormTypeDef.class)) {
            return resElementMapper.getString("CTLineFormTypeDef");
        }
        if (type.equals(UmlPackage.class)) {
            return resElementMapper.getString("CTUmlPackage");
        }
        if (type.equals(ViewDef.class)) {
            return resElementMapper.getString("CTViewDef");
        }
        if (type.equals(ViewProjectionDef.class)) {
            return resElementMapper.getString("CTViewProjectionDef");
        }
        if (type.equals(Contract.class)) {
            return resElementMapper.getString("CTContract");
        }
        if (type.equals(ConstraintDef.class)) {
            return resElementMapper.getString("CTConstraintDef");
        }
        if (type.equals(ContextDef.class)) {
            return resElementMapper.getString("CTContextDef");
        }
        Tracer.getInstance().developerError("No NLS-Property for type <" + type.getName() + ">");
        return StringUtils.getPureClassName(type);
    }

    public static Class getElementDialog(Element element) {
        if (element == null) {
            return null;
        }
        Class dialogClass = null;
        try {
            if (element instanceof Generalization) {
                return GeneralizationDialog.class;
            }
            if (element instanceof Dependency) {
                return DependencyDialog.class;
            }
            String elementClass = StringUtils.getPureClassName(element);
            dialogClass = Class.forName(StringUtils.getPackageName(ElementUtils.class) + "." + elementClass + "Dialog");
        }
        catch (ClassNotFoundException e) {
            dialogClass = CommonSpecificationDialog.class;
        }
        return dialogClass;
    }

    public static NlsString changeNlsString(NlsString oldString, String newValueInDefaultLanguage) {
        if (oldString == null) {
            return new NlsString(newValueInDefaultLanguage);
        }
        return new NlsString(oldString, newValueInDefaultLanguage);
    }

    public static NlsString changeNlsString(NlsString oldString, String newValue, String language) {
        if (oldString == null) {
            return new NlsString(language, newValue);
        }
        return new NlsString(oldString, language, newValue);
    }

    public static String mapNlsString(NlsString string) {
        if (string == null) {
            return null;
        }
        return string.getValue();
    }

    public static String mapNlsString(NlsString nlsString, String language) {
        if (nlsString == null) {
            return null;
        }
        return nlsString.getValue(language);
    }

    public static boolean trySetName(ModelElement modelElement, String newName) {
        return ElementUtils.trySetName(modelElement, newName, NlsString.getDefaultLanguage());
    }

    public static boolean trySetName(ModelElement modelElement, String newName, String language) {
        if (modelElement != null && !newName.equals(ElementUtils.mapNlsString(modelElement.getName(), language))) {
            String warningTitle = resElementMapper.getString("CTNameConflict");
            if (modelElement.containsNamespace()) {
                if (modelElement.getNamespace().containsOwnedElement(newName)) {
                    BaseDialog.showWarning(LauncherView.getInstance(), warningTitle, resElementMapper.getString("CEDuplicatedName"));
                    return false;
                }
            } else if (modelElement instanceof AttributeDef) {
                if (((AttributeDef)modelElement).getOwner().containsFeature(newName)) {
                    BaseDialog.showWarning(LauncherView.getInstance(), warningTitle, resElementMapper.getString("CEDuplicatedAttribute"));
                    return false;
                }
            } else {
                if (modelElement instanceof Participant) {
                    ((Participant)modelElement).getAssociation().setName(new NlsString(modelElement.getName(), language, newName));
                    return true;
                }
                Tracer.getInstance().developerWarning("<" + modelElement.toString() + " cannot be not checked yet because of missing namespace");
            }
            newName = newName.trim();
            if (!(modelElement instanceof AssociationDef) && newName.length() == 0) {
                BaseDialog.showWarning(LauncherView.getInstance(), warningTitle, "name should not be empty");
                return false;
            }
            modelElement.setName(new NlsString(modelElement.getName(), language, newName));
        }
        return true;
    }

    public static UnknownType convertType(Type type) {
        StringWriter iliout = new StringWriter();
        TransferFromUmlMetamodel toili = new TransferFromUmlMetamodel();
        toili.setup(iliout, NlsString.getDefaultLanguage());
        try {
            toili.visitType(null, type);
        }
        catch (IOException ex) {
            EhiLogger.logError((String)"failed to convert type", (Throwable)ex);
        }
        String ret = iliout.toString();
        UnknownType convertedType = new UnknownType();
        convertedType.setSyntax(new NlsString(ret));
        return convertedType;
    }

    public static String getIliTaggedValue(ModelElement def, String tagName) {
        TaggedValue umlTag = null;
        Iterator defLangIt = def.iteratorTaggedValue();
        while (defLangIt.hasNext()) {
            umlTag = (TaggedValue)defLangIt.next();
            String name = umlTag.getName().getValue("");
            if (!name.equals("ili:" + tagName)) continue;
            String value = umlTag.getDataValue();
            return value;
        }
        return null;
    }

    public static void setIliTaggedValue(ModelElement def, String iliTagName, String tagValue) {
        tagValue = StringUtility.purge((String)tagValue);
        TaggedValue umlTag = null;
        Iterator defLangIt = def.iteratorTaggedValue();
        String umlTagName = "ili:" + iliTagName;
        while (defLangIt.hasNext()) {
            umlTag = (TaggedValue)defLangIt.next();
            String name = umlTag.getName().getValue("");
            if (!name.equals(umlTagName)) continue;
            if (tagValue == null) {
                def.removeTaggedValue(umlTag);
            } else {
                umlTag.setDataValue(tagValue);
            }
            return;
        }
        if (tagValue != null) {
            umlTag = (TaggedValue)ElementFactory.createObject(UmlTaggedValue.class);
            umlTag.setName(new NlsString("", umlTagName));
            umlTag.setDataValue(tagValue);
            def.addTaggedValue(umlTag);
        }
    }
}

