/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.modeltopicclass.Contract;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.umleditor.application.DescriptionPanel;
import ch.ehi.umleditor.application.ElementUtils;
import ch.softenvironment.view.BaseDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ContractDialog
extends BaseDialog {
    private static ResourceBundle resContractDialog = ResourceBundle.getBundle("ch/ehi/umleditor/application/resources/ContractDialog");
    Contract contract = null;
    private JPanel ivjBaseDialogContentPane = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JButton ivjBtnCancel = null;
    private JButton ivjBtnOk = null;
    private JTabbedPane ivjTbpGeneral = null;
    private JButton ivjBtnApply = null;
    private DescriptionPanel ivjPnlDescription = null;
    private JLabel ivjLblIssuer = null;
    private JTextField ivjTxtIssuer = null;

    public ContractDialog(Frame owner, Element element) {
        super(owner, true);
        this.initialize();
        this.addEscapeKey();
        this.setTitle(ElementUtils.getDisplayName(element) + " " + resContractDialog.getString("CTDialog"));
        this.setRelativeLocation(owner);
        this.setElement(element);
        this.show();
    }

    private void addEscapeKey() {
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = -2972481431614869047L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ContractDialog.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.okPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.cancelPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.applyPressed();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(FocusEvent arg1) {
        try {
            this.getTxtIssuer().selectAll();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JPanel getBaseDialogContentPane() {
        if (this.ivjBaseDialogContentPane == null) {
            try {
                this.ivjBaseDialogContentPane = new JPanel();
                this.ivjBaseDialogContentPane.setName("BaseDialogContentPane");
                this.ivjBaseDialogContentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblIssuer = new GridBagConstraints();
                constraintsLblIssuer.gridx = 1;
                constraintsLblIssuer.gridy = 1;
                constraintsLblIssuer.gridwidth = 2;
                constraintsLblIssuer.ipadx = 131;
                constraintsLblIssuer.insets = new Insets(22, 15, 4, 4);
                this.getBaseDialogContentPane().add((Component)this.getLblIssuer(), constraintsLblIssuer);
                GridBagConstraints constraintsTxtIssuer = new GridBagConstraints();
                constraintsTxtIssuer.gridx = 3;
                constraintsTxtIssuer.gridy = 1;
                constraintsTxtIssuer.gridwidth = 2;
                constraintsTxtIssuer.fill = 2;
                constraintsTxtIssuer.weightx = 1.0;
                constraintsTxtIssuer.ipadx = 214;
                constraintsTxtIssuer.insets = new Insets(19, 4, 1, 15);
                this.getBaseDialogContentPane().add((Component)this.getTxtIssuer(), constraintsTxtIssuer);
                GridBagConstraints constraintsBtnOk = new GridBagConstraints();
                constraintsBtnOk.gridx = 1;
                constraintsBtnOk.gridy = 3;
                constraintsBtnOk.ipadx = 64;
                constraintsBtnOk.insets = new Insets(4, 32, 5, 3);
                this.getBaseDialogContentPane().add((Component)this.getBtnOk(), constraintsBtnOk);
                GridBagConstraints constraintsBtnCancel = new GridBagConstraints();
                constraintsBtnCancel.gridx = 2;
                constraintsBtnCancel.gridy = 3;
                constraintsBtnCancel.gridwidth = 2;
                constraintsBtnCancel.ipadx = 18;
                constraintsBtnCancel.insets = new Insets(4, 3, 5, 5);
                this.getBaseDialogContentPane().add((Component)this.getBtnCancel(), constraintsBtnCancel);
                GridBagConstraints constraintsBtnApply = new GridBagConstraints();
                constraintsBtnApply.gridx = 4;
                constraintsBtnApply.gridy = 3;
                constraintsBtnApply.ipadx = 16;
                constraintsBtnApply.insets = new Insets(4, 5, 5, 25);
                this.getBaseDialogContentPane().add((Component)this.getBtnApply(), constraintsBtnApply);
                GridBagConstraints constraintsTbpGeneral = new GridBagConstraints();
                constraintsTbpGeneral.gridx = 1;
                constraintsTbpGeneral.gridy = 2;
                constraintsTbpGeneral.gridwidth = 4;
                constraintsTbpGeneral.fill = 1;
                constraintsTbpGeneral.weightx = 1.0;
                constraintsTbpGeneral.weighty = 1.0;
                constraintsTbpGeneral.ipadx = 376;
                constraintsTbpGeneral.ipady = 99;
                constraintsTbpGeneral.insets = new Insets(2, 10, 3, 9);
                this.getBaseDialogContentPane().add((Component)this.getTbpGeneral(), constraintsTbpGeneral);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBaseDialogContentPane;
    }

    private JButton getBtnApply() {
        if (this.ivjBtnApply == null) {
            try {
                this.ivjBtnApply = new JButton();
                this.ivjBtnApply.setName("BtnApply");
                this.ivjBtnApply.setText(ContractDialog.getApplyString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnApply;
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText(ContractDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnOk() {
        if (this.ivjBtnOk == null) {
            try {
                this.ivjBtnOk = new JButton();
                this.ivjBtnOk.setName("BtnOk");
                this.ivjBtnOk.setText(ContractDialog.getOKString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnOk;
    }

    private JLabel getLblIssuer() {
        if (this.ivjLblIssuer == null) {
            try {
                this.ivjLblIssuer = new JLabel();
                this.ivjLblIssuer.setName("LblIssuer");
                this.ivjLblIssuer.setToolTipText(resContractDialog.getString("LblIssuer_toolTipText"));
                this.ivjLblIssuer.setText(resContractDialog.getString("LblIssuer_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblIssuer;
    }

    private DescriptionPanel getPnlDescription() {
        if (this.ivjPnlDescription == null) {
            try {
                this.ivjPnlDescription = new DescriptionPanel();
                this.ivjPnlDescription.setName("PnlDescription");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlDescription;
    }

    private JTabbedPane getTbpGeneral() {
        if (this.ivjTbpGeneral == null) {
            try {
                this.ivjTbpGeneral = new JTabbedPane();
                this.ivjTbpGeneral.setName("TbpGeneral");
                this.ivjTbpGeneral.setToolTipText(resContractDialog.getString("TbpGeneral_toolTipText"));
                this.ivjTbpGeneral.insertTab(this.getDescriptionString(), null, this.getPnlDescription(), null, 0);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTbpGeneral;
    }

    private JTextField getTxtIssuer() {
        if (this.ivjTxtIssuer == null) {
            try {
                this.ivjTxtIssuer = new JTextField();
                this.ivjTxtIssuer.setName("TxtIssuer");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtIssuer;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.handleException(exception);
    }

    private void initConnections() throws Exception {
        this.getBtnOk().addActionListener(this.ivjEventHandler);
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getBtnApply().addActionListener(this.ivjEventHandler);
        this.getTxtIssuer().addFocusListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ContractSpecificationDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(426, 230);
            this.setTitle("Vertrag (Spezifikation)");
            this.setContentPane(this.getBaseDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    protected boolean save() {
        this.contract.setIssuer(new NlsString(this.contract.getIssuer(), this.getTxtIssuer().getText()));
        this.getPnlDescription().getObject();
        return super.save();
    }

    private void setElement(Element element) {
        this.contract = (Contract)element;
        this.getTxtIssuer().setText(ElementUtils.mapNlsString(this.contract.getIssuer()));
        this.getPnlDescription().setObject(this.contract);
    }

    class IvjEventHandler
    implements ActionListener,
    FocusListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ContractDialog.this.getBtnOk()) {
                ContractDialog.this.connEtoC1(e);
            }
            if (e.getSource() == ContractDialog.this.getBtnCancel()) {
                ContractDialog.this.connEtoC2(e);
            }
            if (e.getSource() == ContractDialog.this.getBtnApply()) {
                ContractDialog.this.connEtoC3(e);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == ContractDialog.this.getTxtIssuer()) {
                ContractDialog.this.connEtoM1(e);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

