/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.FontPanel;
import org.freehep.graphicsio.exportchooser.ImageSizePanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.OptionTextField;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class SVGExportFileType
extends AbstractExportFileType {
    private static final String[] versionList = new String[]{"Version 1.1 (REC-SVG11-20030114)"};
    private OptionCheckBox compress;

    public String getDescription() {
        return "Scalable Vector Graphics";
    }

    public String[] getExtensions() {
        return new String[]{"svg", "svgz"};
    }

    public String[] getMIMETypes() {
        return new String[]{"image/svg+xml"};
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, SVGGraphics2D.getDefaultProperties());
        String rootKey = SVGGraphics2D.class.getName();
        String abstractRootKey = AbstractVectorGraphicsIO.class.getName();
        ImageSizePanel imageSize = new ImageSizePanel((Properties)options, rootKey);
        OptionPanel format = new OptionPanel("Format");
        format.add("0 * [5 15 5 15] r", (Component)new JLabel("SVG Version"));
        format.add("1 * [5 15 5 15] lw", (Component)new OptionComboBox((Properties)options, SVGGraphics2D.VERSION, versionList));
        this.compress = new OptionCheckBox((Properties)options, SVGGraphics2D.COMPRESS, "Compress");
        format.add("0 * * 1 [5 15 5 15] w", (Component)this.compress);
        format.add("0 * * 1 [5 15 5 15] w", (Component)new OptionCheckBox((Properties)options, SVGGraphics2D.STYLABLE, "Stylable"));
        OptionPanel imageExport = new OptionPanel("Embed / Export Images");
        OptionCheckBox exportImages = new OptionCheckBox((Properties)options, SVGGraphics2D.EXPORT_IMAGES, "Export");
        imageExport.add("0 * * 1 [5 15 5 15] w", (Component)exportImages);
        JLabel exportSuffixLabel = new JLabel("Image Suffix");
        imageExport.add("0 * [5 15 5 15] r", (Component)exportSuffixLabel);
        exportImages.enables((Component)exportSuffixLabel);
        OptionTextField exportSuffix = new OptionTextField((Properties)options, SVGGraphics2D.EXPORT_SUFFIX, 20);
        imageExport.add("1 * [5 15 5 15] lw", (Component)exportSuffix);
        exportImages.enables((Component)exportSuffix);
        InfoPanel infoPanel = new InfoPanel((Properties)options, rootKey, new String[]{"Creator", "Title"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", (Component)imageSize);
        leftPanel.add("0 * wt", (Component)format);
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", (Component)new BackgroundPanel((Properties)options, rootKey, true));
        rightPanel.add("0 * wt", (Component)imageExport);
        rightPanel.add("0 * wt", (Component)new ImageTypePanel((Properties)options, rootKey, new String[]{"Smallest Size", "PNG", "JPG"}));
        rightPanel.add("0 * wt", (Component)new FontPanel((Properties)options, null, abstractRootKey));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel panel = new OptionPanel();
        panel.add("0 0 [5 5 5 5] wt", (Component)leftPanel);
        panel.add("1 0 [5 5 5 5] wt", (Component)rightPanel);
        panel.add("0 1 2 1 [5 5 5 5] wt", (Component)infoPanel);
        panel.add("0 * wh", (Component)new JLabel());
        return panel;
    }

    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new SVGGraphics2D(os, target);
    }

    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return new SVGGraphics2D(os, dimension);
    }

    public VectorGraphics getGraphics(File file, Component target) throws IOException {
        return new SVGGraphics2D(file, target);
    }

    public VectorGraphics getGraphics(File file, Dimension dimension) throws IOException {
        return new SVGGraphics2D(file, dimension);
    }

    public File adjustFilename(File file, Properties user) {
        UserProperties options = new UserProperties(user, SVGGraphics2D.getDefaultProperties());
        if (options.isProperty(SVGGraphics2D.COMPRESS)) {
            return SVGExportFileType.adjustExtension((File)file, (String)"svgz", null, (String)"");
        }
        return SVGExportFileType.adjustExtension((File)file, (String)"svg", null, (String)"");
    }
}

