/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.ehi.basics.i18n.ResourceBundle;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BaseFrame;
import ch.softenvironment.view.SimpleEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ErrorDialog
extends BaseDialog {
    private Throwable exception = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JPanel ivjJDialogContentPane = null;
    private JButton ivjBtnCancel = null;
    private JLabel ivjLblMessage = null;
    private JLabel ivjLblExceptionIcon = null;
    private JButton ivjBtnStacktrace = null;
    private JPanel ivjJPanel1 = null;
    private JPanel ivjJPanel2 = null;
    private JPanel ivjJPanel3 = null;
    private JDialog ivjDlgException = null;
    private JPanel ivjJDialogContentPane1 = null;
    private SimpleEditorPanel ivjPnlErrorText = null;
    private SimpleEditorPanel ivjPnlException = null;

    protected ErrorDialog(Dialog owner, String title, String message, Throwable original) {
        super(owner, true);
        this.setUp(owner, title, message, original);
    }

    protected ErrorDialog(Frame owner, String title, String message, Throwable original) {
        super(owner, true);
        this.setUp(owner, title, message, original);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.stacktrace();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    @Override
    public void dispose() {
        this.getDlgException().dispose();
        super.dispose();
    }

    private JButton getBtnCancel() {
        if (this.ivjBtnCancel == null) {
            try {
                this.ivjBtnCancel = new JButton();
                this.ivjBtnCancel.setName("BtnCancel");
                this.ivjBtnCancel.setText("Cancel");
                this.ivjBtnCancel.setText(ErrorDialog.getCancelString());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnCancel;
    }

    private JButton getBtnStacktrace() {
        if (this.ivjBtnStacktrace == null) {
            try {
                this.ivjBtnStacktrace = new JButton();
                this.ivjBtnStacktrace.setName("BtnStacktrace");
                this.ivjBtnStacktrace.setText("Stacktrace");
                this.ivjBtnStacktrace.setText(this.getResourceString("BtnStacktrace_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnStacktrace;
    }

    private JDialog getDlgException() {
        if (this.ivjDlgException == null) {
            try {
                this.ivjDlgException = new JDialog(this);
                this.ivjDlgException.setName("DlgException");
                this.ivjDlgException.setDefaultCloseOperation(2);
                this.ivjDlgException.setBounds(67, 186, 660, 240);
                this.ivjDlgException.setTitle("Exception");
                this.getDlgException().setContentPane(this.getJDialogContentPane1());
                this.ivjDlgException.setTitle(this.getResourceString("DlgException_title"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDlgException;
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new BorderLayout());
                this.getJDialogContentPane().add((Component)this.getJPanel1(), "West");
                this.getJDialogContentPane().add((Component)this.getJPanel2(), "South");
                this.getJDialogContentPane().add((Component)this.getJPanel3(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    private JPanel getJDialogContentPane1() {
        if (this.ivjJDialogContentPane1 == null) {
            try {
                this.ivjJDialogContentPane1 = new JPanel();
                this.ivjJDialogContentPane1.setName("JDialogContentPane1");
                this.ivjJDialogContentPane1.setLayout(new BoxLayout(this.getJDialogContentPane1(), 0));
                this.getJDialogContentPane1().add((Component)this.getPnlException(), this.getPnlException().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane1;
    }

    private JPanel getJPanel1() {
        if (this.ivjJPanel1 == null) {
            try {
                this.ivjJPanel1 = new JPanel();
                this.ivjJPanel1.setName("JPanel1");
                this.ivjJPanel1.setLayout(new FlowLayout());
                this.getJPanel1().add((Component)this.getLblExceptionIcon(), this.getLblExceptionIcon().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel1;
    }

    private JPanel getJPanel2() {
        if (this.ivjJPanel2 == null) {
            try {
                this.ivjJPanel2 = new JPanel();
                this.ivjJPanel2.setName("JPanel2");
                this.ivjJPanel2.setLayout(new FlowLayout());
                this.getJPanel2().add((Component)this.getBtnCancel(), this.getBtnCancel().getName());
                this.getJPanel2().add((Component)this.getBtnStacktrace(), this.getBtnStacktrace().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel2;
    }

    private JPanel getJPanel3() {
        if (this.ivjJPanel3 == null) {
            try {
                this.ivjJPanel3 = new JPanel();
                this.ivjJPanel3.setName("JPanel3");
                this.ivjJPanel3.setLayout(new GridBagLayout());
                GridBagConstraints constraintsLblMessage = new GridBagConstraints();
                constraintsLblMessage.gridx = 1;
                constraintsLblMessage.gridy = 1;
                constraintsLblMessage.anchor = 17;
                constraintsLblMessage.ipadx = 94;
                constraintsLblMessage.insets = new Insets(23, 11, 3, 176);
                this.getJPanel3().add((Component)this.getLblMessage(), constraintsLblMessage);
                GridBagConstraints constraintsPnlErrorText = new GridBagConstraints();
                constraintsPnlErrorText.gridx = 1;
                constraintsPnlErrorText.gridy = 2;
                constraintsPnlErrorText.fill = 1;
                constraintsPnlErrorText.weightx = 1.0;
                constraintsPnlErrorText.weighty = 1.0;
                constraintsPnlErrorText.ipadx = 284;
                constraintsPnlErrorText.ipady = 73;
                constraintsPnlErrorText.insets = new Insets(3, 13, 9, 13);
                this.getJPanel3().add((Component)this.getPnlErrorText(), constraintsPnlErrorText);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJPanel3;
    }

    private JLabel getLblExceptionIcon() {
        if (this.ivjLblExceptionIcon == null) {
            try {
                this.ivjLblExceptionIcon = new JLabel();
                this.ivjLblExceptionIcon.setName("LblExceptionIcon");
                this.ivjLblExceptionIcon.setIcon(null);
                this.ivjLblExceptionIcon.setText("");
                this.ivjLblExceptionIcon.setIcon(ResourceBundle.getImageIcon(ErrorDialog.class, (String)"exception-icon.gif"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblExceptionIcon;
    }

    private JLabel getLblMessage() {
        if (this.ivjLblMessage == null) {
            try {
                this.ivjLblMessage = new JLabel();
                this.ivjLblMessage.setName("LblMessage");
                this.ivjLblMessage.setText("");
                this.ivjLblMessage.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                this.ivjLblMessage.setText(this.getResourceString("LblMessage_text"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLblMessage;
    }

    private SimpleEditorPanel getPnlErrorText() {
        if (this.ivjPnlErrorText == null) {
            try {
                this.ivjPnlErrorText = new SimpleEditorPanel();
                this.ivjPnlErrorText.setName("PnlErrorText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlErrorText;
    }

    private SimpleEditorPanel getPnlException() {
        if (this.ivjPnlException == null) {
            try {
                this.ivjPnlException = new SimpleEditorPanel();
                this.ivjPnlException.setName("PnlException");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPnlException;
    }

    @Override
    protected void handleException(Throwable exception) {
        super.traceOnly(exception);
    }

    private void initConnections() throws Exception {
        this.getBtnCancel().addActionListener(this.ivjEventHandler);
        this.getBtnStacktrace().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ErrorDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(433, 182);
            this.setTitle("Fehler");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.setSize(600, 250);
        this.getPnlErrorText().setEditable(false);
        this.getPnlException().setEditable(false);
    }

    private void setException(Throwable exception) {
        if (exception == null) {
            this.getBtnStacktrace().setEnabled(false);
        } else {
            this.exception = exception;
            this.getPnlException().setText(exception.getLocalizedMessage());
            this.getBtnStacktrace().setEnabled(true);
        }
    }

    public void setText(String text) {
        this.getPnlErrorText().setText(text);
    }

    private void setUp(Component owner, String title, String message, Throwable original) {
        this.initialize();
        this.setTitle(title == null ? this.getResourceString("CTUnexpectedError") : title);
        this.getPnlErrorText().setText(message);
        this.setException(original);
        this.setRelativeLocation(owner);
        this.show();
    }

    private void stacktrace() {
        this.getDlgException().setVisible(true);
        this.getPnlException().setEditable(false);
        this.getPnlException().setText(BaseFrame.exceptionToString(this.exception));
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ErrorDialog.this.getBtnCancel()) {
                ErrorDialog.this.connEtoM1(e);
            }
            if (e.getSource() == ErrorDialog.this.getBtnStacktrace()) {
                ErrorDialog.this.connEtoC1(e);
            }
        }
    }
}

