/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.interlis.iliexport;

import ch.ehi.basics.i18n.MessageFormat;
import ch.ehi.basics.i18n.ResourceBundle;
import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.tools.TopoSort;
import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.IliSyntax;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.associations.AssociationDefDerived;
import ch.ehi.interlis.associations.Participant;
import ch.ehi.interlis.associations.RoleDef;
import ch.ehi.interlis.attributes.AttributeDef;
import ch.ehi.interlis.attributes.DomainAttribute;
import ch.ehi.interlis.constraints.ConstraintDef;
import ch.ehi.interlis.constraints.ConstraintExpression;
import ch.ehi.interlis.domainsandconstants.DomainDef;
import ch.ehi.interlis.domainsandconstants.DomainExtends;
import ch.ehi.interlis.domainsandconstants.Type;
import ch.ehi.interlis.domainsandconstants.UnknownType;
import ch.ehi.interlis.domainsandconstants.basetypes.BasketType;
import ch.ehi.interlis.domainsandconstants.basetypes.BooleanType;
import ch.ehi.interlis.domainsandconstants.basetypes.ClassType;
import ch.ehi.interlis.domainsandconstants.basetypes.CoordinateType;
import ch.ehi.interlis.domainsandconstants.basetypes.DateTimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.DateTimeValue;
import ch.ehi.interlis.domainsandconstants.basetypes.DateType;
import ch.ehi.interlis.domainsandconstants.basetypes.DateValue;
import ch.ehi.interlis.domainsandconstants.basetypes.EnumElement;
import ch.ehi.interlis.domainsandconstants.basetypes.Enumeration;
import ch.ehi.interlis.domainsandconstants.basetypes.HorizAlignment;
import ch.ehi.interlis.domainsandconstants.basetypes.IliDim;
import ch.ehi.interlis.domainsandconstants.basetypes.InterlisDateTimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.InterlisDateType;
import ch.ehi.interlis.domainsandconstants.basetypes.InterlisTimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericType;
import ch.ehi.interlis.domainsandconstants.basetypes.NumericalType;
import ch.ehi.interlis.domainsandconstants.basetypes.OidType;
import ch.ehi.interlis.domainsandconstants.basetypes.RefAttrType;
import ch.ehi.interlis.domainsandconstants.basetypes.RotationDef;
import ch.ehi.interlis.domainsandconstants.basetypes.StructAttrType;
import ch.ehi.interlis.domainsandconstants.basetypes.StructDec;
import ch.ehi.interlis.domainsandconstants.basetypes.StructuredUnitType;
import ch.ehi.interlis.domainsandconstants.basetypes.Text;
import ch.ehi.interlis.domainsandconstants.basetypes.TimeType;
import ch.ehi.interlis.domainsandconstants.basetypes.TimeValue;
import ch.ehi.interlis.domainsandconstants.basetypes.VertAlignment;
import ch.ehi.interlis.domainsandconstants.linetypes.IliPolyline;
import ch.ehi.interlis.domainsandconstants.linetypes.IndividualSurface;
import ch.ehi.interlis.domainsandconstants.linetypes.LineForm;
import ch.ehi.interlis.domainsandconstants.linetypes.LineFormTypeDef;
import ch.ehi.interlis.domainsandconstants.linetypes.LineType;
import ch.ehi.interlis.domainsandconstants.linetypes.SurfaceType;
import ch.ehi.interlis.domainsandconstants.linetypes.Tesselation;
import ch.ehi.interlis.functions.FunctionDef;
import ch.ehi.interlis.graphicdescriptions.GraphicDef;
import ch.ehi.interlis.graphicdescriptions.GraphicParameterDef;
import ch.ehi.interlis.metaobjects.MetaDataUseDef;
import ch.ehi.interlis.metaobjects.MetaObjectFile;
import ch.ehi.interlis.metaobjects.ParameterDef;
import ch.ehi.interlis.modeltopicclass.AbstractClassDef;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.ClassExtends;
import ch.ehi.interlis.modeltopicclass.ContextDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.IliImport;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.interlis.modeltopicclass.TopicDepends;
import ch.ehi.interlis.modeltopicclass.TopicExtends;
import ch.ehi.interlis.modeltopicclass.Translation;
import ch.ehi.interlis.tools.AbstractClassDefUtility;
import ch.ehi.interlis.tools.ModelElementUtility;
import ch.ehi.interlis.tools.RoleDefUtility;
import ch.ehi.interlis.tools.UnlinkAllChildren;
import ch.ehi.interlis.units.UnitDef;
import ch.ehi.interlis.views.ViewDef;
import ch.ehi.interlis.views.ViewProjectionDef;
import ch.ehi.interlis.views.ViewableDef;
import ch.ehi.uml1_4.foundation.core.Artifact;
import ch.ehi.uml1_4.foundation.core.Classifier;
import ch.ehi.uml1_4.foundation.core.Dependency;
import ch.ehi.uml1_4.foundation.core.GeneralizableElement;
import ch.ehi.uml1_4.foundation.core.Generalization;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.foundation.core.Namespace;
import ch.ehi.uml1_4.foundation.datatypes.Multiplicity;
import ch.ehi.uml1_4.foundation.datatypes.MultiplicityRange;
import ch.ehi.uml1_4.foundation.extensionmechanisms.TaggedValue;
import ch.ehi.uml1_4.implementation.AbstractEditorElement;
import ch.ehi.uml1_4.implementation.AbstractModelElement;
import ch.ehi.uml1_4.implementation.AbstractNamespace;
import ch.ehi.uml1_4.modelmanagement.Package;
import ch.ehi.uml1_4.tools.ChildFinderByClass;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.application.LogListenerCompilerMsgMapper;
import ch.ehi.umleditor.application.NavigationTreeNodeUtility;
import ch.interlis.ili2c.CompilerLogEvent;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.BoidEntry;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransferFromUmlMetamodel {
    static java.util.ResourceBundle rsrc = ResourceBundle.getBundle(TransferFromUmlMetamodel.class);
    private transient Writer out = null;
    private transient String language = null;
    private transient boolean runIli2c = false;
    public static final String VALUE_ATTR = "value";
    private boolean useMultiValueStructAttrs = false;
    private boolean useListBagOfPrimitives = false;
    private transient List tempFiles = null;
    private transient FileListEntry currentFile = null;
    private transient Map model2file = null;
    private transient Set filedep = null;
    private transient ModelElement lastModelElement = null;
    private DecimalFormat format0000 = new DecimalFormat("0000");
    private DecimalFormat format00 = new DecimalFormat("00");
    private DecimalFormat formatSeconds = new DecimalFormat("00.000");
    private static String nl = null;
    private int lineNumber;
    private int ind = 0;
    private int errc = 0;
    private boolean createFileList = false;
    private List fileList = null;
    private ArrayList flushedDomainStructs = new ArrayList();
    private ArrayList domainStructs = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitNamespace(Namespace ns, Configuration config, Settings settings) throws IOException {
        if (this.runIli2c) {
            this.tempFiles = new ArrayList();
            this.model2file = new HashMap();
            this.filedep = new HashSet();
        }
        this.errc = 0;
        ArrayList<Namespace> todo = new ArrayList<Namespace>();
        todo.add(ns);
        while (!todo.isEmpty()) {
            Namespace current = (Namespace)todo.get(0);
            if (current instanceof INTERLIS2Def) {
                this.visitINTERLIS2Def((INTERLIS2Def)current);
            } else {
                Iterator childi = current.iteratorOwnedElement();
                while (childi.hasNext()) {
                    Object obj = childi.next();
                    if (!(obj instanceof Package) && !(obj instanceof Artifact)) continue;
                    todo.add((Namespace)obj);
                }
            }
            todo.remove(0);
        }
        if (this.errc == 0 && this.runIli2c) {
            config.clearBoidEntry();
            config.clearFileEntry();
            for (Serializable f : ModelElementUtility.getChildElements(ns, MetaObjectFile.class)) {
                File parent;
                String xmlFilename = ((AbstractModelElement)f).getName().getValue("");
                File xmlFile = new File(xmlFilename);
                if (!xmlFile.isAbsolute() && (parent = LauncherView.getInstance().getCurrentFile()) != null) {
                    xmlFile = new File(parent.getParent(), xmlFilename);
                }
                config.addFileEntry(new FileEntry(xmlFile.getAbsolutePath(), 2));
            }
            this.sortIliFiles();
            Iterator i = this.tempFiles.iterator();
            while (i.hasNext()) {
                Serializable f;
                f = ((FileListEntry)i.next()).file;
                config.addFileEntry(new FileEntry(((File)f).getAbsolutePath(), 1));
            }
            ChildFinderByClass finder = new ChildFinderByClass(MetaDataUseDef.class);
            finder.visit(ns);
            for (MetaDataUseDef mdUse : finder.getElements()) {
                config.addBoidEntry(new BoidEntry(ModelElementUtility.getIliQualifiedName(null, mdUse, null), mdUse.getBasketOid()));
            }
            try {
                LauncherView.getInstance().getLogListener().setCompilerMsgMapper(new MyErrorListener());
                Main.runCompiler((Configuration)config, (Settings)settings);
            }
            finally {
                LauncherView.getInstance().getLogListener().setCompilerMsgMapper(null);
            }
            Iterator i2 = this.tempFiles.iterator();
            while (i2.hasNext()) {
                File f = ((FileListEntry)i2.next()).file;
                f.delete();
            }
        }
        if (!this.createFileList) {
            LauncherView.getInstance().log(this.getFuncDesc(), rsrc.getString("CIdone"));
        }
    }

    public void setup(Writer out, String language) {
        this.out = out;
        this.language = language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitINTERLIS2Def(INTERLIS2Def def) throws IOException {
        if (def.getDefLangName().startsWith("<")) {
            return;
        }
        HashSet<String> done = new HashSet<String>();
        ArrayList<String> languages = new ArrayList<String>();
        Set set = ModelElementUtility.getChildElements(def, ModelDef.class);
        for (ModelDef modelDef : set) {
            String baseLanguage = modelDef.getBaseLanguage();
            if (baseLanguage != null && !languages.contains(baseLanguage)) {
                languages.add(baseLanguage);
            }
            List<String> validSecondLanguages = modelDef.getValidSecondLanguages();
            for (String secondLang : validSecondLanguages) {
                if (languages.contains(secondLang)) continue;
                languages.add(secondLang);
            }
        }
        for (String language : languages) {
            if (done.contains(language)) continue;
            File file = null;
            String filename = def.getName().getValue(language);
            if (this.runIli2c) {
                file = File.createTempFile("umleditor", ".ili");
                this.currentFile = new FileListEntry(file);
                this.tempFiles.add(this.currentFile);
            } else {
                File parent;
                file = new File(filename);
                if (!file.isAbsolute() && (parent = LauncherView.getInstance().getCurrentFile()) != null) {
                    file = new File(parent.getParent(), filename);
                }
                if (this.createFileList) {
                    this.fileList.add(file);
                }
                this.currentFile = null;
            }
            try {
                if (!this.createFileList) {
                    this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    this.lineNumber = 1;
                    this.defineLinkToModelElement(def);
                    this.out.write("INTERLIS " + def.getVersion() + ";");
                    this.newline();
                    this.useMultiValueStructAttrs = Double.toString(def.getVersion()).equals("2.3");
                    this.useListBagOfPrimitives = def.getVersion() >= 2.4;
                    this.visitINTERLIS2Def(def, language);
                }
                done.add(language);
                for (String otherLanguage : languages) {
                    if (done.contains(otherLanguage) || !filename.equals(def.getName().getValue(otherLanguage))) continue;
                    if (!this.createFileList) {
                        this.visitINTERLIS2Def(def, otherLanguage);
                    }
                    done.add(otherLanguage);
                }
            }
            finally {
                if (!this.createFileList && this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            if (this.runIli2c || this.createFileList) continue;
            LauncherView.getInstance().log(this.getFuncDesc(), MessageFormat.format((java.util.ResourceBundle)rsrc, (String)"CIilifilewritten", (String)file.getAbsolutePath()));
        }
    }

    public void visitINTERLIS2Def(INTERLIS2Def def, String language) throws IOException {
        this.language = language;
        List todo = this.sortIliDefs(ModelElementUtility.getChildElements(def, ModelDef.class));
        for (Object current : todo) {
            this.newline();
            this.visitModelDef((ModelDef)current);
        }
    }

    public void visitTaggedValues(ModelElement def) throws IOException {
        TaggedValue umlTag = null;
        Iterator defLangIt = def.iteratorTaggedValue();
        while (defLangIt.hasNext()) {
            umlTag = (TaggedValue)defLangIt.next();
            String name = umlTag.getName().getValue("");
            if (!name.startsWith("ili:")) continue;
            String value = umlTag.getDataValue();
            this.out.write(this.getIndent());
            this.out.write("!!@ ");
            this.out.write(name.substring("ili:".length()));
            this.out.write("=");
            if (value.indexOf(32) != -1 || value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(44) != -1 || value.indexOf(34) != -1 || value.indexOf(92) != -1) {
                this.out.write("\"" + value + "\"");
                this.newline();
                continue;
            }
            this.out.write(value);
            this.newline();
        }
    }

    public void visitModelDef(ModelDef def) throws IOException {
        String baseLanguage = def.getBaseLanguage();
        if (!(baseLanguage != null && baseLanguage.equals(this.language) || def.getValidSecondLanguages().contains(this.language))) {
            return;
        }
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        if (def.isContracted()) {
            this.out.write("CONTRACTED ");
        }
        switch (def.getKind()) {
            case 3: {
                this.out.write("REFSYSTEM ");
                break;
            }
            case 4: {
                this.out.write("SYMBOLOGY ");
                break;
            }
            case 2: {
                this.out.write("TYPE ");
                break;
            }
        }
        String modelName = def.getName().getValue(this.language);
        if (this.runIli2c) {
            this.model2file.put(modelName, this.currentFile);
        }
        this.out.write("MODEL " + this.visitIliName(def, modelName) + " (" + this.language + ")");
        this.newline();
        String issuerURI = this.mapNls(def.getIssuerURI());
        if (issuerURI != null) {
            this.out.write("AT \"" + issuerURI + "\"");
        } else {
            this.logErrorMsg(def, "ModelDef " + modelName + " requires an issuer URI");
        }
        this.newline();
        String version = this.mapNls(def.getVersion());
        if (version != null) {
            this.out.write("VERSION \"" + version + "\" ");
        } else {
            this.logErrorMsg(def, "ModelDef " + modelName + " requires a version");
        }
        this.visitExplanation(def.getVersionComment());
        if (def.getBaseLanguage() != null && !def.getBaseLanguage().equals(this.language)) {
            Iterator translationi = def.iteratorTranslation();
            while (translationi.hasNext()) {
                Translation translation = (Translation)translationi.next();
                if (!translation.getLanguage().equals(this.language)) continue;
                this.newline();
                String trslModelName = def.getName().getValue(translation.getBaseLanguage());
                this.out.write("TRANSLATION OF " + trslModelName + " [\"" + version + "\"]");
                if (!this.runIli2c) continue;
                this.filedep.add(new IliFileCond(trslModelName, modelName));
            }
        }
        this.out.write(" =");
        this.newline();
        this.inc_ind();
        int impc = 0;
        String sep = this.getIndent() + "IMPORTS ";
        Iterator importsi = def.iteratorClientDependency();
        while (importsi.hasNext()) {
            IliImport iliimport;
            Iterator supplieri;
            Object obj = importsi.next();
            if (!(obj instanceof IliImport) || !(supplieri = (iliimport = (IliImport)obj).iteratorSupplier()).hasNext()) continue;
            ModelDef supplier = (ModelDef)supplieri.next();
            String supplierLang = iliimport.getSupplierLanguage(this.language);
            String impModelName = supplier.getName().getValue(supplierLang);
            this.out.write(sep + impModelName);
            if (this.runIli2c) {
                this.filedep.add(new IliFileCond(impModelName, modelName));
            }
            sep = ",";
            ++impc;
        }
        if (impc > 0) {
            this.out.write(";");
            this.newline();
        }
        this.lastModelElement = def;
        List children = this.sortIliDefs(ModelElementUtility.getChildElements(def, null));
        for (Object obj : children) {
            if (this.domainStructs.size() > 0 && !(obj instanceof DomainDef)) {
                this.flushDomainStructs();
            }
            if (obj instanceof MetaDataUseDef) {
                this.visitMetaDataUseDef((MetaDataUseDef)obj);
            } else if (obj instanceof UnitDef) {
                this.visitUnitDef((UnitDef)obj);
            } else if (obj instanceof FunctionDef) {
                this.visitFunctionDef((FunctionDef)obj);
            } else if (obj instanceof LineFormTypeDef) {
                this.visitLineFormTypeDef((LineFormTypeDef)obj);
            } else if (obj instanceof DomainDef) {
                this.visitDomainDef((DomainDef)obj);
            } else if (obj instanceof ContextDef) {
                this.visitContextDef((ContextDef)obj);
            } else if (obj instanceof GraphicParameterDef) {
                this.visitGraphicParameterDef((GraphicParameterDef)obj);
            } else if (obj instanceof ClassDef) {
                this.visitClassDef((ClassDef)obj);
            } else if (obj instanceof AssociationDef) {
                AssociationDef assoc = (AssociationDef)obj;
                if (!assoc.isStructureAttribute() && !assoc.isReferenceAttribute()) {
                    this.logErrorMsg(assoc, rsrc.getString("CEassocOutsideTopic"));
                }
            } else if (obj instanceof TopicDef) {
                this.visitTopicDef((TopicDef)obj);
            }
            this.lastModelElement = (ModelElement)obj;
        }
        if (this.domainStructs.size() > 0) {
            this.flushDomainStructs();
        }
        this.lastModelElement = def;
        this.dec_ind();
        this.newline();
        this.out.write("END " + def.getName().getValue(this.language) + ".");
        this.newline();
    }

    private String mapNls(NlsString str) {
        if (str != null) {
            return str.getValue(this.language);
        }
        return null;
    }

    public void visitTopicDef(TopicDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent());
        if (def.getKind() == 2) {
            this.out.write("VIEW ");
        }
        this.out.write("TOPIC " + this.visitIliName(def, def.getName().getValue(this.language)));
        int propc = 0;
        if (def.isAbstract()) {
            this.out.write((propc == 0 ? "(" : ",") + "ABSTRACT");
            ++propc;
        }
        if (def.isPropFinal()) {
            this.out.write((propc == 0 ? "(" : ",") + "FINAL");
            ++propc;
        }
        if (propc > 0) {
            this.out.write(")");
        }
        Iterator extendsi = def.iteratorGeneralization();
        while (extendsi.hasNext()) {
            TopicExtends extend;
            Object obj = extendsi.next();
            if (!(obj instanceof TopicExtends) || !(extend = (TopicExtends)obj).containsParent()) continue;
            TopicDef supplier = (TopicDef)extend.getParent();
            this.newline();
            this.out.write(this.getIndent() + "EXTENDS " + this.topicRef(def, supplier));
            break;
        }
        this.out.write(" =");
        this.newline();
        this.inc_ind();
        if (def.containsBasketoid()) {
            this.out.write(this.getIndent() + "BASKET OID AS " + this.domainRef(def, def.getBasketoid()));
            this.out.write(";");
            this.newline();
        }
        if (def.containsOiddomain()) {
            this.out.write(this.getIndent() + "OID AS " + this.domainRef(def, def.getOiddomain()));
            this.out.write(";");
            this.newline();
        }
        int depc = 0;
        String sep = this.getIndent() + "DEPENDS ON ";
        Iterator dependsi = def.iteratorClientDependency();
        while (dependsi.hasNext()) {
            TopicDepends depends;
            Iterator supplieri;
            Object obj = dependsi.next();
            if (!(obj instanceof TopicDepends) || !(supplieri = (depends = (TopicDepends)obj).iteratorSupplier()).hasNext()) continue;
            TopicDef supplier = (TopicDef)supplieri.next();
            this.out.write(sep + this.topicRef(def, supplier));
            sep = ",";
            ++depc;
        }
        if (depc > 0) {
            this.out.write(";");
            this.newline();
        }
        List children = this.sortIliDefs(ModelElementUtility.getChildElements(def, null));
        this.lastModelElement = def;
        for (Object obj : children) {
            if (this.domainStructs.size() > 0 && !(obj instanceof DomainDef)) {
                this.flushDomainStructs();
            }
            if (obj instanceof MetaDataUseDef) {
                this.visitMetaDataUseDef((MetaDataUseDef)obj);
            } else if (obj instanceof UnitDef) {
                this.visitUnitDef((UnitDef)obj);
            } else if (obj instanceof DomainDef) {
                this.visitDomainDef((DomainDef)obj);
            } else if (obj instanceof ClassDef && !(obj instanceof AssociationDef)) {
                this.visitClassDef((ClassDef)obj);
            } else if (obj instanceof AssociationDef) {
                this.visitAssociationDef((AssociationDef)obj);
            } else if (obj instanceof ViewDef) {
                this.visitViewDef((ViewDef)obj);
            } else if (obj instanceof ViewProjectionDef) {
                this.visitViewProjectionDef((ViewProjectionDef)obj);
            } else if (obj instanceof GraphicDef) {
                this.visitGraphicDef((GraphicDef)obj);
            }
            this.lastModelElement = (ModelElement)obj;
        }
        if (this.domainStructs.size() > 0) {
            this.flushDomainStructs();
        }
        this.dec_ind();
        this.newline();
        this.out.write(this.getIndent());
        this.out.write("END " + def.getName().getValue(this.language) + ";");
        this.newline();
    }

    public void visitMetaDataUseDef(MetaDataUseDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
    }

    public void visitUnitDef(UnitDef def) throws IOException {
        this.newline();
        if (!(this.lastModelElement instanceof UnitDef)) {
            this.out.write(this.getIndent() + "UNIT");
            this.newline();
            this.newline();
            this.inc_ind();
        } else {
            this.inc_ind();
        }
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
        this.dec_ind();
    }

    public void visitContextDef(ContextDef def) throws IOException {
        this.newline();
        if (!(this.lastModelElement instanceof ContextDef)) {
            this.out.write(this.getIndent() + "CONTEXT");
            this.newline();
            this.newline();
        }
        this.inc_ind();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent() + def.getDefLangName() + " =");
        this.newline();
        this.inc_ind();
        this.visitIliSyntax(def);
        this.dec_ind();
        this.dec_ind();
    }

    public void visitFunctionDef(FunctionDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
    }

    public void visitLineFormTypeDef(LineFormTypeDef def) throws IOException {
        this.newline();
        if (!(this.lastModelElement instanceof LineFormTypeDef)) {
            this.out.write(this.getIndent() + "LINE FORM");
            this.newline();
            this.newline();
            this.inc_ind();
        } else {
            this.inc_ind();
        }
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent());
        this.out.write(this.visitIliName(def, def.getName().getValue(this.language)));
        this.out.write(" : ");
        this.out.write(this.classRef(def, def.getStructure()));
        this.out.write(";");
        this.newline();
        this.dec_ind();
    }

    public void visitDomainDef(DomainDef def) throws IOException {
        this.newline();
        if (!(this.lastModelElement instanceof DomainDef)) {
            this.out.write(this.getIndent() + "DOMAIN");
            this.newline();
            this.newline();
            this.inc_ind();
        } else {
            this.inc_ind();
        }
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        String name = def.getName().getValue(this.language);
        this.out.write(this.getIndent() + this.visitIliName(def, name));
        int propc = 0;
        if (def.isAbstract()) {
            this.out.write((propc == 0 ? " (" : ",") + "ABSTRACT");
            ++propc;
        }
        if (def.isPropFinal()) {
            this.out.write((propc == 0 ? " (" : ",") + "FINAL");
            ++propc;
        }
        if (def.isGeneric()) {
            this.out.write((propc == 0 ? " (" : ",") + "GENERIC");
            ++propc;
        }
        if (propc > 0) {
            this.out.write(")");
        }
        Iterator extendsi = def.iteratorGeneralization();
        while (extendsi.hasNext()) {
            DomainExtends extend;
            Object obj = extendsi.next();
            if (!(obj instanceof DomainExtends) || !(extend = (DomainExtends)obj).containsParent()) continue;
            DomainDef supplier = (DomainDef)extend.getParent();
            this.newline();
            this.out.write(this.getIndent() + "EXTENDS " + this.domainRef(def, supplier));
            break;
        }
        this.out.write(" = ");
        if (def.isMandatory()) {
            this.out.write("MANDATORY ");
        }
        if (def.containsType()) {
            this.visitType(def, def.getType());
        }
        if (def.sizeConstraint() > 0) {
            this.inc_ind();
            this.newline();
            this.out.write(this.getIndent() + "CONSTRAINTS");
            this.newline();
            this.inc_ind();
            boolean first = true;
            Iterator constraintIterator = def.iteratorConstraint();
            while (constraintIterator.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    this.out.write(this.getIndent() + ",");
                    this.newline();
                }
                ConstraintDef constraint = (ConstraintDef)constraintIterator.next();
                this.visitIliSyntax((ConstraintExpression)constraint.getBody());
            }
            this.dec_ind();
            this.dec_ind();
            this.out.write(this.getIndent() + ";");
            this.newline();
        } else {
            this.out.write(";");
            this.newline();
        }
        boolean createStruct = false;
        HashSet<DomainAttribute> superfluousDAs = new HashSet<DomainAttribute>();
        Iterator usei = def.iteratorDomainAttribute();
        while (usei.hasNext()) {
            DomainAttribute da = (DomainAttribute)usei.next();
            if (!da.containsAttributeDef()) {
                superfluousDAs.add(da);
                continue;
            }
            AttributeDef use = da.getAttributeDef();
            Multiplicity m = use.getMultiplicity();
            Iterator mri = m.iteratorRange();
            while (mri.hasNext()) {
                MultiplicityRange mr = (MultiplicityRange)mri.next();
                if (mr.getUpper() <= 1L) continue;
                createStruct = true;
            }
        }
        if (createStruct) {
            this.domainStructs.add(def);
        }
        if (superfluousDAs.size() > 0) {
            Iterator dai = superfluousDAs.iterator();
            while (dai.hasNext()) {
                this.logErrorMsg("metamodel fixed. DomainRef (" + name + ") without an AttributeDef removed.");
                UnlinkAllChildren remover = new UnlinkAllChildren();
                remover.visit(dai.next());
                remover.unlinkThem();
            }
        }
        this.dec_ind();
    }

    public void visitGraphicParameterDef(GraphicParameterDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
    }

    public void visitClassDef(ClassDef def) throws IOException {
        Object obj3;
        ClassExtends extend;
        Object obj2;
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent());
        if (def.getKind() == 2) {
            this.out.write("STRUCTURE ");
        } else {
            this.out.write("CLASS ");
        }
        this.out.write(this.visitIliName(def, def.getName().getValue(this.language)));
        int propc = 0;
        if (def.isAbstract()) {
            this.out.write((propc == 0 ? " (" : ",") + "ABSTRACT");
            ++propc;
        }
        if (def.isPropFinal()) {
            this.out.write((propc == 0 ? " (" : ",") + "FINAL");
            ++propc;
        }
        Iterator extendsi = def.iteratorGeneralization();
        while (extendsi.hasNext()) {
            obj2 = extendsi.next();
            if (!(obj2 instanceof ClassExtends) || !(extend = (ClassExtends)obj2).containsParent() || !extend.isExtended()) continue;
            this.out.write((propc == 0 ? " (" : ",") + "EXTENDED");
            ++propc;
        }
        if (propc > 0) {
            this.out.write(")");
        }
        extendsi = def.iteratorGeneralization();
        while (extendsi.hasNext()) {
            obj2 = extendsi.next();
            if (!(obj2 instanceof ClassExtends) || !(extend = (ClassExtends)obj2).containsParent() || extend.isExtended()) continue;
            ClassDef supplier = (ClassDef)extend.getParent();
            this.newline();
            this.out.write(this.getIndent() + "EXTENDS " + this.classRef(def, supplier));
            break;
        }
        this.out.write(" =");
        this.newline();
        this.inc_ind();
        if (def.containsOiddomain()) {
            this.out.write(this.getIndent() + "OID AS " + this.domainRef(def, def.getOiddomain()));
            this.out.write(";");
            this.newline();
        }
        for (Object obj3 : AbstractClassDefUtility.getIliAttributes(def)) {
            if (obj3 instanceof AttributeDef) {
                this.visitAttributeDef((AttributeDef)obj3);
                continue;
            }
            if (!(obj3 instanceof RoleDef)) continue;
            this.visitAttributeDef((RoleDef)obj3);
        }
        Iterator childi = def.iteratorConstraint();
        while (childi.hasNext()) {
            obj3 = childi.next();
            if (!(obj3 instanceof ConstraintDef)) continue;
            this.visitConstraintDef((ConstraintDef)obj3);
        }
        if (def.sizeParameterDef() > 0) {
            this.out.write(this.getIndent());
            this.out.write("PARAMETER");
            this.newline();
            this.inc_ind();
            childi = def.iteratorParameterDef();
            while (childi.hasNext()) {
                obj3 = childi.next();
                if (!(obj3 instanceof ParameterDef)) continue;
                this.visitIliSyntax((ParameterDef)obj3);
            }
            this.dec_ind();
        }
        this.dec_ind();
        this.out.write(this.getIndent());
        this.out.write("END " + def.getName().getValue(this.language) + ";");
        this.newline();
    }

    public void visitAssociationDef(AssociationDef def) throws IOException {
        Object obj4;
        ClassExtends extend;
        Object obj2;
        if (def.isStructureAttribute() || def.isReferenceAttribute()) {
            return;
        }
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent());
        this.out.write("ASSOCIATION ");
        this.out.write(this.visitIliName(def, def.getName().getValue(this.language)));
        int propc = 0;
        if (def.isAbstract()) {
            this.out.write((propc == 0 ? "(" : ",") + "ABSTRACT");
            ++propc;
        }
        if (def.isPropFinal()) {
            this.out.write((propc == 0 ? "(" : ",") + "FINAL");
            ++propc;
        }
        Iterator extendsi = def.iteratorGeneralization();
        while (extendsi.hasNext()) {
            obj2 = extendsi.next();
            if (!(obj2 instanceof ClassExtends) || !(extend = (ClassExtends)obj2).containsParent() || !extend.isExtended()) continue;
            this.out.write((propc == 0 ? "(" : ",") + "EXTENDED");
            ++propc;
        }
        if (propc > 0) {
            this.out.write(")");
        }
        extendsi = def.iteratorGeneralization();
        while (extendsi.hasNext()) {
            obj2 = extendsi.next();
            if (!(obj2 instanceof ClassExtends) || !(extend = (ClassExtends)obj2).containsParent() || extend.isExtended()) continue;
            AbstractClassDef supplier = (AbstractClassDef)extend.getParent();
            this.newline();
            this.out.write(this.getIndent() + "EXTENDS " + this.modelElementRef(def, supplier, null));
            break;
        }
        Iterator derivedi = def.iteratorClientDependency();
        while (derivedi.hasNext()) {
            AssociationDefDerived derived;
            Object obj3 = derivedi.next();
            if (!(obj3 instanceof AssociationDefDerived) || (derived = (AssociationDefDerived)obj3).sizeSupplier() <= 0) continue;
            ViewableDef supplier = (ViewableDef)derived.iteratorSupplier().next();
            this.newline();
            this.out.write(this.getIndent() + "DERIVED FROM " + this.modelElementRef(def, supplier, null));
            break;
        }
        this.out.write(" =");
        this.newline();
        this.inc_ind();
        Iterator childi = def.iteratorConnection();
        while (childi.hasNext()) {
            obj4 = childi.next();
            if (!(obj4 instanceof RoleDef)) continue;
            this.visitRoleDef((RoleDef)obj4);
        }
        for (Object obj4 : AbstractClassDefUtility.getIliAttributes(def)) {
            if (obj4 instanceof AttributeDef) {
                this.visitAttributeDef((AttributeDef)obj4);
                continue;
            }
            if (!(obj4 instanceof RoleDef)) continue;
            this.visitAttributeDef((RoleDef)obj4);
        }
        childi = def.iteratorConstraint();
        while (childi.hasNext()) {
            obj4 = childi.next();
            if (!(obj4 instanceof ConstraintDef)) continue;
            this.visitConstraintDef((ConstraintDef)obj4);
        }
        this.dec_ind();
        this.out.write(this.getIndent());
        this.out.write("END " + def.getName().getValue(this.language) + ";");
        this.newline();
    }

    public void visitConstraintDef(ConstraintDef def) throws IOException {
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax((ConstraintExpression)def.getBody());
    }

    public void visitViewDef(ViewDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
    }

    public void visitViewProjectionDef(ViewProjectionDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
    }

    public void visitGraphicDef(GraphicDef def) throws IOException {
        this.newline();
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.visitIliSyntax(def);
    }

    public String topicRef(ModelElement source, TopicDef ref) {
        StringBuffer ret = new StringBuffer();
        Namespace parent = ref.getNamespace();
        while (!(parent instanceof ModelDef)) {
            parent = parent.getNamespace();
        }
        ret.append(parent.getName().getValue(this.language));
        ret.append(".");
        ret.append(ref.getName().getValue(this.language));
        return ret.toString();
    }

    public void visitIliSyntax(IliSyntax element) throws IOException {
        String def;
        NlsString defNls = element.getSyntax();
        String string = def = defNls != null ? defNls.getValue(this.language) : "";
        if (def == null || def.length() == 0) {
            return;
        }
        LineNumberReader lines = new LineNumberReader(new StringReader(def));
        try {
            String line;
            while ((line = lines.readLine()) != null) {
                this.out.write(this.getIndent() + line);
                this.newline();
            }
        }
        catch (IOException ex) {
            EhiLogger.logError((Throwable)ex);
        }
    }

    public String classRef(ModelElement source, AbstractClassDef ref) {
        if ("ANYCLASS".equals(ref.getDefLangName())) {
            return "ANYCLASS";
        }
        if ("ANYSTRUCTURE".equals(ref.getDefLangName())) {
            return "ANYSTRUCTURE";
        }
        return this.modelElementRef(source, ref, null);
    }

    public void visitAttributeDef(AttributeDef def) throws IOException {
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent());
        this.out.write(this.visitIliName(def, def.getName().getValue(this.language)) + " ");
        int propc = 0;
        if (def.isAbstract()) {
            this.out.write((propc == 0 ? "(" : ",") + "ABSTRACT");
            ++propc;
        }
        if (def.isPropFinal()) {
            this.out.write((propc == 0 ? "(" : ",") + "FINAL");
            ++propc;
        }
        if (def.isPropExtended()) {
            this.out.write((propc == 0 ? "(" : ",") + "EXTENDED");
            ++propc;
        }
        if (def.isPropTransient()) {
            this.out.write((propc == 0 ? "(" : ",") + "TRANSIENT");
            ++propc;
        }
        if (propc > 0) {
            this.out.write(") ");
        }
        this.out.write(": ");
        boolean isMultiValue = false;
        boolean isMandatory = false;
        Multiplicity m = def.getMultiplicity();
        MultiplicityRange mr = null;
        if (m != null) {
            mr = (MultiplicityRange)m.iteratorRange().next();
            if (mr.getUpper() > 1L) {
                isMultiValue = true;
            }
            if (mr.getLower() == 1L) {
                isMandatory = true;
            }
        }
        if (def.containsAttrType()) {
            DomainAttribute attrType = (DomainAttribute)def.getAttrType();
            if (attrType.containsDomainDef()) {
                if (isMultiValue) {
                    if (def.getOrdering() == 2) {
                        this.out.write("LIST ");
                    } else {
                        this.out.write("BAG ");
                    }
                    this.out.write(this.visitCardinality(mr) + " OF ");
                } else if (isMandatory) {
                    this.out.write("MANDATORY ");
                }
                this.out.write(this.domainRef(def.getOwner(), attrType.getDomainDef()));
                if (isMultiValue && this.useMultiValueStructAttrs) {
                    this.out.write("_");
                }
            } else if (attrType.containsDirect()) {
                if (!(attrType.getDirect() instanceof StructAttrType)) {
                    if (isMultiValue && this.useListBagOfPrimitives) {
                        if (def.getOrdering() == 2) {
                            this.out.write("LIST ");
                        } else {
                            this.out.write("BAG ");
                        }
                        this.out.write(this.visitCardinality(mr) + " OF ");
                    } else if (isMandatory) {
                        this.out.write("MANDATORY ");
                    }
                }
                this.visitType(def, attrType.getDirect());
            }
        } else if (isMandatory) {
            this.out.write("MANDATORY ");
        }
        if (def.containsAttributeValueUsage()) {
            this.visitIliSyntaxLine(def.getAttributeValueUsage());
        }
        this.out.write(";");
        this.newline();
    }

    public String domainRef(ModelElement source, DomainDef ref) {
        return this.modelElementRef(source, ref, null);
    }

    public void visitAttributeDef(RoleDef oppend) throws IOException {
        RoleDef def = ModelElementUtility.getOppEnd(oppend);
        if (RoleDefUtility.isIliStructAttr(def)) {
            MultiplicityRange card;
            this.defineLinkToModelElement(oppend);
            this.visitDocumentation(oppend.getDocumentation());
            this.visitTaggedValues(def);
            this.out.write(this.getIndent());
            this.out.write(this.visitIliName(oppend, oppend.getName().getValue(this.language)) + " ");
            int propc = 0;
            if (oppend.isAbstract()) {
                this.out.write((propc == 0 ? "(" : ",") + "ABSTRACT");
                ++propc;
            }
            if (oppend.isPropFinal()) {
                this.out.write((propc == 0 ? "(" : ",") + "FINAL");
                ++propc;
            }
            if (oppend.isPropExtended()) {
                this.out.write((propc == 0 ? "(" : ",") + "EXTENDED");
                ++propc;
            }
            if (propc > 0) {
                this.out.write(") ");
            }
            this.out.write(": ");
            if (oppend.getMultiplicity() != null) {
                card = (MultiplicityRange)oppend.getMultiplicity().iteratorRange().next();
                if (card.getUpper() == 1L) {
                    if (card.getLower() == 1L) {
                        this.out.write("MANDATORY ");
                    }
                } else if (card.getUpper() > 1L) {
                    if (oppend.getOrdering() == 2) {
                        this.out.write("LIST ");
                    } else {
                        this.out.write("BAG ");
                    }
                    this.out.write(this.visitCardinality(card));
                    this.out.write(" OF ");
                }
            } else if (oppend.getOrdering() == 2) {
                this.out.write("LIST OF ");
            } else {
                this.out.write("BAG OF ");
            }
            if (def.getMultiplicity() != null && (card = (MultiplicityRange)def.getMultiplicity().iteratorRange().next()).getUpper() > 1L) {
                this.logErrorMsg(def, rsrc.getString("CEmaxCardGtOne"));
            }
            String external = "";
            if (oppend.isPropExternal()) {
                external = "(EXTERNAL) ";
            }
            this.out.write(external + this.classRef(def.getParticipant(), (ClassDef)oppend.getParticipant()));
            if (oppend.sizeRestriction() > 0) {
                Iterator restri = oppend.iteratorRestriction();
                this.out.write("RESTRICTED TO ");
                String sep = "";
                while (restri.hasNext()) {
                    ClassDef restr = (ClassDef)restri.next();
                    this.out.write(sep + this.classRef(def.getParticipant(), restr));
                    sep = ", ";
                }
            }
            this.out.write(";");
            this.newline();
        } else {
            this.defineLinkToModelElement(oppend);
            this.visitDocumentation(oppend.getDocumentation());
            this.visitTaggedValues(def);
            this.out.write(this.getIndent());
            this.out.write(this.visitIliName(oppend, oppend.getName().getValue(this.language)) + " ");
            int propc = 0;
            if (oppend.isAbstract()) {
                this.out.write((propc == 0 ? "(" : ",") + "ABSTRACT");
                ++propc;
            }
            if (oppend.isPropFinal()) {
                this.out.write((propc == 0 ? "(" : ",") + "FINAL");
                ++propc;
            }
            if (oppend.isPropExtended()) {
                this.out.write((propc == 0 ? "(" : ",") + "EXTENDED");
                ++propc;
            }
            if (propc > 0) {
                this.out.write(") ");
            }
            this.out.write(": ");
            if (oppend.getMultiplicity() != null) {
                MultiplicityRange card = (MultiplicityRange)oppend.getMultiplicity().iteratorRange().next();
                if (card.getLower() == 1L && card.getUpper() == 1L) {
                    this.out.write("MANDATORY ");
                }
                if (card.getUpper() > 1L) {
                    this.logErrorMsg(oppend, rsrc.getString("CEmaxCardGtOne"));
                }
            }
            String external = "";
            if (oppend.isPropExternal()) {
                external = "(EXTERNAL) ";
            }
            this.out.write("REFERENCE TO " + external + this.classRef(def.getParticipant(), (ClassDef)oppend.getParticipant()));
            if (oppend.sizeRestriction() > 0) {
                Iterator restri = oppend.iteratorRestriction();
                this.out.write("RESTRICTED TO ");
                String sep = "";
                while (restri.hasNext()) {
                    ClassDef restr = (ClassDef)restri.next();
                    this.out.write(sep + this.classRef(def.getParticipant(), restr));
                    sep = ", ";
                }
            }
            this.out.write(";");
            this.newline();
        }
    }

    public void visitType(AbstractModelElement owner, Type def) throws IOException {
        if (def instanceof Text) {
            Text text = (Text)def;
            switch (text.getKind()) {
                case 1: {
                    String typeTag = "TEXT";
                    if (text.isMultiline()) {
                        typeTag = "MTEXT";
                    }
                    this.out.write(typeTag);
                    break;
                }
                case 2: {
                    String typeTag = "TEXT";
                    if (text.isMultiline()) {
                        typeTag = "MTEXT";
                    }
                    this.out.write(typeTag + "*" + Long.toString(text.getMaxLength()));
                    break;
                }
                case 3: {
                    this.out.write("NAME");
                    break;
                }
                case 4: {
                    this.out.write("URI");
                }
            }
        } else if (def instanceof BooleanType) {
            this.out.write("BOOLEAN");
        } else if (def instanceof HorizAlignment) {
            this.out.write("HALIGNMENT");
        } else if (def instanceof VertAlignment) {
            this.out.write("VALIGNMENT");
        } else if (def instanceof UnknownType) {
            UnknownType unknown = (UnknownType)def;
            this.out.write(unknown.getSyntax().getValue(this.language));
        } else if (def instanceof OidType) {
            OidType oid = (OidType)def;
            this.out.write("OID ");
            if (oid.getKind() == 1) {
                this.out.write("ANY");
            } else if (oid.getKind() == 3 || oid.getKind() == 2) {
                this.visitType(owner, oid.getOiddomain());
            }
        } else if (def instanceof BasketType) {
            BasketType basketType = (BasketType)def;
            this.out.write("BASKET");
            int kind = basketType.getKind();
            if (kind == 1) {
                this.out.write(" (DATA)");
            } else if (kind == 2) {
                this.out.write(" (VIEW)");
            } else if (kind == 3) {
                this.out.write(" (BASE)");
            } else if (kind == 4) {
                this.out.write(" (GRAPHIC)");
            }
            if (basketType.containsBasketSchema()) {
                TopicDef schema = basketType.getBasketSchema();
                this.out.write(" OF " + this.topicRef(owner, schema));
            }
        } else if (def instanceof ClassType) {
            ClassType classtype = (ClassType)def;
            if (classtype.getKind() == 1) {
                this.out.write("CLASS");
            } else if (classtype.getKind() == 2) {
                this.out.write("STRUCTURE");
            }
            Iterator restrictioni = classtype.iteratorRestrictedTo();
            if (restrictioni.hasNext()) {
                String sep = " RESTRICTION ( ";
                while (restrictioni.hasNext()) {
                    this.out.write(sep + this.classRef(owner, (AbstractClassDef)restrictioni.next()));
                    sep = "; ";
                }
                this.out.write(" )");
            }
        } else if (def instanceof StructAttrType) {
            boolean useStruct = false;
            boolean isMandatory = false;
            Multiplicity m = ((AttributeDef)owner).getMultiplicity();
            MultiplicityRange mr = null;
            if (m != null) {
                mr = (MultiplicityRange)m.iteratorRange().next();
                if (mr.getUpper() > 1L) {
                    useStruct = true;
                }
                if (mr.getLower() == 1L) {
                    isMandatory = true;
                }
            }
            if (useStruct) {
                if (((AttributeDef)owner).getOrdering() == 2) {
                    this.out.write("LIST ");
                } else {
                    this.out.write("BAG ");
                }
                this.out.write(this.visitCardinality(mr) + " OF ");
            } else if (isMandatory) {
                this.out.write("MANDATORY ");
            }
            StructAttrType structattrtype = (StructAttrType)def;
            if (structattrtype.containsParticipant()) {
                this.out.write(this.classRef(owner, structattrtype.getParticipant()));
            } else {
                this.out.write("ANYSTRUCTURE");
            }
            Iterator restrictioni = structattrtype.iteratorRestrictedTo();
            if (restrictioni.hasNext()) {
                String sep = " RESTRICTION ( ";
                while (restrictioni.hasNext()) {
                    this.out.write(sep + this.classRef(owner, (AbstractClassDef)restrictioni.next()));
                    sep = "; ";
                }
                this.out.write(" )");
            }
        } else if (def instanceof RefAttrType) {
            RefAttrType structattrtype = (RefAttrType)def;
            this.out.write("REFERENCE TO ");
            if (structattrtype.isPropExternal()) {
                this.out.write("(EXTERNAL) ");
            }
            if (structattrtype.containsParticipant()) {
                this.out.write(this.classRef(owner, structattrtype.getParticipant()));
            } else {
                this.out.write("ANYCLASS");
            }
            Iterator restrictioni = structattrtype.iteratorRestrictedTo();
            if (restrictioni.hasNext()) {
                String sep = " RESTRICTION ( ";
                while (restrictioni.hasNext()) {
                    this.out.write(sep + this.classRef(owner, (AbstractClassDef)restrictioni.next()));
                    sep = "; ";
                }
                this.out.write(" )");
            }
        } else if (def instanceof Enumeration) {
            this.visitEnumeration(owner, (Enumeration)def);
        } else if (def instanceof NumericalType) {
            this.visitNumericalType(owner, (NumericalType)def);
        } else if (def instanceof DateType) {
            DateType type = (DateType)def;
            this.out.write("FORMAT INTERLIS.XMLDate ");
            if (this.isDateNull(type.getMin())) {
                this.logErrorMsg(owner, rsrc.getString("CEminvalRequired"));
            } else {
                this.out.write(this.visitDate(type.getMin()));
            }
            this.out.write(" .. ");
            if (this.isDateNull(type.getMax())) {
                this.logErrorMsg(owner, rsrc.getString("CEmaxvalRequired"));
            } else {
                this.out.write(this.visitDate(type.getMax()));
            }
        } else if (def instanceof DateTimeType) {
            DateTimeType type = (DateTimeType)def;
            this.out.write("FORMAT INTERLIS.XMLDateTime ");
            if (this.isDateTimeNull(type.getMin())) {
                this.logErrorMsg(owner, rsrc.getString("CEminvalRequired"));
            } else {
                this.out.write(this.visitDateTime(type.getMin()));
            }
            this.out.write(" .. ");
            if (this.isDateTimeNull(type.getMax())) {
                this.logErrorMsg(owner, rsrc.getString("CEmaxvalRequired"));
            } else {
                this.out.write(this.visitDateTime(type.getMax()));
            }
        } else if (def instanceof TimeType) {
            TimeType type = (TimeType)def;
            this.out.write("FORMAT INTERLIS.XMLTime ");
            if (this.isTimeNull(type.getMin())) {
                this.logErrorMsg(owner, rsrc.getString("CEminvalRequired"));
            } else {
                this.out.write(this.visitTime(type.getMin()));
            }
            this.out.write(" .. ");
            if (this.isTimeNull(type.getMax())) {
                this.logErrorMsg(owner, rsrc.getString("CEmaxvalRequired"));
            } else {
                this.out.write(this.visitTime(type.getMax()));
            }
        } else if (def instanceof InterlisDateType) {
            this.out.write("DATE");
        } else if (def instanceof InterlisDateTimeType) {
            this.out.write("DATETIME");
        } else if (def instanceof InterlisTimeType) {
            this.out.write("TIMEOFDAY");
        } else if (def instanceof CoordinateType) {
            CoordinateType type = (CoordinateType)def;
            this.out.write(type.isMulti() ? "MULTICOORD" : "COORD");
            Iterator dimi = type.iteratorDim();
            String sep = " ";
            while (dimi.hasNext()) {
                this.out.write(sep);
                this.visitNumericalType(owner, (NumericalType)dimi.next());
                sep = ", ";
            }
            if (type.containsRotationDef()) {
                RotationDef rot = type.getRotationDef();
                this.out.write(" ,ROTATION ");
                this.out.write(Long.toString(rot.getNullAxis()));
                this.out.write(" -> ");
                this.out.write(Long.toString(rot.getPihalfAxis()));
            }
        } else if (def instanceof LineType) {
            LineType type = (LineType)def;
            if (type instanceof IliPolyline) {
                IliPolyline iliPolyline = (IliPolyline)type;
                if (iliPolyline.isDirected()) {
                    this.out.write("DIRECTED ");
                }
                this.out.write(iliPolyline.isMulti() ? "MULTIPOLYLINE" : "POLYLINE");
            } else if (type instanceof Tesselation) {
                this.out.write(type.isMulti() ? "MULTIAREA" : "AREA");
            } else if (type instanceof IndividualSurface) {
                this.out.write(type.isMulti() ? "MULTISURFACE" : "SURFACE");
            }
            if (type.containsLineForm()) {
                LineForm form = type.getLineForm();
                this.out.write(" WITH (");
                String sep = "";
                if (form.isArcs()) {
                    this.out.write(sep + "ARCS");
                    sep = ",";
                }
                if (form.isStraights()) {
                    this.out.write(sep + "STRAIGHTS");
                    sep = ",";
                }
                Iterator lfIt = form.iteratorLineFormTypeDef();
                while (lfIt.hasNext()) {
                    this.out.write(sep + this.lineFormTypeRef(owner, (LineFormTypeDef)lfIt.next()));
                    sep = ",";
                }
                this.out.write(")");
            }
            if (type.containsControlpoints()) {
                this.out.write(" VERTEX " + this.domainRef(owner, type.getControlpoints()));
            }
            if (type.containsIntersectionDef()) {
                this.out.write(" WITHOUT OVERLAPS>" + this.visitIliDim(type.getIntersectionDef().getMaxi()));
            }
            if (type instanceof SurfaceType && ((SurfaceType)type).containsLinAttrDef()) {
                this.out.write(" LINE ATTRIBUTES " + this.classRef(owner, ((SurfaceType)type).getLinAttrDef()));
            }
        }
    }

    public String unitRef(ModelElement source, UnitDef ref) {
        return this.modelElementRef(source, ref, null);
    }

    public void visitEnumeration(AbstractModelElement owner, Enumeration def) throws IOException {
        this.out.write("(");
        this.newline();
        this.inc_ind();
        Iterator eleIt = def.iteratorEnumElement();
        while (eleIt.hasNext()) {
            EnumElement ele = (EnumElement)eleIt.next();
            this.visitDocumentation(ele.getDocumentation());
            this.visitTaggedValues(ele);
            this.out.write(this.getIndent() + this.visitIliName(owner, ele.getName().getValue(this.language)));
            if (ele.containsChild()) {
                this.visitEnumeration(owner, ele.getChild());
            }
            if (eleIt.hasNext()) {
                this.out.write(",");
            }
            this.newline();
        }
        this.dec_ind();
        this.out.write(this.getIndent() + ")");
    }

    public void visitNumericalType(AbstractModelElement owner, NumericalType def) throws IOException {
        if (def instanceof NumericType) {
            NumericType ntype = (NumericType)def;
            if (ntype.isRangeDefined()) {
                if (ntype.getMinDec() == null) {
                    this.logErrorMsg(owner, rsrc.getString("CEmindecRequired"));
                } else {
                    this.out.write(this.visitIliDim(ntype.getMinDec()));
                }
                this.out.write(" .. ");
                if (ntype.getMaxDec() == null) {
                    this.logErrorMsg(owner, rsrc.getString("CEmaxdecRequired"));
                } else {
                    this.out.write(this.visitIliDim(ntype.getMaxDec()));
                }
            } else {
                this.out.write("NUMERIC");
            }
            if (ntype.isCircular()) {
                this.out.write(" CIRCULAR");
            }
            if (ntype.containsUnitDef()) {
                this.out.write(" [");
                this.out.write(this.unitRef(owner, ntype.getUnitDef()));
                this.out.write("]");
            }
            if (ntype.containsRefSys()) {
                this.out.write(ntype.getRefSys().getSyntax().getValue(this.language));
            } else if (ntype.getDirection() == 2) {
                this.out.write(" CLOCKWISE");
            } else if (ntype.getDirection() == 3) {
                this.out.write(" COUNTERCLOCKWISE");
            }
        } else if (def instanceof StructuredUnitType) {
            StructuredUnitType ntype = (StructuredUnitType)def;
            this.out.write(this.visitStructDec(ntype.getMinStruc()));
            this.out.write(" .. ");
            this.out.write(this.visitStructDec(ntype.getMaxStruc()));
            if (ntype.isCircular()) {
                this.out.write(" CIRCULAR");
            }
            if (ntype.containsUnitDef()) {
                this.out.write(" [");
                this.out.write(this.unitRef(owner, ntype.getUnitDef()));
                this.out.write("]");
            }
            if (ntype.getDirection() == 2) {
                this.out.write(" CLOCKWISE");
            } else if (ntype.getDirection() == 3) {
                this.out.write(" COUNTERCLOCKWISE");
            }
            if (ntype.containsRefSys()) {
                this.out.write(ntype.getRefSys().getSyntax().getValue(this.language));
            }
        }
    }

    public String visitDate(DateValue def) {
        StringBuffer ret = new StringBuffer();
        ret.append("\"");
        ret.append(this.format0000.format(def.getYear()));
        ret.append("-");
        ret.append(this.format00.format(def.getMonth()));
        ret.append("-");
        ret.append(this.format00.format(def.getDay()));
        ret.append("\"");
        return ret.toString();
    }

    public boolean isDateNull(DateValue def) {
        return def == null;
    }

    public String visitDateTime(DateTimeValue def) {
        StringBuffer ret = new StringBuffer();
        ret.append("\"");
        ret.append(this.format0000.format(def.getYear()));
        ret.append("-");
        ret.append(this.format00.format(def.getMonth()));
        ret.append("-");
        ret.append(this.format00.format(def.getDay()));
        ret.append("T");
        ret.append(this.format00.format(def.getHours()));
        ret.append(":");
        ret.append(this.format00.format(def.getMinutes()));
        ret.append(":");
        ret.append(this.formatSeconds.format(def.getSeconds()));
        ret.append("\"");
        return ret.toString();
    }

    public boolean isDateTimeNull(DateTimeValue def) {
        return def == null;
    }

    public String visitTime(TimeValue def) {
        StringBuffer ret = new StringBuffer();
        ret.append("\"");
        ret.append(this.format00.format(def.getHours()));
        ret.append(":");
        ret.append(this.format00.format(def.getMinutes()));
        ret.append(":");
        ret.append(this.formatSeconds.format(def.getSeconds()));
        ret.append("\"");
        return ret.toString();
    }

    public boolean isTimeNull(TimeValue def) {
        return def == null;
    }

    public String visitIliDim(IliDim def) {
        return def.toString();
    }

    public String visitStructDec(StructDec def) {
        return def.toString();
    }

    public String lineFormTypeRef(ModelElement source, LineFormTypeDef ref) {
        return this.modelElementRef(source, ref, null);
    }

    public void visitRoleDef(RoleDef def) throws IOException {
        Iterator xori;
        this.defineLinkToModelElement(def);
        this.visitDocumentation(def.getDocumentation());
        this.visitTaggedValues(def);
        this.out.write(this.getIndent());
        this.out.write(this.visitIliName(def, def.getName().getValue(this.language)) + " ");
        int propc = 0;
        if (def.isAbstract()) {
            this.out.write((propc == 0 ? "(" : ",") + "ABSTRACT");
            ++propc;
        }
        if (def.isPropFinal()) {
            this.out.write((propc == 0 ? "(" : ",") + "FINAL");
            ++propc;
        }
        if (def.isPropExtended()) {
            this.out.write((propc == 0 ? "(" : ",") + "EXTENDED");
            ++propc;
        }
        if (def.isPropExternal()) {
            this.out.write((propc == 0 ? "(" : ",") + "EXTERNAL");
            ++propc;
        }
        if (def.getOrdering() == 2) {
            this.out.write((propc == 0 ? "(" : ",") + "ORDERED");
            ++propc;
        }
        if (propc > 0) {
            this.out.write(") ");
        }
        switch (def.getAggregation()) {
            case 1: {
                this.out.write("-- ");
                break;
            }
            case 2: {
                this.out.write("-<> ");
                break;
            }
            case 3: {
                this.out.write("-<#> ");
            }
        }
        if (def.getMultiplicity() != null) {
            MultiplicityRange card = (MultiplicityRange)def.getMultiplicity().iteratorRange().next();
            this.out.write(this.visitCardinality(card) + " ");
        }
        if (def.containsParticipant()) {
            this.out.write(this.classRef(def.getAssociation(), (AbstractClassDef)def.getParticipant()));
        } else {
            this.logErrorMsg(def, rsrc.getString("CEnoParticipant"));
        }
        String sep = " RESTRICTION ( ";
        Iterator restrictioni = def.iteratorRestriction();
        if (restrictioni.hasNext()) {
            while (restrictioni.hasNext()) {
                this.out.write(sep + this.classRef(def.getAssociation(), (AbstractClassDef)restrictioni.next()));
                sep = "; ";
            }
            this.out.write(")");
        }
        if ((xori = def.iteratorXorParticipant()).hasNext()) {
            this.inc_ind();
            while (xori.hasNext()) {
                Participant xor = (Participant)xori.next();
                this.newline();
                this.out.write(this.getIndent() + " OR ");
                if (xor.containsParticipant()) {
                    this.out.write(this.classRef(def.getAssociation(), xor.getParticipant()));
                } else {
                    this.logErrorMsg(def, rsrc.getString("CEnoParticipant"));
                }
                String sep2 = " RESTRICTION ( ";
                Iterator restrictioni2 = xor.iteratorRestriction();
                if (!restrictioni2.hasNext()) continue;
                while (restrictioni2.hasNext()) {
                    this.out.write(sep2 + this.classRef(def.getAssociation(), (AbstractClassDef)restrictioni2.next()));
                    sep2 = "; ";
                }
                this.out.write(")");
            }
            this.dec_ind();
            this.newline();
            this.out.write(this.getIndent());
        }
        if (def.containsRoleDefDerived()) {
            this.visitIliSyntaxLine(def.getRoleDefDerived());
        }
        this.out.write(";");
        this.newline();
    }

    public String visitCardinality(MultiplicityRange def) {
        String ret = def.getUpper() == Long.MAX_VALUE ? "{" + Long.toString(def.getLower()) + "..*}" : (def.getLower() == def.getUpper() ? "{" + Long.toString(def.getLower()) + "}" : "{" + Long.toString(def.getLower()) + ".." + Long.toString(def.getUpper()) + "}");
        return ret;
    }

    private void sortIliFiles() {
        TopoSort ts = new TopoSort();
        for (FileListEntry f : this.tempFiles) {
            ts.add((Object)f);
        }
        for (IliFileCond cond : this.filedep) {
            FileListEntry after;
            FileListEntry before = (FileListEntry)this.model2file.get(cond.before);
            if (before == (after = (FileListEntry)this.model2file.get(cond.after)) || before == null || after == null) continue;
            ts.addcond((Object)before, (Object)after);
        }
        if (ts.sort()) {
            this.tempFiles = ts.getResult();
            return;
        }
        StringBuffer loopele = new StringBuffer();
        Iterator resi = ts.getResult().iterator();
        String sep = "";
        while (resi.hasNext()) {
            FileListEntry res = (FileListEntry)resi.next();
            loopele.append(sep);
            loopele.append(res.file.getName());
            sep = "->";
        }
        this.logErrorMsg("loop in ili-files: " + loopele.toString());
    }

    private List sortIliDefs(Set children) {
        TopoSort ts = new TopoSort();
        for (ModelElement def : children) {
            ts.add((Object)def);
            if (def instanceof TopicDef) {
                TopicDef topicDef = (TopicDef)def;
                for (ModelElement child : ModelElementUtility.getChildElements(topicDef, null)) {
                    if (child == def || child instanceof TopicDef) continue;
                    this.addSimpleEleCond(children, ts, topicDef, child);
                }
            }
            if (def instanceof TopicDef) {
                for (ModelElement child : children) {
                    if (child == def || child instanceof TopicDef || !this.isDependentOnTopic(child, (TopicDef)def)) continue;
                    ts.addcond((Object)def, (Object)child);
                }
            }
            this.addSimpleEleCond(children, ts, def, def);
        }
        if (ts.sort()) {
            ArrayList<Pair> pairv = new ArrayList<Pair>();
            int[] levv = ts.getLevel();
            ArrayList<Object> objv = ts.getResult();
            Iterator obji = objv.iterator();
            int i = 0;
            while (obji.hasNext()) {
                pairv.add(new Pair(levv[i], obji.next()));
                ++i;
            }
            Collections.sort(pairv, new Comparator(){

                public int compare(Object o_1, Object o_2) {
                    Pair p1 = (Pair)o_1;
                    Pair p2 = (Pair)o_2;
                    if (p1.level < p2.level) {
                        return -1;
                    }
                    if (p2.level < p1.level) {
                        return 1;
                    }
                    int def = ModelElementUtility.compareDefinition(p1.object.getClass(), p2.object.getClass());
                    if (def != 0) {
                        return def;
                    }
                    String name1 = TransferFromUmlMetamodel.getName4sorting(p1.object);
                    String name2 = TransferFromUmlMetamodel.getName4sorting(p2.object);
                    int compareName = name1.compareToIgnoreCase(name2);
                    return compareName;
                }
            });
            objv = new ArrayList<Object>();
            Iterator pairi = pairv.iterator();
            while (pairi.hasNext()) {
                objv.add(((Pair)pairi.next()).object);
            }
            return objv;
        }
        StringBuffer loopele = new StringBuffer();
        Iterator resi = ts.getResult().iterator();
        String sep = "";
        while (resi.hasNext()) {
            ModelElement res = (ModelElement)resi.next();
            loopele.append(sep);
            loopele.append(res.getName().getValue(this.language));
            sep = "->";
        }
        this.logErrorMsg("loop in definitions: " + loopele.toString());
        return new LinkedList(children);
    }

    private void addSimpleEleCond(Set children, TopoSort ts, ModelElement defDef, ModelElement defEle) {
        DomainDef domain;
        AbstractNamespace supplier;
        RoleDef role;
        Object obj;
        ModelElement supplier2;
        Iterator i = defEle.iteratorClientDependency();
        while (i.hasNext()) {
            Dependency dep = (Dependency)i.next();
            Iterator j = dep.iteratorSupplier();
            while (j.hasNext()) {
                supplier2 = (ModelElement)j.next();
                if (!children.contains(supplier2)) continue;
                ts.addcond((Object)supplier2, (Object)defDef);
            }
        }
        if (defEle instanceof GeneralizableElement) {
            i = ((GeneralizableElement)defEle).iteratorGeneralization();
            while (i.hasNext()) {
                GeneralizableElement supplier3;
                Generalization gen = (Generalization)i.next();
                if (!gen.containsParent() || !children.contains(supplier3 = gen.getParent())) continue;
                ts.addcond((Object)supplier3, (Object)defDef);
            }
        }
        if (defEle instanceof AbstractClassDef) {
            i = ((AbstractClassDef)defEle).iteratorAssociation();
            while (i.hasNext()) {
                AbstractClassDef supplier4;
                obj = i.next();
                if (!(obj instanceof RoleDef) || (role = (RoleDef)obj).getAssociation().sizeConnection() > 2 || !RoleDefUtility.isIliAttr(role)) continue;
                RoleDef oppend = ModelElementUtility.getOppEnd(role);
                if (oppend.containsParticipant()) {
                    Classifier supplierc = oppend.getParticipant();
                    supplier4 = (AbstractClassDef)oppend.getParticipant();
                    if (children.contains(supplier4)) {
                        ts.addcond((Object)supplier4, (Object)defDef);
                    }
                }
                if (oppend.sizeRestriction() <= 0) continue;
                Iterator restri = oppend.iteratorRestriction();
                while (restri.hasNext()) {
                    supplier4 = (AbstractClassDef)restri.next();
                    if (!children.contains(supplier4)) continue;
                    ts.addcond((Object)supplier4, (Object)defDef);
                }
            }
        }
        if (defEle instanceof AssociationDef && !((AssociationDef)defEle).isStructureAttribute() && !((AssociationDef)defEle).isReferenceAttribute()) {
            i = ((AssociationDef)defEle).iteratorConnection();
            while (i.hasNext()) {
                obj = i.next();
                if (!(obj instanceof RoleDef)) continue;
                role = (RoleDef)obj;
                if (role.containsParticipant() && children.contains(supplier2 = (AbstractClassDef)role.getParticipant())) {
                    ts.addcond((Object)supplier2, (Object)defDef);
                }
                Iterator restrictioni = role.iteratorRestriction();
                while (restrictioni.hasNext()) {
                    supplier = (AbstractClassDef)restrictioni.next();
                    if (!children.contains(supplier)) continue;
                    ts.addcond((Object)supplier, (Object)defDef);
                }
            }
        }
        if (defEle instanceof AbstractClassDef) {
            i = ((AbstractClassDef)defEle).iteratorFeature();
            while (i.hasNext()) {
                AttributeDef attr;
                obj = i.next();
                if (!(obj instanceof AttributeDef) || !(attr = (AttributeDef)obj).containsAttrType()) continue;
                DomainAttribute attrType = (DomainAttribute)attr.getAttrType();
                if (attrType.containsDomainDef() && children.contains(supplier = attrType.getDomainDef())) {
                    ts.addcond((Object)supplier, (Object)defDef);
                }
                if (!attrType.containsDirect()) continue;
                this.addTypeCondition(children, ts, defDef, attrType.getDirect());
            }
        }
        if (defEle instanceof DomainDef && (domain = (DomainDef)defEle).containsType()) {
            this.addTypeCondition(children, ts, defDef, domain.getType());
        }
    }

    private boolean isDependentOnTopic(ModelElement client, TopicDef supplierTopic) {
        if (client instanceof AbstractClassDef) {
            Iterator i = ((AbstractClassDef)client).iteratorAssociation();
            while (i.hasNext()) {
                AbstractClassDef supplier;
                RoleDef role;
                Object obj = i.next();
                if (!(obj instanceof RoleDef) || (role = (RoleDef)obj).getAssociation().sizeConnection() > 2 || !RoleDefUtility.isIliAttr(role)) continue;
                RoleDef oppend = ModelElementUtility.getOppEnd(role);
                if (oppend.containsParticipant()) {
                    Classifier supplierc = oppend.getParticipant();
                    supplier = (AbstractClassDef)oppend.getParticipant();
                    if (supplier.containsParentTopicDef() && supplier.getParentTopicDef().equals(supplierTopic)) {
                        return true;
                    }
                }
                if (oppend.sizeRestriction() <= 0) continue;
                Iterator restri = oppend.iteratorRestriction();
                while (restri.hasNext()) {
                    supplier = (AbstractClassDef)restri.next();
                    if (!supplier.containsParentTopicDef() || !supplier.getParentTopicDef().equals(supplierTopic)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String getName4sorting(Object ele) {
        String name1 = NavigationTreeNodeUtility.getName(ele);
        if (name1 == null) {
            name1 = "";
        }
        if (name1.equals("") && ele instanceof AssociationDef) {
            Iterator ri = ((AssociationDef)ele).iteratorConnection();
            StringBuffer nb = new StringBuffer();
            while (ri.hasNext()) {
                RoleDef role;
                String n;
                Object obj = ri.next();
                if (!(obj instanceof RoleDef) || (n = (role = (RoleDef)obj).getDefLangName()) == null) continue;
                nb.append(n);
            }
            name1 = nb.toString();
        }
        return name1;
    }

    private void addTypeCondition(Set children, TopoSort ts, ModelElement def, Type type) {
        if (type instanceof NumericalType) {
            this.addNumericalTypeCondition(children, ts, def, (NumericalType)type);
        } else if (type instanceof CoordinateType) {
            CoordinateType ctype = (CoordinateType)type;
            Iterator dimi = ctype.iteratorDim();
            while (dimi.hasNext()) {
                this.addNumericalTypeCondition(children, ts, def, (NumericalType)dimi.next());
            }
        } else if (type instanceof ClassType) {
            ClassType classtype = (ClassType)type;
            Iterator restrictioni = classtype.iteratorRestrictedTo();
            if (restrictioni.hasNext()) {
                while (restrictioni.hasNext()) {
                    AbstractClassDef supplier = (AbstractClassDef)restrictioni.next();
                    if (!children.contains(supplier)) continue;
                    ts.addcond((Object)supplier, (Object)def);
                }
            }
        } else if (type instanceof StructAttrType) {
            Iterator restrictioni;
            ClassDef supplier;
            StructAttrType structattrtype = (StructAttrType)type;
            if (structattrtype.containsParticipant() && children.contains(supplier = structattrtype.getParticipant())) {
                ts.addcond((Object)supplier, (Object)def);
            }
            if ((restrictioni = structattrtype.iteratorRestrictedTo()).hasNext()) {
                while (restrictioni.hasNext()) {
                    AbstractClassDef supplier2 = (AbstractClassDef)restrictioni.next();
                    if (!children.contains(supplier2)) continue;
                    ts.addcond((Object)supplier2, (Object)def);
                }
            }
        } else if (type instanceof RefAttrType) {
            Iterator restrictioni;
            AbstractClassDef supplier;
            RefAttrType refattrtype = (RefAttrType)type;
            if (refattrtype.containsParticipant() && children.contains(supplier = refattrtype.getParticipant())) {
                ts.addcond((Object)supplier, (Object)def);
            }
            if ((restrictioni = refattrtype.iteratorRestrictedTo()).hasNext()) {
                while (restrictioni.hasNext()) {
                    AbstractClassDef supplier3 = (AbstractClassDef)restrictioni.next();
                    if (!children.contains(supplier3)) continue;
                    ts.addcond((Object)supplier3, (Object)def);
                }
            }
        } else if (type instanceof LineType) {
            AbstractNamespace supplier;
            LineType ltype = (LineType)type;
            if (ltype.containsLineForm()) {
                LineForm form = ltype.getLineForm();
                Iterator lfIt = form.iteratorLineFormTypeDef();
                while (lfIt.hasNext()) {
                    LineFormTypeDef supplier4 = (LineFormTypeDef)lfIt.next();
                    if (!children.contains(supplier4)) continue;
                    ts.addcond((Object)supplier4, (Object)def);
                }
            }
            if (ltype.containsControlpoints() && children.contains(supplier = ltype.getControlpoints())) {
                ts.addcond((Object)supplier, (Object)def);
            }
            if (type instanceof SurfaceType && ((SurfaceType)type).containsLinAttrDef() && children.contains(supplier = ((SurfaceType)type).getLinAttrDef())) {
                ts.addcond((Object)supplier, (Object)def);
            }
        }
    }

    private void addNumericalTypeCondition(Set children, TopoSort ts, ModelElement def, NumericalType type) {
        UnitDef supplier;
        if (type.containsUnitDef() && children.contains(supplier = type.getUnitDef())) {
            ts.addcond((Object)supplier, (Object)def);
        }
    }

    public String modelElementRef(ModelElement source, ModelElement ref, String language) {
        IliImport iliImp;
        if (language == null) {
            language = this.language;
        }
        ModelDef modelOfSource = null;
        ModelDef modelOfRef = null;
        modelOfSource = ModelElementUtility.getModel(source);
        modelOfRef = ModelElementUtility.getModel(ref);
        if (!modelOfRef.equals(modelOfSource) && (iliImp = modelOfSource.getImport(modelOfRef)) != null) {
            language = iliImp.getSupplierLanguage(language);
        }
        return ModelElementUtility.getIliQualifiedName(source, ref, language);
    }

    public void visitDocumentation(NlsString nlsdoc) throws IOException {
        String line;
        if (nlsdoc == null) {
            return;
        }
        String doc = nlsdoc.getValue(this.language).trim();
        if (doc.length() == 0) {
            return;
        }
        String beg = "/** ";
        int last = 0;
        int next = doc.indexOf("\n", last);
        while (next > -1) {
            line = doc.substring(last, next);
            this.out.write(this.getIndent() + beg + line);
            this.newline();
            beg = " * ";
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        this.out.write(this.getIndent() + beg + line);
        this.newline();
        this.out.write(this.getIndent() + " */");
        this.newline();
    }

    public void visitExplanation(NlsString nlsdoc) throws IOException {
        String line;
        if (nlsdoc == null) {
            return;
        }
        String doc = nlsdoc.getValue(this.language).trim();
        if (doc.length() == 0) {
            return;
        }
        String beg = "// ";
        boolean multiline = false;
        int last = 0;
        int next = doc.indexOf("\n", last);
        if (next > -1) {
            multiline = true;
            this.newline();
            this.inc_ind();
        }
        while (next > -1) {
            line = doc.substring(last, next);
            this.out.write(this.getIndent() + beg + line);
            this.newline();
            beg = "   ";
            last = next + 1;
            next = doc.indexOf("\n", last);
        }
        line = doc.substring(last);
        if (multiline) {
            this.out.write(this.getIndent());
        } else {
            this.out.write(" ");
        }
        this.out.write(beg + line);
        if (multiline) {
            this.newline();
        }
        this.out.write(this.getIndent() + " //");
        if (multiline) {
            this.dec_ind();
        }
    }

    private void newline() throws IOException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        this.out.write(nl);
        ++this.lineNumber;
    }

    private String getIndent() {
        return StringUtility.STRING((int)(this.ind * 2), (char)' ');
    }

    private void inc_ind() {
        ++this.ind;
    }

    private void dec_ind() {
        --this.ind;
    }

    private void logErrorMsg(AbstractModelElement def, String msg) {
        LauncherView.getInstance().log(def.getOid(), this.getFuncDesc(), msg);
        ++this.errc;
    }

    private void logErrorMsg(String msg) {
        LauncherView.getInstance().log(this.getFuncDesc(), msg);
        ++this.errc;
    }

    private void defineLinkToModelElement(AbstractEditorElement def) {
        if (this.currentFile != null) {
            this.currentFile.add(this.lineNumber, def);
        }
    }

    private String findElementId(String filename, int line) {
        if (filename == null || line == 0) {
            return null;
        }
        for (FileListEntry f : this.tempFiles) {
            if (!f.file.getAbsolutePath().equals(filename)) continue;
            String id = null;
            for (ModelElementEntry m : f.modelElements) {
                if (m.line > line) break;
                id = m.def.getOid();
            }
            return id;
        }
        return null;
    }

    public String getFuncDesc() {
        if (this.runIli2c) {
            return rsrc.getString("CIcheckmodel");
        }
        return rsrc.getString("CIexportinterlis");
    }

    public void runCompiler(Namespace ns, Configuration config, Settings settings) throws IOException {
        this.runIli2c = true;
        this.visitNamespace(ns, config, settings);
    }

    public void writeIliFile(INTERLIS2Def ili) throws IOException {
        this.visitINTERLIS2Def(ili);
    }

    public void writeIliFiles(Namespace ns) throws IOException {
        this.visitNamespace(ns, null, null);
    }

    public List getFileList(Namespace ns) throws IOException {
        try {
            this.createFileList = true;
            this.fileList = new ArrayList();
            this.visitNamespace(ns, null, null);
        }
        finally {
            this.createFileList = false;
        }
        return this.fileList;
    }

    private void flushDomainStructs() throws IOException {
        if (this.useMultiValueStructAttrs) {
            for (DomainDef def : this.domainStructs) {
                String name = def.getName().getValue(this.language);
                this.out.write(this.getIndent() + "STRUCTURE " + name + "_ ");
                boolean extended = false;
                Iterator extendsi = def.iteratorGeneralization();
                while (extendsi.hasNext()) {
                    DomainExtends extend;
                    Object obj = extendsi.next();
                    if (!(obj instanceof DomainExtends) || !(extend = (DomainExtends)obj).containsParent()) continue;
                    DomainDef supplier = (DomainDef)extend.getParent();
                    if (!this.flushedDomainStructs.contains(supplier)) break;
                    this.out.write("EXTENDS " + this.domainRef(def, supplier) + "_ ");
                    extended = true;
                    break;
                }
                this.out.write("= value " + (extended ? "(EXTENDED)" : "") + ": MANDATORY " + name + "; END " + name + "_;");
                this.newline();
            }
        }
        this.flushedDomainStructs.addAll(this.domainStructs);
        this.domainStructs.clear();
    }

    public void visitIliSyntaxLine(IliSyntax element) throws IOException {
        String line;
        NlsString defNls = element.getSyntax();
        String def = defNls != null ? defNls.getValue(this.language) : "";
        int last = 0;
        int next = def.indexOf("\n", last);
        String nextIndent = "";
        while (next > -1) {
            line = def.substring(last, next);
            this.out.write(nextIndent + line);
            this.newline();
            last = next + 1;
            next = def.indexOf("\n", last);
            nextIndent = this.getIndent();
        }
        line = def.substring(last);
        this.out.write(nextIndent + line);
    }

    private String visitIliName(AbstractModelElement def, String name) throws IOException {
        if (!name.matches("[a-zA-Z][a-zA-Z_0-9]*")) {
            this.logErrorMsg(def, MessageFormat.format((java.util.ResourceBundle)rsrc, (String)"CEillegalIliName", (String)name));
        }
        return name;
    }

    class Pair {
        public int level;
        public Object object;

        Pair(int level, Object object) {
            this.level = level;
            this.object = object;
        }
    }

    class MyErrorListener
    implements LogListenerCompilerMsgMapper {
        MyErrorListener() {
        }

        @Override
        public String getId(CompilerLogEvent evt) {
            int line = evt.getLine();
            String filename = evt.getFilename();
            String id = null;
            id = TransferFromUmlMetamodel.this.findElementId(filename, line);
            if (id != null) {
                return id;
            }
            return null;
        }

        @Override
        public String getTitle() {
            return TransferFromUmlMetamodel.this.getFuncDesc();
        }
    }

    private class IliFileCond {
        public String before;
        public String after;

        public IliFileCond(String before1, String after1) {
            this.before = before1;
            this.after = after1;
        }
    }

    class FileListEntry {
        public File file;
        public List modelElements;

        public FileListEntry(File file) {
            this.file = file;
            this.modelElements = new ArrayList();
        }

        public void add(int linenumber, AbstractEditorElement def) {
            this.modelElements.add(new ModelElementEntry(linenumber, def));
        }
    }

    class ModelElementEntry {
        public int line;
        public AbstractEditorElement def;

        public ModelElementEntry(int line, AbstractEditorElement def) {
            this.line = line;
            this.def = def;
        }
    }
}

