/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.wkb.ByteArrayOutputStream;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import ch.interlis.iox_j.wkb.RingCollector;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class Iox2wkb {
    private int outputDimension = 2;
    private ByteArrayOutputStream os = null;
    private boolean asEWKB = true;

    public Iox2wkb(int outputDimension) {
        this(outputDimension, ByteOrder.BIG_ENDIAN, true);
    }

    public Iox2wkb(int outputDimension, ByteOrder byteOrder) {
        this(outputDimension, byteOrder, true);
    }

    public Iox2wkb(int outputDimension, ByteOrder byteOrder, boolean asEWKB) {
        this.outputDimension = outputDimension;
        this.asEWKB = asEWKB;
        this.os = new ByteArrayOutputStream(byteOrder);
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(Iox2wkb.toHexDigit(b >> 4 & 0xF));
            buf.append(Iox2wkb.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public byte[] coord2wkb(IomObject value) throws Iox2wkbException {
        if (value == null) {
            return null;
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(1);
            this.writeCoord(value);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multicoord2wkb(IomObject obj) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            this.writeGeometryType(4);
            int coordc = obj.getattrvaluecount("coord");
            this.os.writeInt(coordc);
            for (int coordi = 0; coordi < coordc; ++coordi) {
                IomObject coord = obj.getattrobj("coord", coordi);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.coord2wkb(coord));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeCoord(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        double zCoord = 0.0;
        if (this.outputDimension == 3) {
            if (c3 != null) {
                try {
                    zCoord = Double.parseDouble(c3);
                }
                catch (Exception ex) {
                    throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
                }
            } else {
                throw new Iox2wkbException("missing C3");
            }
        }
        this.writeCoord(xCoord, yCoord, zCoord);
    }

    private static Coordinate arcSupportingCoord2JTS(IomObject value) throws Iox2wkbException {
        double arcPt_ho;
        double arcPt_re;
        String a1 = value.getattrvalue("A1");
        String a2 = value.getattrvalue("A2");
        try {
            arcPt_re = Double.parseDouble(a1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read A1 <" + a1 + ">", ex);
        }
        try {
            arcPt_ho = Double.parseDouble(a2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read A2 <" + a2 + ">", ex);
        }
        return new Coordinate(arcPt_re, arcPt_ho);
    }

    private static Coordinate coord2JTS(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        Coordinate coord = null;
        if (c3 == null) {
            coord = new Coordinate(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
            }
            coord = new Coordinate(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    public byte[] polyline2wkb(IomObject polylineObj, boolean isSurfaceOrArea, boolean asCompoundCurve, double p) throws Iox2wkbException {
        if (polylineObj == null) {
            return null;
        }
        IomObject[] polylineObjs = new IomObject[]{polylineObj};
        return this.polyline2wkb(polylineObjs, isSurfaceOrArea, asCompoundCurve, p);
    }

    public byte[] polyline2wkb(IomObject[] polylineObjs, boolean isSurfaceOrArea, boolean asCompoundCurve, double p) throws Iox2wkbException {
        ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>();
        for (int polylinei = 0; polylinei < polylineObjs.length; ++polylinei) {
            IomObject polyline = polylineObjs[polylinei];
            lines.addAll(this.collectSegments(new IomObject[]{polyline}, asCompoundCurve, p, false));
        }
        try {
            this.os.reset();
            for (CompoundCurve line : lines) {
                if (asCompoundCurve) {
                    this.writeCompoundCurve(line);
                    continue;
                }
                this.writeLineString(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private List<CompoundCurve> collectSegments(IomObject[] polylineObjs, boolean asCompoundCurve, double p, boolean repairTouchingLine) throws Iox2wkbException {
        if (repairTouchingLine) {
            RingCollector ringCollector = new RingCollector();
            for (IomObject polylineObj : polylineObjs) {
                CompoundCurve poly;
                if (polylineObj == null) continue;
                try {
                    poly = Iox2jtsext.polyline2JTS(polylineObj, false, p);
                }
                catch (IoxException e) {
                    throw new Iox2wkbException(e);
                }
                ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>();
                for (CurveSegment seg : poly.getSegments()) {
                    if (seg instanceof ArcSegment) {
                        seg = new ArcSegment(((ArcSegment)seg).getStartPoint(), ((ArcSegment)seg).getMidPoint(), ((ArcSegment)seg).getEndPoint(), p);
                    }
                    segs.add(seg);
                }
                poly = new CompoundCurve(segs, new JtsextGeometryFactory());
                ringCollector.addLine(poly);
            }
            return ringCollector.getRings();
        }
        ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>();
        ArrayList<CurveSegment> segs = new ArrayList<CurveSegment>();
        for (IomObject polylineObj : polylineObjs) {
            CompoundCurve poly;
            if (polylineObj == null) continue;
            try {
                poly = Iox2jtsext.polyline2JTS(polylineObj, false, p);
            }
            catch (IoxException e) {
                throw new Iox2wkbException(e);
            }
            for (CurveSegment seg : poly.getSegments()) {
                if (seg instanceof ArcSegment) {
                    seg = new ArcSegment(((ArcSegment)seg).getStartPoint(), ((ArcSegment)seg).getMidPoint(), ((ArcSegment)seg).getEndPoint(), p);
                }
                segs.add(seg);
            }
        }
        lines.add(new CompoundCurve(segs, new JtsextGeometryFactory()));
        return lines;
    }

    @Deprecated
    public byte[] surface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP) throws Iox2wkbException {
        return this.surface2wkb(obj, asCurvePolygon, strokeP, true);
    }

    public byte[] surface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP, boolean repairTouchingLine) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        if (obj.getobjectconsistency() == 1) {
            throw new Iox2wkbException("clipped surface not supported");
        }
        ArrayList<CompoundCurve> rings = new ArrayList<CompoundCurve>();
        for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
            if (surfacei > 0) {
                throw new Iox2wkbException("unclipped surface with multi 'surface' elements");
            }
            IomObject surface = obj.getattrobj("surface", surfacei);
            int boundaryc = surface.getattrvaluecount("boundary");
            for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                int polylinec = boundary.getattrvaluecount("polyline");
                ArrayList<IomObject> polylines = new ArrayList<IomObject>();
                for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    if (polyline.getattrobj("lineattr", 0) != null) {
                        throw new Iox2wkbException("Lineattributes not supported");
                    }
                    if (polyline.getobjectconsistency() == 1) {
                        throw new Iox2wkbException("clipped polyline not supported");
                    }
                    polylines.add(polyline);
                }
                rings.addAll(this.collectSegments(polylines.toArray(new IomObject[polylines.size()]), asCurvePolygon, strokeP, repairTouchingLine));
            }
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(asCurvePolygon ? 10 : 3);
            this.os.writeInt(rings.size());
            for (CompoundCurve ring : rings) {
                if (asCurvePolygon) {
                    this.writeCompoundCurve(ring);
                    continue;
                }
                this.writeWkblinearring(ring);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    @Deprecated
    public byte[] multisurface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP) throws Iox2wkbException {
        return this.multisurface2wkb(obj, asCurvePolygon, strokeP, true);
    }

    public byte[] multisurface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP, boolean repairTouchingLine) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            this.writeGeometryType(asCurvePolygon ? 12 : 6);
            int surfacec = obj.getattrvaluecount("surface");
            this.os.writeInt(surfacec);
            for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                IomObject surface = obj.getattrobj("surface", surfacei);
                Iom_jObject iomSurfaceClone = new Iom_jObject("MULTISURFACE", null);
                iomSurfaceClone.addattrobj("surface", surface);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.surface2wkb(iomSurfaceClone, asCurvePolygon, strokeP, repairTouchingLine));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multiline2wkb(IomObject obj, boolean asCurve, double strokeP) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        int polylinec = obj.getattrvaluecount("polyline");
        ArrayList<CompoundCurve> lines = new ArrayList<CompoundCurve>();
        for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
            IomObject polyline = obj.getattrobj("polyline", polylinei);
            if (polyline.getobjectconsistency() == 1) {
                throw new Iox2wkbException("clipped polyline not supported");
            }
            lines.addAll(this.collectSegments(new IomObject[]{polyline}, asCurve, strokeP, false));
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(asCurve ? 11 : 5);
            this.os.writeInt(lines.size());
            for (CompoundCurve line : lines) {
                if (asCurve) {
                    this.writeCompoundCurve(line);
                    continue;
                }
                this.writeLineString(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeByteOrder() throws IOException {
        if (this.os.order().equals(ByteOrder.LITTLE_ENDIAN)) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
    }

    private void writeGeometryType(int geometryType) throws IOException {
        int flagIncludeZ = this.asEWKB ? Integer.MIN_VALUE : 1000;
        int flag3D = this.outputDimension == 3 ? flagIncludeZ : 0;
        int typeInt = geometryType + flag3D;
        this.os.writeInt(typeInt);
    }

    private void writeLineString(CompoundCurve line) throws IOException {
        this.writeByteOrder();
        this.writeGeometryType(2);
        this.os.writeInt(line.getCoordinates().length);
        this.writeCoords(line.getCoordinates());
    }

    private void writeWkblinearring(CompoundCurve line) throws IOException {
        this.os.writeInt(line.getCoordinates().length);
        this.writeCoords(line.getCoordinates());
    }

    private void writeCompoundCurve(CompoundCurve segments) throws IOException {
        int idx;
        this.writeByteOrder();
        this.writeGeometryType(9);
        int max = segments.getNumSegments();
        ArrayList<Integer> starts = new ArrayList<Integer>();
        ArrayList<Integer> ends = new ArrayList<Integer>();
        int start = 0;
        Class<?> startType = segments.getSegments().get(0).getClass();
        for (idx = 1; idx < max; ++idx) {
            if (startType.equals(segments.getSegments().get(idx).getClass())) continue;
            starts.add(start);
            ends.add(idx);
            start = idx;
            startType = segments.getSegments().get(idx).getClass();
        }
        starts.add(start);
        ends.add(idx);
        this.os.writeInt(starts.size());
        for (start = 0; start < starts.size(); ++start) {
            startType = segments.getSegments().get((Integer)starts.get(start)).getClass();
            int wkbType = startType == StraightSegment.class ? 2 : 8;
            this.writeByteOrder();
            this.writeGeometryType(wkbType);
            int coordc = (Integer)ends.get(start) - (Integer)starts.get(start);
            if (wkbType == 8) {
                coordc *= 2;
            }
            this.os.writeInt(++coordc);
            this.writeCoord(segments.getSegments().get((Integer)starts.get(start)).getStartPoint());
            if (wkbType == 2) {
                for (idx = ((Integer)starts.get(start)).intValue(); idx < (Integer)ends.get(start); ++idx) {
                    this.writeCoord(segments.getSegments().get(idx).getEndPoint());
                }
                continue;
            }
            for (idx = ((Integer)starts.get(start)).intValue(); idx < (Integer)ends.get(start); ++idx) {
                this.writeCoord(((ArcSegment)segments.getSegments().get(idx)).getMidPoint());
                this.writeCoord(segments.getSegments().get(idx).getEndPoint());
            }
        }
    }

    private void writeCoords(Iterable<Coordinate> coordinates) {
        for (Coordinate c : coordinates) {
            this.writeCoord(c);
        }
    }

    private void writeCoords(Coordinate[] coordinates) {
        for (Coordinate c : coordinates) {
            this.writeCoord(c);
        }
    }

    private void writeCoord(Coordinate coordinate) {
        this.writeCoord(coordinate.x, coordinate.y, coordinate.z);
    }

    private void writeCoord(double xCoord, double yCoord, double zCoord) {
        this.os.writeDouble(xCoord);
        this.os.writeDouble(yCoord);
        if (this.outputDimension == 3) {
            this.os.writeDouble(zCoord);
        }
    }
}

