/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.hrg;

public class HrgUtility {
    static final double EPS = 1.0E-8;
    static final double EPS100 = 1.9E-6;
    static final double CIRCIR_ENDPT_TOL = 5.0E-5;
    public static final double TWO_PI = Math.PI * 2;

    public static void CTRC3P(double P1I, double P2I, double S1I, double S2I, double Q1I, double Q2I, double[] Z1O, double[] Z2O, double[] DETAO, double[] SIGNO) {
        double dx = P1I;
        double dy = P2I;
        double P1I_ = P1I - dx;
        double P2I_ = P2I - dy;
        double S1I_ = S1I - dx;
        double S2I_ = S2I - dy;
        double Q1I_ = Q1I - dx;
        double Q2I_ = Q2I - dy;
        HrgUtility.CTRC3P_(P1I_, P2I_, S1I_, S2I_, Q1I_, Q2I_, Z1O, Z2O, DETAO, SIGNO);
        Z1O[0] = Z1O[0] + dx;
        Z2O[0] = Z2O[0] + dy;
    }

    public static void CTRC3P_(double P1I, double P2I, double S1I, double S2I, double Q1I, double Q2I, double[] Z1O, double[] Z2O, double[] DETAO, double[] SIGNO) {
        double X1 = (P1I + S1I) / 2.0;
        double X2 = (P2I + S2I) / 2.0;
        double Y1 = (S1I + Q1I) / 2.0;
        double Y2 = (S2I + Q2I) / 2.0;
        double N1 = -S2I + P2I;
        double N2 = S1I - P1I;
        double M1 = -Q2I + S2I;
        double M2 = Q1I - S1I;
        double A11 = N1;
        double A21 = N2;
        double A12 = -M1;
        double A22 = -M2;
        double G1 = Y1 - X1;
        double G2 = Y2 - X2;
        DETAO[0] = A11 * A22 - A21 * A12;
        if (DETAO[0] != 0.0 && !(Math.abs(DETAO[0]) < 1.0E-8)) {
            double L1 = (G1 * A22 - A12 * G2) / DETAO[0];
            double L2 = (A11 * G2 - G1 * A21) / DETAO[0];
            Z1O[0] = (X1 + L1 * N1 + Y1 + L2 * M1) / 2.0;
            Z2O[0] = (X2 + L1 * N2 + Y2 + L2 * M2) / 2.0;
            double D1 = Z1O[0] - P1I;
            double D2 = Z2O[0] - P2I;
            SIGNO[0] = 1.0;
            if (L1 > 0.0 || L2 > 0.0) {
                SIGNO[0] = -1.0;
            }
        } else if (P1I == Q1I && P2I == Q2I) {
            Z1O[0] = (P1I + S1I) / 2.0;
            Z2O[0] = (P2I + S2I) / 2.0;
            SIGNO[0] = 0.0;
            DETAO[0] = Math.PI * 2;
        } else {
            Z1O[0] = S1I;
            Z2O[0] = S2I;
            SIGNO[0] = 0.0;
            DETAO[0] = 0.0;
        }
    }

    private static double CURVF(double[] V1I, double[] V2I, char TYLI, double AZITAI) {
        double RADIUS;
        double SIGN = 0.0;
        double Z1 = 0.0;
        double Z2 = 0.0;
        if (TYLI == ' ') {
            return 0.0;
        }
        if (TYLI != 'A') {
            return 0.0;
        }
        double[] Z1O = new double[1];
        double[] Z2O = new double[1];
        double[] DETAO = new double[1];
        double[] SIGNO = new double[1];
        HrgUtility.CTRC3P(V1I[1], V2I[1], V1I[2], V2I[2], V1I[3], V2I[3], Z1O, Z2O, DETAO, SIGNO);
        Z1 = Z1O[0];
        Z2 = Z2O[0];
        SIGN = SIGNO[0];
        if (SIGN != 0.0) {
            double RADIUS2 = HrgUtility.DISTDF(V1I[1], V2I[1], Z1, Z2);
            if (RADIUS2 == 0.0) {
                return SIGN * 999999.999;
            }
            return SIGN / RADIUS2;
        }
        if (V1I[1] != V1I[3] || V2I[1] != V2I[3]) {
            return 0.0;
        }
        double N1 = V1I[1];
        double N2 = V2I[1] + Math.max(Math.abs(V1I[2] - V1I[1]), Math.abs(V2I[2] - V2I[1]));
        double AZICIC = HrgUtility.PSECOS(V1I[2], V2I[2], V1I[1], V2I[1], N1, N2);
        double ALFA = HrgUtility.PSECIV(AZICIC) - HrgUtility.PSECIV(AZITAI);
        ALFA = HrgUtility.ANGLNR(ALFA);
        SIGN = 1.0;
        if (ALFA > Math.PI) {
            SIGN = -1.0;
        }
        if ((RADIUS = HrgUtility.DISTDF(V1I[1], V2I[1], Z1, Z2)) == 0.0) {
            return SIGN * 999999.999;
        }
        return SIGN / RADIUS;
    }

    private static double ANGLNR(double betai) {
        if (betai < 0.0) {
            while (betai < 0.0) {
                betai += Math.PI * 2;
            }
        } else {
            while (betai >= Math.PI * 2) {
                betai -= Math.PI * 2;
            }
        }
        return betai;
    }

    public static double PSECIV(double PCOSI) {
        if (PCOSI < 1.0) {
            return Math.acos(-PCOSI);
        }
        return Math.acos(-PCOSI + 2.0) + Math.PI;
    }

    public static double PSECOS(double P1I, double P2I, double S1I, double S2I, double Q1I, double Q2I) {
        double DP1 = P1I - S1I;
        double DP2 = P2I - S2I;
        double DQ1 = Q1I - S1I;
        double DQ2 = Q2I - S2I;
        double H = Math.sqrt((DP1 * DP1 + DP2 * DP2) * (DQ1 * DQ1 + DQ2 * DQ2));
        if (H == 0.0) {
            return -1.0;
        }
        double COS = (DP1 * DQ1 + DP2 * DQ2) / H;
        double SIN = (DP1 * DQ2 - DP2 * DQ1) / H;
        if (SIN >= 0.0) {
            return -COS;
        }
        return COS + 2.0;
    }

    private static double DISTDF(double a1, double b1, double a2, double b2) {
        double D1 = a2 - a1;
        double D2 = b2 - b1;
        double RV = Math.hypot(D1, D2);
        return RV;
    }

    public static void ISCICR(double[] AV1I, double[] AV2I, double[] AW1I, double[] AW2I, int[] NHO, double[] H1O, double[] H2O, double[] overlap) {
        double dx = Math.min(AV1I[1], AW1I[1]);
        double dy = Math.min(AV2I[1], AW2I[1]);
        double[] AV1I_ = new double[]{AV1I[0] - dx, AV1I[1] - dx, AV1I[2] - dx, AV1I[3] - dx};
        double[] AV2I_ = new double[]{AV2I[0] - dy, AV2I[1] - dy, AV2I[2] - dy, AV2I[3] - dy};
        double[] AW1I_ = new double[]{AW1I[0] - dx, AW1I[1] - dx, AW1I[2] - dx, AW1I[3] - dx};
        double[] AW2I_ = new double[]{AW2I[0] - dy, AW2I[1] - dy, AW2I[2] - dy, AW2I[3] - dy};
        HrgUtility.ISCICR_(AV1I_, AV2I_, AW1I_, AW2I_, NHO, H1O, H2O, overlap, dx, dy);
        int i = 1;
        while (i <= NHO[0] && i <= 2) {
            int n = i;
            H1O[n] = H1O[n] + dx;
            int n2 = i++;
            H2O[n2] = H2O[n2] + dy;
        }
    }

    public static void ISCICR_(double[] AV1I, double[] AV2I, double[] AW1I, double[] AW2I, int[] NHO, double[] H1O, double[] H2O, double[] overlap, double _dx, double _dy) {
        double ALFA = 0.0;
        double BETA = 0.0;
        double D1 = 0.0;
        double D2 = 0.0;
        double DVW = 0.0;
        double DVWSQ = 0.0;
        double EFP = 0.0;
        boolean J = false;
        int J1 = 0;
        int J2 = 0;
        int NP = 0;
        double[] P1 = new double[3];
        double[] P2 = new double[3];
        double RDIF = 0.0;
        double RSUM = 0.0;
        double RV = 0.0;
        double RW = 0.0;
        double SIGNV = 0.0;
        double SIGNW = 0.0;
        double V1 = 0.0;
        double V2 = 0.0;
        double W1 = 0.0;
        double W2 = 0.0;
        double XVF = 0.0;
        boolean YCHKEX = false;
        NHO[0] = 0;
        for (J1 = 1; J1 <= 2; ++J1) {
            for (J2 = J1 + 1; J2 <= 3; ++J2) {
                if (AV1I[J1] == AV1I[J2] && AV2I[J1] == AV2I[J2]) {
                    int TYCIR = 86;
                    double PA1 = AV1I[J1];
                    double PA2 = AV2I[J1];
                    NHO[0] = -1;
                    throw new IllegalArgumentException("definition of arc V is wrong " + PA1 + ", " + PA2);
                }
                if (AW1I[J1] != AW1I[J2] || AW2I[J1] != AW2I[J2]) continue;
                int TYCIR = 87;
                double PA1 = AW1I[J1];
                double PA2 = AW2I[J1];
                NHO[0] = -1;
                throw new IllegalArgumentException("definition of arc W is wrong " + PA1 + ", " + PA2);
            }
        }
        for (int JV = 1; JV <= 3; ++JV) {
            for (int JW = 1; JW <= 3; ++JW) {
                if (AV1I[JV] != AW1I[JW] || AV2I[JV] != AW2I[JW]) continue;
                if (NHO[0] >= 2) {
                    H1O[NHO[0]] = AV1I[JV];
                    H2O[NHO[0]] = AV2I[JV];
                    NHO[0] = 3;
                    return;
                }
                NHO[0] = NHO[0] + 1;
                H1O[NHO[0]] = AV1I[JV];
                H2O[NHO[0]] = AV2I[JV];
            }
        }
        double[] Z1O = new double[1];
        double[] Z2O = new double[1];
        double[] DETAO = new double[1];
        double[] SIGNO = new double[1];
        HrgUtility.CTRC3P(AV1I[1], AV2I[1], AV1I[2], AV2I[2], AV1I[3], AV2I[3], Z1O, Z2O, DETAO, SIGNO);
        V1 = Z1O[0];
        V2 = Z2O[0];
        SIGNV = SIGNO[0];
        if (DETAO[0] == 0.0) {
            throw new IllegalArgumentException("unexpected straight line");
        }
        HrgUtility.CTRC3P(AW1I[1], AW2I[1], AW1I[2], AW2I[2], AW1I[3], AW2I[3], Z1O, Z2O, DETAO, SIGNO);
        W1 = Z1O[0];
        W2 = Z2O[0];
        SIGNW = SIGNO[0];
        if (DETAO[0] == 0.0) {
            throw new IllegalArgumentException("unexpected straight line");
        }
        D1 = AV1I[1] - V1;
        D2 = AV2I[1] - V2;
        RV = Math.hypot(D1, D2);
        D1 = AW1I[1] - W1;
        D2 = AW2I[1] - W2;
        RW = Math.hypot(D1, D2);
        RSUM = RV + RW;
        RDIF = Math.abs(RV - RW);
        D1 = W1 - V1;
        D2 = W2 - V2;
        DVWSQ = D1 * D1 + D2 * D2;
        DVW = Math.hypot(D1, D2);
        if (RDIF < 1.0E-8 && DVW < 1.0E-8) {
            NHO[0] = 0;
            if (SIGNV == SIGNW) {
                double ALFA_W;
                if (AV1I[1] == AW1I[1] && AV2I[1] == AW2I[1]) {
                    NHO[0] = NHO[0] + 1;
                    H1O[NHO[0]] = AV1I[1];
                    H2O[NHO[0]] = AV2I[1];
                } else {
                    double ALFA_V = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AV1I[3], AV2I[3]);
                    double BETA_W1 = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AW1I[1], AW2I[1]);
                    if (AV1I[3] == AW1I[1] && AV2I[3] == AW2I[1] || ALFA_V != BETA_W1 && Math.signum(BETA_W1 - ALFA_V) != SIGNV) {
                        ALFA_W = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AW1I[3], AW2I[3]);
                        double BETA_V1 = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AV1I[1], AV2I[1]);
                        if (AV1I[1] == AW1I[3] && AV2I[1] == AW2I[3] || ALFA_W != BETA_V1 && Math.signum(BETA_V1 - ALFA_W) != SIGNW) {
                            NHO[0] = 0;
                            return;
                        }
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AV1I[1];
                        H2O[NHO[0]] = AV2I[1];
                    } else {
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AW1I[1];
                        H2O[NHO[0]] = AW2I[1];
                    }
                }
                if (AV1I[3] == AW1I[3] && AV2I[3] == AW2I[3]) {
                    NHO[0] = NHO[0] + 1;
                    H1O[NHO[0]] = AV1I[3];
                    H2O[NHO[0]] = AV2I[3];
                } else {
                    double BETA_W3;
                    double ALFA_V = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AV1I[3], AV2I[3]);
                    if (ALFA_V != (BETA_W3 = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AW1I[3], AW2I[3])) && Math.signum(BETA_W3 - ALFA_V) != SIGNV) {
                        double BETA_V3;
                        ALFA_W = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AW1I[3], AW2I[3]);
                        if (ALFA_W != (BETA_V3 = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AV1I[3], AV2I[3])) && Math.signum(BETA_V3 - ALFA_W) != SIGNW) {
                            NHO[0] = 0;
                            return;
                        }
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AV1I[3];
                        H2O[NHO[0]] = AV2I[3];
                    } else {
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AW1I[3];
                        H2O[NHO[0]] = AW2I[3];
                    }
                }
            } else {
                double BETA_V1;
                double ALFA_W;
                if (AV1I[1] == AW1I[3] && AV2I[1] == AW2I[3]) {
                    NHO[0] = NHO[0] + 1;
                    H1O[NHO[0]] = AV1I[1];
                    H2O[NHO[0]] = AV2I[1];
                } else {
                    double ALFA_V = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AV1I[3], AV2I[3]);
                    double BETA_W3 = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AW1I[3], AW2I[3]);
                    if (AV1I[3] == AW1I[3] && AV2I[3] == AW2I[3] || ALFA_V != BETA_W3 && Math.signum(BETA_W3 - ALFA_V) != SIGNV) {
                        ALFA_W = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AW1I[3], AW2I[3]);
                        BETA_V1 = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AV1I[1], AV2I[1]);
                        if (AV1I[1] == AW1I[1] && AV2I[1] == AW2I[1] || ALFA_W != BETA_V1 && Math.signum(BETA_V1 - ALFA_W) != SIGNW) {
                            NHO[0] = 0;
                            return;
                        }
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AV1I[1];
                        H2O[NHO[0]] = AV2I[1];
                    } else {
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AW1I[3];
                        H2O[NHO[0]] = AW2I[3];
                    }
                }
                if (AV1I[3] == AW1I[1] && AV2I[3] == AW2I[1]) {
                    NHO[0] = NHO[0] + 1;
                    H1O[NHO[0]] = AV1I[3];
                    H2O[NHO[0]] = AV2I[3];
                } else {
                    double BETA_W1;
                    double ALFA_V = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AV1I[3], AV2I[3]);
                    if (ALFA_V != (BETA_W1 = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AW1I[1], AW2I[1])) && Math.signum(BETA_W1 - ALFA_V) != SIGNV) {
                        ALFA_W = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AW1I[3], AW2I[3]);
                        if (ALFA_W != (BETA_V1 = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AV1I[1], AV2I[1])) && Math.signum(BETA_V1 - ALFA_W) != SIGNW) {
                            NHO[0] = 0;
                            return;
                        }
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AV1I[3];
                        H2O[NHO[0]] = AV2I[3];
                    } else {
                        NHO[0] = NHO[0] + 1;
                        H1O[NHO[0]] = AW1I[1];
                        H2O[NHO[0]] = AW2I[1];
                    }
                }
            }
            if (NHO[0] == 2) {
                NHO[0] = 3;
            } else if (NHO[0] != 0) {
                throw new IllegalStateException("unexpected number (" + NHO[0] + ") of common points");
            }
            return;
        }
        if (DVW >= RDIF + 1.0E-8 && DVW <= RSUM - 1.0E-8) {
            XVF = (RV * RV + DVWSQ - RW * RW) / (2.0 * DVW);
            EFP = Math.sqrt(RV * RV - XVF * XVF);
            D1 = W1 - V1;
            D2 = W2 - V2;
            overlap[0] = DVW < Math.max(RV, RW) ? DVW - RDIF : RSUM - DVW;
            NP = 2;
            P1[1] = V1 + XVF * D1 / DVW + EFP * D2 / DVW;
            P2[1] = V2 + XVF * D2 / DVW - EFP * D1 / DVW;
            P1[2] = V1 + XVF * D1 / DVW - EFP * D2 / DVW;
            P2[2] = V2 + XVF * D2 / DVW + EFP * D1 / DVW;
            YCHKEX = true;
        } else {
            if (DVW >= RSUM + 1.0E-8) {
                return;
            }
            if (DVW < RDIF - 1.0E-8) {
                return;
            }
            if (NHO[0] > 0) {
                H1O[2] = H1O[1];
                H2O[2] = H2O[1];
                NHO[0] = 1;
                overlap[0] = 0.0;
                return;
            }
            NP = 1;
            P1[1] = V1 + (W1 - V1) * RV / RSUM;
            P2[1] = V2 + (W2 - V2) * RV / RSUM;
            overlap[0] = 0.0;
            YCHKEX = false;
        }
        for (int JP = 1; JP <= NP; ++JP) {
            if (YCHKEX) {
                boolean continueJP = false;
                for (int JH = 1; JH <= NHO[0]; ++JH) {
                    if (Math.abs(P1[JP] - H1O[JH]) > 5.0E-5 || Math.abs(P2[JP] - H2O[JH]) > 5.0E-5) continue;
                    continueJP = true;
                    break;
                }
                if (continueJP) continue;
            }
            if ((ALFA = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AV1I[3], AV2I[3])) != (BETA = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, P1[JP], P2[JP])) && Math.signum(BETA - ALFA) != SIGNV || (ALFA = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, AW1I[3], AW2I[3])) != (BETA = HrgUtility.PSECOS(AW1I[1], AW2I[1], W1, W2, P1[JP], P2[JP])) && Math.signum(BETA - ALFA) != SIGNW) continue;
            if (NHO[0] >= 2) {
                throw new IllegalStateException("more than 2 IPs (" + H1O[1] + ", " + H2O[1] + "), (" + H1O[2] + ", " + H2O[2] + "), (" + P1[JP] + ", " + P2[JP] + ")");
            }
            NHO[0] = NHO[0] + 1;
            H1O[NHO[0]] = P1[JP];
            H2O[NHO[0]] = P2[JP];
        }
    }

    public static void ISCISR(double[] AV1I, double[] AV2I, double[] SL1I, double[] SL2I, int[] NHO, double[] H1O, double[] H2O, double[] overlap) {
        double dx = AV1I[1];
        double dy = AV2I[1];
        double[] AV1I_ = new double[]{AV1I[0] - dx, AV1I[1] - dx, AV1I[2] - dx, AV1I[3] - dx};
        double[] AV2I_ = new double[]{AV2I[0] - dy, AV2I[1] - dy, AV2I[2] - dy, AV2I[3] - dy};
        double[] SL1I_ = new double[]{SL1I[0] - dx, SL1I[1] - dx, SL1I[2] - dx};
        double[] SL2I_ = new double[]{SL2I[0] - dy, SL2I[1] - dy, SL2I[2] - dy};
        HrgUtility.ISCISR_(AV1I_, AV2I_, SL1I_, SL2I_, NHO, H1O, H2O, overlap);
        int i = 1;
        while (i <= NHO[0]) {
            int n = i;
            H1O[n] = H1O[n] + dx;
            int n2 = i++;
            H2O[n2] = H2O[n2] + dy;
        }
    }

    public static void ISCISR_(double[] AV1I, double[] AV2I, double[] SL1I, double[] SL2I, int[] NHO, double[] H1O, double[] H2O, double[] overlap) {
        int NP;
        double ALFA = 0.0;
        double BETA = 0.0;
        double D1 = 0.0;
        double D2 = 0.0;
        double EFP = 0.0;
        double F1 = 0.0;
        double F2 = 0.0;
        double G1 = 0.0;
        double G2 = 0.0;
        double GL = 0.0;
        double GLSQ = 0.0;
        int J1 = 0;
        int J2 = 0;
        double[] P1 = new double[3];
        double[] P2 = new double[3];
        double RV = 0.0;
        double RVSQ = 0.0;
        double SCAP = 0.0;
        double SIGNV = 0.0;
        double V1 = 0.0;
        double V2 = 0.0;
        double XVF = 0.0;
        double XVFSQ = 0.0;
        boolean YCHKEX = false;
        NHO[0] = 0;
        for (J1 = 1; J1 <= 2; ++J1) {
            for (J2 = J1 + 1; J2 <= 3; ++J2) {
                if (AV1I[J1] != AV1I[J2] || AV2I[J1] != AV2I[J2]) continue;
                int TYCIR = 86;
                double PA1 = AV1I[J1];
                double PA2 = AV2I[J1];
                NHO[0] = -1;
                throw new IllegalArgumentException("definition of arc W is wrong " + PA1 + ", " + PA2);
            }
        }
        if (SL1I[1] == SL1I[2] && SL2I[1] == SL2I[2]) {
            int TYCIR = 76;
            double PA1 = SL1I[1];
            double PA2 = SL2I[1];
            NHO[0] = -1;
            throw new IllegalArgumentException("definition of straight L is wrong " + PA1 + ", " + PA2);
        }
        for (int JV = 1; JV <= 3; ++JV) {
            for (int JL = 1; JL <= 2; ++JL) {
                if (AV1I[JV] != SL1I[JL] || AV2I[JV] != SL2I[JL]) continue;
                if (NHO[0] >= 2) {
                    NHO[0] = 3;
                    return;
                }
                NHO[0] = NHO[0] + 1;
                H1O[NHO[0]] = AV1I[JV];
                H2O[NHO[0]] = AV2I[JV];
            }
        }
        if (NHO[0] >= 2) {
            return;
        }
        double[] Z1O = new double[1];
        double[] Z2O = new double[1];
        double[] DETAO = new double[1];
        double[] SIGNO = new double[1];
        HrgUtility.CTRC3P(AV1I[1], AV2I[1], AV1I[2], AV2I[2], AV1I[3], AV2I[3], Z1O, Z2O, DETAO, SIGNO);
        V1 = Z1O[0];
        V2 = Z2O[0];
        SIGNV = SIGNO[0];
        if (DETAO[0] == 0.0) {
            throw new IllegalArgumentException("unexpected straight line");
        }
        D1 = AV1I[1] - V1;
        D2 = AV2I[1] - V2;
        RVSQ = D1 * D1 + D2 * D2;
        RV = Math.sqrt(RVSQ);
        G1 = SL1I[2] - SL1I[1];
        G2 = SL2I[2] - SL2I[1];
        SCAP = (V1 - SL1I[1]) * G1 + (V2 - SL2I[1]) * G2;
        GLSQ = G1 * G1 + G2 * G2;
        GL = Math.sqrt(GLSQ);
        F1 = SL1I[1] + G1 * SCAP / GLSQ;
        D1 = V1 - F1;
        F2 = SL2I[1] + G2 * SCAP / GLSQ;
        D2 = V2 - F2;
        XVFSQ = D1 * D1 + D2 * D2;
        XVF = Math.sqrt(XVFSQ);
        if (XVF < RV - 1.0E-8) {
            EFP = Math.sqrt(RVSQ - XVFSQ);
            NP = 2;
            P1[1] = F1 + G1 * EFP / GL;
            P2[1] = F2 + G2 * EFP / GL;
            P1[2] = F1 - G1 * EFP / GL;
            P2[2] = F2 - G2 * EFP / GL;
            overlap[0] = RV - XVF;
            YCHKEX = true;
        } else {
            if (XVF > RV + 1.0E-8) {
                return;
            }
            if (NHO[0] > 0) {
                H1O[2] = H1O[1];
                H2O[2] = H2O[1];
                overlap[0] = 0.0;
                NHO[0] = 1;
                return;
            }
            NP = 1;
            P1[1] = F1;
            P2[1] = F2;
            P1[2] = F1;
            P2[2] = F2;
            overlap[0] = 0.0;
            YCHKEX = false;
        }
        for (int JP = 1; JP <= NP; ++JP) {
            if (YCHKEX) {
                boolean continueJP = false;
                for (int JH = 1; JH <= NHO[0]; ++JH) {
                    if (!(Math.abs(P1[JP] - H1O[JH]) <= 1.9E-6) || !(Math.abs(P2[JP] - H2O[JH]) <= 1.9E-6)) continue;
                    continueJP = true;
                    break;
                }
                if (continueJP) continue;
            }
            if ((ALFA = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, AV1I[3], AV2I[3])) != (BETA = HrgUtility.PSECOS(AV1I[1], AV2I[1], V1, V2, P1[JP], P2[JP])) && Math.signum(BETA - ALFA) != SIGNV) continue;
            if (SL1I[1] != P1[JP]) {
                if (SL1I[1] < SL1I[2] ? P1[JP] < SL1I[1] || SL1I[2] < P1[JP] : P1[JP] < SL1I[2] || SL1I[1] < P1[JP]) {
                    continue;
                }
            } else if (!(SL2I[1] < SL2I[2]) ? P2[JP] < SL2I[2] || SL2I[1] < P2[JP] : P2[JP] < SL2I[1] || SL2I[2] < P2[JP]) continue;
            if (NHO[0] >= 2) {
                throw new IllegalStateException("more than 2 IPs (" + H1O[1] + ", " + H2O[1] + "), (" + H1O[2] + ", " + H2O[2] + "), (" + P1[JP] + ", " + P2[JP] + ")");
            }
            NHO[0] = NHO[0] + 1;
            H1O[NHO[0]] = P1[JP];
            H2O[NHO[0]] = P2[JP];
        }
    }

    public static void main(String[] args) {
        double[] Z1O = new double[1];
        double[] Z2O = new double[1];
        double[] DETAO = new double[1];
        double[] SIGNO = new double[1];
        HrgUtility.CTRC3P(0.0, 0.0, 1.0, 1.0, 2.0, 0.0, Z1O, Z2O, DETAO, SIGNO);
        System.out.println(" " + Z1O[0] + ", " + Z2O[0] + ", DETA " + DETAO[0] + ", SIGN " + SIGNO[0]);
        HrgUtility.CTRC3P(0.0, 0.0, 1.0, -1.0, 2.0, 0.0, Z1O, Z2O, DETAO, SIGNO);
        System.out.println(" " + Z1O[0] + ", " + Z2O[0] + ", DETA " + DETAO[0] + ", SIGN " + SIGNO[0]);
        HrgUtility.CTRC3P(0.0, 0.0, 1.0, 0.0, 2.0, 0.0, Z1O, Z2O, DETAO, SIGNO);
        System.out.println(" " + Z1O[0] + ", " + Z2O[0] + ", DETA " + DETAO[0] + ", SIGN " + SIGNO[0]);
        HrgUtility.CTRC3P(0.0, 0.0, 2.0, 0.0, 0.0, 0.0, Z1O, Z2O, DETAO, SIGNO);
        System.out.println(" " + Z1O[0] + ", " + Z2O[0] + ", DETA " + DETAO[0] + ", SIGN " + SIGNO[0]);
    }
}

