/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl.btree;

import ch.ehi.iox.objpool.impl.LongSerializer;
import ch.ehi.iox.objpool.impl.btree.BTree;
import ch.ehi.iox.objpool.impl.btree.Entry;
import ch.ehi.iox.objpool.impl.btree.NodeId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

final class Node<Key, Value> {
    private int m;
    private Entry<Key, Value>[] children = new Entry[16];
    private NodeId nodeId;
    private boolean dirty = true;
    private BTree<Key, Value> tree = null;
    private ArrayList<Long> overflowPages = new ArrayList();
    private static final boolean doMagic = true;
    private static final int MAGIC = 165;

    Node(BTree<Key, Value> tree, NodeId nodeId, int k) {
        this.nodeId = nodeId;
        this.m = k;
        this.tree = tree;
        this.dirty = true;
        tree.cachePut(nodeId, this);
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getEntryCount() {
        this.tree.touchNode(this.nodeId);
        return this.m;
    }

    public void setEntryCount(int m) {
        this.tree.touchNode(this.nodeId);
        this.m = m;
        this.dirty = true;
    }

    public Entry<Key, Value> getEntry(int i) {
        this.tree.touchNode(this.nodeId);
        return this.children[i];
    }

    public void setEntry(int i, Entry<Key, Value> child) {
        this.tree.touchNode(this.nodeId);
        this.children[i] = child;
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ArrayList<Long> getOverflowPages() {
        return this.overflowPages;
    }

    public void setOverflowPages(ArrayList<Long> overflowPages) {
        this.overflowPages = overflowPages;
    }

    public static <Key, Value> Node<Key, Value> read(BTree<Key, Value> tree, NodeId nodeId, byte[] in) throws IOException {
        ByteArrayInputStream bytes = new ByteArrayInputStream(in);
        byte[] b = new byte[4];
        bytes.read(b);
        if (165 != LongSerializer.bytesToInteger(b, 0)) {
            throw new IllegalStateException();
        }
        byte[] b2 = new byte[4];
        bytes.read(b2);
        int m = LongSerializer.bytesToInteger(b2, 0);
        Node<Key, Value> ret = new Node<Key, Value>(tree, nodeId, m);
        for (int i = 0; i < m; ++i) {
            byte[] b3 = new byte[8];
            bytes.read(b3);
            long next = LongSerializer.bytesToLong(b3);
            Key key = tree.deserialzeKey(bytes);
            if (next == -1L) {
                Object val = tree.deserialzeValue(bytes);
                ret.children[i] = new Entry<Key, Object>(key, val, null);
                continue;
            }
            ret.children[i] = new Entry<Key, Object>(key, null, new NodeId(next));
        }
        byte[] b4 = new byte[4];
        bytes.read(b4);
        if (165 != LongSerializer.bytesToInteger(b4, 0)) {
            throw new IllegalStateException();
        }
        return ret;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] b = new byte[4];
        LongSerializer.integerToBytes(165, b, 0);
        bytes.write(b);
        b = new byte[4];
        LongSerializer.integerToBytes(this.m, b, 0);
        bytes.write(b);
        for (int i = 0; i < this.m; ++i) {
            Entry<Key, Value> e = this.children[i];
            byte[] b2 = new byte[8];
            if (e.getChildNode() == null) {
                LongSerializer.longToBytes(-1L, b2);
            } else {
                LongSerializer.longToBytes(e.getChildNode().getPageId(), b2);
            }
            bytes.write(b2);
            this.tree.serialzeKey(bytes, e.getKey());
            if (e.getChildNode() != null) continue;
            this.tree.serialzeValue(bytes, e.getVal());
        }
        b = new byte[4];
        LongSerializer.integerToBytes(165, b, 0);
        bytes.write(b);
        bytes.flush();
        return bytes.toByteArray();
    }
}

