/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.iox.objpool.impl.ObjPoolImpl2;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.util.ArrayList;
import java.util.Iterator;

public class ObjectPoolFunctions {
    private final Validator validator;
    private final ObjectPool objectPool;
    private final LogEventFactory logger;
    public static final String OBJECTPOOL = "ObjectPool_V1_0";

    public ObjectPoolFunctions(Validator validator, ObjectPool objectPool, LogEventFactory logger) {
        this.validator = validator;
        this.objectPool = objectPool;
        this.logger = logger;
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, TextType texttype, RoleDef firstRole) {
        Evaluable[] arguments = functionCallObj.getArguments();
        Value[] actualArguments = new Value[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            Value result = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
            if (result.skipEvaluation()) {
                return result;
            }
            actualArguments[i] = result;
        }
        if (currentFunction.getName().equals("allObjects")) {
            return this.evaluateAllObjects(validationKind, usageScope, iomObj, actualArguments);
        }
        return Value.createNotYetImplemented();
    }

    private Value evaluateAllObjects(String validationKind, String usageScope, IomObject iomObj, Value[] actualArguments) {
        Viewable viewable = actualArguments[0].getViewable();
        if (viewable == null) {
            this.logger.logErrorMsg("Missing ObjectClass argument for allObjects", new String[0]);
            return Value.createUndefined();
        }
        Projection projection = null;
        Viewable objectClass = viewable;
        if (viewable instanceof Projection) {
            projection = (Projection)viewable;
            objectClass = projection.getSelected().getAliasing();
        }
        String className = objectClass.getScopedName();
        ArrayList<IomObject> objects = new ArrayList<IomObject>();
        for (String basketId : this.objectPool.getDataBids()) {
            ObjPoolImpl2 basketObjectPool = this.objectPool.getObjectsOfBasketId(basketId);
            Iterator valueIterator = basketObjectPool.valueIterator();
            while (valueIterator.hasNext()) {
                IomObject object = (IomObject)valueIterator.next();
                if (!object.getobjecttag().equals(className) || projection != null && !this.validator.viewIncludesObject(projection, object)) continue;
                objects.add(object);
            }
        }
        return new Value(objects);
    }
}

