/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.types.OutParam;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.generator.Interlis2Generator;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AssociationPath;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Constant;
import ch.interlis.ili2c.metamodel.Constraint;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.DataModel;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.DomainConstraint;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.ExistenceConstraint;
import ch.interlis.ili2c.metamodel.Expression;
import ch.interlis.ili2c.metamodel.ExpressionSelection;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.MandatoryConstraint;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiAreaType;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.Objects;
import ch.interlis.ili2c.metamodel.ParameterValue;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAbstractClassRole;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PathElBase;
import ch.interlis.ili2c.metamodel.PathElRefAttr;
import ch.interlis.ili2c.metamodel.PathElThis;
import ch.interlis.ili2c.metamodel.PlausibilityConstraint;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Projection;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SetConstraint;
import ch.interlis.ili2c.metamodel.StructAttributeRef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextOIDType;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.ValueRefThis;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableAlias;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.ili2c.parser.Ili23Parser;
import ch.interlis.ilirepository.Dataset;
import ch.interlis.ilirepository.ReposManager;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfAreaPolygon2Linetable;
import ch.interlis.iom_j.itf.impl.ItfSurfaceLinetable2Polygon;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.noding.CompoundCurveNoder;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iom_j.xtf.XtfWriter;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox.IoxValidationDataPool;
import ch.interlis.iox.IoxValidator;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.IoxIntersectionException;
import ch.interlis.iox_j.IoxInvalidDataException;
import ch.interlis.iox_j.PipelinePool;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.logging.LogEventFactory;
import ch.interlis.iox_j.utility.ReaderFactory;
import ch.interlis.iox_j.validator.AttributeArray;
import ch.interlis.iox_j.validator.ExternalObjectResolver;
import ch.interlis.iox_j.validator.Ili23KeyWords;
import ch.interlis.iox_j.validator.InterlisFunction;
import ch.interlis.iox_j.validator.LinkPool;
import ch.interlis.iox_j.validator.ObjectPool;
import ch.interlis.iox_j.validator.PlausibilityPoolValue;
import ch.interlis.iox_j.validator.Value;
import ch.interlis.iox_j.validator.functions.DmavtymTopologie;
import ch.interlis.iox_j.validator.functions.ElementsFunctions;
import ch.interlis.iox_j.validator.functions.Interlis;
import ch.interlis.iox_j.validator.functions.Interlis_ext;
import ch.interlis.iox_j.validator.functions.Math;
import ch.interlis.iox_j.validator.functions.MinimalRuntimeSystem;
import ch.interlis.iox_j.validator.functions.ObjectPoolFunctions;
import ch.interlis.iox_j.validator.functions.Text;
import ch.interlis.iox_j.wkb.RingCollector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Polygon;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validator
implements IoxValidator {
    private static final String ILI_LEGACYAREAREAS = "ILI_LEGACYAREAREAS";
    private static final String ENUM_TREE_VALUES = "ENUM_TREE_VALUES";
    private static final String VALUE_REF_THIS = "Value";
    public static final String ALL_OBJECTS_ACCESSIBLE = "allObjectsAccessible";
    public static final String REGEX_FOR_ID_VALIDATION = "^[0-9a-zA-Z_][0-9a-zA-Z\\_\\.\\-]*";
    public static final String REGEX_FOR_TEXTOID_VALIDATION = "^[a-zA-Z_][0-9a-zA-Z\\_\\.\\-]*";
    public static final String REGEX_FOR_STANDARTOID_VALIDATION = "^[a-zA-Z][0-9a-zA-Z]*";
    public static final String REGEX_FOR_BASE64_VALIDATION = "[a-zA-Z0-9+/= \\t\\n\\r]+";
    public static final String CONFIG_DO_ITF_LINETABLES = "ch.interlis.iox_j.validator.doItfLinetables";
    public static final String CONFIG_DO_ITF_LINETABLES_DO = "doItfLinetables";
    public static final String CONFIG_DO_ITF_OIDPERTABLE = "ch.interlis.iox_j.validator.doItfOidPerTable";
    public static final String CONFIG_DO_ITF_OIDPERTABLE_DO = "doItfOidPerTable";
    public static final String CONFIG_DO_XTF_VERIFYMODEL = "ch.interlis.iox_j.validator.doXtfVersionControl";
    public static final String CONFIG_DO_XTF_VERIFYMODEL_DO = "doXtfVersionControl";
    public static final String CONFIG_DO_SINGLE_PASS = "ch.interlis.iox_j.validator.doSinglePass";
    public static final String CONFIG_DO_SINGLE_PASS_DO = "doSinglePass";
    public static final String CONFIG_CUSTOM_FUNCTIONS = "ch.interlis.iox_j.validator.customFunctions";
    public static final String CONFIG_OBJECT_RESOLVERS = "ch.interlis.iox_j.validator.objectResolvers";
    public static final String CONFIG_DEBUG_XTFOUT = "ch.interlis.iox_j.validator.debugXtfOutput";
    public static final String CONFIG_VERBOSE = "ch.interlis.iox_j.validator.verbose";
    private Map<Evaluable, Value> functions = new HashMap<Evaluable, Value>();
    private ObjectPoolManager objPoolManager = null;
    private ObjectPool objectPool = null;
    private LinkPool linkPool = null;
    private IoxValidationConfig validationConfig = null;
    private PipelinePool pipelinePool = null;
    private IoxLogging errs = null;
    private LogEventFactory errFact = null;
    private TransferDescription td = null;
    private boolean doItfLineTables = false;
    private boolean doItfOidPerTable = false;
    private Settings settings = null;
    private boolean validationOff = false;
    private boolean singlePass = false;
    private boolean validateSimpleBoundary = false;
    private String areaOverlapValidation = null;
    private String constraintValidation = null;
    private String defaultGeometryTypeValidation = null;
    Pattern patternForIdValidation = null;
    Pattern patternForTextOIdValidation = null;
    Pattern patternForStandartOidValidation = null;
    Pattern patternForBase64Validation = null;
    private boolean enforceTypeValidation = false;
    private boolean enforceConstraintValidation = false;
    private boolean enforceTargetValidation = false;
    private String currentBasketId = null;
    private String currentMainOid = null;
    private boolean autoSecondPass = true;
    private boolean allObjectsAccessible = false;
    private boolean isVerbose = false;
    private Map<AttributeDef, ItfAreaPolygon2Linetable> areaAttrs = new HashMap<AttributeDef, ItfAreaPolygon2Linetable>();
    private Map<AttributeDef, Boolean> areaAttrsAreSurfaceTopologiesValid = new HashMap<AttributeDef, Boolean>();
    private Map<String, Class> customFunctions = new HashMap<String, Class>();
    private List<ExternalObjectResolver> extObjResolvers = null;
    private HashMap<Constraint, Projection> additionalConstraints = new HashMap();
    private Map<PlausibilityConstraint, PlausibilityPoolValue> plausibilityConstraints = new LinkedHashMap<PlausibilityConstraint, PlausibilityPoolValue>();
    private HashSet<String> configOffOufputReduction = new HashSet();
    private HashSet<String> setConstraintOufputReduction = new HashSet();
    private HashSet<String> constraintOutputReduction = new HashSet();
    private HashSet<String> seenModels = new HashSet();
    private HashSet<String> datatypesOutputReduction = new HashSet();
    private Map<String, String> uniquenessOfBid = new HashMap<String, String>();
    private Map<String, String> stableBids = new HashMap<String, String>();
    private String globalMultiplicity = null;
    private ReposManager repositoryManager = null;
    private ResourceBundle rsrc = ResourceBundle.getBundle("ch.interlis.iox_j.validator.ValidatorMessages");
    private IoxWriter writer = null;
    private long objectCount = 0L;
    private long structCount = 0L;
    private final Map<String, Domain> genericDomains = new HashMap<String, Domain>();
    private HashMap<String, Object> tag2class = null;
    private HashSet<String> unknownTypev = null;
    private Set<String> mandatoryBaskets = null;
    private Set<String> optionalBaskets = null;
    private Set<String> bannedBaskets = null;
    private Set<String> seenTopics = null;
    private HashMap<SetConstraint, Collection<String>> setConstraints = new HashMap();
    private Iterator<String> allObjIterator = null;
    private Map<RoleDef, Map<String, List<IomObject>>> targetObjects = new HashMap<RoleDef, Map<String, List<IomObject>>>();
    private Map<RoleDef, Map<String, List<IomObject>>> linkObjects = new HashMap<RoleDef, Map<String, List<IomObject>>>();
    private boolean legacyAreAreas = false;
    HashMap<UniquenessConstraint, HashMap<AttributeArray, String>> seenUniqueConstraintValues = new HashMap();
    Map<String, String> uniqueObjectIDs = new HashMap<String, String>();
    HashSet<Object> loggedObjects = new HashSet();
    private boolean disableRounding = false;
    private boolean disableAreAreasMessages = false;
    private Interlis interlisFunction = null;
    private Interlis_ext interlis_ext = null;
    private Math mathFunction = null;
    private Text textFunction = null;
    private MinimalRuntimeSystem rtsFunction = null;
    private DmavtymTopologie dmavtymTopologie = null;
    private ObjectPoolFunctions objectPoolFunctions = null;
    private ElementsFunctions elementsFunctions = null;

    @Deprecated
    public Validator(TransferDescription td, IoxValidationConfig validationConfig, IoxLogging errs, LogEventFactory errFact, Settings config) {
        this(td, validationConfig, errs, errFact, new PipelinePool(), config);
    }

    public Validator() {
    }

    public Validator(TransferDescription td, IoxValidationConfig validationConfig, IoxLogging errs, LogEventFactory errFact, PipelinePool pipelinePool, Settings settings) {
        String filename;
        boolean allowOnlyRelaxedMultiplicity;
        String validateSimpleBoundaryParam;
        this.td = td;
        this.validationConfig = validationConfig;
        this.errs = errs;
        this.errFact = errFact;
        if (errFact.getLogger() == null) {
            errFact.setLogger(errs);
        }
        if (errFact.getValidationConfig() == null) {
            errFact.setValidationConfig(validationConfig);
        }
        this.legacyAreAreas = System.getenv(ILI_LEGACYAREAREAS) != null;
        this.settings = settings;
        this.patternForIdValidation = Pattern.compile(REGEX_FOR_ID_VALIDATION);
        this.patternForTextOIdValidation = Pattern.compile(REGEX_FOR_TEXTOID_VALIDATION);
        this.patternForStandartOidValidation = Pattern.compile(REGEX_FOR_STANDARTOID_VALIDATION);
        this.patternForBase64Validation = Pattern.compile(REGEX_FOR_BASE64_VALIDATION);
        this.settings.setTransientObject("ch.interlis.iox_j.validator.IoxDataPool", (Object)pipelinePool);
        this.settings.setTransientObject("ch.interlis.iox_j.validator.Validator", (Object)this);
        this.pipelinePool = pipelinePool;
        this.objPoolManager = new ObjectPoolManager();
        Map cf = (Map)settings.getTransientObject(CONFIG_CUSTOM_FUNCTIONS);
        if (cf != null) {
            this.customFunctions = cf;
        }
        List resolverClasses = (List)settings.getTransientObject(CONFIG_OBJECT_RESOLVERS);
        this.repositoryManager = (ReposManager)settings.getTransientObject("ch.interlis.ili2c.customIliManager");
        this.singlePass = CONFIG_DO_SINGLE_PASS_DO.equals(settings.getValue(CONFIG_DO_SINGLE_PASS));
        this.doItfLineTables = CONFIG_DO_ITF_LINETABLES_DO.equals(settings.getValue(CONFIG_DO_ITF_LINETABLES));
        this.doItfOidPerTable = CONFIG_DO_ITF_OIDPERTABLE_DO.equals(settings.getValue(CONFIG_DO_ITF_OIDPERTABLE));
        this.isVerbose = "true".equals(settings.getTransientValue(CONFIG_VERBOSE));
        this.allObjectsAccessible = "true".equals(validationConfig.getConfigValue("PARAMETER", ALL_OBJECTS_ACCESSIBLE));
        if (this.singlePass) {
            errs.addEvent(errFact.logInfoMsg("do single pass validation", new String[0]));
        }
        if (!this.allObjectsAccessible) {
            errs.addEvent(errFact.logInfoMsg("assume unknown external objects", new String[0]));
        }
        this.disableRounding = "true".equals(validationConfig.getConfigValue("PARAMETER", "disableRounding"));
        if (this.disableRounding) {
            errs.addEvent(errFact.logInfoMsg("disable rounding", new String[0]));
        }
        this.validateSimpleBoundary = (validateSimpleBoundaryParam = validationConfig.getConfigValue("PARAMETER", "simpleBoundary")) != null ? "true".equals(validateSimpleBoundaryParam) : td.getLastModel().getIliVersion().equals("2.4");
        if (this.validateSimpleBoundary) {
            errs.addEvent(errFact.logInfoMsg("validate simple boundaries", new String[0]));
        }
        this.disableAreAreasMessages = "true".equals(validationConfig.getConfigValue("PARAMETER", "disableAreAreasMessages"));
        if (this.disableAreAreasMessages) {
            errs.addEvent(errFact.logInfoMsg("disable areAreas() messages", new String[0]));
        }
        if (allowOnlyRelaxedMultiplicity = "on".equals(validationConfig.getConfigValue("PARAMETER", "allowOnlyMultiplicityReduction"))) {
            errs.addEvent(errFact.logInfoMsg("only multiplicity validation relaxable", new String[0]));
        }
        this.enforceConstraintValidation = allowOnlyRelaxedMultiplicity;
        this.enforceTypeValidation = allowOnlyRelaxedMultiplicity;
        this.enforceTargetValidation = allowOnlyRelaxedMultiplicity;
        this.tag2class = this.doItfLineTables ? ModelUtilities.getTagMap(td) : XSDGenerator.getTagMap((TransferDescription)td);
        this.unknownTypev = new HashSet();
        this.seenTopics = new HashSet<String>();
        this.mandatoryBaskets = new HashSet<String>();
        this.parseBasketList(this.mandatoryBaskets, validationConfig.getConfigValue("PARAMETER", "mandatoryBaskets"));
        this.optionalBaskets = new HashSet<String>();
        this.parseBasketList(this.optionalBaskets, validationConfig.getConfigValue("PARAMETER", "optionalBaskets"));
        this.bannedBaskets = new HashSet<String>();
        this.parseBasketList(this.bannedBaskets, validationConfig.getConfigValue("PARAMETER", "bannedBaskets"));
        if (this.mandatoryBaskets.isEmpty() && this.optionalBaskets.isEmpty() && this.bannedBaskets.isEmpty()) {
            this.optionalBaskets.add("ANY");
        }
        if (!this.optionalBaskets.isEmpty() && !this.optionalBaskets.contains("ANY") && this.bannedBaskets.isEmpty() && !this.mandatoryBaskets.contains("ANY")) {
            this.bannedBaskets.add("ANY");
        }
        if (!this.mandatoryBaskets.isEmpty() && !this.mandatoryBaskets.contains("ANY") && this.optionalBaskets.isEmpty() && !this.bannedBaskets.contains("ANY")) {
            this.optionalBaskets.add("ANY");
        }
        this.validationOff = "off".equals(this.validationConfig.getConfigValue("PARAMETER", "validation"));
        this.globalMultiplicity = validationConfig.getConfigValue("PARAMETER", "multiplicity");
        if (this.globalMultiplicity != null && "on".equals(this.globalMultiplicity)) {
            this.globalMultiplicity = null;
        }
        this.areaOverlapValidation = this.validationConfig.getConfigValue("PARAMETER", "areaOverlapValidation");
        this.constraintValidation = this.validationConfig.getConfigValue("PARAMETER", "constraintValidation");
        this.defaultGeometryTypeValidation = this.validationConfig.getConfigValue("PARAMETER", "defaultGeometryTypeValidation");
        if (!this.singlePass) {
            this.objectPool = new ObjectPool(this.doItfOidPerTable, errs, errFact, this.tag2class, this.objPoolManager);
            this.linkPool = new LinkPool(this.objPoolManager);
        }
        if (resolverClasses != null) {
            this.extObjResolvers = new ArrayList<ExternalObjectResolver>();
            for (Class resolverClass : resolverClasses) {
                ExternalObjectResolver resolver = null;
                try {
                    resolver = (ExternalObjectResolver)resolverClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                resolver.init(td, settings, validationConfig, this.objectPool, errFact);
                this.extObjResolvers.add(resolver);
            }
        }
        if ((filename = settings.getValue(CONFIG_DEBUG_XTFOUT)) != null) {
            EhiLogger.traceState((String)("xtfout <" + filename + ">"));
            try {
                this.writer = new XtfWriter(new File(filename), td);
            }
            catch (IoxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void parseBasketList(Set<String> mandatoryBaskets, String baskets) {
        if (baskets != null) {
            String[] basketv;
            for (String basket : basketv = baskets.split(";")) {
                mandatoryBaskets.add(basket);
            }
        }
    }

    public void close() {
        if (this.objPoolManager != null) {
            this.objPoolManager.close();
            this.objPoolManager = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IoxException e) {
                throw new IllegalArgumentException(e);
            }
            this.writer = null;
        }
    }

    public IoxValidationDataPool getDataPool() {
        return null;
    }

    public IoxLogging getLoggingHandler() {
        return this.errs;
    }

    public void setLoggingHandler(IoxLogging handler) {
        this.errs = handler;
    }

    public void addReferenceData(IoxEvent event) {
        this.validate(event, false);
    }

    public void validate(IoxEvent event) {
        this.validate(event, true);
    }

    private void validate(IoxEvent event, boolean doValidation) {
        if (this.validationOff) {
            return;
        }
        if (event instanceof StartTransferEvent) {
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validate.firstValidationPass"), new String[0]));
            if (doValidation) {
                this.validateInconsistentIliAndXMLVersion(event);
            }
            this.uniquenessOfBid.clear();
            this.uniquenessOfBid.putAll(this.stableBids);
            if (!this.singlePass) {
                this.objectPool.startNewTransfer();
            }
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent startBasketEvent = (StartBasketEvent)event;
            this.currentBasketId = startBasketEvent.getBid();
            if (this.isValidId(this.currentBasketId) && !this.singlePass) {
                this.objectPool.startBasket(this.currentBasketId, doValidation);
            }
            this.validateBasketEvent(startBasketEvent);
        } else if (event instanceof ObjectEvent) {
            Iom_jObject iomObj = new Iom_jObject(((ObjectEvent)event).getIomObject());
            try {
                this.validateObject(iomObj, null, null, doValidation);
            }
            catch (IoxException e) {
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validate.failedToValidateObject"), ((Object)iomObj).toString()));
            }
            catch (RuntimeException e) {
                EhiLogger.traceState((String)(this.rsrc.getString("validate.failingObject") + ((Object)iomObj).toString()));
                throw e;
            }
        } else if (event instanceof EndBasketEvent) {
            this.cleanupCurrentBasket();
        } else if (event instanceof EndTransferEvent && doValidation && this.autoSecondPass) {
            this.doSecondPass();
        }
        if (this.writer != null) {
            try {
                this.writer.write(event);
            }
            catch (IoxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void validateInconsistentIliAndXMLVersion(IoxEvent event) {
        String versionControl = this.settings.getValue(CONFIG_DO_XTF_VERIFYMODEL);
        if (versionControl != null && versionControl.equals(CONFIG_DO_XTF_VERIFYMODEL_DO) && event instanceof XtfStartTransferEvent) {
            XtfStartTransferEvent startTransferEvent = (XtfStartTransferEvent)event;
            Collection<IomObject> headerObjValues = startTransferEvent.getHeaderObjects().values();
            ArrayList<IomObject> headerObjects = new ArrayList<IomObject>(headerObjValues);
            for (IomObject currentObj : headerObjects) {
                String currentModelName;
                Model model;
                String iliVersion;
                String currentVersion;
                if (!currentObj.getobjecttag().equals("iom04.metamodel.ModelEntry") || currentObj.getattrvaluecount("version") <= 0 || (currentVersion = currentObj.getattrvalue("version")).equals(iliVersion = (model = this.getModelFromTransferDesc(currentModelName = currentObj.getattrvalue("model"))).getModelVersion())) continue;
                String versionInfoMessage = "The VERSION in model (" + currentModelName + ") and transferfile do not match (" + iliVersion + "!=" + currentVersion + ")";
                this.errs.addEvent(this.errFact.logInfoMsg(versionInfoMessage, new String[0]));
            }
        }
    }

    private Model getModelFromTransferDesc(String modelName) {
        Iterator modeli = this.td.iterator();
        ArrayList list = new ArrayList();
        while (modeli.hasNext()) {
            list.add(0, modeli.next());
        }
        for (Model model : list) {
            if (!model.getName().equals(modelName)) continue;
            return model;
        }
        return null;
    }

    private void cleanupCurrentBasket() {
        this.currentMainOid = null;
        this.errFact.setDataObj(null);
        this.genericDomains.clear();
    }

    private void validateBasketEvent(StartBasketEvent event) {
        Object bid;
        boolean isValid = true;
        Topic topic = null;
        Model model = null;
        this.errFact.setTid(event.getBid());
        String topicQName = event.getType();
        this.errFact.setIliqname(topicQName);
        if (!this.isValidTopicName(topicQName)) {
            isValid = false;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.invalidBasketElementName"), topicQName));
        }
        if (!this.isValidId(event.getBid())) {
            isValid = false;
            LogEventFactory factory = new LogEventFactory();
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.valueIsNotAValidBID"), event.getBid() == null ? "" : event.getBid()));
        }
        this.seenTopics.add(topicQName);
        if (!(!isValid || this.mandatoryBaskets.contains(topicQName) || this.mandatoryBaskets.contains("ANY") || this.optionalBaskets.contains(topicQName) || this.optionalBaskets.contains("ANY") || !this.bannedBaskets.contains(topicQName) && !this.bannedBaskets.contains("ANY"))) {
            isValid = false;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.bannedBasket"), topicQName));
        }
        Domain bidDomain = null;
        if (isValid) {
            topic = (Topic)this.td.getElement(topicQName);
            model = (Model)topic.getContainer();
            this.seenModels.add(model.getName());
            this.collectSetConstraints(topic);
            bidDomain = topic.getBasketOid();
            if (bidDomain != null && !this.isAValidBasketOID(bidDomain, event.getBid())) {
                isValid = false;
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.valueIsNotAValidBID"), event.getBid() == null ? "" : event.getBid()));
            }
        }
        if (isValid && (bid = event.getBid()) != null) {
            if (bidDomain == this.td.INTERLIS.UUIDOID) {
                bid = Validator.normalizeUUID((String)bid);
            }
            if (this.uniquenessOfBid.containsKey(bid)) {
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateUniqueBasketId.bidOfAlreadyExistIn"), new String[]{bid, topicQName, this.uniquenessOfBid.get(bid)}));
            } else {
                this.uniquenessOfBid.put((String)bid, topicQName);
                if (bidDomain != null) {
                    this.stableBids.put((String)bid, topicQName);
                }
            }
        }
        this.genericDomains.clear();
        if (isValid) {
            for (Map.Entry entry : ((ch.interlis.iox_j.StartBasketEvent)event).getDomains().entrySet()) {
                String genericDomainName = (String)entry.getKey();
                Element genericDomain = this.td.getElement(genericDomainName);
                if (!(genericDomain instanceof Domain)) {
                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.genericDomainNotFound"), genericDomainName));
                    continue;
                }
                String concreteDomainName = (String)entry.getValue();
                Element concreteDomain = this.td.getElement(concreteDomainName);
                if (concreteDomain instanceof Domain) {
                    if (!this.validateDeferredGeneric(model, topic, (Domain)genericDomain, (Domain)concreteDomain)) continue;
                    this.genericDomains.put(genericDomainName, (Domain)concreteDomain);
                    continue;
                }
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.concreteDomainNotFound"), concreteDomainName, genericDomainName));
            }
        }
        if (isValid && "2.4".equals(model.getIliVersion()) && model.getTranslationOf() != null) {
            Model baseModel = (Model)model.getTranslationOf();
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.Ili24TranslatedTransferNotAllowed"), topicQName, model.getLanguage(), baseModel.getLanguage()));
        }
    }

    private static <T> boolean arrayContains(T[] array, T value) {
        for (T object : array) {
            if (object != value) continue;
            return true;
        }
        return false;
    }

    private boolean validateDeferredGeneric(Model model, Topic topic, Domain genericDomain, Domain concreteDomain) {
        Type genericType = genericDomain.getType();
        if (!(genericType instanceof AbstractCoordType) || !((AbstractCoordType)genericType).isGeneric()) {
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.domainNotGeneric"), genericDomain.toString()));
            return false;
        }
        if (!Validator.arrayContains(topic.getDefferedGenerics(), genericDomain)) {
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.genericNotDeferred"), genericDomain.toString()));
            return false;
        }
        Domain[] resolved = model.resolveGenericDomain(genericDomain);
        if (resolved == null) {
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateCoordType.missingContext"), genericDomain.toString()));
            return false;
        }
        if (!Validator.arrayContains(resolved, concreteDomain)) {
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateCoordType.invalidDomain"), concreteDomain.toString(), genericDomain.toString()));
            return false;
        }
        return true;
    }

    private boolean isAValidBasketOID(Domain domain, String bid) {
        Type type = domain.getType();
        return !(domain == this.td.INTERLIS.UUIDOID ? !this.isValidUuid(bid) : (domain == this.td.INTERLIS.STANDARDOID ? !this.isValidAnnexOid(bid) : type instanceof TextOIDType && !this.isValidTextOid(bid, ((TextType)((TextOIDType)type).getOIDType()).getMaxLength())));
    }

    private boolean isValidTopicName(String topicName) {
        Element element = this.td.getElement(topicName);
        return element != null && element instanceof Topic;
    }

    private boolean isValidId(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        Matcher matcher = this.patternForIdValidation.matcher(valueStr);
        return matcher.matches();
    }

    private boolean isValidAnnexOid(String valueStr) {
        if (valueStr == null) {
            return false;
        }
        if (valueStr.length() != 16) {
            return false;
        }
        Matcher matcher = this.patternForStandartOidValidation.matcher(valueStr);
        return matcher.matches();
    }

    private boolean isValidTextOid(String valueStr, int maxLength) {
        if (valueStr == null) {
            return false;
        }
        int len = valueStr.length();
        if (len == 0) {
            return false;
        }
        if (maxLength != -1 && len > maxLength) {
            return false;
        }
        Matcher matcher = this.patternForTextOIdValidation.matcher(valueStr);
        return matcher.matches();
    }

    public void doSecondPass() {
        if (!this.singlePass) {
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("doSecondPass.secondValidationPass"), new String[0]));
            for (String mandatoryBasket : this.mandatoryBaskets) {
                if ("ANY".equals(mandatoryBasket) || this.seenTopics.contains(mandatoryBasket)) continue;
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateBasketEvent.mandatoryBasketMissing"), mandatoryBasket));
            }
            this.iterateThroughReferencedModels();
            String additionalModelsConfig = this.validationConfig.getConfigValue("PARAMETER", "additionalModels");
            if (additionalModelsConfig != null) {
                String[] additionalModels = additionalModelsConfig.split(";");
                this.iterateThroughAdditionalModels(additionalModels);
            }
            this.iterateThroughAllObjects();
            this.validateAllAreas();
            this.validatePlausibilityConstraints();
        }
    }

    private void iterateThroughReferencedModels() {
        HashSet<String> iteratedModels = new HashSet<String>();
        for (String modelName : this.seenModels) {
            Element modelElement = this.td.getElement(modelName);
            if (!(modelElement instanceof DataModel)) continue;
            DataModel model = (DataModel)modelElement;
            this.iterateThroughReferencedModel(model, iteratedModels);
        }
    }

    private void iterateThroughReferencedModel(DataModel model, HashSet<String> iteratedModels) {
        if (iteratedModels.contains(model.getName())) {
            return;
        }
        iteratedModels.add(model.getName());
        for (Element modelEntry : model) {
            if (!(modelEntry instanceof Topic)) continue;
            Topic topic = (Topic)modelEntry;
            for (Element topicEntry : topic) {
                if (!(topicEntry instanceof Projection)) continue;
                Projection view = (Projection)topicEntry;
                this.collectProjectionConstraints(view);
            }
        }
        for (Model importedModel : model.getImporting()) {
            if (!(importedModel instanceof DataModel)) continue;
            this.iterateThroughReferencedModel((DataModel)importedModel, iteratedModels);
        }
    }

    private void iterateThroughAdditionalModels(String[] additionalModels) {
        if (additionalModels == null) {
            return;
        }
        for (int modelIndex = 0; modelIndex < additionalModels.length; ++modelIndex) {
            String additionalModel = additionalModels[modelIndex];
            if (additionalModel == null || this.seenModels.contains(additionalModel)) continue;
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("iterateThroughAdditionalModels.additionalModel"), additionalModel));
            this.seenModels.add(additionalModel);
            Iterator tdIterator = this.td.iterator();
            boolean modelExists = false;
            while (tdIterator.hasNext()) {
                DataModel model;
                Object modelObj = tdIterator.next();
                if (!(modelObj instanceof DataModel) || !(model = (DataModel)modelObj).getName().equals(additionalModel)) continue;
                modelExists = true;
                this.collectAdditionalConstraints(model);
            }
            if (modelExists) continue;
            this.logMsg(additionalModel, this.rsrc.getString("iterateThroughAdditionalModels.requiredAdditionalModelNotFound"), additionalModel);
        }
    }

    private void collectAdditionalConstraints(DataModel model) {
        for (Object modelObj : model) {
            Topic topic;
            if (!(modelObj instanceof Topic) || !(topic = (Topic)modelObj).isViewTopic()) continue;
            for (Object topicObj : topic) {
                if (!(topicObj instanceof Projection)) continue;
                Projection view = (Projection)topicObj;
                this.collectProjectionConstraints(view);
            }
        }
    }

    private void collectProjectionConstraints(Projection view) {
        if (view.getSelected().getAliasing() == null) {
            return;
        }
        for (Object constraintObj : view) {
            if (!(constraintObj instanceof Constraint)) continue;
            Constraint constraint = (Constraint)constraintObj;
            String constraintName = this.getScopedName(constraint);
            String checkConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkConstraint)) {
                if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                this.configOffOufputReduction.add("check:" + constraintName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("collectAdditionalConstraints.validationConfigurationCheckOff"), constraintName));
                continue;
            }
            this.additionalConstraints.put(constraint, view);
        }
    }

    private void validateAllAreas() {
        this.setCurrentMainObj(null);
        for (AttributeDef attr : this.areaAttrs.keySet()) {
            ItfAreaPolygon2Linetable allLines = this.areaAttrs.get(attr);
            Boolean surfaceTopologiesValid = this.areaAttrsAreSurfaceTopologiesValid.get(attr);
            if (surfaceTopologiesValid != null && !surfaceTopologiesValid.booleanValue()) continue;
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAllAreas.validateAREA"), this.getScopedName(attr)));
            AbstractSurfaceOrAreaType type = (AbstractSurfaceOrAreaType)attr.getDomainResolvingAliases();
            double maxOverlap = type.getMaxOverlap() == null ? 0.0 : type.getMaxOverlap().doubleValue();
            List<IoxInvalidDataException> intersections = null;
            intersections = this.legacyAreAreas ? allLines.validate0(maxOverlap) : allLines.validate1(maxOverlap);
            if (intersections == null || intersections.isEmpty()) continue;
            for (IoxInvalidDataException ex : intersections) {
                String tid1 = ex.getTid();
                String iliqname = ex.getIliqname();
                this.errFact.setTid(tid1);
                this.errFact.setIliqname(iliqname);
                if (ex instanceof IoxIntersectionException) {
                    IoxIntersectionException intersectionEx = (IoxIntersectionException)ex;
                    this.logMsg(this.areaOverlapValidation, intersectionEx);
                    EhiLogger.traceState((String)intersectionEx.toString());
                    continue;
                }
                this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
            }
            this.setCurrentMainObj(null);
            this.logMsg(this.areaOverlapValidation, this.rsrc.getString("validateAllAreas.failedToValidateAREA"), this.getScopedName(attr));
        }
    }

    private String getScopedName(AttributeDef attr) {
        return attr.getContainer().getScopedName(null) + "." + attr.getName();
    }

    private String getScopedName(RoleDef roleDef) {
        return roleDef.getContainer().getScopedName(null) + "." + roleDef.getName();
    }

    private String getScopedName(Constraint cnstr) {
        return cnstr.getContainer().getScopedName(null) + "." + cnstr.getName();
    }

    private String getScopedName(Viewable viewable) {
        return viewable.getContainer().getScopedName(null) + "." + viewable.getName();
    }

    private String getDisplayName(Constraint cnstr) {
        String scopedContainerName = cnstr.getContainer().getScopedName(null);
        String constraintName = cnstr.getName();
        if (this.isVerbose) {
            return String.format("%s.%s (%s)", scopedContainerName, constraintName, this.getConditionString(cnstr));
        }
        return String.format("%s.%s", scopedContainerName, constraintName);
    }

    private String getConditionString(Constraint constraint) {
        StringWriter stringWriter = new StringWriter();
        Interlis2Generator generator = Interlis2Generator.generateElements((Writer)stringWriter, (TransferDescription)this.td);
        generator.printConstraint(constraint, true);
        String constraintDefinition = stringWriter.toString();
        return constraintDefinition.replaceAll("\\s+", " ").trim();
    }

    private boolean isBasketSame(String bidOfTargetObject, IomObject iomObj) {
        String objectBid;
        if (iomObj == null) {
            return false;
        }
        Object modelElement = this.tag2class.get(iomObj.getobjecttag());
        Viewable classOfCurrentObj = (Viewable)modelElement;
        String oid = iomObj.getobjectoid();
        if (oid == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)modelElement);
        }
        if ((objectBid = this.objectPool.getBidOfObject(oid, classOfCurrentObj)) == null) {
            return false;
        }
        return objectBid.equals(bidOfTargetObject);
    }

    private void iterateThroughAllObjects() {
        HashSet types = new HashSet();
        for (String basketId : this.objectPool.getDataBids()) {
            Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
            this.updateCurrentBasket(basketId);
            while (objectIterator.hasNext()) {
                RoleDef role;
                IomObject iomObj = (IomObject)objectIterator.next();
                if (iomObj == null) continue;
                this.setCurrentMainObj(iomObj);
                this.errFact.setDefaultCoord(this.getDefaultCoord(iomObj));
                Object modelElement = this.tag2class.get(iomObj.getobjecttag());
                Viewable classOfCurrentObj = (Viewable)modelElement;
                if (!"off".equals(this.constraintValidation)) {
                    for (Map.Entry<Constraint, Projection> additionalConstraintsEntry : this.additionalConstraints.entrySet()) {
                        String constraintName;
                        Constraint additionalConstraint = additionalConstraintsEntry.getKey();
                        Projection view = additionalConstraintsEntry.getValue();
                        Viewable classOfAdditionalConstraint = view.getSelected().getAliasing();
                        if (!classOfCurrentObj.isExtending((Element)classOfAdditionalConstraint) || !this.viewIncludesObject(view, iomObj)) continue;
                        if (additionalConstraint instanceof ExistenceConstraint) {
                            ExistenceConstraint existenceConstraint = (ExistenceConstraint)additionalConstraint;
                            this.validateExistenceConstraint(iomObj, existenceConstraint);
                            continue;
                        }
                        if (additionalConstraint instanceof MandatoryConstraint) {
                            MandatoryConstraint mandatoryConstraint = (MandatoryConstraint)additionalConstraint;
                            this.validateMandatoryConstraint(null, iomObj, mandatoryConstraint, null);
                            continue;
                        }
                        if (additionalConstraint instanceof SetConstraint) {
                            SetConstraint setConstraint = (SetConstraint)additionalConstraint;
                            constraintName = this.getScopedName((Constraint)setConstraint);
                            String checkAdditionalConstraint = null;
                            if (!this.enforceConstraintValidation) {
                                checkAdditionalConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                            }
                            if ("off".equals(checkAdditionalConstraint)) {
                                if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                                this.configOffOufputReduction.add("check:" + constraintName);
                                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("iterateThroughAllObjects.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                                continue;
                            }
                            this.collectSetConstraintObj(checkAdditionalConstraint, constraintName, iomObj, setConstraint);
                            continue;
                        }
                        if (additionalConstraint instanceof UniquenessConstraint) {
                            UniquenessConstraint uniquenessConstraint = (UniquenessConstraint)additionalConstraint;
                            String iomObjOid = iomObj.getobjectoid();
                            if (iomObjOid == null && classOfCurrentObj instanceof AssociationDef) {
                                iomObjOid = ObjectPool.getAssociationId(iomObj, (AssociationDef)classOfCurrentObj);
                            }
                            this.validateUniquenessConstraint(null, iomObj, iomObjOid, uniquenessConstraint, null);
                            continue;
                        }
                        if (!(additionalConstraint instanceof PlausibilityConstraint)) continue;
                        PlausibilityConstraint plausibilityConstraint = (PlausibilityConstraint)additionalConstraint;
                        constraintName = this.getScopedName((Constraint)plausibilityConstraint);
                        String checkPlausibilityConstraint = null;
                        if (!this.enforceConstraintValidation) {
                            checkPlausibilityConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                        }
                        if ("off".equals(checkPlausibilityConstraint)) {
                            if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                            this.configOffOufputReduction.add("check:" + constraintName);
                            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("iterateThroughAllObjects.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                            continue;
                        }
                        this.fillOfPlausibilityConstraintMap(checkPlausibilityConstraint, constraintName, plausibilityConstraint, iomObj);
                    }
                }
                this.validateConstraints(iomObj, classOfCurrentObj);
                String objectBid = this.objectPool.getBidOfObject(iomObj.getobjectoid(), classOfCurrentObj);
                this.validateReferenceAttrs("", iomObj, classOfCurrentObj, objectBid);
                Iterator attrIterator = classOfCurrentObj.getAttributesAndRoles2();
                while (attrIterator.hasNext()) {
                    ViewableTransferElement objA = (ViewableTransferElement)attrIterator.next();
                    if (!(objA.obj instanceof RoleDef)) continue;
                    RoleDef roleDef = (RoleDef)objA.obj;
                    this.validateRoleReference(basketId, roleDef, iomObj);
                }
                if (!(classOfCurrentObj instanceof AbstractClassDef)) continue;
                AbstractClassDef abstractClassDef = (AbstractClassDef)classOfCurrentObj;
                Iterator<RoleDef> targetRoleIterator = this.getOpposideRoles(abstractClassDef);
                while (targetRoleIterator.hasNext()) {
                    role = targetRoleIterator.next();
                    this.validateRoleCardinality(role, iomObj);
                }
                targetRoleIterator = this.getOpposideForNonNavigableRoles(abstractClassDef);
                while (targetRoleIterator.hasNext()) {
                    role = targetRoleIterator.next();
                    this.validateRoleCardinality(role, iomObj);
                }
            }
            for (SetConstraint setConstraint : this.setConstraints.keySet()) {
                if (!setConstraint.perBasket()) continue;
                this.validateSetConstraint(setConstraint);
            }
        }
        for (SetConstraint setConstraint : this.setConstraints.keySet()) {
            if (setConstraint.perBasket()) continue;
            this.validateSetConstraint(setConstraint);
        }
    }

    private Iterator<RoleDef> getOpposideForNonNavigableRoles(AbstractClassDef classDef) {
        ArrayList<RoleDef> result = new ArrayList<RoleDef>();
        Iterator rolei = classDef.getTargetForNonNavigableRoles();
        while (rolei.hasNext()) {
            RoleDef role = (RoleDef)rolei.next();
            role = this.findExtendedRole(classDef, role);
            AssociationDef assoc = (AssociationDef)role.getContainer();
            Iterator iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Element oppRole = (Element)iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role) continue;
                result.add((RoleDef)oppRole);
            }
        }
        return result.iterator();
    }

    private Iterator<RoleDef> getOpposideRoles(AbstractClassDef classDef) {
        ArrayList<RoleDef> result = new ArrayList<RoleDef>();
        Iterator rolei = classDef.getTargetForRoles();
        while (rolei.hasNext()) {
            RoleDef role = (RoleDef)rolei.next();
            role = this.findExtendedRole(classDef, role);
            AssociationDef assoc = (AssociationDef)role.getContainer();
            Iterator iter = assoc.getAttributesAndRoles();
            while (iter.hasNext()) {
                Element oppRole = (Element)iter.next();
                if (!(oppRole instanceof RoleDef) || oppRole == role) continue;
                result.add((RoleDef)oppRole);
            }
        }
        return result.iterator();
    }

    private RoleDef findExtendedRole(AbstractClassDef target, RoleDef role) {
        ArrayList extRoles = new ArrayList();
        extRoles.addAll(role.getExtensions());
        Collections.sort(extRoles, new Comparator<RoleDef>(){

            @Override
            public int compare(RoleDef o1, RoleDef o2) {
                return -Integer.valueOf(o1.getDefidx()).compareTo(o2.getDefidx());
            }
        });
        for (RoleDef found : extRoles) {
            if (!target.isExtending((Element)found.getDestination())) continue;
            return found;
        }
        return role;
    }

    public boolean viewIncludesObject(Projection view, IomObject iomObj) {
        String viewName = this.getScopedName((Viewable)view);
        for (Object viewEntry : view) {
            ExpressionSelection selection;
            Evaluable whereExpression;
            Value result;
            if (!(viewEntry instanceof ExpressionSelection) || (result = this.evaluateExpression(null, null, viewName, iomObj, whereExpression = (selection = (ExpressionSelection)viewEntry).getCondition(), null)).skipEvaluation() || result.isTrue()) continue;
            return false;
        }
        return true;
    }

    private void updateCurrentBasket(String basketId) {
        this.currentBasketId = basketId;
        for (UniquenessConstraint uniquenessConstraint : this.seenUniqueConstraintValues.keySet()) {
            if (!uniquenessConstraint.perBasket()) continue;
            this.seenUniqueConstraintValues.get(uniquenessConstraint).clear();
        }
        for (SetConstraint setConstraint : this.setConstraints.keySet()) {
            if (!setConstraint.perBasket() || this.setConstraints.get(setConstraint) == null) continue;
            this.setConstraints.get(setConstraint).clear();
        }
    }

    private void validateConstraints(IomObject iomObj, Viewable classOfIomObj) {
        if (!"off".equals(this.constraintValidation)) {
            for (Viewable classOfCurrentObj = classOfIomObj; classOfCurrentObj != null; classOfCurrentObj = (Viewable)classOfCurrentObj.getExtending()) {
                for (Object constraintObj : classOfCurrentObj) {
                    String constraintName;
                    if (constraintObj instanceof ExistenceConstraint) {
                        ExistenceConstraint existenceConstraint = (ExistenceConstraint)constraintObj;
                        this.validateExistenceConstraint(iomObj, existenceConstraint);
                    }
                    if (constraintObj instanceof MandatoryConstraint) {
                        MandatoryConstraint mandatoryConstraint = (MandatoryConstraint)constraintObj;
                        this.validateMandatoryConstraint(null, iomObj, mandatoryConstraint, null);
                    }
                    if (constraintObj instanceof UniquenessConstraint) {
                        String iomObjOid = iomObj.getobjectoid();
                        if (iomObjOid == null && classOfIomObj instanceof AssociationDef) {
                            iomObjOid = ObjectPool.getAssociationId(iomObj, (AssociationDef)classOfIomObj);
                        }
                        UniquenessConstraint uniquenessConstraint = (UniquenessConstraint)constraintObj;
                        this.validateUniquenessConstraint(null, iomObj, iomObjOid, uniquenessConstraint, null);
                    }
                    if (constraintObj instanceof SetConstraint) {
                        SetConstraint setConstraint = (SetConstraint)constraintObj;
                        constraintName = this.getScopedName((Constraint)setConstraint);
                        String checkSetConstraint = null;
                        if (!this.enforceConstraintValidation) {
                            checkSetConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                        }
                        if ("off".equals(checkSetConstraint)) {
                            if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                                this.configOffOufputReduction.add("check:" + constraintName);
                                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateConstraints.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                            }
                        } else {
                            this.collectSetConstraintObj(checkSetConstraint, constraintName, iomObj, setConstraint);
                        }
                    }
                    if (!(constraintObj instanceof PlausibilityConstraint)) continue;
                    PlausibilityConstraint plausibilityConstraint = (PlausibilityConstraint)constraintObj;
                    constraintName = this.getScopedName((Constraint)plausibilityConstraint);
                    String checkPlausibilityConstraint = null;
                    if (!this.enforceConstraintValidation) {
                        checkPlausibilityConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                    }
                    if ("off".equals(checkPlausibilityConstraint)) {
                        if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                        this.configOffOufputReduction.add("check:" + constraintName);
                        this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateConstraints.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                        continue;
                    }
                    this.fillOfPlausibilityConstraintMap(checkPlausibilityConstraint, constraintName, plausibilityConstraint, iomObj);
                }
            }
            Iterator iter = classOfIomObj.getAttributesAndRoles2();
            while (iter.hasNext()) {
                ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                if (obj.obj instanceof AttributeDef) {
                    Type proxyType;
                    AttributeDef attr = (AttributeDef)obj.obj;
                    if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                    Type type = attr.getDomainResolvingAliases();
                    String attrName = attr.getName();
                    if (!(type instanceof CompositionType)) continue;
                    Table structType = ((CompositionType)type).getComponentType();
                    int structc = iomObj.getattrvaluecount(attrName);
                    for (int structi = 0; structi < structc; ++structi) {
                        IomObject structEle = iomObj.getattrobj(attrName, structi);
                        if (structEle == null) continue;
                        this.validateConstraints(structEle, (Viewable)structType);
                    }
                    continue;
                }
                if (!(obj.obj instanceof RoleDef) || !obj.embedded) continue;
                this.validateConstraintsOfEmbeddedAssociation((RoleDef)obj.obj, iomObj);
            }
        }
    }

    private void validateConstraintsOfEmbeddedAssociation(RoleDef role, IomObject iomObj) {
        int propc = iomObj.getattrvaluecount(role.getName());
        if (propc >= 1) {
            IomObject embeddedLinkObj = iomObj.getattrobj(role.getName(), 0);
            AssociationDef roleOwner = (AssociationDef)role.getContainer();
            AssociationDef classOfCurrentObj = roleOwner;
            if (classOfCurrentObj != null) {
                String iomObjOid = iomObj.getobjectoid();
                for (Object constraintObj : classOfCurrentObj) {
                    if (constraintObj instanceof UniquenessConstraint) {
                        UniquenessConstraint uniquenessConstraint = (UniquenessConstraint)constraintObj;
                        this.validateUniquenessConstraint(iomObj, embeddedLinkObj, iomObjOid, uniquenessConstraint, role);
                        continue;
                    }
                    if (!(constraintObj instanceof MandatoryConstraint)) continue;
                    MandatoryConstraint mandatoryConstraint = (MandatoryConstraint)constraintObj;
                    this.validateMandatoryConstraint(iomObj, embeddedLinkObj, mandatoryConstraint, role);
                }
            }
        }
    }

    private void fillOfPlausibilityConstraintMap(String validationKind, String usageScope, PlausibilityConstraint constraint, IomObject iomObj) {
        Evaluable condition = constraint.getCondition();
        Value conditionValue = this.evaluateExpression(null, validationKind, usageScope, iomObj, condition, null);
        if (this.plausibilityConstraints.containsKey(constraint)) {
            PlausibilityPoolValue poolConstraintValues = this.plausibilityConstraints.get(constraint);
            double successfulResults = poolConstraintValues.getSuccessfulResults();
            double totalSumOfConstraints = poolConstraintValues.getTotalSumOfConstraints();
            if (conditionValue.skipEvaluation() || conditionValue.isTrue()) {
                this.plausibilityConstraints.remove(constraint);
                this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(successfulResults + 1.0, totalSumOfConstraints + 1.0));
            } else {
                this.plausibilityConstraints.remove(constraint);
                this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(successfulResults, totalSumOfConstraints + 1.0));
            }
        } else if (conditionValue.skipEvaluation() || conditionValue.isTrue()) {
            this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(1.0, 1.0));
        } else {
            this.plausibilityConstraints.put(constraint, new PlausibilityPoolValue(0.0, 1.0));
        }
    }

    private void validatePlausibilityConstraints() {
        this.setCurrentMainObj(null);
        if (!"off".equals(this.constraintValidation)) {
            for (Map.Entry<PlausibilityConstraint, PlausibilityPoolValue> constraintEntry : this.plausibilityConstraints.entrySet()) {
                PlausibilityConstraint constraint = constraintEntry.getKey();
                String constraintName = this.getScopedName((Constraint)constraintEntry.getKey());
                String checkConstraint = null;
                if (!this.enforceConstraintValidation) {
                    checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                }
                if ("off".equals(checkConstraint)) {
                    if (this.configOffOufputReduction.contains("check:" + constraintName)) continue;
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validatePlausibilityConstraints.validationConfigurationCheckOff"), constraintName));
                    continue;
                }
                if (!this.constraintOutputReduction.contains(constraint + ":" + constraintName)) {
                    this.constraintOutputReduction.add(constraint + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validatePlausibilityConstraints.validatePlausibilityConstraint"), this.getScopedName((Constraint)constraintEntry.getKey())));
                }
                String actualLanguage = Locale.getDefault().getLanguage();
                String msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)constraintEntry.getKey()), "msg_" + actualLanguage);
                if (msg == null) {
                    msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)constraintEntry.getKey()), "msg");
                }
                if (msg != null && this.isVerbose) {
                    msg = String.format("%s %s", msg, this.getDisplayName((Constraint)constraint));
                }
                if (constraintEntry.getKey().getDirection() == 0) {
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validatePlausibilityConstraints.calculatedValue"), ">=", Double.toString(constraintEntry.getValue().getSuccessfulResults() / constraintEntry.getValue().getTotalSumOfConstraints() * 100.0), Double.toString(constraintEntry.getKey().getPercentage())));
                    if (constraintEntry.getValue().getSuccessfulResults() / constraintEntry.getValue().getTotalSumOfConstraints() * 100.0 >= constraintEntry.getKey().getPercentage()) continue;
                    if (msg != null && msg.length() > 0) {
                        this.logMsg(checkConstraint, msg, new String[0]);
                        continue;
                    }
                    this.logMsg(checkConstraint, this.rsrc.getString("validatePlausibilityConstraints.plausibilityConstraintIsNotTrue"), this.getDisplayName((Constraint)constraintEntry.getKey()));
                    continue;
                }
                if (constraintEntry.getKey().getDirection() != 1) continue;
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validatePlausibilityConstraints.calculatedValue"), "<=", Double.toString(constraintEntry.getValue().getSuccessfulResults() / constraintEntry.getValue().getTotalSumOfConstraints() * 100.0), Double.toString(constraintEntry.getKey().getPercentage())));
                if (constraintEntry.getValue().getSuccessfulResults() / constraintEntry.getValue().getTotalSumOfConstraints() * 100.0 <= constraintEntry.getKey().getPercentage()) continue;
                if (msg != null && msg.length() > 0) {
                    this.logMsg(checkConstraint, msg, new String[0]);
                    continue;
                }
                this.logMsg(checkConstraint, this.rsrc.getString("validatePlausibilityConstraints.plausibilityConstraintIsNotTrue"), this.getDisplayName((Constraint)constraintEntry.getKey()));
            }
        }
    }

    private void validateUniquenessConstraint(IomObject parentObject, IomObject iomObj, String iomObjOid, UniquenessConstraint uniquenessConstraint, RoleDef role) {
        if (!"off".equals(this.constraintValidation)) {
            String constraintName = this.getScopedName((Constraint)uniquenessConstraint);
            String checkUniqueConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkUniqueConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkUniqueConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateUniquenessConstraint.validationConfigurationCheckOff"), constraintName, iomObj.getobjectoid()));
                }
            } else {
                if (uniquenessConstraint.getPreCondition() != null) {
                    Value preConditionValue = this.evaluateExpression(parentObject, checkUniqueConstraint, constraintName, iomObj, uniquenessConstraint.getPreCondition(), role);
                    if (preConditionValue.isNotYetImplemented()) {
                        this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateUniquenessConstraint.functionInUniquenessConstraintIsNotYetImplemented"), constraintName));
                        return;
                    }
                    if (preConditionValue.skipEvaluation()) {
                        return;
                    }
                    if (!preConditionValue.isTrue()) {
                        return;
                    }
                }
                Object modelElement = this.tag2class.get(iomObj.getobjecttag());
                Viewable aClass1 = (Viewable)modelElement;
                if (!this.loggedObjects.contains(uniquenessConstraint)) {
                    this.loggedObjects.add(uniquenessConstraint);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateUniquenessConstraint.validateUniqeConstraint"), this.getScopedName((Constraint)uniquenessConstraint)));
                }
                HashMap<Object, HashMap<AttributeArray, String>> seenValues = null;
                seenValues = uniquenessConstraint.getLocal() ? new HashMap() : this.seenUniqueConstraintValues;
                if (uniquenessConstraint.getPrefix() != null) {
                    PathEl[] attrPath = uniquenessConstraint.getPrefix().getPathElements();
                    this.visitStructEle(checkUniqueConstraint, uniquenessConstraint, seenValues, iomObjOid, aClass1, attrPath, 0, parentObject, iomObj, role);
                } else {
                    this.visitStructEle(checkUniqueConstraint, uniquenessConstraint, seenValues, iomObjOid, aClass1, null, 0, parentObject, iomObj, role);
                }
            }
        }
    }

    private void visitStructEle(String checkUniqueConstraint, UniquenessConstraint uniquenessConstraint, HashMap<UniquenessConstraint, HashMap<AttributeArray, String>> seenValues, String iomObjOid, Viewable iomObjClass, PathEl[] attrPath, int i, IomObject parentObject, IomObject iomObj, RoleDef role) {
        if (attrPath == null || i >= attrPath.length) {
            OutParam values = new OutParam();
            String oidOfObjectWithDuplicateValue = this.validateUnique(seenValues, iomObjOid, parentObject, iomObj, uniquenessConstraint, (OutParam<AttributeArray>)values, role);
            if (oidOfObjectWithDuplicateValue != null) {
                String actualLanguage = Locale.getDefault().getLanguage();
                String msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)uniquenessConstraint), "msg_" + actualLanguage);
                if (msg == null) {
                    msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)uniquenessConstraint), "msg");
                }
                if (msg != null && msg.length() > 0) {
                    if (this.isVerbose) {
                        msg = String.format("%s %s", msg, this.getDisplayName((Constraint)uniquenessConstraint));
                    }
                    this.logMsg(checkUniqueConstraint, msg, new String[0]);
                } else {
                    this.logMsg(checkUniqueConstraint, this.rsrc.getString("visitStructEle.uniqueIsViolatedValuesAlreadyExistInObject"), this.getDisplayName((Constraint)uniquenessConstraint), ((AttributeArray)values.value).valuesAsString(), this.formatObjectId(oidOfObjectWithDuplicateValue, iomObjClass));
                }
            }
            return;
        }
        String attrName = attrPath[i].getName();
        int structElec = iomObj.getattrvaluecount(attrName);
        for (int structElei = 0; structElei < structElec; ++structElei) {
            IomObject structEle = iomObj.getattrobj(attrName, structElei);
            this.visitStructEle(checkUniqueConstraint, uniquenessConstraint, seenValues, iomObjOid, iomObjClass, attrPath, i + 1, parentObject, structEle, role);
        }
    }

    private String formatObjectId(String oid, Viewable classOfOid) {
        String actualLanguage = Locale.getDefault().getLanguage();
        ArrayList<Viewable> classes = new ArrayList<Viewable>();
        classes.add(classOfOid);
        IomObject iomObj = this.objectPool.getObject(oid, classes, null);
        String keymsg = this.validationConfig.getConfigValue(iomObj.getobjecttag(), "keymsg_" + actualLanguage);
        if (keymsg != null) {
            return LogEventFactory.formatMessage(keymsg, iomObj, new String[0]);
        }
        keymsg = this.validationConfig.getConfigValue(iomObj.getobjecttag(), "keymsg");
        return keymsg != null ? LogEventFactory.formatMessage(keymsg, iomObj, new String[0]) : oid;
    }

    private void collectSetConstraintObj(String validationKind, String constraintName, IomObject iomObj, SetConstraint setConstraint) {
        String oid;
        Evaluable preCondition = setConstraint.getPreCondition();
        Collection<String> objs = this.setConstraints.get(setConstraint);
        if (objs == null) {
            objs = new HashSet<String>();
            this.setConstraints.put(setConstraint, objs);
        }
        if (preCondition != null) {
            Value preConditionValue = this.evaluateExpression(null, validationKind, constraintName, iomObj, preCondition, null);
            if (preConditionValue.isNotYetImplemented()) {
                this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("collectSetConstraintObjs.functionInSetConstraintIsNotYetImplemented"), this.getScopedName((Constraint)setConstraint)));
                return;
            }
            if (preConditionValue.skipEvaluation()) {
                return;
            }
            if (!preConditionValue.isTrue()) {
                return;
            }
        }
        if ((oid = iomObj.getobjectoid()) == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)this.td.getElement(iomObj.getobjecttag()));
        }
        objs.add(oid);
    }

    private void collectSetConstraints(Topic topic) {
        while (topic != null) {
            for (Element ele : topic) {
                if (!(ele instanceof Viewable)) continue;
                Viewable view = (Viewable)ele;
                for (Object cObj : view) {
                    SetConstraint setConstraint;
                    if (!(cObj instanceof SetConstraint) || this.setConstraints.containsKey(setConstraint = (SetConstraint)cObj)) continue;
                    this.setConstraints.put(setConstraint, null);
                }
            }
            topic = (Topic)topic.getExtending();
        }
    }

    private void validateSetConstraint(SetConstraint setConstraint) {
        block11: {
            Evaluable preCondition;
            String checkConstraint;
            String constraintName;
            Collection<String> objs;
            block12: {
                this.setCurrentMainObj(null);
                if ("off".equals(this.constraintValidation)) break block11;
                objs = this.setConstraints.get(setConstraint);
                constraintName = this.getScopedName((Constraint)setConstraint);
                checkConstraint = null;
                if (!this.enforceConstraintValidation) {
                    checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
                }
                if (!"off".equals(checkConstraint)) break block12;
                if (this.configOffOufputReduction.contains("check:" + this.getScopedName((Constraint)setConstraint))) break block11;
                this.configOffOufputReduction.add("check:" + this.getScopedName((Constraint)setConstraint));
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateSetConstraint.validationConfigurationCheckOff"), this.getScopedName((Constraint)setConstraint)));
                break block11;
            }
            if (!this.constraintOutputReduction.contains(setConstraint + ":" + constraintName)) {
                this.constraintOutputReduction.add(setConstraint + ":" + constraintName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateSetConstraint.validateSetConstraint"), this.getScopedName((Constraint)setConstraint)));
            }
            if ((preCondition = setConstraint.getPreCondition()) == null && objs == null) {
                objs = new HashSet<String>();
            }
            Iterator<String> objIt = null;
            objIt = objs == null ? new HashSet().iterator() : objs.iterator();
            String oid = null;
            do {
                Evaluable condition;
                Value constraintValue;
                if (objIt.hasNext()) {
                    oid = objIt.next();
                }
                this.allObjIterator = objs == null ? null : objs.iterator();
                IomObject iomObj = null;
                if (oid != null) {
                    iomObj = this.objectPool.getObject(oid, null, null);
                    this.setCurrentMainObj(iomObj);
                    this.errFact.setDefaultCoord(this.getDefaultCoord(iomObj));
                }
                if ((constraintValue = this.evaluateExpression(null, checkConstraint, constraintName, iomObj, condition = setConstraint.getCondition(), null)).isNotYetImplemented()) {
                    this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateSetConstraint.functionInSetConstraintIsNotYetImplemented"), this.getScopedName((Constraint)setConstraint)));
                    return;
                }
                if (constraintValue.skipEvaluation()) {
                    return;
                }
                if (constraintValue.isTrue()) continue;
                String actualLanguage = Locale.getDefault().getLanguage();
                String msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)setConstraint), "msg_" + actualLanguage);
                if (msg == null) {
                    msg = this.validationConfig.getConfigValue(this.getScopedName((Constraint)setConstraint), "msg");
                }
                if (msg != null && msg.length() > 0) {
                    if (this.isVerbose) {
                        msg = String.format("%s %s", msg, this.getDisplayName((Constraint)setConstraint));
                    }
                    this.logMsg(checkConstraint, msg, new String[0]);
                    continue;
                }
                String constraintIdentifier = setConstraint + ":" + constraintName + (setConstraint.perBasket() ? ":Basket(" + this.currentBasketId + ")" : "");
                if (this.setConstraintOufputReduction.contains(constraintIdentifier)) continue;
                this.setConstraintOufputReduction.add(constraintIdentifier);
                this.logMsg(checkConstraint, this.rsrc.getString("validateSetConstraint.setConstraintIsNotTrue"), this.getDisplayName((Constraint)setConstraint));
            } while (objIt.hasNext());
        }
    }

    private void validateMandatoryConstraint(IomObject parentObject, IomObject iomObj, MandatoryConstraint mandatoryConstraintObj, RoleDef firstRole) {
        if (!"off".equals(this.constraintValidation)) {
            String constraintName = this.getScopedName((Constraint)mandatoryConstraintObj);
            String checkConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateMandatoryConstraint.validationConfigurationCheckOff"), constraintName));
                }
            } else {
                Evaluable condition;
                Value conditionValue;
                if (!this.constraintOutputReduction.contains(mandatoryConstraintObj + ":" + constraintName)) {
                    this.constraintOutputReduction.add(mandatoryConstraintObj + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateMandatoryConstraint.validateMandatoryConstraint"), this.getScopedName((Constraint)mandatoryConstraintObj)));
                }
                if (!(conditionValue = this.evaluateExpression(parentObject, checkConstraint, constraintName, iomObj, condition = mandatoryConstraintObj.getCondition(), firstRole)).isNotYetImplemented()) {
                    if (!conditionValue.skipEvaluation() && !conditionValue.isTrue()) {
                        String actualLanguage = Locale.getDefault().getLanguage();
                        String msg = this.validationConfig.getConfigValue(constraintName, "msg_" + actualLanguage);
                        if (msg == null) {
                            msg = this.validationConfig.getConfigValue(constraintName, "msg");
                        }
                        if (msg != null && msg.length() > 0) {
                            if (this.isVerbose) {
                                msg = String.format("%s %s", msg, this.getDisplayName((Constraint)mandatoryConstraintObj));
                            }
                            this.logMsg(checkConstraint, msg, new String[0]);
                        } else {
                            this.logMsg(checkConstraint, this.rsrc.getString("validateMandatoryConstraint.mandatoryConstraintIsNotTrue"), this.getDisplayName((Constraint)mandatoryConstraintObj));
                        }
                    }
                } else if (condition instanceof FunctionCall) {
                    FunctionCall functionCallObj = (FunctionCall)condition;
                    Function function = functionCallObj.getFunction();
                    this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateMandatoryConstraint.functionIsNotYetImplemented"), function.getScopedName(null)));
                    Value.createNotYetImplemented();
                } else {
                    this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("validateMandatoryConstraint.mandatoryConstraintIsNotYetImplemented"), mandatoryConstraintObj.getScopedName(null), iomObj.getobjecttag()));
                    Value.createNotYetImplemented();
                }
            }
        }
    }

    private Value evaluateExpressionToSingleValue(IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, Evaluable expression, RoleDef firstRole) {
        Value value = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, expression, firstRole);
        if (!value.skipEvaluation() && value.getValues() != null && value.getValues().length > 1) {
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("evaluateExpressionToSingleValue.expressionMustEvaluateToASingleValue"), expression.toString()));
            return Value.createSkipEvaluation();
        }
        return value;
    }

    public Value evaluateExpression(IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, Evaluable expression, RoleDef firstRole) {
        TextType texttype = new TextType();
        if (expression instanceof Expression.Equality) {
            Expression.Equality equality = (Expression.Equality)expression;
            Evaluable leftExpression = equality.getLeft();
            Evaluable rightExpression = equality.getRight();
            Value leftValue = this.evaluateExpressionToSingleValue(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpressionToSingleValue(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) == 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.GreaterThan) {
            Expression.GreaterThan greaterThan = (Expression.GreaterThan)expression;
            Evaluable leftExpression = greaterThan.getLeft();
            Evaluable rightExpression = greaterThan.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) > 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.GreaterThanOrEqual) {
            Expression.GreaterThanOrEqual greaterThanOrEqual = (Expression.GreaterThanOrEqual)expression;
            Evaluable leftExpression = greaterThanOrEqual.getLeft();
            Evaluable rightExpression = greaterThanOrEqual.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) >= 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.Inequality) {
            Expression.Inequality inEquality = (Expression.Inequality)expression;
            Evaluable leftExpression = inEquality.getLeft();
            Evaluable rightExpression = inEquality.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) != 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.LessThan) {
            Expression.LessThan lessThan = (Expression.LessThan)expression;
            Evaluable leftExpression = lessThan.getLeft();
            Evaluable rightExpression = lessThan.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) < 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.LessThanOrEqual) {
            Expression.LessThanOrEqual lessThanOrEqual = (Expression.LessThanOrEqual)expression;
            Evaluable leftExpression = lessThanOrEqual.getLeft();
            Evaluable rightExpression = lessThanOrEqual.getRight();
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, leftExpression, firstRole);
            if (leftValue.skipEvaluation()) {
                return leftValue;
            }
            if (leftValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, rightExpression, firstRole);
            if (rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (rightValue.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.compareTo(rightValue) <= 0.0) {
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.Negation) {
            Expression.Negation negation = (Expression.Negation)expression;
            Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, negation.getNegated(), firstRole);
            if (arg.skipEvaluation()) {
                return arg;
            }
            if (arg.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            if (arg.isTrue()) {
                return new Value(false);
            }
            return new Value(true);
        }
        if (expression instanceof Expression.Subexpression) {
            Expression.Subexpression negation = (Expression.Subexpression)expression;
            Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, negation.getSubexpression(), firstRole);
            if (arg.skipEvaluation()) {
                return arg;
            }
            if (arg.isUndefined()) {
                return Value.createSkipEvaluation();
            }
            return arg;
        }
        if (expression instanceof Expression.Conjunction) {
            Expression.Conjunction conjunction = (Expression.Conjunction)expression;
            Evaluable[] conjunctionArray = conjunction.getConjoined();
            for (int i = 0; i < conjunctionArray.length; ++i) {
                Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, conjunctionArray[i], firstRole);
                if (arg.skipEvaluation()) {
                    return arg;
                }
                if (arg.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (arg.isTrue()) continue;
                return new Value(false);
            }
            return new Value(true);
        }
        if (expression instanceof Expression.DefinedCheck) {
            Expression.DefinedCheck defined = (Expression.DefinedCheck)expression;
            Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, defined.getArgument(), firstRole);
            if (arg.skipEvaluation()) {
                return arg;
            }
            if (arg.isUndefined()) {
                return new Value(false);
            }
            return new Value(true);
        }
        if (expression instanceof Expression.Disjunction) {
            Expression.Disjunction disjunction = (Expression.Disjunction)expression;
            Evaluable[] disjunctionArray = disjunction.getDisjoined();
            for (int i = 0; i < disjunctionArray.length; ++i) {
                Value arg = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, disjunctionArray[i], firstRole);
                if (arg.skipEvaluation()) {
                    return arg;
                }
                if (arg.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (!arg.isTrue()) continue;
                return new Value(true);
            }
            return new Value(false);
        }
        if (expression instanceof Expression.Implication) {
            Expression.Implication implication = (Expression.Implication)expression;
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, implication.getLeft(), firstRole);
            Value rightValue = Value.createSkipEvaluation();
            if (!leftValue.skipEvaluation() && !leftValue.isUndefined() && leftValue.isTrue()) {
                rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, implication.getRight(), firstRole);
            }
            if (leftValue.skipEvaluation() || rightValue.skipEvaluation()) {
                return rightValue;
            }
            if (leftValue.isUndefined() || rightValue.isUndefined()) {
                return Value.createUndefined();
            }
            return new Value(!leftValue.isTrue() || leftValue.isTrue() && rightValue.isTrue());
        }
        if (expression instanceof Expression.Addition) {
            Expression.Addition addition = (Expression.Addition)expression;
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, addition.getLeft(), firstRole);
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, addition.getRight(), firstRole);
            if (leftValue.skipEvaluation() || rightValue.skipEvaluation()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.isUndefined() || rightValue.isUndefined()) {
                return Value.createUndefined();
            }
            return new Value(leftValue.getNumeric() + rightValue.getNumeric());
        }
        if (expression instanceof Expression.Subtraction) {
            Expression.Subtraction subtraction = (Expression.Subtraction)expression;
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, subtraction.getLeft(), firstRole);
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, subtraction.getRight(), firstRole);
            if (leftValue.skipEvaluation() || rightValue.skipEvaluation()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.isUndefined() || rightValue.isUndefined()) {
                return Value.createUndefined();
            }
            return new Value(leftValue.getNumeric() - rightValue.getNumeric());
        }
        if (expression instanceof Expression.Multiplication) {
            Expression.Multiplication multiplication = (Expression.Multiplication)expression;
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, multiplication.getLeft(), firstRole);
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, multiplication.getRight(), firstRole);
            if (leftValue.skipEvaluation() || rightValue.skipEvaluation()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.isUndefined() || rightValue.isUndefined()) {
                return Value.createUndefined();
            }
            return new Value(leftValue.getNumeric() * rightValue.getNumeric());
        }
        if (expression instanceof Expression.Division) {
            Expression.Division division = (Expression.Division)expression;
            Value leftValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, division.getLeft(), firstRole);
            Value rightValue = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, division.getRight(), firstRole);
            if (leftValue.skipEvaluation() || rightValue.skipEvaluation()) {
                return Value.createSkipEvaluation();
            }
            if (leftValue.isUndefined() || rightValue.isUndefined()) {
                return Value.createUndefined();
            }
            return new Value(leftValue.getNumeric() / rightValue.getNumeric());
        }
        if (expression instanceof Constant) {
            Constant constantObj = (Constant)expression;
            if (constantObj instanceof Constant.EnumConstOrRange) {
                Constant.EnumConstOrRange enumConstOrRange = (Constant.EnumConstOrRange)constantObj;
                if (enumConstOrRange instanceof Constant.Enumeration) {
                    Constant.Enumeration enumObj = (Constant.Enumeration)enumConstOrRange;
                    String value = this.getEnumerationConstantXtfValue(enumObj);
                    if (value.equals("true")) {
                        return new Value(true);
                    }
                    if (value.equals("false")) {
                        return new Value(false);
                    }
                    return new Value((Type)texttype, value);
                }
            } else if (constantObj instanceof Constant.Text) {
                Constant.Text textConstant = (Constant.Text)constantObj;
                if (textConstant != null) {
                    return new Value((Type)texttype, textConstant.getValue());
                }
            } else if (constantObj instanceof Constant.Numeric) {
                Constant.Numeric numericConstant = (Constant.Numeric)constantObj;
                if (numericConstant != null) {
                    return new Value((Type)texttype, numericConstant.getValue().toString());
                }
            } else if (constantObj instanceof Constant.Class) {
                Constant.Class classConstant = (Constant.Class)constantObj;
                if (classConstant != null && classConstant.getValue() instanceof Viewable) {
                    Viewable classValue = classConstant.getValue();
                    return new Value(classValue);
                }
            } else {
                Constant.AttributePath attrPath;
                if (constantObj instanceof Constant.Undefined) {
                    return Value.createUndefined();
                }
                if (constantObj instanceof Constant.AttributePath && (attrPath = (Constant.AttributePath)constantObj).getValue() instanceof LocalAttribute) {
                    LocalAttribute attrLocal = (LocalAttribute)attrPath.getValue();
                    String attrName = attrLocal.getName();
                    return new Value((Type)texttype, attrName);
                }
            }
        } else {
            if (expression instanceof FunctionCall) {
                FunctionCall functionCallObj = (FunctionCall)expression;
                Function currentFunction = functionCallObj.getFunction();
                String funcName = currentFunction.getScopedName(null);
                if (funcName.startsWith("Text.") || funcName.startsWith("Text_V2.")) {
                    if (this.textFunction == null) {
                        this.textFunction = new Text(this, this.td, this.validationConfig);
                    }
                    return this.textFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                if (funcName.startsWith("Math.") || funcName.startsWith("Math_V2.") || funcName.startsWith("Math_V2_1.")) {
                    if (this.mathFunction == null) {
                        this.mathFunction = new Math(this, this.td, this.validationConfig);
                    }
                    return this.mathFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                if (funcName.startsWith("MinimalRuntimeSystem01.")) {
                    if (this.rtsFunction == null) {
                        this.rtsFunction = new MinimalRuntimeSystem(this, this.td, this.validationConfig);
                    }
                    return this.rtsFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                if (!funcName.equals("INTERLIS.convertUnit") && funcName.startsWith("INTERLIS.")) {
                    if (this.interlisFunction == null) {
                        this.interlisFunction = new Interlis(this, this.td, this.validationConfig);
                    }
                    return this.interlisFunction.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, expression, this.functions, this.td, firstRole);
                }
                if (funcName.startsWith("INTERLIS_ext.")) {
                    if (this.interlis_ext == null) {
                        this.interlis_ext = new Interlis_ext(this, this.td, this.validationConfig);
                    }
                    return this.interlis_ext.evaluateFunction(currentFunction, parentObject, validationKind, usageScope, iomObj, expression, this.functions, this.td, firstRole);
                }
                if (funcName.startsWith("DMAVTYM_Topologie_V1_0.") || funcName.startsWith("DMAVTYM_Topologie_V1_1.")) {
                    if (this.dmavtymTopologie == null) {
                        this.dmavtymTopologie = new DmavtymTopologie(this, this.td, this.validationConfig, this.errFact);
                    }
                    return this.dmavtymTopologie.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                if (funcName.startsWith("Elements_V1_0.")) {
                    if (this.elementsFunctions == null) {
                        this.elementsFunctions = new ElementsFunctions(this, this.td, this.validationConfig, this.errFact);
                    }
                    return this.elementsFunctions.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, firstRole);
                }
                if (funcName.startsWith("ObjectPool_V1_0.")) {
                    if (this.objectPoolFunctions == null) {
                        this.objectPoolFunctions = new ObjectPoolFunctions(this, this.objectPool, this.errFact);
                    }
                    return this.objectPoolFunctions.evaluateFunction(currentFunction, functionCallObj, parentObject, validationKind, usageScope, iomObj, texttype, firstRole);
                }
                String functionQname = funcName;
                Class functionTargetClass = this.customFunctions.get(functionQname);
                if (functionTargetClass == null) {
                    return Value.createNotYetImplemented();
                }
                FunctionCall functionCall = (FunctionCall)expression;
                Evaluable[] arguments = functionCall.getArguments();
                int argumentCount = functionCall.getArguments().length;
                Value[] actualArguments = new Value[argumentCount];
                for (int i = 0; i < argumentCount; ++i) {
                    Value anObject = this.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[i], firstRole);
                    if (anObject.skipEvaluation()) {
                        return anObject;
                    }
                    actualArguments[i] = anObject;
                }
                InterlisFunction functionTarget = null;
                try {
                    functionTarget = (InterlisFunction)functionTargetClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                functionTarget.init(this.td, this.settings, this.validationConfig, this.objectPool, this.errFact);
                return functionTarget.evaluate(validationKind, usageScope, iomObj, actualArguments);
            }
            if (expression instanceof ObjectPath) {
                ObjectPath objectPathObj = (ObjectPath)expression;
                PathEl[] pathElements = objectPathObj.getPathElements();
                return this.getValueFromObjectPath(parentObject, iomObj, pathElements, firstRole);
            }
            if (expression instanceof Objects) {
                if (this.allObjIterator == null) {
                    return Value.createSkipEvaluation();
                }
                if (this.functions.containsKey(expression)) {
                    return this.functions.get(expression);
                }
                Iterator<String> objectIterator = this.allObjIterator;
                ArrayList<IomObject> listOfIomObjects = new ArrayList<IomObject>();
                while (objectIterator.hasNext()) {
                    String oid = objectIterator.next();
                    IomObject aIomObj = this.objectPool.getObject(oid, null, null);
                    if (aIomObj == null) continue;
                    listOfIomObjects.add(aIomObj);
                }
                Value listOfIomObjectsValue = new Value(listOfIomObjects);
                this.functions.put(expression, listOfIomObjectsValue);
                return listOfIomObjectsValue;
            }
            if (expression instanceof ValueRefThis) {
                Domain domain = (Domain)this.td.getElement(iomObj.getobjecttag());
                String value = iomObj.getattrvalue(VALUE_REF_THIS);
                return new Value(domain.getType(), value);
            }
            if (expression instanceof ParameterValue) {
                ParameterValue paramValue = (ParameterValue)expression;
                String paramName = paramValue.getParameter().getScopedName();
                String value = (String)this.td.getActualRuntimeParameter(paramName);
                if (value != null) {
                    return new Value((Type)texttype, value);
                }
                return Value.createUndefined();
            }
            this.errs.addEvent(this.errFact.logWarningMsg(this.rsrc.getString("evaluateExpression.ExpressionIsNotYetImplemented"), expression.toString()));
        }
        return Value.createSkipEvaluation();
    }

    public ObjectPath parseObjectOrAttributePath(Viewable viewable, String objectPath) throws Ili2cException {
        return Ili23Parser.parseObjectOrAttributePath((TransferDescription)this.td, (Viewable)viewable, (String)objectPath);
    }

    public Value getValueFromObjectPath(IomObject parentObject, IomObject iomObjStart, PathEl[] pathElements, RoleDef firstRole) {
        if (iomObjStart == null) {
            return Value.createSkipEvaluation();
        }
        ArrayList<IomObject> currentObjects = new ArrayList<IomObject>();
        ArrayList<Object> nextCurrentObjects = new ArrayList<IomObject>();
        RoleDef role = null;
        int lastPathIndex = pathElements.length - 1;
        currentObjects.add(iomObjStart);
        for (int k = 0; k < pathElements.length; ++k) {
            for (IomObject iomObj : currentObjects) {
                ViewableAlias alias;
                Viewable viewable;
                LocalAttribute localAttributeValue;
                PathEl currentPathEl = pathElements[k];
                if (currentPathEl instanceof PathElAbstractClassRole || currentPathEl instanceof PathElAssocRole || currentPathEl instanceof AssociationPath) {
                    Viewable srcObjClass;
                    if (currentPathEl instanceof PathElAbstractClassRole) {
                        PathElAbstractClassRole abstractClassRole = (PathElAbstractClassRole)currentPathEl;
                        role = abstractClassRole.getRole();
                    } else if (currentPathEl instanceof PathElAssocRole) {
                        role = ((PathElAssocRole)currentPathEl).getRole();
                    } else if (currentPathEl instanceof AssociationPath) {
                        role = ((AssociationPath)currentPathEl).getTargetRole();
                    }
                    if (role == null) {
                        throw new IllegalStateException(this.rsrc.getString("getValueFromObjectPath.roleIsNotBeEmpty"));
                    }
                    if (parentObject != null && k == 0) {
                        if (k == lastPathIndex) {
                            if (role == firstRole) {
                                nextCurrentObjects.add(iomObj);
                                continue;
                            }
                            Iom_jObject ref = new Iom_jObject("REF", null);
                            ref.setobjectrefoid(parentObject.getobjectoid());
                            nextCurrentObjects.add(ref);
                            continue;
                        }
                        if (role == firstRole) {
                            IomObject targetObj = this.getReferencedObject(role, iomObj.getobjectrefoid());
                            nextCurrentObjects.add(targetObj);
                            continue;
                        }
                        nextCurrentObjects.add(parentObject);
                        continue;
                    }
                    String targetOid = null;
                    IomObject roleDefValue = iomObj.getattrobj(role.getName(), 0);
                    if (roleDefValue != null) {
                        targetOid = roleDefValue.getobjectrefoid();
                    }
                    if (this.isBackward(srcObjClass = (Viewable)this.tag2class.get(iomObj.getobjecttag()), role)) {
                        List<IomObject> objects = null;
                        if (((AssociationDef)role.getContainer()).isLightweight()) {
                            objects = this.getTargetObjectsOfReverseRole(role, this.normalizeOid(srcObjClass, iomObj.getobjectoid()));
                            if (objects == null) continue;
                            nextCurrentObjects.addAll(objects);
                            continue;
                        }
                        objects = this.getLinkObjects(role, this.normalizeOid(srcObjClass, iomObj.getobjectoid()));
                        if (objects == null) continue;
                        if (currentPathEl instanceof PathElAssocRole || currentPathEl instanceof PathElAbstractClassRole) {
                            for (IomObject obj : objects) {
                                IomObject attrobj = obj.getattrobj(role.getName(), 0);
                                IomObject targetObj = this.getReferencedObject(role, attrobj.getobjectrefoid());
                                if (targetObj == null) continue;
                                ArrayList<IomObject> objct = new ArrayList<IomObject>();
                                objct.add(targetObj);
                                if (k != lastPathIndex) {
                                    nextCurrentObjects.add(targetObj);
                                    continue;
                                }
                                nextCurrentObjects.addAll(objct);
                            }
                            continue;
                        }
                        if (!(currentPathEl instanceof AssociationPath)) continue;
                        nextCurrentObjects.addAll(objects);
                        continue;
                    }
                    IomObject targetObj = this.getReferencedObject(role, targetOid);
                    if (targetObj == null) continue;
                    nextCurrentObjects.add(targetObj);
                    continue;
                }
                if (currentPathEl instanceof StructAttributeRef) {
                    StructAttributeRef structAttributeRefValue = (StructAttributeRef)currentPathEl;
                    if (!(structAttributeRefValue.getAttr() instanceof LocalAttribute)) continue;
                    localAttributeValue = (LocalAttribute)structAttributeRefValue.getAttr();
                    if (!(localAttributeValue.getDomain() instanceof CompositionType)) {
                        throw new IllegalStateException();
                    }
                    CompositionType type = (CompositionType)localAttributeValue.getDomain();
                    String currentAttrName = localAttributeValue.getName();
                    if (iomObj.getattrvaluecount(currentAttrName) == 0) continue;
                    IomObject targetObj = iomObj = this.getIomObjWithIndex(iomObj, structAttributeRefValue, currentAttrName);
                    if (k != lastPathIndex) {
                        nextCurrentObjects.add(targetObj);
                        continue;
                    }
                    String attrValue = iomObj.getattrvalue(currentAttrName);
                    if (attrValue != null) {
                        if (attrValue.equals("true")) {
                            return new Value(true);
                        }
                        if (attrValue.equals("false")) {
                            return new Value(false);
                        }
                        return new Value((Type)type, attrValue);
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    objects.add(targetObj);
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (currentPathEl instanceof AttributeRef) {
                    AttributeRef attrRef = (AttributeRef)currentPathEl;
                    Type type = attrRef.getAttr().getDomain();
                    String currentAttrName = currentPathEl.getName();
                    if (iomObj == null) {
                        return Value.createUndefined();
                    }
                    int attrCount = iomObj.getattrvaluecount(currentAttrName);
                    if (attrCount == 0) {
                        return Value.createUndefined();
                    }
                    if (k != lastPathIndex) {
                        for (int i = 0; i < attrCount; ++i) {
                            IomObject iomObjTmp = iomObj.getattrobj(currentAttrName, i);
                            nextCurrentObjects.add(iomObjTmp);
                        }
                        continue;
                    }
                    String attrValue = iomObj.getattrvalue(currentAttrName);
                    if (attrValue != null) {
                        if (currentObjects.size() == 1 && attrCount == 1) {
                            Type aliasedType;
                            if (attrRef.getAttr().isDomainIliUuid()) {
                                aliasedType = ((TypeAlias)type).getAliasing().getType();
                                return new Value(aliasedType, Validator.normalizeUUID(attrValue));
                            }
                            if (attrRef.getAttr().isDomainBoolean()) {
                                if (attrValue.equals("true")) {
                                    return new Value(true);
                                }
                                if (attrValue.equals("false")) {
                                    return new Value(false);
                                }
                            } else if (type instanceof TypeAlias) {
                                aliasedType = ((TypeAlias)type).getAliasing().getType();
                                if (aliasedType instanceof EnumerationType) {
                                    String domainName = ((TypeAlias)type).getAliasing().getName();
                                    return new Value(aliasedType, attrValue, domainName);
                                }
                                return new Value(aliasedType, attrValue);
                            }
                            return new Value(type, attrValue);
                        }
                        ArrayList<String> attrValues = new ArrayList<String>();
                        for (IomObject value : currentObjects) {
                            for (int attri = 0; attri < value.getattrvaluecount(currentAttrName); ++attri) {
                                attrValue = value.getattrprim(currentAttrName, attri);
                                if (attrValue == null) continue;
                                attrValues.add(attrValue);
                            }
                        }
                        if (attrValues.size() > 0) {
                            return new Value(type, attrValues.toArray(new String[attrValues.size()]));
                        }
                        return Value.createUndefined();
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    int attrValueCount = iomObj.getattrvaluecount(currentAttrName);
                    for (int i = 0; i < attrValueCount; ++i) {
                        objects.add(iomObj.getattrobj(currentAttrName, i));
                    }
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (currentPathEl instanceof PathElRefAttr) {
                    IomObject targetObj;
                    PathElRefAttr pathElRefAttr = (PathElRefAttr)currentPathEl;
                    if (!(pathElRefAttr.getAttr() instanceof LocalAttribute)) {
                        throw new IllegalStateException();
                    }
                    localAttributeValue = (LocalAttribute)pathElRefAttr.getAttr();
                    if (!(localAttributeValue.getDomain() instanceof ReferenceType)) {
                        throw new IllegalStateException();
                    }
                    ReferenceType referenceType = (ReferenceType)localAttributeValue.getDomain();
                    String targetOid = null;
                    IomObject tmpIomObject = iomObj.getattrobj(currentPathEl.getName(), 0);
                    if (tmpIomObject != null) {
                        targetOid = tmpIomObject.getobjectrefoid();
                    }
                    if (targetOid == null || (targetObj = this.getIomObjectFromObjectPool(referenceType, targetOid)) == null) continue;
                    if (k != lastPathIndex) {
                        nextCurrentObjects.add(targetObj);
                        continue;
                    }
                    ArrayList<IomObject> objects = new ArrayList<IomObject>();
                    objects.add(targetObj);
                    nextCurrentObjects.addAll(objects);
                    continue;
                }
                if (currentPathEl instanceof PathElThis) {
                    nextCurrentObjects.addAll(currentObjects);
                    continue;
                }
                if (!(currentPathEl instanceof PathElBase) || !((viewable = ((PathElBase)currentPathEl).getCurrentViewable()) instanceof Projection) || !(alias = ((Projection)viewable).getSelected()).getName().equals(currentPathEl.getName())) continue;
                nextCurrentObjects.addAll(currentObjects);
            }
            if (nextCurrentObjects.isEmpty()) {
                return Value.createUndefined();
            }
            if (k == lastPathIndex) {
                return new Value(nextCurrentObjects);
            }
            currentObjects = nextCurrentObjects;
            nextCurrentObjects = new ArrayList();
        }
        return Value.createUndefined();
    }

    private String normalizeOid(Viewable modelEle, String oid) {
        Domain oidType;
        if (oid == null) {
            return null;
        }
        if (modelEle instanceof AbstractClassDef && (oidType = ((AbstractClassDef)modelEle).getOid()) == PredefinedModel.getInstance().UUIDOID) {
            oid = Validator.normalizeUUID(oid);
        }
        return oid;
    }

    public static String normalizeUUID(String attrValue) {
        if (attrValue == null) {
            return null;
        }
        return attrValue.toLowerCase();
    }

    private boolean isBackward(Viewable srcObjClass, RoleDef role) {
        AssociationDef assoc = (AssociationDef)role.getContainer();
        if (assoc.isLightweight()) {
            return role.isAssociationEmbedded() && role.getOppEnd().getDestination() == srcObjClass;
        }
        return srcObjClass != assoc;
    }

    private List<IomObject> getTargetObjectsOfReverseRole(RoleDef role, String srcObjOid) {
        if (!this.targetObjects.containsKey(role)) {
            this.buildTargetObjectsMap(role);
        }
        return this.targetObjects.get(role).get(srcObjOid);
    }

    private void buildTargetObjectsMap(RoleDef role) {
        HashMap<String, ArrayList<IomObject>> values = new HashMap<String, ArrayList<IomObject>>();
        this.targetObjects.put(role, values);
        for (String basketId : this.objectPool.getDataBids()) {
            Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
            while (objectIterator.hasNext()) {
                IomObject refStruct;
                IomObject targetObj = (IomObject)objectIterator.next();
                if (!((Viewable)this.tag2class.get(targetObj.getobjecttag())).isExtending((Element)role.getDestination()) || (refStruct = targetObj.getattrobj(role.getOppEnd().getName(), 0)) == null) continue;
                String refoid = this.normalizeOid((Viewable)role.getDestination(), refStruct.getobjectrefoid());
                ArrayList<IomObject> objects = (ArrayList<IomObject>)values.get(refoid);
                if (objects == null) {
                    objects = new ArrayList<IomObject>();
                    values.put(refoid, objects);
                }
                objects.add(targetObj);
            }
        }
    }

    private IomObject getReferencedObject(RoleDef role, String oid) {
        Iterator targetClassIterator = role.iteratorDestination();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        while (targetClassIterator.hasNext()) {
            Viewable roleDestinationClass = (Viewable)targetClassIterator.next();
            destinationClasses.add(roleDestinationClass);
        }
        OutParam bidOfTargetObj = new OutParam();
        IomObject targetObj = this.objectPool.getObject(oid, destinationClasses, (OutParam<String>)bidOfTargetObj);
        return targetObj;
    }

    private List<IomObject> getLinkObjects(RoleDef role, String srcObjOid) {
        if (!this.linkObjects.containsKey(role)) {
            this.buildLinkObjMap(role);
        }
        return this.linkObjects.get(role).get(srcObjOid);
    }

    private void buildLinkObjMap(RoleDef role) {
        HashMap<String, ArrayList<IomObject>> values = new HashMap<String, ArrayList<IomObject>>();
        this.linkObjects.put(role, values);
        for (String basketId : this.objectPool.getDataBids()) {
            Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
            while (objectIterator.hasNext()) {
                IomObject refStruct;
                IomObject linkObj = (IomObject)objectIterator.next();
                if (!((Viewable)this.tag2class.get(linkObj.getobjecttag())).isExtending((Element)role.getContainer()) || (refStruct = linkObj.getattrobj(role.getOppEnd().getName(), 0)) == null) continue;
                String refoid = this.normalizeOid((Viewable)role.getOppEnd().getDestination(), refStruct.getobjectrefoid());
                ArrayList<IomObject> objects = (ArrayList<IomObject>)values.get(refoid);
                if (objects == null) {
                    objects = new ArrayList<IomObject>();
                    values.put(refoid, objects);
                }
                objects.add(linkObj);
            }
        }
    }

    private IomObject getIomObjWithIndex(IomObject iomObj, StructAttributeRef structAttributeRefValue, String currentAttrName) {
        int expectedIndex = (int)structAttributeRefValue.getIndex();
        int attrValueCount = iomObj.getattrvaluecount(currentAttrName);
        if (structAttributeRefValue.getIndex() == -1L) {
            iomObj = iomObj.getattrobj(currentAttrName, 0);
        } else if (structAttributeRefValue.getIndex() == -2L) {
            iomObj = iomObj.getattrobj(currentAttrName, attrValueCount - 1);
        } else if (expectedIndex <= attrValueCount && expectedIndex > 0) {
            if ((iomObj = iomObj.getattrobj(currentAttrName, expectedIndex - 1)) == null) {
                throw new IllegalStateException(this.rsrc.getString("getIomObjWithIndex.thereIsNoRecordFoundForThisIndex"));
            }
        } else {
            throw new IllegalStateException(this.rsrc.getString("getIomObjWithIndex.thereIsNoRecordFoundForThisIndex"));
        }
        return iomObj;
    }

    private IomObject getIomObjectFromObjectPool(ReferenceType referenceType, String targetOid) {
        OutParam bidOfTargetObj = new OutParam();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        destinationClasses.add((Viewable)referenceType.getReferred());
        return this.objectPool.getObject(targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
    }

    public Value evaluateObjectCount(Value value) {
        Iterator objectIterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
        int counter = 0;
        while (objectIterator.hasNext()) {
            IomObject anObj = (IomObject)objectIterator.next();
            if (anObj == null) continue;
            Object modelElement = this.tag2class.get(anObj.getobjecttag());
            Viewable viewable = (Viewable)modelElement;
            if (!value.getViewable().equals(viewable)) continue;
            ++counter;
        }
        return new Value(counter);
    }

    @Deprecated
    public Value evaluateAreArea(IomObject mainIomObj, Value value, PathEl[] pathToStructEle, PathEl[] pathToSurfaceAttr, Function currentFunction) {
        return this.evaluateAreArea(mainIomObj, value, pathToStructEle, pathToSurfaceAttr, currentFunction, null);
    }

    public Value evaluateAreArea(IomObject mainIomObj, Value value, PathEl[] pathToStructEle, PathEl[] pathToSurfaceAttr, Function currentFunction, String validationKind) {
        if (this.legacyAreAreas) {
            return this.evaluateAreArea0(mainIomObj, value, pathToStructEle, pathToSurfaceAttr, currentFunction, validationKind);
        }
        return this.evaluateAreArea1(mainIomObj, value, pathToStructEle, pathToSurfaceAttr, currentFunction, validationKind);
    }

    public Value evaluateAreArea1(IomObject mainIomObj, Value value, PathEl[] pathToStructEle, PathEl[] pathToSurfaceAttr, Function currentFunction, String validationKind) {
        PathEl[] fullPath;
        if (pathToStructEle == null) {
            fullPath = pathToSurfaceAttr;
        } else {
            fullPath = Arrays.copyOf(pathToStructEle, pathToStructEle.length + pathToSurfaceAttr.length);
            System.arraycopy(pathToSurfaceAttr, 0, fullPath, pathToStructEle.length, pathToSurfaceAttr.length);
        }
        Collection<Object> inputObjects = new ArrayList();
        if (value.getViewable() == null) {
            inputObjects = value.getComplexObjects();
        } else {
            Iterator iterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
            while (iterator.hasNext()) {
                IomObject iomObj = (IomObject)iterator.next();
                Viewable viewable = (Viewable)this.tag2class.get(iomObj.getobjecttag());
                if (!value.getViewable().equals(viewable)) continue;
                inputObjects.add(iomObj);
            }
        }
        ArrayList<IomObject> listOfPolygons = new ArrayList<IomObject>();
        for (IomObject iomObject : inputObjects) {
            this.getStructElesFromAttrPath(fullPath, iomObject.getobjectoid(), listOfPolygons, iomObject, 0);
        }
        String mainObjTag = mainIomObj.getobjecttag();
        ItfAreaPolygon2Linetable itfAreaPolygon2Linetable = new ItfAreaPolygon2Linetable(mainObjTag, this.objPoolManager);
        for (IomObject polygon : listOfPolygons) {
            try {
                itfAreaPolygon2Linetable.addPolygon(null, polygon.getobjectoid(), polygon, validationKind, this.errFact);
            }
            catch (IoxException e) {
                EhiLogger.logError((Throwable)e);
                return new Value(false);
            }
            catch (IllegalArgumentException e) {
                EhiLogger.logError((Throwable)e);
                return new Value(false);
            }
        }
        List<IoxInvalidDataException> intersections = itfAreaPolygon2Linetable.validate1(0.0);
        if (intersections != null && !intersections.isEmpty()) {
            if (!this.disableAreAreasMessages) {
                for (IoxInvalidDataException ex : intersections) {
                    String tid1 = ex.getTid();
                    String iliqname = ex.getIliqname();
                    this.errFact.setTid(tid1);
                    this.errFact.setIliqname(iliqname);
                    if (ex instanceof IoxIntersectionException) {
                        IoxIntersectionException intersectionEx = (IoxIntersectionException)ex;
                        this.logMsg(this.areaOverlapValidation, intersectionEx);
                        EhiLogger.traceState((String)intersectionEx.toString());
                        continue;
                    }
                    this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
                }
                this.setCurrentMainObj(null);
            }
            EhiLogger.traceState((String)(mainObjTag + ":" + currentFunction.getScopedName(null) + " returned false"));
            return new Value(false);
        }
        return new Value(true);
    }

    /*
     * WARNING - void declaration
     */
    public Value evaluateAreArea0(IomObject mainIomObj, Value value, PathEl[] pathToStructEle, PathEl[] pathToSurfaceAttr, Function currentFunction, String validationKind) {
        String mainObjTag = mainIomObj.getobjecttag();
        if (pathToStructEle == null) {
            ItfAreaPolygon2Linetable polygonPool = new ItfAreaPolygon2Linetable(mainObjTag, this.objPoolManager);
            ArrayList<IomObject> listOfPolygons = new ArrayList<IomObject>();
            if (value.getViewable() != null) {
                Iterator objectIterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
                while (objectIterator.hasNext()) {
                    IomObject iomObject = (IomObject)objectIterator.next();
                    Viewable iomObjClass = (Viewable)this.tag2class.get(iomObject.getobjecttag());
                    if (!value.getViewable().equals(iomObjClass)) continue;
                    this.getStructElesFromAttrPath(pathToSurfaceAttr, iomObject.getobjectoid(), listOfPolygons, iomObject, 0);
                }
            } else {
                for (IomObject iomObject : value.getComplexObjects()) {
                    this.getStructElesFromAttrPath(pathToSurfaceAttr, iomObject.getobjectoid(), listOfPolygons, iomObject, 0);
                }
            }
            for (IomObject iomObject : listOfPolygons) {
                try {
                    polygonPool.addPolygon(null, iomObject.getobjectoid(), iomObject, validationKind, this.errFact);
                }
                catch (IoxException e) {
                    EhiLogger.logError((Throwable)e);
                }
            }
            List<IoxInvalidDataException> intersections = polygonPool.validate0(0.0);
            if (intersections != null) {
                if (!this.disableAreAreasMessages && intersections.size() > 0) {
                    for (IoxInvalidDataException ex : intersections) {
                        String tid1 = ex.getTid();
                        String iliqname = ex.getIliqname();
                        this.errFact.setTid(tid1);
                        this.errFact.setIliqname(iliqname);
                        if (ex instanceof IoxIntersectionException) {
                            IoxIntersectionException intersectionEx = (IoxIntersectionException)ex;
                            this.logMsg(this.areaOverlapValidation, intersectionEx);
                            EhiLogger.traceState((String)intersectionEx.toString());
                            continue;
                        }
                        this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
                    }
                    this.setCurrentMainObj(null);
                }
                EhiLogger.traceState((String)(mainObjTag + ":" + currentFunction.getScopedName(null) + " returned false"));
                return new Value(false);
            }
            return new Value(true);
        }
        ItfAreaPolygon2Linetable polygonPool = new ItfAreaPolygon2Linetable(mainObjTag, this.objPoolManager);
        ArrayList<IomObject> listOfPolygons = new ArrayList<IomObject>();
        Iterator<Object> objectIterator = null;
        Object var11_20 = null;
        if (value.getViewable() != null) {
            Viewable viewable = value.getViewable();
            objectIterator = this.objectPool.getObjectsOfBasketId(this.currentBasketId).valueIterator();
        } else {
            objectIterator = value.getComplexObjects().iterator();
        }
        boolean returnValue = true;
        while (objectIterator.hasNext()) {
            void var11_22;
            IomObject iomObj = (IomObject)objectIterator.next();
            Viewable iomObjClass = (Viewable)this.tag2class.get(iomObj.getobjecttag());
            if (var11_22 != null && !var11_22.equals(iomObjClass)) continue;
            ArrayList<IomObject> complexObjects = new ArrayList<IomObject>();
            this.getStructElesFromAttrPath(pathToStructEle, iomObj.getobjectoid(), complexObjects, iomObj, 0);
            if (complexObjects.size() <= 0) continue;
            for (IomObject currentObj : complexObjects) {
                this.getStructElesFromAttrPath(pathToSurfaceAttr, currentObj.getobjectoid(), listOfPolygons, currentObj, 0);
            }
        }
        for (IomObject polygon : listOfPolygons) {
            try {
                polygonPool.addPolygon(null, polygon.getobjectoid(), polygon, validationKind, this.errFact);
            }
            catch (IoxException e) {
                EhiLogger.logError((Throwable)e);
            }
        }
        List<IoxInvalidDataException> intersections = polygonPool.validate0(0.0);
        if (intersections != null) {
            if (!this.disableAreAreasMessages && intersections.size() > 0) {
                for (IoxInvalidDataException ex : intersections) {
                    String tid1 = ex.getTid();
                    String iliqname = ex.getIliqname();
                    this.errFact.setTid(tid1);
                    this.errFact.setIliqname(iliqname);
                    if (ex instanceof IoxIntersectionException) {
                        IoxIntersectionException intersectionEx = (IoxIntersectionException)ex;
                        this.logMsg(this.areaOverlapValidation, intersectionEx);
                        EhiLogger.traceState((String)intersectionEx.toString());
                        continue;
                    }
                    this.logMsg(this.areaOverlapValidation, ex.getMessage(), new String[0]);
                }
                this.setCurrentMainObj(null);
            }
            EhiLogger.traceState((String)(mainObjTag + ":" + currentFunction.getScopedName(null) + " returned false"));
            return new Value(false);
        }
        return new Value(true);
    }

    private void getStructElesFromAttrPath(PathEl[] attrPath, String oidPrefix, Collection<IomObject> listOfFoundStructEles, IomObject iomObj, int currentPathElIdx) {
        if (attrPath != null && currentPathElIdx < attrPath.length) {
            if (oidPrefix == null) {
                oidPrefix = "";
            } else if (oidPrefix.length() > 0) {
                oidPrefix = oidPrefix + "/";
            }
            int lastPathElIdx = attrPath.length - 1;
            PathEl currentPathEl = attrPath[currentPathElIdx];
            String attrName = currentPathEl.getName();
            int valueCount = iomObj.getattrvaluecount(attrName);
            for (int valuei = 0; valuei < valueCount; ++valuei) {
                String oid = oidPrefix + attrName + "[" + (valuei + 1) + "]";
                IomObject structEle = iomObj.getattrobj(attrName, valuei);
                if (currentPathElIdx == lastPathElIdx) {
                    structEle.setobjectoid(oid);
                    listOfFoundStructEles.add(structEle);
                    continue;
                }
                this.getStructElesFromAttrPath(attrPath, oid, listOfFoundStructEles, structEle, currentPathElIdx + 1);
            }
        }
    }

    private String getEnumerationConstantXtfValue(Constant.Enumeration enumValue) {
        String[] value = enumValue.getValue();
        StringBuilder buf = new StringBuilder(100);
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                buf.append('.');
            }
            buf.append(value[i]);
        }
        return buf.toString();
    }

    private void validateRoleCardinality(RoleDef role, IomObject iomObj) {
        String roleQName = null;
        roleQName = this.getScopedName(role);
        String multiplicity = this.validationConfig.getConfigValue(roleQName, "multiplicity");
        if (multiplicity == null) {
            multiplicity = this.globalMultiplicity;
        }
        if (multiplicity != null && "off".equals(multiplicity)) {
            if (!this.configOffOufputReduction.contains("multiplicity:" + roleQName)) {
                this.configOffOufputReduction.add("multiplicity:" + roleQName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleCardinality.validationConfigurationMultiplicityOff"), roleQName));
            }
        } else {
            if (!this.configOffOufputReduction.contains("multiplicity:" + roleQName)) {
                this.configOffOufputReduction.add("multiplicity:" + roleQName);
                this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleCardinality.validateMultiplicityOfRole"), roleQName));
            }
            long nrOfTargetObjs = this.linkPool.getTargetObjectCount(iomObj, role, this.doItfOidPerTable);
            long cardMin = role.getCardinality().getMinimum();
            long cardMax = role.getCardinality().getMaximum();
            if (nrOfTargetObjs < cardMin || nrOfTargetObjs > cardMax) {
                if (role.getCardinality().getMaximum() == Long.MAX_VALUE) {
                    String cardMaxStr = "*";
                    this.logMsg(multiplicity, this.rsrc.getString("validateRoleCardinality.shouldAssociateToTargetObject"), role.getName(), String.valueOf(cardMin), cardMaxStr, String.valueOf(nrOfTargetObjs));
                } else {
                    this.logMsg(multiplicity, this.rsrc.getString("validateRoleCardinality.shouldAssociateToTargetObject"), role.getName(), String.valueOf(cardMin), String.valueOf(cardMax), String.valueOf(nrOfTargetObjs));
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateRoleReference(String bidOfObj, RoleDef role, IomObject iomObj) {
        Viewable destinationClass;
        String oid;
        String bid;
        Object modelElement = this.tag2class.get(iomObj.getobjecttag());
        Viewable classObj = (Viewable)modelElement;
        String roleQName = this.getScopedName(role);
        String validateTarget = null;
        if (!this.enforceTargetValidation) {
            validateTarget = this.validationConfig.getConfigValue(roleQName, "target");
        }
        if ("off".equals(validateTarget)) {
            if (this.configOffOufputReduction.contains("target:" + roleQName)) return;
            this.configOffOufputReduction.add("target:" + roleQName);
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleReference.validationConfigurationTargetOff"), roleQName));
            return;
        }
        if (!this.datatypesOutputReduction.contains(roleQName)) {
            this.datatypesOutputReduction.add(roleQName);
            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateRoleReference.validateTargetOfRole"), roleQName));
        }
        String targetOid = null;
        IomObject roleDefValue = iomObj.getattrobj(role.getName(), 0);
        if (roleDefValue != null) {
            targetOid = roleDefValue.getobjectrefoid();
        }
        if (targetOid == null) {
            return;
        }
        Iterator targetClassIterator = role.iteratorDestination();
        ArrayList<Viewable> destinationClasses = new ArrayList<Viewable>();
        StringBuffer possibleTargetClasses = new StringBuffer();
        String sep = "";
        while (targetClassIterator.hasNext()) {
            for (Viewable roleDestinationClass : this.getTranslations((Viewable)targetClassIterator.next())) {
                destinationClasses.add(roleDestinationClass);
                possibleTargetClasses.append(sep);
                possibleTargetClasses.append(roleDestinationClass.getScopedName(null));
                sep = ",";
            }
        }
        OutParam bidOfTargetObj = new OutParam();
        IomObject targetObj = this.objectPool.getObject(targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
        if (targetObj == null && (bid = this.validationConfig.getConfigValue(roleQName, "requiredIn")) != null) {
            targetObj = this.findExternalObject(bid, targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
        }
        if ((oid = iomObj.getobjectoid()) == null) {
            oid = ObjectPool.getAssociationId(iomObj, (AssociationDef)modelElement);
        }
        if (!role.isExternal()) {
            if (targetOid != null) {
                if (!this.isBasketSame(bidOfObj, targetObj)) {
                    this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.noObjectFoundWithOidInBasket"), targetOid, bidOfObj);
                    return;
                }
                if (targetObj == null) {
                    this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.noObjectFoundWithOid"), targetOid);
                    return;
                }
            }
        } else if (targetObj == null) {
            boolean extObjFound = false;
            if (this.extObjResolvers != null) {
                for (ExternalObjectResolver extObjResolver : this.extObjResolvers) {
                    if (!extObjResolver.objectExists(targetOid, destinationClasses)) continue;
                    extObjFound = true;
                    break;
                }
            }
            if (this.allObjectsAccessible && !extObjFound) {
                this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.noObjectFoundWithOid"), targetOid);
            }
        }
        if (targetObj == null) return;
        Object modelEle = this.tag2class.get(targetObj.getobjecttag());
        Viewable targetObjClass = (Viewable)modelEle;
        Iterator<Viewable> iterator = destinationClasses.iterator();
        do {
            if (!iterator.hasNext()) {
                this.logMsg(validateTarget, this.rsrc.getString("validateRoleReference.wrongClassOfTargetObjectForRole"), this.getScopedName(targetObjClass), targetOid, this.getScopedName(role));
                return;
            }
            destinationClass = iterator.next();
            if (!targetObjClass.equals(destinationClass)) continue;
            return;
        } while (targetObjClass.getExtending() == null || !targetObjClass.isExtending((Element)destinationClass));
    }

    private List<Viewable> getTranslations(Viewable aclass0) {
        Viewable rootClass = (Viewable)this.getRootTranslation((Element)aclass0);
        ArrayList<Viewable> ret = new ArrayList<Viewable>();
        ret.add(rootClass);
        Model rootModel = (Model)this.getRootTranslation((Element)rootClass.getContainer(Model.class));
        Topic rootTopic = (Topic)this.getRootTranslation((Element)rootClass.getContainer(Topic.class));
        for (Model destModel : this.td) {
            if (!this.isTranslatedBy((Element)rootModel, (Element)destModel)) continue;
            block1: for (Element destEle : destModel) {
                if (destEle instanceof Viewable && this.isTranslatedBy((Element)rootClass, destEle)) {
                    if (destEle == rootClass) continue;
                    ret.add((Viewable)destEle);
                    continue;
                }
                if (!(destEle instanceof Topic) || rootTopic == null || !this.isTranslatedBy(destEle, (Element)rootTopic)) continue;
                for (Element destClass : (Topic)destEle) {
                    if (!(destClass instanceof Viewable) || !this.isTranslatedBy(destClass, (Element)rootClass)) continue;
                    if (destClass == rootClass) continue block1;
                    ret.add((Viewable)destClass);
                    continue block1;
                }
            }
        }
        return ret;
    }

    private boolean isTranslatedBy(Element ele1, Element ele2) {
        Element root1 = this.getRootTranslation(ele1);
        Element root2 = this.getRootTranslation(ele2);
        return root1.equals(root2);
    }

    private Element getRootTranslation(Element ele0) {
        if (ele0 == null) {
            return null;
        }
        Element ele1;
        while ((ele1 = ele0.getTranslationOf()) != null) {
            ele0 = ele1;
        }
        return ele0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IomObject findExternalObject(String targetBid, String targetOid, ArrayList<Viewable> destinationClasses, OutParam<String> bidOfTargetObj) {
        if (!this.objectPool.getDataBids().contains(targetBid)) {
            List<Dataset> dataset = null;
            File[] datasetFiles = null;
            IoxReader reader = null;
            try {
                dataset = this.repositoryManager.getDatasetIndex(targetBid, null);
                if (dataset != null && !dataset.isEmpty()) {
                    datasetFiles = this.repositoryManager.getLocalFileOfRemoteDataset(dataset.get(0), "application/interlis+xml;version=2.3");
                }
                if (datasetFiles != null) {
                    File[] files;
                    for (File file : files = (File[])datasetFiles.clone()) {
                        reader = new ReaderFactory().createReader(file, this.errFact);
                        String currentBid = null;
                        while (true) {
                            IoxEvent currentIoxEvent;
                            if ((currentIoxEvent = reader.read()) instanceof ObjectEvent) {
                                IomObject iomObject = this.objectPool.addObject(((ObjectEvent)currentIoxEvent).getIomObject(), currentBid);
                                continue;
                            }
                            if (currentIoxEvent instanceof StartBasketEvent) {
                                currentBid = ((StartBasketEvent)currentIoxEvent).getBid();
                                this.objectPool.startBasket(currentBid, false);
                                continue;
                            }
                            if (currentIoxEvent instanceof EndTransferEvent) break;
                        }
                    }
                }
            }
            catch (RepositoryAccessException e) {
                EhiLogger.logError((Throwable)e);
            }
            catch (Ili2cException e) {
                EhiLogger.logError((Throwable)e);
            }
            catch (IoxException e) {
                EhiLogger.logError((Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IoxException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                }
            }
        }
        return this.objectPool.getObject(targetOid, destinationClasses, bidOfTargetObj);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private void validateReferenceAttrs(String structAttrQName, IomObject iomStruct, Viewable structure, String bidOfObj) {
        attrIter = structure.getAttributesAndRoles();
        while (true) {
            block28: {
                block27: {
                    block26: {
                        if (!attrIter.hasNext()) {
                            return;
                        }
                        refAttrO = attrIter.next();
                        if (!(refAttrO instanceof LocalAttribute)) continue;
                        refAttr = (LocalAttribute)refAttrO;
                        type = refAttr.getDomain();
                        if (!(type instanceof ReferenceType)) break block26;
                        refAttrType = (ReferenceType)type;
                        validateTarget = null;
                        attrQName = this.getScopedName((AttributeDef)refAttr);
                        if (!this.enforceTargetValidation) {
                            validateTarget = this.validationConfig.getConfigValue(attrQName, "target");
                        }
                        if ("off".equals(validateTarget)) {
                            if (this.configOffOufputReduction.contains("target:" + attrQName)) continue;
                            this.configOffOufputReduction.add("target:" + attrQName);
                            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateReferenceAttrs.validationConfigurationTargetOff"), new String[]{attrQName}));
                            continue;
                        }
                        if (!this.datatypesOutputReduction.contains(attrQName)) {
                            this.datatypesOutputReduction.add(attrQName);
                            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateReferenceAttrs.validateReferenceAttr"), new String[]{attrQName}));
                        }
                        refAttrStruct = iomStruct.getattrobj(refAttr.getName(), 0);
                        targetOid = null;
                        if (refAttrStruct != null) {
                            targetOid = refAttrStruct.getobjectrefoid();
                        }
                        if (!(targetClassIterator = refAttrType.iteratorRestrictedTo()).hasNext()) {
                            targetClass = refAttrType.getReferred();
                            refs = new ArrayList<AbstractClassDef>();
                            refs.add(targetClass);
                            targetClassIterator = refs.iterator();
                        }
                        destinationClasses = new ArrayList<Viewable>();
                        possibleTargetClasses = new StringBuffer();
                        while (targetClassIterator.hasNext()) {
                            for (Viewable roleDestinationClass : this.getTranslations((Viewable)targetClassIterator.next())) {
                                destinationClasses.add(roleDestinationClass);
                            }
                        }
                        targetObjClassStr = null;
                        bidOfTargetObj = new OutParam();
                        targetObject = null;
                        if (targetOid != null) {
                            targetObject = this.objectPool.getObject(targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
                        }
                        if (targetObject == null) {
                            bid = this.validationConfig.getConfigValue(attrQName, "requiredIn");
                            if (bid == null) {
                                bid = this.validationConfig.getConfigValue(structAttrQName, "requiredIn");
                            }
                            if (bid != null) {
                                targetObject = this.findExternalObject(bid, targetOid, destinationClasses, (OutParam<String>)bidOfTargetObj);
                            }
                        }
                        if (!refAttrType.isExternal()) {
                            if (targetOid != null) {
                                if (targetObject == null) {
                                    this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.noObjectFoundWithOid"), new String[]{targetOid});
                                    return;
                                }
                                if (!this.isBasketSame(bidOfObj, targetObject)) {
                                    this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.noObjectFoundWithOidInBasket"), new String[]{targetOid, bidOfObj});
                                    return;
                                }
                            }
                        } else if (targetObject == null && targetOid != null) {
                            extObjFound = false;
                            if (this.extObjResolvers != null) {
                                for (ExternalObjectResolver extObjResolver : this.extObjResolvers) {
                                    if (!extObjResolver.objectExists(targetOid, destinationClasses)) continue;
                                    extObjFound = true;
                                    break;
                                }
                            }
                            if (this.allObjectsAccessible && !extObjFound) {
                                this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.noObjectFoundWithOid"), new String[]{targetOid});
                            }
                        }
                        if (targetObject == null) continue;
                        modelEle = this.tag2class.get(targetObject.getobjecttag());
                        targetObjClass = (Table)modelEle;
                        targetObjClassStr = targetObject.getobjecttag();
                        classNames = new StringBuffer();
                        sep = "";
                        refAttrRestrictionIter = destinationClasses.iterator();
                        break block27;
                    }
                    if (!(type instanceof CompositionType)) continue;
                    break block28;
                }
                while (refAttrRestrictionIter.hasNext()) {
                    targetClass = refAttrRestrictionIter.next();
                    if (targetObjClass.isExtending((Element)targetClass)) {
                        return;
                    }
                    classNames.append(sep);
                    classNames.append(targetClass.getScopedName(null));
                    sep = ", ";
                }
                this.logMsg(validateTarget, this.rsrc.getString("validateReferenceAttrs.wrongClassOfTargetObjectForReferenceAttr"), new String[]{this.getScopedName((Viewable)targetObjClass), targetOid, this.getScopedName((AttributeDef)refAttr)});
                continue;
            }
            attrName = refAttr.getName();
            structc = iomStruct.getattrvaluecount(attrName);
            structi = 0;
            while (true) {
                if (structi >= structc) ** break;
                structValue = iomStruct.getattrobj(attrName, structi);
                if (structValue != null) {
                    this.validateReferenceAttrs(refAttr.getScopedName(), structValue, (Viewable)((CompositionType)type).getComponentType(), bidOfObj);
                }
                ++structi;
            }
            break;
        }
    }

    private void validateExistenceConstraint(IomObject iomObj, ExistenceConstraint existenceConstraint) {
        if (!"off".equals(this.constraintValidation)) {
            String constraintName = this.getScopedName((Constraint)existenceConstraint);
            String checkConstraint = null;
            if (!this.enforceConstraintValidation) {
                checkConstraint = this.validationConfig.getConfigValue(constraintName, "check");
            }
            if ("off".equals(checkConstraint)) {
                if (!this.configOffOufputReduction.contains("check:" + constraintName)) {
                    this.configOffOufputReduction.add("check:" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateExistenceConstraint.validationConfigurationCheckOff"), constraintName));
                }
            } else {
                String restrictedAttrName;
                if (iomObj.getattrcount() == 0) {
                    return;
                }
                if (!this.constraintOutputReduction.contains(existenceConstraint + ":" + constraintName)) {
                    this.constraintOutputReduction.add(existenceConstraint + ":" + constraintName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateExistenceConstraint.validateExistenceConstraint"), this.getScopedName((Constraint)existenceConstraint)));
                }
                if (iomObj.getattrvaluecount(restrictedAttrName = existenceConstraint.getRestrictedAttribute().getLastPathEl().getName()) == 0) {
                    return;
                }
                Type type = existenceConstraint.getRestrictedAttribute().getType();
                if (type instanceof TypeAlias) {
                    TypeAlias aliasType = (TypeAlias)type;
                    Domain domainAliasing = aliasType.getAliasing();
                    type = domainAliasing.getType();
                }
                Iterator requiredInIterator = existenceConstraint.iteratorRequiredIn();
                boolean valueExists = false;
                Table classA = null;
                Table otherClass = null;
                while (!valueExists && requiredInIterator.hasNext()) {
                    classA = null;
                    ObjectPath otherAttrPath = (ObjectPath)requiredInIterator.next();
                    String otherAttrName = otherAttrPath.toString();
                    otherClass = (Table)otherAttrPath.getRoot();
                    String attrValueThisObj = iomObj.getattrvalue(restrictedAttrName);
                    Iterator<String> basketIdIterator = this.objectPool.getDataBids().iterator();
                    while (!valueExists && basketIdIterator.hasNext()) {
                        String basketId = basketIdIterator.next();
                        Iterator objectIterator = this.objectPool.getObjectsOfBasketId(basketId).valueIterator();
                        block2: while (!valueExists && objectIterator.hasNext()) {
                            IomObject otherIomObj = (IomObject)objectIterator.next();
                            if (otherIomObj.getattrcount() == 0) continue;
                            Object modelElement = this.tag2class.get(otherIomObj.getobjecttag());
                            classA = (Table)modelElement;
                            if (otherIomObj.getattrvaluecount(otherAttrName) <= 0 || !classA.isExtending((Element)otherClass)) continue;
                            if (type instanceof ReferenceType) {
                                ReferenceType referenceType = (ReferenceType)type;
                                valueExists = this.equalsReferenceValue(iomObj, referenceType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof CoordType) {
                                CoordType coordType = (CoordType)type;
                                valueExists = this.equalsCoordValue(iomObj, coordType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof PolylineType) {
                                PolylineType polylineType = (PolylineType)type;
                                valueExists = this.equalsPolylineValue(iomObj, polylineType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof SurfaceOrAreaType) {
                                SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                                valueExists = this.equalsSurfaceOrAreaValue(iomObj, surfaceOrAreaType, otherIomObj, otherAttrName, restrictedAttrName);
                                continue;
                            }
                            if (type instanceof CompositionType) {
                                if (iomObj.getattrvaluecount(restrictedAttrName) != otherIomObj.getattrvaluecount(restrictedAttrName)) continue;
                                for (int structi = 0; structi < iomObj.getattrvaluecount(restrictedAttrName); ++structi) {
                                    IomObject structEle = iomObj.getattrobj(restrictedAttrName, structi);
                                    IomObject otherStructEle = otherIomObj.getattrobj(restrictedAttrName, structi);
                                    if (structEle == null || otherStructEle == null || !(valueExists = this.equalsStructEle((Viewable)((CompositionType)type).getComponentType(), structEle, otherStructEle))) continue block2;
                                }
                                continue;
                            }
                            if (!otherIomObj.getattrvalue(otherAttrName).equals(iomObj.getattrvalue(restrictedAttrName))) continue;
                            valueExists = true;
                        }
                    }
                }
                if (!valueExists) {
                    String actualLanguage = Locale.getDefault().getLanguage();
                    String msg = this.validationConfig.getConfigValue(constraintName, "msg_" + actualLanguage);
                    if (msg == null) {
                        msg = this.validationConfig.getConfigValue(constraintName, "msg");
                    }
                    if (msg != null && msg.length() > 0) {
                        if (this.isVerbose) {
                            msg = String.format("%s %s", msg, this.getDisplayName((Constraint)existenceConstraint));
                        }
                        this.logMsg(checkConstraint, msg, new String[0]);
                    } else {
                        this.logMsg(checkConstraint, this.rsrc.getString("validateExistenceConstraint.valueOfTheAttributeWasNotFoundInTheConditionClass"), this.getDisplayName((Constraint)existenceConstraint), restrictedAttrName.toString(), iomObj.getobjecttag().toString());
                    }
                }
            }
        }
    }

    private boolean equalsStructEle(Viewable aclass, IomObject iomObj, IomObject otherIomObj) {
        Iterator iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
            String targetAttrName = attr.getName();
            Type type = attr.getDomainResolvingAliases();
            if (iomObj.getattrvaluecount(targetAttrName) != otherIomObj.getattrvaluecount(targetAttrName)) {
                return false;
            }
            if (iomObj.getattrvaluecount(targetAttrName) <= 0) continue;
            if (type instanceof ReferenceType) {
                ReferenceType referenceType = (ReferenceType)type;
                if (this.equalsReferenceValue(iomObj, referenceType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof CoordType) {
                CoordType coordType = (CoordType)type;
                if (this.equalsCoordValue(iomObj, coordType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof PolylineType) {
                PolylineType polylineType = (PolylineType)type;
                if (this.equalsPolylineValue(iomObj, polylineType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof SurfaceOrAreaType) {
                SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                if (this.equalsSurfaceOrAreaValue(iomObj, surfaceOrAreaType, otherIomObj, targetAttrName, targetAttrName)) continue;
                return false;
            }
            if (type instanceof CompositionType) {
                for (int structi = 0; structi < iomObj.getattrvaluecount(targetAttrName); ++structi) {
                    IomObject structEle = iomObj.getattrobj(targetAttrName, structi);
                    IomObject otherStructEle = otherIomObj.getattrobj(targetAttrName, structi);
                    if (structEle != null && otherStructEle != null) {
                        if (this.equalsStructEle((Viewable)((CompositionType)type).getComponentType(), structEle, otherStructEle)) continue;
                        return false;
                    }
                    return false;
                }
                continue;
            }
            if (otherIomObj.getattrvalue(targetAttrName).equals(iomObj.getattrvalue(targetAttrName))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsSurfaceOrAreaValue(IomObject iomObj, SurfaceOrAreaType surfaceType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject objA = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject objB = otherIomObj.getattrobj(otherAttrName, 0);
        if (objA != null && objB != null) {
            for (int i = 0; i < objA.getattrvaluecount("surface"); ++i) {
                IomObject surfaceA = objA.getattrobj("surface", i);
                IomObject surfaceB = objB.getattrobj("surface", i);
                if (objA.getattrvaluecount("surface") != objB.getattrvaluecount("surface")) {
                    return false;
                }
                for (int j = 0; j < surfaceA.getattrvaluecount("boundary"); ++j) {
                    IomObject boundaryA = surfaceA.getattrobj("boundary", j);
                    IomObject boundaryB = surfaceB.getattrobj("boundary", j);
                    if (boundaryA.getattrvaluecount("boundary") != boundaryB.getattrvaluecount("boundary")) {
                        return false;
                    }
                    for (int k = 0; k < boundaryA.getattrvaluecount("polyline"); ++k) {
                        IomObject polylineA = boundaryA.getattrobj("polyline", k);
                        IomObject polylineB = boundaryB.getattrobj("polyline", k);
                        if (polylineA.getattrvaluecount("polyline") != polylineB.getattrvaluecount("polyline")) {
                            return false;
                        }
                        for (int l = 0; l < polylineA.getattrvaluecount("sequence"); ++l) {
                            IomObject sequenceA = polylineA.getattrobj("sequence", l);
                            IomObject sequenceB = polylineB.getattrobj("sequence", l);
                            if (objA.getattrvaluecount("sequence") != objB.getattrvaluecount("sequence")) {
                                return false;
                            }
                            for (int m = 0; m < sequenceA.getattrvaluecount("segment"); ++m) {
                                IomObject segmentA = sequenceA.getattrobj("segment", m);
                                IomObject segmentB = sequenceB.getattrobj("segment", m);
                                if (segmentA.getattrvaluecount("segment") != segmentB.getattrvaluecount("segment")) {
                                    return false;
                                }
                                for (int n = 0; n < segmentA.getattrcount(); ++n) {
                                    if (segmentA.getobjecttag().equals("COORD")) {
                                        if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                                            if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                        if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                                            return false;
                                        }
                                        if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                                        return false;
                                    }
                                    if (!segmentA.getobjecttag().equals("ARC")) continue;
                                    if (segmentA.getattrvalue("A1") != null && segmentB.getattrvalue("A1") != null) {
                                        if (!segmentA.getattrvalue("A1").equals(segmentB.getattrvalue("A1"))) {
                                            return false;
                                        }
                                    } else {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("A2") != null && segmentB.getattrvalue("A2") != null) {
                                        if (!segmentA.getattrvalue("A2").equals(segmentB.getattrvalue("A2"))) {
                                            return false;
                                        }
                                    } else {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                                        if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                            return false;
                                        }
                                    } else {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                                        return false;
                                    }
                                    if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                                    return false;
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean equalsPolylineValue(IomObject iomObj, PolylineType polylineType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject objA = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject objB = otherIomObj.getattrobj(otherAttrName, 0);
        if (objA != null && objB != null) {
            for (int i = 0; i < objA.getattrvaluecount("sequence"); ++i) {
                IomObject sequenceA = objA.getattrobj("sequence", i);
                IomObject sequenceB = objB.getattrobj("sequence", i);
                if (objA.getattrvaluecount("sequence") != objB.getattrvaluecount("sequence")) {
                    return false;
                }
                for (int j = 0; j < sequenceA.getattrvaluecount("segment"); ++j) {
                    IomObject segmentA = sequenceA.getattrobj("segment", j);
                    IomObject segmentB = sequenceB.getattrobj("segment", j);
                    if (segmentA.getattrvaluecount("segment") != segmentB.getattrvaluecount("segment")) {
                        return false;
                    }
                    for (int k = 0; k < segmentA.getattrcount(); ++k) {
                        if (segmentA.getobjecttag().equals("COORD")) {
                            if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                                if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                    return false;
                                }
                            } else {
                                return false;
                            }
                            if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                                return false;
                            }
                            if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                            return false;
                        }
                        if (!segmentA.getobjecttag().equals("ARC")) continue;
                        if (segmentA.getattrvalue("A1") != null && segmentB.getattrvalue("A1") != null) {
                            if (!segmentA.getattrvalue("A1").equals(segmentB.getattrvalue("A1"))) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        if (segmentA.getattrvalue("A2") != null && segmentB.getattrvalue("A2") != null) {
                            if (!segmentA.getattrvalue("A2").equals(segmentB.getattrvalue("A2"))) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        if (segmentA.getattrvalue("C1") != null && segmentB.getattrvalue("C1") != null) {
                            if (!segmentA.getattrvalue("C1").equals(segmentB.getattrvalue("C1"))) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                        if (segmentA.getattrvalue("C2") != null && segmentB.getattrvalue("C2") != null && !segmentA.getattrvalue("C2").equals(segmentB.getattrvalue("C2"))) {
                            return false;
                        }
                        if (segmentA.getattrvalue("C3") == null || segmentB.getattrvalue("C3") == null || segmentA.getattrvalue("C3").equals(segmentB.getattrvalue("C3"))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean equalsReferenceValue(IomObject iomObj, ReferenceType referenceType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject referenceValueRestricted = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject referenceValueOther = otherIomObj.getattrobj(otherAttrName, 0);
        return true;
    }

    private boolean equalsCoordValue(IomObject iomObj, CoordType coordType, IomObject otherIomObj, String otherAttrName, String restrictedAttrName) {
        IomObject coordValueRestricted = iomObj.getattrobj(restrictedAttrName, 0);
        IomObject coordValueOther = otherIomObj.getattrobj(otherAttrName, 0);
        if (coordType.getDimensions().length >= 1 && (coordValueRestricted.getattrvalue("C1") != null ? !coordValueRestricted.getattrvalue("C1").equals(coordValueOther.getattrvalue("C1")) : coordValueOther.getattrvalue("C1") != null)) {
            return false;
        }
        if (coordType.getDimensions().length >= 2 && (coordValueRestricted.getattrvalue("C2") != null ? !coordValueRestricted.getattrvalue("C2").equals(coordValueOther.getattrvalue("C2")) : coordValueOther.getattrvalue("C2") != null)) {
            return false;
        }
        return coordType.getDimensions().length < 3 || !(coordValueRestricted.getattrvalue("C3") != null ? !coordValueRestricted.getattrvalue("C3").equals(coordValueOther.getattrvalue("C3")) : coordValueOther.getattrvalue("C3") != null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateObject(IomObject iomObj, String attrPath, Viewable assocClass, boolean doValidation) throws IoxException {
        IomObject duplicateObj;
        HashSet<String> propNames;
        boolean addToPool;
        boolean isObject;
        block53: {
            Viewable aclass1;
            block50: {
                String tag;
                block52: {
                    String oid;
                    Domain oidType;
                    block48: {
                        AssociationDef modelAssociationDef;
                        block51: {
                            block49: {
                                String objectoid;
                                boolean bl = isObject = attrPath == null;
                                if (isObject) {
                                    this.setCurrentMainObj(iomObj);
                                    ++this.objectCount;
                                } else {
                                    ++this.structCount;
                                }
                                tag = iomObj.getobjecttag();
                                Object modelele = null;
                                modelele = assocClass != null && "REF".equals(tag) ? assocClass : this.tag2class.get(tag);
                                if (modelele == null) {
                                    if (!this.unknownTypev.contains(tag)) {
                                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.unknownClass"), tag));
                                    }
                                    return;
                                }
                                if (isObject && (objectoid = iomObj.getobjectoid()) != null && !objectoid.equals("")) {
                                    Domain oidType2;
                                    if (modelele instanceof AbstractClassDef && (oidType2 = ((AbstractClassDef)modelele).getOid()) == this.td.INTERLIS.UUIDOID) {
                                        objectoid = Validator.normalizeUUID(objectoid);
                                    }
                                    if (this.uniquenessOfBid.containsKey(objectoid)) {
                                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.oidIsEqualToABid"), objectoid));
                                    }
                                }
                                if (isObject && this.doItfLineTables && modelele instanceof AttributeDef) {
                                    if (doValidation) {
                                        this.validateItfLineTableObject(iomObj, (AttributeDef)modelele);
                                    }
                                    return;
                                }
                                aclass1 = (Viewable)modelele;
                                addToPool = true;
                                if (isObject) {
                                    this.errFact.setDefaultCoord(this.getDefaultCoord(iomObj));
                                }
                                if (aclass1.isAbstract()) {
                                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.objectMustBeANonAbstractClass"), new String[0]));
                                }
                                if (!(aclass1 instanceof AssociationDef)) break block48;
                                modelAssociationDef = (AssociationDef)aclass1;
                                oidType = modelAssociationDef.getOid();
                                oid = iomObj.getobjectoid();
                                if (!isObject || !modelAssociationDef.isLightweight()) break block49;
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.linkMustBeEmbedded"), iomObj.getobjecttag()));
                                addToPool = false;
                                break block50;
                            }
                            if (!modelAssociationDef.isIdentifiable() && oidType == null) break block51;
                            if (oid == null) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.AssociationHasToHaveAnOid"), iomObj.getobjecttag()));
                                addToPool = false;
                                break block50;
                            } else if (!this.isValidId(oid)) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                            }
                            break block50;
                        }
                        if (oid != null) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.associationHasNotToHaveAnOid"), iomObj.getobjecttag(), oid));
                            break block50;
                        } else if (isObject) {
                            this.currentMainOid = ObjectPool.getAssociationId(iomObj, modelAssociationDef);
                        }
                        break block50;
                    }
                    if (!(aclass1 instanceof Table)) break block50;
                    Table classValueTable = (Table)aclass1;
                    if (!classValueTable.isIdentifiable()) break block52;
                    oidType = ((AbstractClassDef)aclass1).getOid();
                    oid = iomObj.getobjectoid();
                    if (oid == null) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.classHasToHaveAnOid"), iomObj.getobjecttag()));
                        addToPool = false;
                        break block50;
                    } else if (!this.isValidId(oid) && oidType == null) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                    }
                    break block50;
                }
                addToPool = false;
                String structId = iomObj.getobjectoid();
                if (structId != null) {
                    if (isObject) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.structureHasNotToHaveAnOid"), iomObj.getobjecttag()));
                    } else {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.structAttrMustNotHaveAnOid"), attrPath, tag, structId));
                    }
                }
            }
            if (isObject && aclass1 instanceof AbstractClassDef) {
                Domain oidType = ((AbstractClassDef)aclass1).getOid();
                String oid = iomObj.getobjectoid();
                if (oidType != null && oidType == this.td.INTERLIS.UUIDOID) {
                    if (oid != null && !this.isValidUuid(oid)) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.tidIsNotAValidUuid"), oid));
                    }
                } else if (oidType == null || oidType != this.td.INTERLIS.I32OID) {
                    if (oidType != null && oidType == this.td.INTERLIS.STANDARDOID) {
                        if (!this.isValidAnnexOid(oid)) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                        }
                    } else if (oidType != null && oidType.getType() instanceof TextOIDType && !this.isValidTextOid(oid, ((TextType)((TextOIDType)oidType.getType()).getOIDType()).getMaxLength())) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.valueIsNotAValidOid"), oid));
                    }
                }
            }
            propNames = new HashSet<String>();
            if (!doValidation) break block53;
            Iterator iter = aclass1.getAttributesAndRoles2();
            while (iter.hasNext()) {
                String refoid;
                RoleDef role;
                block55: {
                    int propc;
                    String roleName;
                    block54: {
                        Type proxyType;
                        AttributeDef attr;
                        ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                        if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                            propNames.add(attr.getName());
                            this.validateAttrValue(aclass1, iomObj, attr, attrPath);
                        }
                        if (!isObject || !(obj.obj instanceof RoleDef)) continue;
                        role = (RoleDef)obj.obj;
                        refoid = null;
                        roleName = role.getName();
                        if (!obj.embedded) break block54;
                        propc = iomObj.getattrvaluecount(roleName);
                        if (propc >= 1) {
                            IomObject embeddedLinkObj = iomObj.getattrobj(roleName, 0);
                            AssociationDef roleOwner = (AssociationDef)role.getContainer();
                            if (roleOwner.getDerivedFrom() == null) {
                                propNames.add(roleName);
                                if (propc > 0) {
                                    this.validateObject(embeddedLinkObj, roleName, (Viewable)roleOwner, true);
                                }
                                if (embeddedLinkObj != null) {
                                    refoid = embeddedLinkObj.getobjectrefoid();
                                    long orderPos = embeddedLinkObj.getobjectreforderpos();
                                    if (orderPos == 0L) {
                                        // empty if block
                                    }
                                } else {
                                    refoid = null;
                                }
                            }
                            if (propc > 1) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.roleRequiresOnlyOneReferenceProperty"), role.getScopedName()));
                            }
                            if (refoid == null) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.roleRequiresAReferenceToAnotherObject"), role.getScopedName()));
                            }
                        }
                        break block55;
                    }
                    propc = iomObj.getattrvaluecount(roleName);
                    if (propc == 1) {
                        IomObject structvalue = iomObj.getattrobj(roleName, 0);
                        propNames.add(roleName);
                        refoid = structvalue.getobjectrefoid();
                        long orderPos = structvalue.getobjectreforderpos();
                        if (orderPos != 0L) {
                            // empty if block
                        }
                    }
                    if (refoid == null) {
                        addToPool = false;
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.roleRequiresAReferenceToAnotherObject"), role.getScopedName()));
                    }
                }
                if (refoid == null || this.singlePass) continue;
                this.linkPool.addLink(iomObj, role, refoid, this.doItfOidPerTable);
            }
        }
        if (isObject && addToPool && !this.singlePass && (duplicateObj = this.objectPool.addObject(iomObj, this.currentBasketId)) != null) {
            Viewable aclass = (Viewable)this.tag2class.get(duplicateObj.getobjecttag());
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.oidXOfObjectYAlreadyExistsInZ"), this.currentMainOid, iomObj.getobjecttag(), aclass.getScopedName()));
        }
        if (doValidation) {
            int propc = iomObj.getattrcount();
            for (int propi = 0; propi < propc; ++propi) {
                String propName = iomObj.getattrname(propi);
                if (propName.startsWith("_") || propNames.contains(propName)) continue;
                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateObject.unknownPropertyX"), propName));
            }
        }
    }

    private void setCurrentMainObj(IomObject iomObj) {
        this.errFact.setDataObj(iomObj);
        this.currentMainOid = iomObj != null ? iomObj.getobjectoid() : null;
    }

    private IomObject getDefaultCoord(IomObject iomObj) {
        String tag = iomObj.getobjecttag();
        Object modelele = this.tag2class.get(tag);
        if (modelele == null) {
            return null;
        }
        Viewable aclass1 = (Viewable)modelele;
        Iterator iter = aclass1.getAttributesAndRoles2();
        while (iter.hasNext()) {
            Type proxyType;
            AttributeDef attr;
            ViewableTransferElement obj = (ViewableTransferElement)iter.next();
            if (!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
            Type type = attr.getDomainResolvingAliases();
            String attrName = attr.getName();
            if (type instanceof CompositionType) {
                int structc = iomObj.getattrvaluecount(attrName);
                for (int structi = 0; structi < structc; ++structi) {
                    IomObject coord;
                    IomObject structEle = iomObj.getattrobj(attrName, structi);
                    if (structEle == null || (coord = this.getDefaultCoord(structEle)) == null) continue;
                    return coord;
                }
                continue;
            }
            if (type instanceof PolylineType) {
                IomObject coord;
                PolylineType polylineType = (PolylineType)type;
                IomObject polylineValue = iomObj.getattrobj(attrName, 0);
                if (polylineValue == null || (coord = this.getFirstCoordFromPolyline(polylineValue)) == null) continue;
                return coord;
            }
            if (type instanceof SurfaceOrAreaType) {
                if (this.doItfLineTables) {
                    if (type instanceof SurfaceType) {
                        SurfaceType polylineType = (SurfaceType)type;
                        continue;
                    }
                    AreaType areaType = (AreaType)type;
                    IomObject coord = iomObj.getattrobj(attrName, 0);
                    if (coord == null) continue;
                    return coord;
                }
                SurfaceOrAreaType surfaceOrAreaType = (SurfaceOrAreaType)type;
                IomObject surfaceValue = iomObj.getattrobj(attrName, 0);
                if (surfaceValue == null) continue;
                for (int surfacei = 0; surfacei < surfaceValue.getattrvaluecount("surface"); ++surfacei) {
                    IomObject surface = surfaceValue.getattrobj("surface", surfacei);
                    int boundaryc = surface.getattrvaluecount("boundary");
                    for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                        IomObject boundary = surface.getattrobj("boundary", boundaryi);
                        for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                            IomObject polyline = boundary.getattrobj("polyline", polylinei);
                            IomObject coord = this.getFirstCoordFromPolyline(polyline);
                            if (coord == null) continue;
                            return coord;
                        }
                    }
                }
                continue;
            }
            if (!(type instanceof CoordType)) continue;
            CoordType coordType = (CoordType)type;
            IomObject coord = iomObj.getattrobj(attrName, 0);
            if (coord == null) continue;
            return coord;
        }
        return null;
    }

    private IomObject getFirstCoordFromPolyline(IomObject polylineValue) {
        for (int sequencei = 0; sequencei < polylineValue.getattrvaluecount("sequence"); ++sequencei) {
            int segmenti = 0;
            IomObject sequence = polylineValue.getattrobj("sequence", sequencei);
            if (segmenti >= sequence.getattrvaluecount("segment")) continue;
            IomObject segment = sequence.getattrobj("segment", segmenti);
            return segment;
        }
        return null;
    }

    private String validateUnique(HashMap<UniquenessConstraint, HashMap<AttributeArray, String>> seenValues, String originObjOid, IomObject parentObject, IomObject currentObject, UniquenessConstraint constraint, OutParam<AttributeArray> valuesRet, RoleDef role) {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator constraintIter = constraint.getElements().iteratorAttribute();
        while (constraintIter.hasNext()) {
            Object next = constraintIter.next();
            ObjectPath objectPathObj = (ObjectPath)next;
            PathEl[] pathElements = objectPathObj.getPathElements();
            Value value = this.getValueFromObjectPath(parentObject, currentObject, pathElements, role);
            if (value.isUndefined()) {
                return null;
            }
            if (value.skipEvaluation()) {
                return null;
            }
            if (value.getValue() != null) {
                values.add(value.getValue());
                continue;
            }
            if (value.getOid() != null) {
                values.add(value.getOid());
                continue;
            }
            if (value.getComplexObjects() != null) {
                IomObject complexValue = value.getComplexObjects().iterator().next();
                if (complexValue.getobjectrefoid() != null) {
                    values.add(complexValue.getobjectrefoid());
                    continue;
                }
                values.add(complexValue);
                continue;
            }
            throw new IllegalStateException(this.rsrc.getString("validateUnique.unexpectedValueInUnique"));
        }
        valuesRet.value = new AttributeArray(values);
        HashMap<Object, Object> alreadySeenValues = null;
        if (seenValues.containsKey(constraint)) {
            alreadySeenValues = seenValues.get(constraint);
            String oidOfNonUniqueObj = (String)alreadySeenValues.get(valuesRet.value);
            if (oidOfNonUniqueObj != null) {
                return oidOfNonUniqueObj;
            }
            alreadySeenValues.put(valuesRet.value, originObjOid);
        } else {
            alreadySeenValues = new HashMap();
            alreadySeenValues.put(valuesRet.value, originObjOid);
            seenValues.put(constraint, alreadySeenValues);
        }
        return null;
    }

    private void validateAttrValue(Viewable eleClass, IomObject iomObj, AttributeDef attr, String attrPath) throws IoxException {
        Type attrType;
        String attrName = attr.getName();
        String attrQName = this.getScopedName(attr);
        String iliClassQName = this.getScopedName(eleClass);
        attrPath = attrPath == null ? attrName : attrPath + "/" + attrName;
        String validateMultiplicity = this.validationConfig.getConfigValue(attrQName, "multiplicity");
        if (validateMultiplicity == null) {
            validateMultiplicity = this.globalMultiplicity;
        }
        String validateType = null;
        Object validateTarget = null;
        String validateGeometryType = null;
        if (!this.enforceTypeValidation && (validateType = this.validationConfig.getConfigValue(attrQName, "type")) == null) {
            validateGeometryType = this.defaultGeometryTypeValidation;
        }
        Domain domain = (attrType = attr.getDomain()) instanceof TypeAlias ? ((TypeAlias)attrType).getAliasing() : null;
        Model model = (Model)attr.getContainer(Model.class);
        Type type = attr.getDomainResolvingAll();
        if (type instanceof CompositionType) {
            int structc = iomObj.getattrvaluecount(attrName);
            if ("off".equals(validateMultiplicity)) {
                if (!this.configOffOufputReduction.contains("multiplicity:" + attrQName)) {
                    this.configOffOufputReduction.add("multiplicity:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationMultiplicityOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                }
            } else {
                Cardinality card = ((CompositionType)type).getCardinality();
                if ((long)structc < card.getMinimum() || (long)structc > card.getMaximum()) {
                    this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXHasWrongNumberOfValues"), attrPath);
                }
            }
            for (int structi = 0; structi < structc; ++structi) {
                IomObject structEle = iomObj.getattrobj(attrName, structi);
                if ("off".equals(validateType)) {
                    if (this.configOffOufputReduction.contains("type:" + attrQName)) continue;
                    this.configOffOufputReduction.add("type:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationTypeOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                    continue;
                }
                if (structEle == null) {
                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresAStructureY"), attrPath, ((CompositionType)type).getComponentType().getScopedName(null));
                    continue;
                }
                String tag = structEle.getobjecttag();
                Object modelele = this.tag2class.get(tag);
                if (modelele == null) {
                    if (!this.unknownTypev.contains(tag)) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.unknownClassXInAttributeY"), tag, attrPath));
                    }
                } else {
                    Viewable structEleClass = (Viewable)modelele;
                    Table requiredClass = ((CompositionType)type).getComponentType();
                    if (!structEleClass.isExtending((Element)requiredClass)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresAStructureY"), attrPath, requiredClass.getScopedName(null));
                    } else {
                        Model requiredClassModel;
                        Model structEleModel = (Model)structEleClass.getContainer(Model.class);
                        if (structEleModel != (requiredClassModel = (Model)requiredClass.getContainer(Model.class))) {
                            Topic requiredClassTopic = (Topic)requiredClass.getContainer(Topic.class);
                            if (requiredClassTopic == null) {
                                this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresAStructureY"), attrPath, requiredClass.getScopedName(null));
                            } else {
                                requiredClassTopic = (Topic)requiredClassTopic.getExtending();
                                while (requiredClassTopic != null && structEleModel != (requiredClassModel = (Model)requiredClassTopic.getContainer(Model.class))) {
                                }
                                if (structEleModel != requiredClassModel) {
                                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresAStructureY"), attrPath, requiredClass.getScopedName(null));
                                }
                            }
                        }
                    }
                    if (structEleClass.isAbstract()) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXRequiresANonAbstractStructure"), attrPath);
                    }
                }
                this.validateObject(structEle, attrPath + "[" + structi + "]", null, true);
            }
        } else {
            int structc = iomObj.getattrvaluecount(attrName);
            if ("off".equals(validateMultiplicity)) {
                if (!this.configOffOufputReduction.contains("multiplicity:" + attrQName)) {
                    this.configOffOufputReduction.add("multiplicity:" + attrQName);
                    this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationMultiplicityOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                }
            } else {
                Object topologyDone = this.pipelinePool.getIntermediateValue(attr, "topology");
                if (topologyDone == null) {
                    Cardinality card;
                    IomObject refObj;
                    if (structc == 1 && type instanceof ReferenceType && ((refObj = iomObj.getattrobj(attrName, 0)) == null || refObj.getobjectrefoid() == null)) {
                        structc = 0;
                    }
                    if (!(this.doItfLineTables && type instanceof SurfaceType || (long)structc >= (card = Validator.getCardinality(attr)).getMinimum() && (long)structc <= card.getMaximum())) {
                        if (card.getMaximum() > 1L || structc > 1) {
                            this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXHasWrongNumberOfValues"), attrPath);
                        } else {
                            this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXRequiresAValue"), attrPath);
                        }
                    }
                } else {
                    Boolean topologyValidationOk = (Boolean)this.pipelinePool.getIntermediateValue(attr, "topologyValidationOk");
                    if ((topologyValidationOk == null || topologyValidationOk.booleanValue()) && structc == 0 && Validator.isAttributeMandatory(attr)) {
                        this.logMsg(validateMultiplicity, this.rsrc.getString("validateAttrValue.attributeXRequiresAValue"), attrPath);
                    }
                }
            }
            for (int structi = 0; structi < structc; ++structi) {
                String actualValue;
                ItfAreaPolygon2Linetable allLines;
                boolean surfaceTopologyValid;
                SurfaceOrAreaType surfaceOrAreaType;
                PolylineType polylineType;
                String valueStr;
                String attrPathEle = attrPath;
                if (Validator.getCardinality(attr).getMaximum() > 1L) {
                    attrPathEle = attrPath + "[" + structi + "]";
                }
                if ("off".equals(validateType)) {
                    if (!this.configOffOufputReduction.contains("type:" + attrQName)) {
                        this.configOffOufputReduction.add("type:" + attrQName);
                        this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.XNotValidatedValidationConfigurationTypeOffInAttributeY"), attrQName, attrPath, iomObj.getobjecttag(), iomObj.getobjectoid()));
                    }
                } else if (attr.isDomainIli1Date()) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    if (valueStr != null) {
                        if (valueStr.length() == 8) {
                            try {
                                int year = Integer.parseInt(valueStr.substring(0, 4));
                                int month = Integer.parseInt(valueStr.substring(4, 6));
                                int day = Integer.parseInt(valueStr.substring(6, 8));
                                if (year < 1582 || year > 2999 || month < 1 || month > 12 || day < 1 || day > 31) {
                                    this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotInRangeInAttributeY"), valueStr, attrPathEle);
                                }
                            }
                            catch (NumberFormatException numberformatexception) {
                                this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAValidDateInAttributeY"), valueStr, attrPathEle);
                            }
                        } else {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAValidDateInAttributeY"), valueStr, attrPathEle);
                        }
                    }
                } else if (attr.isDomainBoolean()) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    if (valueStr != null && !valueStr.equals("true") && !valueStr.equals("false")) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotABooleanInAttributeY"), valueStr, attrPathEle);
                    }
                } else if (attr.isDomainIliUuid()) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    if (valueStr != null && !this.isValidUuid(valueStr)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAValidUUIDInAttributeY"), valueStr, attrPathEle);
                    }
                } else if (attr.isDomainIli2Date()) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    FormattedType subType = (FormattedType)type;
                    if (valueStr != null) {
                        if (!valueStr.matches(subType.getRegExp()) || valueStr.length() != 10) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfDateValueXInAttributeY"), valueStr, attrPathEle);
                        } else if (!subType.isValueInRange(valueStr)) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.dateValueXIsNotInRangeInAttributeY"), valueStr, attrPathEle);
                        }
                    }
                } else if (attr.isDomainIli2Time()) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    FormattedType subType = (FormattedType)type;
                    if (valueStr != null) {
                        if (!valueStr.matches(subType.getRegExp()) || valueStr.length() < 9 || valueStr.length() > 12) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfTimeValueXInAttributeY"), valueStr, attrPathEle);
                        } else if (!subType.isValueInRange(valueStr)) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.timeValueXIsNotInRangeInAttributeY"), valueStr, attrPathEle);
                        }
                    }
                } else if (attr.isDomainIli2DateTime()) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    FormattedType subType = (FormattedType)type;
                    if (valueStr != null) {
                        if (!valueStr.matches(subType.getRegExp()) || valueStr.length() < 18 || valueStr.length() > 23) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfDatetimeValueXInAttributeY"), valueStr, attrPathEle);
                        } else if (!subType.isValueInRange(valueStr)) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.datetimeValueXIsNotInRangeInAttributeY"), valueStr, attrPathEle);
                        }
                    }
                } else if (Validator.isDomainName(attr)) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    if (valueStr != null) {
                        Pattern pattern;
                        Matcher matcher;
                        this.validateTextType(iomObj, attrPathEle, validateType, type, valueStr);
                        if (this.isAKeyword(valueStr)) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsAKeywordInAttributeY"), valueStr, attrPathEle);
                        }
                        if ((matcher = (pattern = Pattern.compile("[a-zA-Z]{1}([a-zA-Z0-9\\_]{1,})")).matcher(valueStr)) == null || !matcher.matches()) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfInterlisNameValueXInAttributeY"), valueStr, attrPathEle);
                        }
                    } else {
                        IomObject structValue = iomObj.getattrobj(attrName, structi);
                        if (structValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXHasAnUnexpectedTypeY"), attrPathEle, structValue.getobjecttag());
                        }
                    }
                } else if (Validator.isDomainUri(attr)) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    if (valueStr != null) {
                        this.validateTextType(iomObj, attrPathEle, validateType, type, valueStr);
                        Pattern pattern = Pattern.compile("((?<=\\()[A-Za-z][A-Za-z0-9\\+\\.\\-]*:([A-Za-z0-9\\.\\-_~:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=]|%[A-Fa-f0-9]{2})+(?=\\)))|([A-Za-z][A-Za-z0-9\\+\\.\\-]*:([A-Za-z0-9\\.\\-_~:/\\?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=]|%[A-Fa-f0-9]{2})+)");
                        Matcher matcher = pattern.matcher(valueStr);
                        if (matcher == null || !matcher.matches()) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.invalidFormatOfInterlisUriValueXInAttributeY"), valueStr, attrPathEle);
                        }
                    } else {
                        IomObject structValue = iomObj.getattrobj(attrName, structi);
                        if (structValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXHasAnUnexpectedTypeY"), attrPathEle, structValue.getobjecttag());
                        }
                    }
                } else if (type instanceof PolylineType) {
                    polylineType = (PolylineType)type;
                    IomObject polylineValue = iomObj.getattrobj(attrName, structi);
                    if (polylineValue != null) {
                        boolean isValid = this.validatePolyline(validateGeometryType, model, (LineType)polylineType, polylineValue, attrPathEle);
                        if (isValid) {
                            this.validatePolylineTopology(attrPathEle, validateGeometryType, (LineType)polylineType, polylineValue);
                        }
                    } else {
                        String attrValue = iomObj.getattrvalue(attrName);
                        if (attrValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotAPolylineInAttributeY"), attrValue, attrPathEle);
                        }
                    }
                } else if (type instanceof MultiPolylineType) {
                    polylineType = (MultiPolylineType)type;
                    IomObject multipolylineValue = iomObj.getattrobj(attrName, structi);
                    if (multipolylineValue != null) {
                        if (multipolylineValue.getobjecttag().equals("MULTIPOLYLINE")) {
                            int polylinec = multipolylineValue.getattrvaluecount("polyline");
                            if (polylinec > 0) {
                                for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                                    IomObject polylineValue = multipolylineValue.getattrobj("polyline", polylinei);
                                    boolean isValid = this.validatePolyline(validateGeometryType, model, (LineType)polylineType, polylineValue, attrName);
                                    if (!isValid) continue;
                                    this.validatePolylineTopology(attrPath, validateGeometryType, (LineType)polylineType, polylineValue);
                                }
                            } else {
                                this.logMsg(validateType, this.rsrc.getString("validateMultiPolyline.invalidNumberOfPolylines"), new String[0]);
                            }
                        } else {
                            this.logMsg(validateType, "unexpected Type " + multipolylineValue.getobjecttag() + "; MULTIPOLYLINE expected", new String[0]);
                        }
                    } else {
                        String attrValue = iomObj.getattrvalue(attrName);
                        if (attrValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotAPolylineInAttributeY"), attrValue, attrPathEle);
                        }
                    }
                } else if (type instanceof SurfaceOrAreaType) {
                    if (this.doItfLineTables) {
                        if (type instanceof SurfaceType) {
                            // empty if block
                        }
                    } else {
                        surfaceOrAreaType = (SurfaceOrAreaType)type;
                        IomObject surfaceValue = iomObj.getattrobj(attrName, structi);
                        if (surfaceValue != null) {
                            boolean isValid = this.validatePolygon(validateGeometryType, model, (AbstractSurfaceOrAreaType)surfaceOrAreaType, surfaceValue, iomObj, attrName);
                            if (isValid) {
                                Object attrValidator = this.pipelinePool.getIntermediateValue(attr, "topology");
                                if (attrValidator == null) {
                                    attrValidator = this;
                                    this.pipelinePool.setIntermediateValue(attr, "topology", this);
                                }
                                if (attrValidator == this) {
                                    surfaceTopologyValid = this.validateSurfaceTopology(validateGeometryType, attr, surfaceOrAreaType, this.currentMainOid, surfaceValue);
                                    if (surfaceOrAreaType instanceof AreaType && !this.singlePass && !"off".equals(this.areaOverlapValidation)) {
                                        allLines = this.areaAttrs.get(attr);
                                        if (allLines == null) {
                                            allLines = new ItfAreaPolygon2Linetable(iliClassQName, this.objPoolManager);
                                            this.areaAttrs.put(attr, allLines);
                                        }
                                        if (surfaceTopologyValid) {
                                            allLines.addPolygon(this.currentMainOid, null, surfaceValue, validateGeometryType, this.errFact);
                                        } else {
                                            this.areaAttrsAreSurfaceTopologiesValid.put(attr, false);
                                            this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.areaTopologyNoValidatedValidationOfSurfaceTopologyFailedInAttributeY"), attrPath));
                                        }
                                    }
                                }
                            }
                        } else {
                            String attrValue = iomObj.getattrprim(attrName, structi);
                            if (attrValue != null) {
                                this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotAPolygonInAttributeY"), attrValue, attrPathEle);
                            }
                        }
                    }
                } else if (type instanceof MultiSurfaceOrAreaType) {
                    surfaceOrAreaType = (MultiSurfaceOrAreaType)type;
                    IomObject surfaceValue = iomObj.getattrobj(attrName, structi);
                    if (surfaceValue != null) {
                        boolean isValid = this.validatePolygon(validateGeometryType, model, (AbstractSurfaceOrAreaType)surfaceOrAreaType, surfaceValue, iomObj, attrPathEle);
                        if (isValid) {
                            Object attrValidator = this.pipelinePool.getIntermediateValue(attr, "topology");
                            if (attrValidator == null) {
                                attrValidator = this;
                                this.pipelinePool.setIntermediateValue(attr, "topology", this);
                            }
                            if (attrValidator == this) {
                                surfaceTopologyValid = this.validateMultiSurfaceTopology(validateGeometryType, attr, (MultiSurfaceOrAreaType)surfaceOrAreaType, this.currentMainOid, surfaceValue);
                                if (surfaceOrAreaType instanceof MultiAreaType && !this.singlePass && !"off".equals(this.areaOverlapValidation)) {
                                    allLines = this.areaAttrs.get(attr);
                                    if (allLines == null) {
                                        allLines = new ItfAreaPolygon2Linetable(iliClassQName, this.objPoolManager);
                                        this.areaAttrs.put(attr, allLines);
                                    }
                                    if (surfaceTopologyValid) {
                                        allLines.addMultiPolygon(this.currentMainOid, null, surfaceValue, validateGeometryType, this.errFact);
                                    } else {
                                        this.areaAttrsAreSurfaceTopologiesValid.put(attr, false);
                                        this.errs.addEvent(this.errFact.logInfoMsg(this.rsrc.getString("validateAttrValue.areaTopologyNoValidatedValidationOfSurfaceTopologyFailedInAttributeY"), attrPathEle));
                                    }
                                }
                            }
                        }
                    } else {
                        String attrValue = iomObj.getattrprim(attrName, structi);
                        if (attrValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotAPolygonInAttributeY"), attrValue, attrPathEle);
                        }
                    }
                } else if (type instanceof CoordType) {
                    IomObject coord = iomObj.getattrobj(attrName, structi);
                    if (coord != null) {
                        this.validateCoordType(validateGeometryType, model, domain, (AbstractCoordType)((CoordType)type), coord, attrPathEle);
                    } else {
                        String attrValue = iomObj.getattrprim(attrName, structi);
                        if (attrValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotCoordInAttributeY"), attrValue, attrPathEle);
                        }
                    }
                } else if (type instanceof MultiCoordType) {
                    IomObject multicoordValue = iomObj.getattrobj(attrName, structi);
                    if (multicoordValue != null) {
                        if (multicoordValue.getobjecttag().equals("MULTICOORD")) {
                            int coordc = multicoordValue.getattrvaluecount("coord");
                            if (coordc > 0) {
                                for (int coordi = 0; coordi < coordc; ++coordi) {
                                    IomObject coordValue = multicoordValue.getattrobj("coord", coordi);
                                    if (coordValue.getobjecttag().equals("COORD")) {
                                        this.validateCoordType(validateGeometryType, model, domain, (AbstractCoordType)((MultiCoordType)type), coordValue, attrPathEle);
                                        continue;
                                    }
                                    this.logMsg(validateType, "unexpected Type " + coordValue.getobjecttag() + "; COORD expected", new String[0]);
                                }
                            } else {
                                this.logMsg(validateType, this.rsrc.getString("validateMultiCoord.invalidNumberOfCoords"), new String[0]);
                            }
                        } else {
                            this.logMsg(validateType, "unexpected Type " + multicoordValue.getobjecttag() + "; MULTICOORD expected", new String[0]);
                        }
                    } else {
                        String attrValue = iomObj.getattrprim(attrName, structi);
                        if (attrValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.theValueXIsNotCoordInAttributeY"), attrValue, attrPathEle);
                        }
                    }
                } else if (type instanceof NumericType) {
                    valueStr = iomObj.getattrprim(attrName, structi);
                    if (valueStr != null) {
                        OutParam isNumValid = new OutParam((Object)true);
                        String newValueStr = this.validateNumericType(validateType, (NumericType)type, valueStr, attrPathEle, (OutParam<Boolean>)isNumValid);
                        if (newValueStr != null) {
                            ((Iom_jObject)iomObj).setattrvalue(attrName, structi, newValueStr);
                        }
                    } else {
                        IomObject structValue = iomObj.getattrobj(attrName, structi);
                        if (structValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXHasAnUnexpectedTypeY"), attrPathEle, structValue.getobjecttag());
                        }
                    }
                } else if (type instanceof EnumerationType) {
                    EnumerationType enumType = (EnumerationType)type;
                    String value = iomObj.getattrprim(attrName, structi);
                    if (value != null) {
                        if (!((EnumerationType)type).getValues().contains(value)) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAMemberOfTheEnumerationInAttributeY"), value, attrPathEle);
                        }
                    } else {
                        IomObject structValue = iomObj.getattrobj(attrName, structi);
                        if (structValue != null) {
                            this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXHasAnUnexpectedTypeY"), attrPathEle, structValue.getobjecttag());
                        }
                    }
                } else if (type instanceof EnumTreeValueType) {
                    actualValue = iomObj.getattrprim(attrName, structi);
                    if (actualValue != null && this.isValidEnumTreeValue(actualValue, attrPath, (EnumTreeValueType)type)) {
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.valueXIsNotAMemberOfTheEnumerationInAttributeY"), actualValue, attrPathEle);
                    }
                } else if (!(type instanceof ReferenceType)) {
                    Matcher matcher;
                    String value;
                    if (type instanceof TextType) {
                        value = iomObj.getattrprim(attrName, structi);
                        if (value != null) {
                            this.validateTextType(iomObj, attrPathEle, validateType, type, value);
                        } else {
                            IomObject structValue = iomObj.getattrobj(attrName, structi);
                            if (structValue != null) {
                                this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXHasAnUnexpectedTypeY"), attrPathEle, structValue.getobjecttag());
                            }
                        }
                    } else if (type instanceof TextOIDType) {
                        value = iomObj.getattrprim(attrName, structi);
                        if (value != null && Validator.isDomainAnnexOid(attr)) {
                            if (!this.isValidAnnexOid(value)) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsNotAValidOidInAttributeY"), value, attrPathEle));
                            }
                        } else if (value != null && Validator.isDomainUuid(attr)) {
                            if (!this.isValidUuid(value)) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsNotAValidOidInAttributeY"), value, attrPathEle));
                            }
                        } else if (value != null && Validator.isDomainTextOid(attr) && !this.isValidTextOid(value, ((TextType)((TextOIDType)type).getOIDType()).getMaxLength())) {
                            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsNotAValidOidInAttributeY"), value, attrPathEle));
                        }
                    } else if (type instanceof FormattedType) {
                        String regExp = ((FormattedType)type).getRegExp();
                        String actualValue2 = iomObj.getattrprim(attrName, structi);
                        if (actualValue2 != null) {
                            if (!actualValue2.matches(regExp)) {
                                this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.attributeXHasAInvalidValueY"), attrPathEle, actualValue2));
                            } else {
                                boolean hasAValidValue = ((FormattedType)type).isValueInRange(actualValue2);
                                if (!hasAValidValue) {
                                    this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.valueXIsAOutOfRangeInAttributeY"), actualValue2, attrPathEle));
                                }
                            }
                        }
                    } else if (type instanceof BlackboxType && ((BlackboxType)type).getKind() == 2 && (actualValue = iomObj.getattrprim(attrName, structi)) != null && !(matcher = this.patternForBase64Validation.matcher(actualValue)).matches()) {
                        this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateAttrValue.attributeXHasAInvalidValueY"), attrPathEle, Validator.shortcutValue(actualValue)));
                    }
                }
                if (domain == null) continue;
                String rootDomainName = domain.getScopedName(null);
                while (domain != null) {
                    for (DomainConstraint constraint : domain) {
                        Iom_jObject iomValueObject = new Iom_jObject(rootDomainName, null);
                        iomValueObject.setattrvalue(VALUE_REF_THIS, iomObj.getattrprim(attrName, structi));
                        Value result = this.evaluateExpression(null, constraint.getScopedName(), rootDomainName, iomValueObject, constraint.getCondition(), null);
                        if (result.isTrue()) continue;
                        this.logMsg(validateType, this.rsrc.getString("validateAttrValue.attributeXDoesNotSatisfyTheDomainConstraintY"), attrPathEle, constraint.getScopedName());
                    }
                    domain = domain.getExtending();
                }
            }
        }
    }

    private static Cardinality getCardinality(AttributeDef attr) {
        Type type = attr.getDomainOrDerivedDomain();
        Cardinality card = type.getCardinality();
        if (card.getMinimum() == 0L && type instanceof TypeAlias && ((TypeAlias)type).getAliasing().isDefinedMandatory()) {
            card = new Cardinality(1L, card.getMaximum());
        }
        return card;
    }

    private static String shortcutValue(String value) {
        int MAX_LEN = 20;
        if (value == null || value.length() <= MAX_LEN) {
            return value;
        }
        return value.substring(0, MAX_LEN) + "...";
    }

    private boolean isValidEnumTreeValue(String actualValue, String attrPath, EnumTreeValueType enumTreeValueType) {
        HashSet trueValueFormat = (HashSet)enumTreeValueType.getTransientMetaValue(ENUM_TREE_VALUES);
        if (trueValueFormat == null) {
            ArrayList values = new ArrayList();
            ModelUtilities.buildEnumListAll(values, "", enumTreeValueType.getConsolidatedEnumeration());
            trueValueFormat = new HashSet(values);
            enumTreeValueType.setTransientMetaValue(ENUM_TREE_VALUES, trueValueFormat);
        }
        return !trueValueFormat.contains(actualValue);
    }

    private void validateTextType(IomObject iomObj, String attrPath, String validateType, Type type, String value) {
        if (value != null) {
            int maxLength = ((TextType)type).getMaxLength();
            TextType textType = (TextType)type;
            if (maxLength != -1 && value.length() > maxLength) {
                this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXIsLengthRestrictedToY"), attrPath, Integer.toString(maxLength));
            }
            if (((TextType)type).isNormalized() && (value.indexOf(10) >= 0 || value.indexOf(13) >= 0 || value.indexOf(9) >= 0)) {
                this.logMsg(validateType, this.rsrc.getString("validateTextType.attributeXMustNotContainControlCharacters"), attrPath);
            }
        }
    }

    private static boolean isAttributeMandatory(AttributeDef attr) {
        Type attrType = attr.getDomain();
        if (attrType == null) {
            if (attr instanceof LocalAttribute) {
                Evaluable[] ev = ((LocalAttribute)attr).getBasePaths();
                attrType = ((ObjectPath)ev[0]).getType();
            } else {
                throw new IllegalArgumentException("unexpected attribute type " + attr.getScopedName());
            }
        }
        return attrType.isMandatoryConsideringAliases();
    }

    private boolean validateSurfaceTopology(String validateType, AttributeDef attr, SurfaceOrAreaType type, String mainObjTid, IomObject iomValue) {
        boolean surfaceTopologyValid = true;
        try {
            AbstractCoordType coordType = this.resolveGenericCoordTypeOfSurface(validateType, attr);
            if (coordType == null) {
                return false;
            }
            surfaceTopologyValid = ItfSurfaceLinetable2Polygon.validatePolygon(mainObjTid, attr, iomValue, this.errFact, validateType, coordType);
            Polygon polygon = null;
            if (surfaceTopologyValid) {
                polygon = Iox2jtsext.surface2JTS(iomValue, 0.0);
                Envelope shell = polygon.getExteriorRing().getEnvelopeInternal();
                for (int i = 0; surfaceTopologyValid && i < polygon.getNumInteriorRing(); ++i) {
                    Envelope hole = polygon.getInteriorRingN(i).getEnvelopeInternal();
                    if (!hole.contains(shell)) continue;
                    this.errs.addEvent(this.errFact.logErrorMsg("first boundary not shell " + polygon.getExteriorRing().getStartPoint().getCoordinate(), new String[0]));
                    surfaceTopologyValid = false;
                }
            }
            if (this.validateSimpleBoundary && surfaceTopologyValid) {
                JtsextGeometryFactory fact = new JtsextGeometryFactory();
                RingCollector ringCollector = new RingCollector();
                ringCollector.addLine(fact.createCompoundCurve(polygon.getExteriorRing()));
                List<CompoundCurve> rings = ringCollector.getRings();
                if (rings.size() > 1) {
                    this.errs.addEvent(this.errFact.logErrorMsg("not a simple boundary " + rings.get(1).getSegments().get(0).getStartPoint(), new String[0]));
                    surfaceTopologyValid = false;
                }
                for (int i = 0; surfaceTopologyValid && i < polygon.getNumInteriorRing(); ++i) {
                    RingCollector ringCollector2 = new RingCollector();
                    ringCollector2.addLine(fact.createCompoundCurve(polygon.getInteriorRingN(i)));
                    List<CompoundCurve> rings2 = ringCollector2.getRings();
                    if (rings2.size() <= 1) continue;
                    this.errs.addEvent(this.errFact.logErrorMsg("not a simple boundary " + rings2.get(1).getSegments().get(0).getStartPoint(), new String[0]));
                    surfaceTopologyValid = false;
                }
            }
        }
        catch (IoxException e) {
            surfaceTopologyValid = false;
            this.errs.addEvent(this.errFact.logErrorMsg(e, this.rsrc.getString("validateSurfaceTopology.failedToValidatePolygon"), new String[0]));
        }
        return surfaceTopologyValid;
    }

    private boolean validateMultiSurfaceTopology(String validateType, AttributeDef attr, MultiSurfaceOrAreaType type, String mainObjTid, IomObject iomValue) {
        boolean surfaceTopologyValid = true;
        try {
            AbstractCoordType coordType = this.resolveGenericCoordTypeOfSurface(validateType, attr);
            if (coordType == null) {
                return false;
            }
            surfaceTopologyValid = ItfSurfaceLinetable2Polygon.validateMultiPolygon(mainObjTid, attr, iomValue, this.errFact, validateType, coordType);
        }
        catch (IoxException e) {
            surfaceTopologyValid = false;
            this.errs.addEvent(this.errFact.logErrorMsg(e, this.rsrc.getString("validateSurfaceTopology.failedToValidatePolygon"), new String[0]));
        }
        return surfaceTopologyValid;
    }

    private AbstractCoordType resolveGenericCoordTypeOfSurface(String validateType, AttributeDef attr) {
        AbstractSurfaceOrAreaType surfaceType = (AbstractSurfaceOrAreaType)attr.getDomainResolvingAliases();
        Domain coordDomain = surfaceType.getControlPointDomain();
        AbstractCoordType coordType = (AbstractCoordType)coordDomain.getType();
        if (coordType.isGeneric()) {
            coordType = this.resolveGenericCoordType(validateType, (Model)attr.getContainer(Model.class), coordDomain);
        }
        return coordType;
    }

    private void validatePolylineTopology(String attrPath, String validateType, LineType type, IomObject iomValue) {
        CompoundCurve seg = null;
        try {
            OutParam foundErrs = new OutParam();
            seg = Iox2jtsext.polyline2JTS(iomValue, false, 0.0, (OutParam<Boolean>)foundErrs, this.errFact, 0.0, validateType, "warning");
            if (seg == null || ((Boolean)foundErrs.value).booleanValue()) {
                return;
            }
        }
        catch (IoxException e) {
            throw new IllegalStateException(e);
        }
        PrecisionDecimal overlapDef = type.getMaxOverlap();
        if (overlapDef != null) {
            NumericalType[] dimensions;
            double size;
            double newVertexOffset = 0.0;
            double maxOverlaps = overlapDef.doubleValue();
            if (maxOverlaps > 0.0 && (size = (double)((NumericType)(dimensions = ((CoordType)type.getControlPointDomain().getType()).getDimensions())[0]).getMinimum().getAccuracy()) > 0.0) {
                newVertexOffset = 2.0 * java.lang.Math.pow(10.0, -size);
            }
            ItfSurfaceLinetable2Polygon.removeValidSelfIntersections(seg, maxOverlaps, newVertexOffset);
            ArrayList<CompoundCurve> segv = new ArrayList<CompoundCurve>();
            segv.add(seg);
            CompoundCurveNoder validator = new CompoundCurveNoder(segv, false);
            if (!validator.isValid()) {
                boolean hasIntersections = false;
                for (Intersection is : validator.getIntersections()) {
                    Coordinate[] pt = is.getPt();
                    this.logMsg(validateType, "Attribute {0} has an invalid self-intersection at {1}", attrPath, "" + this.coordToString(pt[0]) + (pt.length == 2 ? ", coord2 " + this.coordToString(pt[1]) : ""));
                }
            }
        }
    }

    private String coordToString(Coordinate coord) {
        return "(" + coord.x + ", " + coord.y + ")";
    }

    private boolean validatePolygon(String validateType, Model model, AbstractSurfaceOrAreaType surfaceOrAreaType, IomObject surfaceValue, IomObject currentIomObj, String attrName) {
        boolean foundErrs = false;
        if (surfaceValue.getobjecttag().equals("MULTISURFACE")) {
            boolean clipped;
            int surfacec = surfaceValue.getattrvaluecount("surface");
            if (surfacec == 0) {
                this.logMsg(validateType, this.rsrc.getString("validateMultiPolygon.invalidNumberOfSurfaces"), new String[0]);
                return false;
            }
            boolean bl = clipped = surfaceValue.getobjectconsistency() == 1;
            if (surfaceOrAreaType instanceof SurfaceOrAreaType && !clipped && surfacec > 1) {
                this.logMsg(validateType, this.rsrc.getString("validatePolygon.invalidNumberOfSurfaceInCompleteBasket"), new String[0]);
                return false;
            }
            for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                IomObject surface = surfaceValue.getattrobj("surface", surfacei);
                int boundaryc = surface.getattrvaluecount("boundary");
                if (boundaryc == 0) {
                    String objectIdentification = currentIomObj.getobjectoid();
                    if (objectIdentification == null) {
                        objectIdentification = currentIomObj.getobjecttag();
                    }
                    this.logMsg(validateType, this.rsrc.getString("validatePolygon.missingOuterboundaryInXOfObjectY"), attrName, objectIdentification);
                    return false;
                }
                for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    if (boundaryi == 0) {
                        // empty if block
                    }
                    for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        foundErrs = foundErrs || !this.validatePolyline(validateType, model, (LineType)surfaceOrAreaType, polyline, attrName);
                    }
                }
            }
        } else {
            this.logMsg(validateType, "unexpected Type " + surfaceValue.getobjecttag() + "; MULTISURFACE expected", new String[0]);
            return false;
        }
        return !foundErrs;
    }

    private boolean validatePolyline(String validateType, Model model, LineType polylineType, IomObject polylineValue, String attrName) {
        boolean foundErrs = false;
        if (polylineValue.getobjecttag().equals("POLYLINE")) {
            boolean clipped;
            boolean bl = clipped = polylineValue.getobjectconsistency() == 1;
            if (!clipped && polylineValue.getattrvaluecount("sequence") > 1) {
                this.logMsg(validateType, this.rsrc.getString("validatePolyline.invalidNumberOfSequenceInCompleteBasket"), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            }
            for (int sequencei = 0; sequencei < polylineValue.getattrvaluecount("sequence"); ++sequencei) {
                IomObject sequence = polylineValue.getattrobj("sequence", sequencei);
                LineForm[] lineforms = polylineType.getLineForms();
                HashSet<String> lineformNames = new HashSet<String>();
                for (LineForm lf : lineforms) {
                    lineformNames.add(lf.getName());
                }
                if (sequence.getobjecttag().equals("SEGMENTS")) {
                    if (sequence.getattrvaluecount("segment") <= 1) {
                        this.logMsg(validateType, this.rsrc.getString("validatePolyline.invalidNumberOfSegments"), new String[0]);
                        if (!foundErrs) {
                            // empty if block
                        }
                        foundErrs = true;
                    }
                    for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                        IomObject segment = sequence.getattrobj("segment", segmenti);
                        if (segment.getobjecttag().equals("COORD")) {
                            if (lineformNames.contains(PredefinedModel.getInstance().STRAIGHTS.getName()) || segmenti == 0) {
                                Domain coordDomain = polylineType.getControlPointDomain();
                                foundErrs = foundErrs || !this.validateCoordType(validateType, model, coordDomain, (AbstractCoordType)((CoordType)coordDomain.getType()), segment, attrName);
                                continue;
                            }
                            this.logMsg(validateType, "unexpected COORD", new String[0]);
                            if (!foundErrs) {
                                // empty if block
                            }
                            foundErrs = true;
                            continue;
                        }
                        if (segment.getobjecttag().equals("ARC")) {
                            if (lineformNames.contains(PredefinedModel.getInstance().ARCS.getName()) && segmenti > 0) {
                                foundErrs = foundErrs || !this.validateARCSType(validateType, (CoordType)polylineType.getControlPointDomain().getType(), segment, attrName);
                                continue;
                            }
                            this.logMsg(validateType, "unexpected ARC", new String[0]);
                            if (!foundErrs) {
                                // empty if block
                            }
                            foundErrs = true;
                            continue;
                        }
                        this.logMsg(validateType, "unexpected Type " + segment.getobjecttag(), new String[0]);
                        if (!foundErrs) {
                            // empty if block
                        }
                        foundErrs = true;
                    }
                    continue;
                }
                this.logMsg(validateType, "unexpected Type " + sequence.getobjecttag(), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            }
        } else {
            this.logMsg(validateType, "unexpected Type " + polylineValue.getobjecttag() + "; POLYLINE expected", new String[0]);
            if (!foundErrs) {
                // empty if block
            }
            foundErrs = true;
        }
        return !foundErrs;
    }

    private AbstractCoordType resolveGenericCoordType(String validateType, Model model, Domain coordDomain) {
        Domain concreteDomain = this.genericDomains.get(coordDomain.getScopedName());
        if (concreteDomain != null) {
            return (AbstractCoordType)concreteDomain.getType();
        }
        Domain[] resolved = model.resolveGenericDomain(coordDomain);
        if (resolved == null) {
            this.logMsg(validateType, this.rsrc.getString("validateCoordType.missingContext"), coordDomain.toString());
            return null;
        }
        if (resolved.length == 1) {
            return (AbstractCoordType)resolved[0].getType();
        }
        this.logMsg(validateType, this.rsrc.getString("validateCoordType.multipleDomainsInContext"), coordDomain.toString());
        return null;
    }

    private boolean validateCoordType(String validateType, Model model, Domain coordDomain, AbstractCoordType coordType, IomObject coordValue, String attrName) {
        boolean foundErrs = false;
        OutParam isNumValid = new OutParam((Object)true);
        if (coordType.isGeneric() && (coordType = this.resolveGenericCoordType(validateType, model, coordDomain)) == null) {
            return false;
        }
        if (coordType.getDimensions().length >= 1) {
            if (coordValue.getattrvalue("C1") != null) {
                coordValue.setattrvalue("C1", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[0], coordValue.getattrvalue("C1"), attrName, (OutParam<Boolean>)isNumValid));
            } else if (coordValue.getattrvalue("A1") != null) {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.notATypeOfCoord"), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            } else {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC1Expected"), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            }
        }
        if (coordType.getDimensions().length == 2 && coordValue.getattrvalue("C3") != null) {
            this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC3NotExpected"), new String[0]);
            if (!foundErrs) {
                // empty if block
            }
            foundErrs = true;
        }
        if (coordType.getDimensions().length >= 2) {
            if (coordValue.getattrvalue("C2") != null) {
                coordValue.setattrvalue("C2", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[1], coordValue.getattrvalue("C2"), attrName, (OutParam<Boolean>)isNumValid));
            } else if (coordValue.getattrvalue("A2") != null) {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.notATypeOfCoord"), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            } else {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC2Expected"), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            }
        }
        if (coordType.getDimensions().length == 3) {
            if (coordValue.getattrvalue("C3") != null) {
                coordValue.setattrvalue("C3", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[2], coordValue.getattrvalue("C3"), attrName, (OutParam<Boolean>)isNumValid));
            } else {
                this.logMsg(validateType, this.rsrc.getString("validateCoordType.wrongCoordStructureC3Expected"), new String[0]);
                if (!foundErrs) {
                    // empty if block
                }
                foundErrs = true;
            }
        }
        int propc = coordValue.getattrcount();
        for (int propi = 0; propi < propc; ++propi) {
            String propName = coordValue.getattrname(propi);
            if (propName.startsWith("_") || propName.equals("C1") || propName.equals("C2") || propName.equals("C3")) continue;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateCoordType.wrongCoordStructureUnknownPropertyX"), propName));
            if (!foundErrs) {
                // empty if block
            }
            foundErrs = true;
        }
        return !foundErrs && (Boolean)isNumValid.value != false;
    }

    private boolean validateARCSType(String validateType, CoordType coordType, IomObject coordValue, String attrName) {
        boolean foundErrs = false;
        int dimLength = coordType.getDimensions().length;
        String c1 = coordValue.getattrvalue("C1");
        String c2 = coordValue.getattrvalue("C2");
        String c3 = coordValue.getattrvalue("C3");
        String a1 = coordValue.getattrvalue("A1");
        String a2 = coordValue.getattrvalue("A2");
        boolean wrongArcStructure = false;
        OutParam isNumValid = new OutParam((Object)true);
        int c1Count = coordValue.getattrvaluecount("C1");
        if (dimLength >= 2 && dimLength <= 3) {
            if (a1 != null && a2 != null && c1 != null && c2 != null) {
                coordValue.setattrvalue("A1", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[0], a1, attrName, (OutParam<Boolean>)isNumValid));
                coordValue.setattrvalue("A2", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[1], a2, attrName, (OutParam<Boolean>)isNumValid));
                coordValue.setattrvalue("C1", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[0], c1, attrName, (OutParam<Boolean>)isNumValid));
                coordValue.setattrvalue("C2", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[1], c2, attrName, (OutParam<Boolean>)isNumValid));
                if (dimLength == 2) {
                    if (c3 != null) {
                        this.logMsg(validateType, this.rsrc.getString("validateARCSType.wrongArcStructureC3NotExpected"), new String[0]);
                        if (!foundErrs) {
                            // empty if block
                        }
                        foundErrs = true;
                    }
                } else if (dimLength == 3) {
                    if (c3 != null) {
                        coordValue.setattrvalue("C3", this.validateNumericType(validateType, (NumericType)coordType.getDimensions()[2], c3, attrName, (OutParam<Boolean>)isNumValid));
                    } else {
                        this.logMsg(validateType, this.rsrc.getString("validateARCSType.wrongArcStructureC3Expected"), new String[0]);
                        if (!foundErrs) {
                            // empty if block
                        }
                        foundErrs = true;
                    }
                }
            } else {
                wrongArcStructure = true;
            }
        } else {
            wrongArcStructure = true;
        }
        if (wrongArcStructure) {
            this.logMsg(validateType, this.rsrc.getString("validateARCSType.wrongArcStructure"), new String[0]);
            if (!foundErrs) {
                // empty if block
            }
            foundErrs = true;
        }
        int propc = coordValue.getattrcount();
        for (int propi = 0; propi < propc; ++propi) {
            String propName = coordValue.getattrname(propi);
            if (propName.startsWith("_") || !propName.equals("A1") || !propName.equals("A2") || !propName.equals("C1") || !propName.equals("C2") || !propName.equals("C3")) continue;
            this.errs.addEvent(this.errFact.logErrorMsg(this.rsrc.getString("validateARCSType.wrongArcStructureUnknownPropertyX"), propName));
            if (!foundErrs) {
                // empty if block
            }
            foundErrs = true;
        }
        return !foundErrs && (Boolean)isNumValid.value != false;
    }

    private String validateNumericType(String validateType, NumericType type, String valueStr, String attrPathEle, OutParam<Boolean> isValid) {
        PrecisionDecimal value = null;
        try {
            value = new PrecisionDecimal(valueStr);
        }
        catch (NumberFormatException e) {
            this.logMsg(validateType, this.rsrc.getString("validateNumericType.valueXIsNotANumber"), valueStr, attrPathEle);
            isValid.value = false;
        }
        BigDecimal rounded = null;
        if (value != null) {
            PrecisionDecimal minimum = type.getMinimum();
            PrecisionDecimal maximum = type.getMaximum();
            BigDecimal min_general = new BigDecimal(minimum.toString());
            BigDecimal max_general = new BigDecimal(maximum.toString());
            BigDecimal valueBigDec = new BigDecimal(value.toString());
            int precision = minimum.getAccuracy();
            rounded = this.disableRounding ? valueBigDec : Validator.roundNumeric(precision, valueBigDec);
            if (rounded != null && (rounded.compareTo(min_general) == -1 || rounded.compareTo(max_general) == 1)) {
                this.logMsg(validateType, this.rsrc.getString("validateNumericType.valueXIsOutOfRangeInAttributeY"), rounded.toString(), attrPathEle);
                isValid.value = false;
            }
        }
        if (rounded == null) {
            return null;
        }
        return rounded.toPlainString();
    }

    private boolean isAKeyword(String valueStr) {
        HashSet<String> keyWords = Ili23KeyWords.getAllKeyWords();
        return keyWords.contains(valueStr);
    }

    public static BigDecimal roundNumeric(int precision, String valueStr) {
        if (valueStr == null) {
            return null;
        }
        return Validator.roundNumeric(precision, new BigDecimal(valueStr));
    }

    public static BigDecimal roundNumeric(int precision, BigDecimal value) {
        if (value == null) {
            return null;
        }
        boolean isNegative = value.signum() == -1;
        BigDecimal rounded = null;
        if (value != null) {
            rounded = isNegative ? value.setScale(precision, 5) : value.setScale(precision, 4);
        }
        return rounded;
    }

    public boolean isValidUuid(String valueStr) {
        return valueStr.length() == 36 && valueStr.matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}?");
    }

    private static boolean isDomainName(AttributeDef attr) {
        return attr.isDomainName();
    }

    private static boolean isDomainUri(AttributeDef attr) {
        return attr.isDomainUri();
    }

    private static boolean isDomainAnnexOid(AttributeDef attr) {
        Type type = attr.getDomain();
        while (type instanceof TypeAlias) {
            if (((TypeAlias)type).getAliasing() == PredefinedModel.getInstance().STANDARDOID) {
                return true;
            }
            type = ((TypeAlias)type).getAliasing().getType();
        }
        return false;
    }

    private static boolean isDomainUuid(AttributeDef attr) {
        return attr.isDomainIliUuid();
    }

    private static boolean isDomainTextOid(AttributeDef attr) {
        Type type = attr.getDomain();
        return type instanceof TextOIDType;
    }

    private void logMsg(String validateKind, String msg, String ... args) {
        if (!"off".equals(validateKind)) {
            if ("warning".equals(validateKind)) {
                this.errs.addEvent(this.errFact.logWarningMsg(msg, args));
            } else {
                this.errs.addEvent(this.errFact.logErrorMsg(msg, args));
            }
        }
    }

    private void logMsg(String validateKind, IoxIntersectionException intersectionException) {
        if (!"off".equals(validateKind)) {
            if ("warning".equals(validateKind)) {
                this.errs.addEvent(this.errFact.logWarningMsg(intersectionException));
            } else {
                this.errs.addEvent(this.errFact.logErrorMsg(intersectionException));
            }
        }
    }

    private void validateItfLineTableObject(IomObject iomObj, AttributeDef modelele) {
    }

    public boolean isAutoSecondPass() {
        return this.autoSecondPass;
    }

    public void setAutoSecondPass(boolean autoSecondPass) {
        this.autoSecondPass = autoSecondPass;
    }

    public static void initItfValidation(Settings settings) {
        settings.setValue(CONFIG_DO_ITF_OIDPERTABLE, CONFIG_DO_ITF_OIDPERTABLE_DO);
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public long getStructCount() {
        return this.structCount;
    }
}

