/*
 * Decompiled with CFR 0.152.
 */
package org.interlis2.validator.gui;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.basics.swing.SwingWorker;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.basics.view.FileChooser;
import ch.ehi.basics.view.GenericFileFilter;
import ch.interlis.ili2c.gui.RepositoriesDialog;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.interlis2.validator.Main;
import org.interlis2.validator.Validator;
import org.interlis2.validator.gui.AboutDialog;
import org.interlis2.validator.gui.LogListener;

public class MainFrame
extends JFrame {
    private static final String WINDOW_HEIGHT = "org.interlis2.validator.gui.MainFrame.windowHeight";
    private static final String WINDOW_WIDTH = "org.interlis2.validator.gui.MainFrame.windowWidth";
    private static final String WINDOW_X = "org.interlis2.validator.gui.MainFrame.windowX";
    private static final String WINDOW_Y = "org.interlis2.validator.gui.MainFrame.windowY";
    private ResourceBundle rsrc = ResourceBundle.getBundle("org.interlis2.validator.gui.IliValidatorTexts");
    private Settings settings = null;
    private JPanel jContentPane = null;
    private JLabel xtfFileLabel = null;
    private JLabel xtfRefFileLabel = null;
    private JTextArea xtfFileUi = null;
    private JTextArea xtfRefFileUi = null;
    private JCheckBox allObjectsAccessibleUi = null;
    private JButton doXtfFileSelBtn = null;
    private JButton doXtfRefFileSelBtn = null;
    private JLabel modelNamesLabel = null;
    private JTextField modelNamesUi = null;
    private JLabel scopeLabel = null;
    private JTextField scopeUi = null;
    private JLabel refMappingFileLabel = null;
    private JTextField refMappingFileUi = null;
    private JButton doRefMappingFileBtn = null;
    private JLabel configFileLabel = null;
    private JTextField configFileUi = null;
    private JButton doConfigFileSelBtn = null;
    private JLabel metaConfigFileLabel = null;
    private JTextField metaConfigFileUi = null;
    private JButton doMetaConfigFileSelBtn = null;
    private JLabel logFileLabel = null;
    private JTextField logFileUi = null;
    private JButton doLogFileSelBtn = null;
    private JLabel xtfLogFileLabel = null;
    private JTextField xtfLogFileUi = null;
    private JButton doXtfLogFileSelBtn = null;
    private JButton doNewConfigFileBtn = null;
    private JTextArea logUi = null;
    private JButton clearlogBtn = null;
    private JCheckBoxMenuItem optionsSkipPolygonBuildingItem = null;
    private JCheckBoxMenuItem optionsMultiplicityOffItem = null;
    private JCheckBoxMenuItem optionsAllowItfAreaHolesItem = null;
    private JCheckBoxMenuItem optionsSimpleBoundaryItem = null;
    private JCheckBoxMenuItem optionsLogTimeItem = null;
    private JCheckBoxMenuItem optionsTraceItem = null;
    private JCheckBoxMenuItem optionsDisableConstraintValidationItem = null;
    private JCheckBoxMenuItem optionsDisableAreaValidationItem = null;
    private StringBuffer body = new StringBuffer();
    private JScrollPane jScrollPane = null;
    private JButton doValidateBtn = null;
    private LogListener logListener = null;

    public MainFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 361);
        this.setLocationByPlatform(true);
        this.setContentPane(this.getJContentPane());
        this.setDefaultCloseOperation(3);
        this.setName("ilivalidator");
        this.setTitle(this.rsrc.getString("MainFrame.Title"));
        this.xtfFileUi.setBorder(new JTextField().getBorder());
        this.xtfRefFileUi.setBorder(new JTextField().getBorder());
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu(this.rsrc.getString("MainFrame.ToolsMenu"));
        menu.setMnemonic(84);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem(this.rsrc.getString("MainFrame.ModelRepositoriesMenuItem"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoriesDialog dlg = new RepositoriesDialog(MainFrame.this);
                dlg.setIlidirs(MainFrame.this.settings.getValue("org.interlis2.validator.ilidirs"));
                dlg.setHttpProxyHost(MainFrame.this.settings.getValue("ch.interlis.ili2c.http_proxy_host"));
                dlg.setHttpProxyPort(MainFrame.this.settings.getValue("ch.interlis.ili2c.http_proxy_port"));
                dlg.setLocationRelativeTo(MainFrame.this.getJContentPane());
                if (dlg.showDialog() == 1) {
                    String ilidirs = dlg.getIlidirs();
                    if (ilidirs == null) {
                        ilidirs = "%ITF_DIR;http://models.interlis.ch/;%JAR_DIR/ilimodels";
                    }
                    MainFrame.this.settings.setValue("org.interlis2.validator.ilidirs", ilidirs);
                    MainFrame.this.settings.setValue("ch.interlis.ili2c.http_proxy_host", dlg.getHttpProxyHost());
                    MainFrame.this.settings.setValue("ch.interlis.ili2c.http_proxy_port", dlg.getHttpProxyPort());
                    MainFrame.this.saveSettings(MainFrame.this.settings);
                }
            }
        });
        menu.add(menuItem);
        JMenu optionsMenu = new JMenu(this.rsrc.getString("MainFrame.OptionsMenu"));
        optionsMenu.setMnemonic(84);
        menuBar.add(optionsMenu);
        this.optionsMultiplicityOffItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsMultiplicityOffItem"));
        optionsMenu.add(this.optionsMultiplicityOffItem);
        this.optionsSkipPolygonBuildingItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsSkipPolygonBuildingItem"));
        optionsMenu.add(this.optionsSkipPolygonBuildingItem);
        this.optionsAllowItfAreaHolesItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsAllowItfAreaHolesItem"));
        optionsMenu.add(this.optionsAllowItfAreaHolesItem);
        this.optionsSimpleBoundaryItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsSimpleBoundaryItem"));
        optionsMenu.add(this.optionsSimpleBoundaryItem);
        this.optionsDisableConstraintValidationItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsDisableConstraintValidationItem"));
        optionsMenu.add(this.optionsDisableConstraintValidationItem);
        this.optionsDisableAreaValidationItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsDisableAreaValidationItem"));
        optionsMenu.add(this.optionsDisableAreaValidationItem);
        this.optionsLogTimeItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsLogTimeItem"));
        optionsMenu.add(this.optionsLogTimeItem);
        this.optionsTraceItem = new JCheckBoxMenuItem(this.rsrc.getString("MainFrame.OptionsTraceItem"));
        optionsMenu.add(this.optionsTraceItem);
        JMenu helpMenu = new JMenu(this.rsrc.getString("MainFrame.HelpMenu"));
        menuBar.add(helpMenu);
        JMenuItem onlineDocumentation = new JMenuItem(this.rsrc.getString("MainFrame.OnlineHelpMenuItem"));
        helpMenu.add(onlineDocumentation);
        onlineDocumentation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop currentDesktop = Desktop.getDesktop();
                    if (Desktop.isDesktopSupported() && currentDesktop.isSupported(Desktop.Action.BROWSE)) {
                        URI docUri = URI.create(MainFrame.this.rsrc.getString("MainFrame.DocURL"));
                        currentDesktop.browse(docUri);
                    }
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        });
        final AboutDialog aboutDialog = new AboutDialog(this);
        JMenuItem aboutMenuItem = new JMenuItem(this.rsrc.getString("MainFrame.AboutMenuItem"));
        helpMenu.add(aboutMenuItem);
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                aboutDialog.setLocationRelativeTo(MainFrame.this.getJContentPane());
                aboutDialog.setVisible(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainFrame.this.saveSettings(MainFrame.this.getSettings());
                System.exit(0);
            }
        });
    }

    private void saveSettings(Settings settings) {
        Settings toSave = new Settings();
        toSave.setValue("WORKING_DIRECTORY", settings.getValue("WORKING_DIRECTORY"));
        toSave.setValue("org.interlis2.validator.ilidirs", settings.getValue("org.interlis2.validator.ilidirs"));
        toSave.setValue("org.interlis2.validator.modelNames", settings.getValue("org.interlis2.validator.modelNames"));
        toSave.setValue("org.interlis2.validator.allobjectsaccessible", settings.getValue("org.interlis2.validator.allobjectsaccessible"));
        toSave.setValue("org.interlis2.validator.log.timestamp", settings.getValue("org.interlis2.validator.log.timestamp"));
        toSave.setValue("ch.interlis.ili2c.http_proxy_host", settings.getValue("ch.interlis.ili2c.http_proxy_host"));
        toSave.setValue("ch.interlis.ili2c.http_proxy_port", settings.getValue("ch.interlis.ili2c.http_proxy_port"));
        toSave.setValue(WINDOW_WIDTH, settings.getValue(WINDOW_WIDTH));
        toSave.setValue(WINDOW_HEIGHT, settings.getValue(WINDOW_HEIGHT));
        toSave.setValue(WINDOW_X, settings.getValue(WINDOW_X));
        toSave.setValue(WINDOW_Y, settings.getValue(WINDOW_Y));
        Main.writeSettings(toSave);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            GridBagConstraints xtfFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints xtfFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doXtfFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints xtfRefFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints xtfRefFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doXtfRefFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints allObjectsAccessibleConstraints = new GridBagConstraints();
            GridBagConstraints modelNamesLabelConstraints = new GridBagConstraints();
            GridBagConstraints modelNamesUiConstraints = new GridBagConstraints();
            GridBagConstraints scopeLabelConstraints = new GridBagConstraints();
            GridBagConstraints scopeUiConstraints = new GridBagConstraints();
            GridBagConstraints refMappingFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints refMappingFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doRefMappingFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints logFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints logFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doLogFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints xtfLogFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints xtfLogFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doXtfLogFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints configFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints configFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doConfigFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints doNewConfigFileBtnConstraints = new GridBagConstraints();
            GridBagConstraints metaConfigFileLabelConstraints = new GridBagConstraints();
            GridBagConstraints metaConfigFileUiConstraints = new GridBagConstraints();
            GridBagConstraints doMetaConfigFileSelBtnConstraints = new GridBagConstraints();
            GridBagConstraints clearlogBtnConstraints = new GridBagConstraints();
            GridBagConstraints logPaneConstraints = new GridBagConstraints();
            GridBagConstraints doValidateConstraints = new GridBagConstraints();
            int row = 0;
            xtfFileLabelConstraints.gridx = 0;
            xtfFileLabelConstraints.gridy = row;
            xtfFileLabelConstraints.anchor = 18;
            xtfFileUiConstraints.fill = 2;
            xtfFileUiConstraints.weightx = 1.0;
            xtfFileUiConstraints.gridx = 1;
            xtfFileUiConstraints.gridy = row;
            xtfFileUiConstraints.anchor = 18;
            doXtfFileSelBtnConstraints.gridx = 2;
            doXtfFileSelBtnConstraints.gridy = row++;
            doXtfFileSelBtnConstraints.anchor = 17;
            xtfRefFileLabelConstraints.gridx = 0;
            xtfRefFileLabelConstraints.gridy = row;
            xtfRefFileLabelConstraints.anchor = 18;
            xtfRefFileUiConstraints.fill = 2;
            xtfRefFileUiConstraints.weightx = 1.0;
            xtfRefFileUiConstraints.gridx = 1;
            xtfRefFileUiConstraints.gridy = row;
            xtfRefFileUiConstraints.anchor = 18;
            doXtfRefFileSelBtnConstraints.gridx = 2;
            doXtfRefFileSelBtnConstraints.gridy = row++;
            doXtfRefFileSelBtnConstraints.anchor = 17;
            refMappingFileLabelConstraints.gridx = 0;
            refMappingFileLabelConstraints.gridy = row;
            refMappingFileLabelConstraints.anchor = 18;
            refMappingFileUiConstraints.fill = 2;
            refMappingFileUiConstraints.weightx = 1.0;
            refMappingFileUiConstraints.gridx = 1;
            refMappingFileUiConstraints.gridy = row;
            refMappingFileUiConstraints.anchor = 18;
            doRefMappingFileSelBtnConstraints.gridx = 2;
            doRefMappingFileSelBtnConstraints.gridy = row++;
            doRefMappingFileSelBtnConstraints.anchor = 17;
            scopeLabelConstraints.gridx = 0;
            scopeLabelConstraints.gridy = row;
            scopeLabelConstraints.anchor = 18;
            scopeUiConstraints.fill = 2;
            scopeUiConstraints.weightx = 1.0;
            scopeUiConstraints.gridx = 1;
            scopeUiConstraints.gridy = row++;
            scopeUiConstraints.anchor = 18;
            allObjectsAccessibleConstraints.gridx = 1;
            allObjectsAccessibleConstraints.gridy = row++;
            allObjectsAccessibleConstraints.anchor = 18;
            modelNamesLabelConstraints.gridx = 0;
            modelNamesLabelConstraints.gridy = row;
            modelNamesLabelConstraints.anchor = 18;
            modelNamesUiConstraints.fill = 2;
            modelNamesUiConstraints.weightx = 1.0;
            modelNamesUiConstraints.gridx = 1;
            modelNamesUiConstraints.gridy = row++;
            modelNamesUiConstraints.anchor = 18;
            logFileLabelConstraints.gridx = 0;
            logFileLabelConstraints.gridy = row;
            logFileLabelConstraints.anchor = 18;
            logFileUiConstraints.fill = 2;
            logFileUiConstraints.weightx = 1.0;
            logFileUiConstraints.gridx = 1;
            logFileUiConstraints.gridy = row;
            logFileUiConstraints.anchor = 18;
            doLogFileSelBtnConstraints.gridx = 2;
            doLogFileSelBtnConstraints.gridy = row++;
            doLogFileSelBtnConstraints.anchor = 17;
            xtfLogFileLabelConstraints.gridx = 0;
            xtfLogFileLabelConstraints.gridy = row;
            xtfLogFileLabelConstraints.anchor = 18;
            xtfLogFileUiConstraints.fill = 2;
            xtfLogFileUiConstraints.weightx = 1.0;
            xtfLogFileUiConstraints.gridx = 1;
            xtfLogFileUiConstraints.gridy = row;
            xtfLogFileUiConstraints.anchor = 18;
            doXtfLogFileSelBtnConstraints.gridx = 2;
            doXtfLogFileSelBtnConstraints.gridy = row++;
            doXtfLogFileSelBtnConstraints.anchor = 17;
            configFileLabelConstraints.gridx = 0;
            configFileLabelConstraints.gridy = row;
            configFileLabelConstraints.anchor = 18;
            configFileUiConstraints.fill = 2;
            configFileUiConstraints.weightx = 1.0;
            configFileUiConstraints.gridx = 1;
            configFileUiConstraints.gridy = row;
            configFileUiConstraints.anchor = 18;
            doConfigFileSelBtnConstraints.gridx = 2;
            doConfigFileSelBtnConstraints.gridy = row;
            doConfigFileSelBtnConstraints.anchor = 17;
            doNewConfigFileBtnConstraints.gridx = 3;
            doNewConfigFileBtnConstraints.gridy = row++;
            metaConfigFileLabelConstraints.gridx = 0;
            metaConfigFileLabelConstraints.gridy = row;
            metaConfigFileLabelConstraints.anchor = 18;
            metaConfigFileUiConstraints.fill = 2;
            metaConfigFileUiConstraints.weightx = 1.0;
            metaConfigFileUiConstraints.gridx = 1;
            metaConfigFileUiConstraints.gridy = row;
            metaConfigFileUiConstraints.anchor = 18;
            doMetaConfigFileSelBtnConstraints.gridx = 2;
            doMetaConfigFileSelBtnConstraints.gridy = row++;
            doMetaConfigFileSelBtnConstraints.anchor = 17;
            logPaneConstraints.fill = 1;
            logPaneConstraints.weightx = 1.0;
            logPaneConstraints.weighty = 1.0;
            logPaneConstraints.gridx = 0;
            logPaneConstraints.gridy = row;
            logPaneConstraints.gridheight = 2;
            logPaneConstraints.gridwidth = 2;
            doValidateConstraints.gridy = row++;
            doValidateConstraints.gridx = 2;
            doValidateConstraints.gridwidth = 2;
            doValidateConstraints.anchor = 17;
            clearlogBtnConstraints.gridx = 2;
            clearlogBtnConstraints.gridy = row;
            clearlogBtnConstraints.gridwidth = 2;
            clearlogBtnConstraints.anchor = 18;
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getXtfFileLabel(), xtfFileLabelConstraints);
            this.jContentPane.add((Component)this.getXtfFileUi(), xtfFileUiConstraints);
            this.jContentPane.add((Component)this.getDoXtfFileSelBtn(), doXtfFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getXtfRefFileLabel(), xtfRefFileLabelConstraints);
            this.jContentPane.add((Component)this.getXtfRefFileUi(), xtfRefFileUiConstraints);
            this.jContentPane.add((Component)this.getDoXtfRefFileSelBtn(), doXtfRefFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getModelNamesLabel(), modelNamesLabelConstraints);
            this.jContentPane.add((Component)this.getModelNamesUi(), modelNamesUiConstraints);
            this.jContentPane.add((Component)this.getScopeLabel(), scopeLabelConstraints);
            this.jContentPane.add((Component)this.getScopeUi(), scopeUiConstraints);
            this.jContentPane.add((Component)this.getRefMappingFileLabel(), refMappingFileLabelConstraints);
            this.jContentPane.add((Component)this.getRefMappingFileUi(), refMappingFileUiConstraints);
            this.jContentPane.add((Component)this.getDoRefMappingFileBtn(), doRefMappingFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getLogFileLabel(), logFileLabelConstraints);
            this.jContentPane.add((Component)this.getLogFileUi(), logFileUiConstraints);
            this.jContentPane.add((Component)this.getDoLogFileSelBtn(), doLogFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getXtfLogFileLabel(), xtfLogFileLabelConstraints);
            this.jContentPane.add((Component)this.getXtfLogFileUi(), xtfLogFileUiConstraints);
            this.jContentPane.add((Component)this.getDoXtfLogFileSelBtn(), doXtfLogFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getConfigFileLabel(), configFileLabelConstraints);
            this.jContentPane.add((Component)this.getConfigFileUi(), configFileUiConstraints);
            this.jContentPane.add((Component)this.getDoConfigFileSelBtn(), doConfigFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getNewConfigFileBtn(), doNewConfigFileBtnConstraints);
            this.jContentPane.add((Component)this.getMetaConfigFileLabel(), metaConfigFileLabelConstraints);
            this.jContentPane.add((Component)this.getMetaConfigFileUi(), metaConfigFileUiConstraints);
            this.jContentPane.add((Component)this.getDoMetaConfigFileSelBtn(), doMetaConfigFileSelBtnConstraints);
            this.jContentPane.add((Component)this.getJScrollPane(), logPaneConstraints);
            this.jContentPane.add((Component)this.getClearlogBtn(), clearlogBtnConstraints);
            this.jContentPane.add((Component)this.getAllObjectsAccessibleUi(), allObjectsAccessibleConstraints);
            this.jContentPane.add((Component)this.getDoValidateBtn(), doValidateConstraints);
        }
        return this.jContentPane;
    }

    private JLabel getXtfFileLabel() {
        if (this.xtfFileLabel == null) {
            this.xtfFileLabel = new JLabel();
            this.xtfFileLabel.setText(this.rsrc.getString("MainFrame.xtfFileLabel"));
        }
        return this.xtfFileLabel;
    }

    private JLabel getXtfRefFileLabel() {
        if (this.xtfRefFileLabel == null) {
            this.xtfRefFileLabel = new JLabel();
            this.xtfRefFileLabel.setText(this.rsrc.getString("MainFrame.xtfRefFileLabel"));
        }
        return this.xtfRefFileLabel;
    }

    private JLabel getModelNamesLabel() {
        if (this.modelNamesLabel == null) {
            this.modelNamesLabel = new JLabel();
            this.modelNamesLabel.setText(this.rsrc.getString("MainFrame.modelNamesLabel"));
        }
        return this.modelNamesLabel;
    }

    private JLabel getScopeLabel() {
        if (this.scopeLabel == null) {
            this.scopeLabel = new JLabel();
            this.scopeLabel.setText(this.rsrc.getString("MainFrame.scopeLabel"));
        }
        return this.scopeLabel;
    }

    private JLabel getConfigFileLabel() {
        if (this.configFileLabel == null) {
            this.configFileLabel = new JLabel();
            this.configFileLabel.setText(this.rsrc.getString("MainFrame.configFileLabel"));
        }
        return this.configFileLabel;
    }

    private JLabel getMetaConfigFileLabel() {
        if (this.metaConfigFileLabel == null) {
            this.metaConfigFileLabel = new JLabel();
            this.metaConfigFileLabel.setText(this.rsrc.getString("MainFrame.metaConfigFileLabel"));
        }
        return this.metaConfigFileLabel;
    }

    private JLabel getRefMappingFileLabel() {
        if (this.refMappingFileLabel == null) {
            this.refMappingFileLabel = new JLabel();
            this.refMappingFileLabel.setText(this.rsrc.getString("MainFrame.refMappingFileLabel"));
        }
        return this.refMappingFileLabel;
    }

    private JLabel getLogFileLabel() {
        if (this.logFileLabel == null) {
            this.logFileLabel = new JLabel();
            this.logFileLabel.setText(this.rsrc.getString("MainFrame.logFileLabel"));
        }
        return this.logFileLabel;
    }

    private JLabel getXtfLogFileLabel() {
        if (this.xtfLogFileLabel == null) {
            this.xtfLogFileLabel = new JLabel();
            this.xtfLogFileLabel.setText(this.rsrc.getString("MainFrame.xtfLogFileLabel"));
        }
        return this.xtfLogFileLabel;
    }

    private JTextArea getXtfFileUi() {
        if (this.xtfFileUi == null) {
            this.xtfFileUi = new JTextArea();
            new DropTarget(this.xtfFileUi, this.getXtfFileDragAndDropHandler());
        }
        return this.xtfFileUi;
    }

    private JTextArea getXtfRefFileUi() {
        if (this.xtfRefFileUi == null) {
            this.xtfRefFileUi = new JTextArea();
            new DropTarget(this.xtfRefFileUi, this.getXtfRefFileDragAndDropHandler());
        }
        return this.xtfRefFileUi;
    }

    private JTextField getModelNamesUi() {
        if (this.modelNamesUi == null) {
            this.modelNamesUi = new JTextField();
        }
        return this.modelNamesUi;
    }

    private JTextField getScopeUi() {
        if (this.scopeUi == null) {
            this.scopeUi = new JTextField();
        }
        return this.scopeUi;
    }

    private JTextField getRefMappingFileUi() {
        if (this.refMappingFileUi == null) {
            this.refMappingFileUi = new JTextField();
        }
        return this.refMappingFileUi;
    }

    private JTextField getConfigFileUi() {
        if (this.configFileUi == null) {
            this.configFileUi = new JTextField();
        }
        return this.configFileUi;
    }

    private JTextField getMetaConfigFileUi() {
        if (this.metaConfigFileUi == null) {
            this.metaConfigFileUi = new JTextField();
        }
        return this.metaConfigFileUi;
    }

    private JTextField getLogFileUi() {
        if (this.logFileUi == null) {
            this.logFileUi = new JTextField();
        }
        return this.logFileUi;
    }

    private JTextField getXtfLogFileUi() {
        if (this.xtfLogFileUi == null) {
            this.xtfLogFileUi = new JTextField();
        }
        return this.xtfLogFileUi;
    }

    private JTextArea getLogUi() {
        if (this.logUi == null) {
            this.logUi = new JTextArea();
            this.logUi.setEditable(false);
        }
        return this.logUi;
    }

    private JButton getClearlogBtn() {
        if (this.clearlogBtn == null) {
            this.clearlogBtn = new JButton();
            this.clearlogBtn.setText(this.rsrc.getString("MainFrame.clearLogButton"));
            this.clearlogBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this.logClear();
                }
            });
        }
        return this.clearlogBtn;
    }

    private JCheckBox getAllObjectsAccessibleUi() {
        if (this.allObjectsAccessibleUi == null) {
            this.allObjectsAccessibleUi = new JCheckBox();
            this.allObjectsAccessibleUi.setText(this.rsrc.getString("MainFrame.allObjectsAccessible"));
        }
        return this.allObjectsAccessibleUi;
    }

    private DropTargetListener getXtfFileDragAndDropHandler() {
        return new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent evt) {
            }

            @Override
            public void dragOver(DropTargetDragEvent evt) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent evt) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent evt) {
                try {
                    Transferable tr = evt.getTransferable();
                    for (DataFlavor flavor : tr.getTransferDataFlavors()) {
                        if (!flavor.isFlavorJavaFileListType()) continue;
                        evt.acceptDrop(3);
                        List files = (List)tr.getTransferData(flavor);
                        String[] absolutePaths = new String[files.size()];
                        for (int i = 0; i < files.size(); ++i) {
                            absolutePaths[i] = ((File)files.get(i)).getAbsolutePath();
                        }
                        MainFrame.this.setXtfFile(absolutePaths);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private DropTargetListener getXtfRefFileDragAndDropHandler() {
        return new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent evt) {
            }

            @Override
            public void dragOver(DropTargetDragEvent evt) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent evt) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent evt) {
                try {
                    Transferable tr = evt.getTransferable();
                    for (DataFlavor flavor : tr.getTransferDataFlavors()) {
                        if (!flavor.isFlavorJavaFileListType()) continue;
                        evt.acceptDrop(3);
                        List files = (List)tr.getTransferData(flavor);
                        String[] absolutePaths = new String[files.size()];
                        for (int i = 0; i < files.size(); ++i) {
                            absolutePaths[i] = ((File)files.get(i)).getAbsolutePath();
                        }
                        MainFrame.this.setXtfRefFile(absolutePaths);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public String[] getXtfFile() {
        String fileTextInUi = this.getXtfFileUi().getText();
        String[] files = MainFrame.splitFilenames(fileTextInUi);
        return files;
    }

    public String[] getXtfRefFile() {
        String fileTextInUi = this.getXtfRefFileUi().getText();
        String[] files = MainFrame.splitFilenames(fileTextInUi);
        return files;
    }

    public static String[] splitFilenames(String lines) {
        String[] dataFileParts = lines.split("\n");
        ArrayList<String> trimmedFileParts = new ArrayList<String>();
        for (String fileText : dataFileParts) {
            String trimmedText = fileText.trim();
            String retText = trimmedText.replace("\n", "");
            if (retText == null || retText.isEmpty() || retText.toString().length() <= 0) continue;
            trimmedFileParts.add(retText);
        }
        String[] partArr = trimmedFileParts.toArray(new String[0]);
        return partArr;
    }

    public void setXtfFile(String[] xtfFileList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (xtfFileList != null) {
            String newLine = "";
            for (int i = 0; i < xtfFileList.length; ++i) {
                if (xtfFileList[i] == null) continue;
                stringBuilder.append(newLine);
                stringBuilder.append(xtfFileList[i]);
                newLine = "\n";
            }
        }
        this.getXtfFileUi().setText(stringBuilder.toString());
    }

    public void setXtfRefFile(String[] xtfFileList) {
        StringBuilder stringBuilder = new StringBuilder();
        if (xtfFileList != null) {
            String newLine = "";
            for (int i = 0; i < xtfFileList.length; ++i) {
                if (xtfFileList[i] == null) continue;
                stringBuilder.append(newLine);
                stringBuilder.append(xtfFileList[i]);
                newLine = "\n";
            }
        }
        this.getXtfRefFileUi().setText(stringBuilder.toString());
    }

    public String getModelNames() {
        return StringUtility.purge((String)this.getModelNamesUi().getText());
    }

    public void setModelNames(String modelNames) {
        this.getModelNamesUi().setText(modelNames);
    }

    public String getScope() {
        return StringUtility.purge((String)this.getScopeUi().getText());
    }

    public void setScope(String modelNames) {
        this.getScopeUi().setText(modelNames);
    }

    public String getRefMappingFile() {
        return StringUtility.purge((String)this.getRefMappingFileUi().getText());
    }

    public void setRefMappingFile(String modelNames) {
        this.getRefMappingFileUi().setText(modelNames);
    }

    public String getConfigFile() {
        return StringUtility.purge((String)this.getConfigFileUi().getText());
    }

    public String getMetaConfigFile() {
        return StringUtility.purge((String)this.getMetaConfigFileUi().getText());
    }

    public boolean getObjectsAccessible() {
        boolean allObjectsAccessible = this.getAllObjectsAccessibleUi().isSelected();
        return allObjectsAccessible;
    }

    public void setObjectsAccessible(boolean allObjectsAccessible) {
        this.getAllObjectsAccessibleUi().setSelected(allObjectsAccessible);
    }

    public void setConfigFile(String dbhost) {
        this.getConfigFileUi().setText(dbhost);
    }

    public void setMetaConfigFile(String dbhost) {
        this.getMetaConfigFileUi().setText(dbhost);
    }

    public String getLogFile() {
        return StringUtility.purge((String)this.getLogFileUi().getText());
    }

    public void setLogFile(String logfile) {
        this.getLogFileUi().setText(logfile);
    }

    public String getXtfLogFile() {
        return StringUtility.purge((String)this.getXtfLogFileUi().getText());
    }

    public void setXtfLogFile(String xtflogfile) {
        this.getXtfLogFileUi().setText(xtflogfile);
    }

    public Settings getSettings() {
        String xtfRefFiles = Main.makeFileList(this.getXtfRefFile());
        String logFile = this.getLogFile();
        String datalogFile = this.getXtfLogFile();
        String configFile = this.getConfigFile();
        String metaConfigFile = this.getMetaConfigFile();
        String modelNames = this.getModelNames();
        String objectsAccess = this.getObjectsAccessible() ? "true" : "false";
        String scope = this.getScope();
        String refMappingFile = this.getRefMappingFile();
        String workingDir = this.settings.getValue("WORKING_DIRECTORY");
        String proxyHost = this.settings.getValue("ch.interlis.ili2c.http_proxy_host");
        String proxyPort = this.settings.getValue("ch.interlis.ili2c.http_proxy_port");
        String ilidirs = this.settings.getValue("org.interlis2.validator.ilidirs");
        String appHome = this.settings.getValue("org.interlis2.validator.appHome");
        Dimension dimension = this.getSize();
        String windowWidth = Integer.toString((int)dimension.getWidth());
        String windowHeight = Integer.toString((int)dimension.getHeight());
        Point origin = this.getLocation();
        String windowX = Integer.toString((int)origin.getX());
        String windowY = Integer.toString((int)origin.getY());
        Settings newSettings = new Settings();
        newSettings.setValue("org.interlis2.validator.refdata", xtfRefFiles);
        newSettings.setValue("WORKING_DIRECTORY", workingDir);
        newSettings.setValue("org.interlis2.validator.log", logFile);
        if (datalogFile != null && GenericFileFilter.createCsvFilter().getExtension().equals(GenericFileFilter.getFileExtension((String)datalogFile))) {
            newSettings.setValue("org.interlis2.validator.csvlog", datalogFile);
        } else {
            newSettings.setValue("org.interlis2.validator.xtflog", datalogFile);
        }
        newSettings.setValue("org.interlis2.validator.modelNames", modelNames);
        newSettings.setValue("org.interlis2.validator.configfile", configFile);
        newSettings.setValue("org.interlis2.validator.metaconfigfile", metaConfigFile);
        newSettings.setValue("org.interlis2.validator.validationScope", scope);
        newSettings.setValue("org.interlis2.validator.refmapping", refMappingFile);
        newSettings.setValue("org.interlis2.validator.allobjectsaccessible", objectsAccess);
        newSettings.setValue("org.interlis2.validator.ilidirs", ilidirs);
        newSettings.setValue("org.interlis2.validator.appHome", appHome);
        newSettings.setValue("ch.interlis.ili2c.http_proxy_host", proxyHost);
        newSettings.setValue("ch.interlis.ili2c.http_proxy_port", proxyPort);
        newSettings.setValue(WINDOW_WIDTH, windowWidth);
        newSettings.setValue(WINDOW_HEIGHT, windowHeight);
        newSettings.setValue(WINDOW_X, windowX);
        newSettings.setValue(WINDOW_Y, windowY);
        if (this.optionsSkipPolygonBuildingItem.isSelected()) {
            newSettings.setValue("ch.interlis.iox_j.validator.doItfLinetables", "doItfLinetables");
        }
        if (this.optionsMultiplicityOffItem.isSelected()) {
            newSettings.setValue(Validator.SETTING_MULTIPLICITY_VALIDATION, "off");
        }
        if (this.optionsAllowItfAreaHolesItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.allowitfareaholes", "true");
        }
        if (this.optionsSimpleBoundaryItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.simpleBoundary", "true");
        }
        if (this.optionsLogTimeItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.log.timestamp", "true");
        }
        if (this.optionsTraceItem.isSelected()) {
            EhiLogger.getInstance().setTraceFilter(false);
        } else {
            EhiLogger.getInstance().setTraceFilter(true);
        }
        if (this.optionsDisableConstraintValidationItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.disableconstraintvalidation", "true");
        }
        if (this.optionsDisableAreaValidationItem.isSelected()) {
            newSettings.setValue("org.interlis2.validator.disableareavalidation", "true");
        }
        return newSettings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void logAppend(String msg) {
        this.body.append(msg);
        if (!msg.endsWith("\n")) {
            this.body.append("\n");
        }
        this.getLogUi().setText(this.body.toString());
    }

    public void logClear() {
        this.body = new StringBuffer();
        this.getLogUi().setText(this.body.toString());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLogUi());
        }
        return this.jScrollPane;
    }

    @Deprecated
    public static void main(String[] xtfFile, Settings settings) {
        MainFrame.main(xtfFile, null, settings);
    }

    public static void main(String[] xtfFile, String[] xtfRefFile, Settings settings) {
        MainFrame frame = new MainFrame();
        frame.setSettings(settings);
        String logFile = settings.getValue("org.interlis2.validator.log");
        frame.setLogFile(logFile);
        MainFrame.resetLogListener(frame, logFile);
        frame.setXtfFile(xtfFile);
        if (xtfRefFile != null) {
            frame.setXtfRefFile(xtfRefFile);
        }
        String modelList = settings.getValue("org.interlis2.validator.modelNames");
        frame.setModelNames(modelList);
        String xtflogFile = settings.getValue("org.interlis2.validator.xtflog");
        frame.setXtfLogFile(xtflogFile);
        String configFile = settings.getValue("org.interlis2.validator.configfile");
        frame.setConfigFile(configFile);
        String metaConfigFile = settings.getValue("org.interlis2.validator.metaconfigfile");
        frame.setMetaConfigFile(metaConfigFile);
        frame.setObjectsAccessible("true".equals(settings.getValue("org.interlis2.validator.allobjectsaccessible")));
        MainFrame.restoreWindowSizeAndLocation(frame, settings);
        frame.show();
    }

    private static void resetLogListener(MainFrame frame, String logFile) {
        if (frame.logListener != null) {
            EhiLogger.getInstance().removeListener((ch.ehi.basics.logging.LogListener)frame.logListener);
        }
        frame.logListener = new LogListener(frame, logFile);
        EhiLogger.getInstance().addListener((ch.ehi.basics.logging.LogListener)frame.logListener);
    }

    private static void restoreWindowSizeAndLocation(JFrame frame, Settings settings) {
        try {
            int width = Integer.parseInt(settings.getValue(WINDOW_WIDTH));
            int height = Integer.parseInt(settings.getValue(WINDOW_HEIGHT));
            int x = Integer.parseInt(settings.getValue(WINDOW_X));
            int y = Integer.parseInt(settings.getValue(WINDOW_Y));
            frame.setSize(width, height);
            if (MainFrame.isLocationOnScreen(x, y)) {
                frame.setLocation(x, y);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static boolean isLocationOnScreen(int x, int y) {
        for (GraphicsDevice screen : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Rectangle bounds = screen.getDefaultConfiguration().getBounds();
            if (!bounds.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    private JButton getDoValidateBtn() {
        if (this.doValidateBtn == null) {
            this.doValidateBtn = new JButton();
            this.doValidateBtn.setText(this.rsrc.getString("MainFrame.doValidateButton"));
            this.doValidateBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker worker = new SwingWorker(){

                        public Object construct() {
                            try {
                                boolean ret = Validator.runValidation(MainFrame.this.getXtfFile(), MainFrame.this.getSettings());
                                MainFrame.resetLogListener(MainFrame.this, MainFrame.this.getLogFile());
                                MainFrame.this.getLogUi().setCaretPosition(MainFrame.this.getLogUi().getDocument().getLength());
                                Toolkit.getDefaultToolkit().beep();
                                JOptionPane.showMessageDialog(MainFrame.this, ret ? "...validation done" : "...validation failed");
                            }
                            catch (Exception ex) {
                                EhiLogger.logError((String)MainFrame.this.rsrc.getString("MainFrame.generalError"), (Throwable)ex);
                            }
                            return null;
                        }
                    };
                    worker.start();
                }
            });
        }
        return this.doValidateBtn;
    }

    private JButton getDoXtfFileSelBtn() {
        if (this.doXtfFileSelBtn == null) {
            this.doXtfFileSelBtn = new JButton();
            this.doXtfFileSelBtn.setText("...");
            this.doXtfFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser fileDialog = new FileChooser();
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtfFileChooserTitle"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.itfFileFilter"), "itf"));
                    fileDialog.addChoosableFileFilter((FileFilter)GenericFileFilter.createXmlFilter());
                    FileNameExtensionFilter filter = new FileNameExtensionFilter(MainFrame.this.rsrc.getString("MainFrame.xtfFileFilter"), "xtf", "xml");
                    fileDialog.setFileFilter((FileFilter)filter);
                    fileDialog.setMultiSelectionEnabled(true);
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        File[] multipleFiles = fileDialog.getSelectedFiles();
                        String[] selectedFiles = new String[multipleFiles.length];
                        for (int i = 0; i < multipleFiles.length; ++i) {
                            selectedFiles[i] = multipleFiles[i].getAbsolutePath();
                        }
                        MainFrame.this.setXtfFile(selectedFiles);
                    }
                }
            });
        }
        return this.doXtfFileSelBtn;
    }

    private JButton getDoXtfRefFileSelBtn() {
        if (this.doXtfRefFileSelBtn == null) {
            this.doXtfRefFileSelBtn = new JButton();
            this.doXtfRefFileSelBtn.setText("...");
            this.doXtfRefFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileChooser fileDialog = new FileChooser();
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtfFileChooserTitle"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.itfFileFilter"), "itf"));
                    fileDialog.addChoosableFileFilter((FileFilter)GenericFileFilter.createXmlFilter());
                    FileNameExtensionFilter filter = new FileNameExtensionFilter(MainFrame.this.rsrc.getString("MainFrame.xtfFileFilter"), "xtf", "xml");
                    fileDialog.setFileFilter((FileFilter)filter);
                    fileDialog.setMultiSelectionEnabled(true);
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        File[] multipleFiles = fileDialog.getSelectedFiles();
                        String[] selectedFiles = new String[multipleFiles.length];
                        for (int i = 0; i < multipleFiles.length; ++i) {
                            selectedFiles[i] = multipleFiles[i].getAbsolutePath();
                        }
                        MainFrame.this.setXtfRefFile(selectedFiles);
                    }
                }
            });
        }
        return this.doXtfRefFileSelBtn;
    }

    private JButton getDoLogFileSelBtn() {
        if (this.doLogFileSelBtn == null) {
            this.doLogFileSelBtn = new JButton();
            this.doLogFileSelBtn.setText("...");
            this.doLogFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.logFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.logFileFilter"), "log"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.txtFileFilter"), "txt"));
                    if (fileDialog.showSaveDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setLogFile(file);
                    }
                }
            });
        }
        return this.doLogFileSelBtn;
    }

    private JButton getDoXtfLogFileSelBtn() {
        if (this.doXtfLogFileSelBtn == null) {
            this.doXtfLogFileSelBtn = new JButton();
            this.doXtfLogFileSelBtn.setText("...");
            this.doXtfLogFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtflogFileChooserTitle"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.xtfFileFilter"), "xtf"));
                    fileDialog.setFileFilter((FileFilter)GenericFileFilter.createCsvFilter());
                    if (fileDialog.showSaveDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setXtfLogFile(file);
                    }
                }
            });
        }
        return this.doXtfLogFileSelBtn;
    }

    private JButton getNewConfigFileBtn() {
        if (this.doNewConfigFileBtn == null) {
            this.doNewConfigFileBtn = new JButton();
            this.doNewConfigFileBtn.setText("new..");
            this.doNewConfigFileBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getLogFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.xtflogFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)MainFrame.this.createConfigFileFilter());
                    if (fileDialog.showSaveDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setConfigFile(file);
                        this.writeNewConfigFile(file);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void writeNewConfigFile(String file) {
                    BufferedWriter writer = null;
                    if (file != null) {
                        try {
                            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine1"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine2"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine3"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine4"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine5"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine6"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine7"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine8"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine9"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine10"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine11"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine12"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine13"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine14"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine15"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine16"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine17"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine18"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine19"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine20"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine21"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine22"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine23"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine24"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine25"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine26"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine27"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine28"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine29"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine30"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine31"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine32"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine33"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine34"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine35"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine36"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine37"));
                            writer.write(MainFrame.this.rsrc.getString("MainFrame.ConfigFileLine38"));
                        }
                        catch (IOException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                        finally {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    EhiLogger.logError((Throwable)e);
                                }
                            }
                        }
                    }
                }
            });
        }
        return this.doNewConfigFileBtn;
    }

    private JButton getDoConfigFileSelBtn() {
        if (this.doConfigFileSelBtn == null) {
            this.doConfigFileSelBtn = new JButton();
            this.doConfigFileSelBtn.setText("...");
            this.doConfigFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getConfigFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.configFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)MainFrame.this.createConfigFileFilter());
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setConfigFile(file);
                    }
                }
            });
        }
        return this.doConfigFileSelBtn;
    }

    private JButton getDoMetaConfigFileSelBtn() {
        if (this.doMetaConfigFileSelBtn == null) {
            this.doMetaConfigFileSelBtn = new JButton();
            this.doMetaConfigFileSelBtn.setText("...");
            this.doMetaConfigFileSelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getMetaConfigFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.metaConfigFileChooserTitle"));
                    fileDialog.setFileFilter((FileFilter)MainFrame.this.createMetaConfigFileFilter());
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setMetaConfigFile(file);
                    }
                }
            });
        }
        return this.doMetaConfigFileSelBtn;
    }

    private JButton getDoRefMappingFileBtn() {
        if (this.doRefMappingFileBtn == null) {
            this.doRefMappingFileBtn = new JButton();
            this.doRefMappingFileBtn.setText("...");
            this.doRefMappingFileBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String file = MainFrame.this.getRefMappingFile();
                    FileChooser fileDialog = new FileChooser(file);
                    fileDialog.setCurrentDirectory(new File(MainFrame.this.getWorkingDirectory()));
                    fileDialog.setDialogTitle(MainFrame.this.rsrc.getString("MainFrame.refMappingFileChooserTitle"));
                    fileDialog.addChoosableFileFilter((FileFilter)new GenericFileFilter(MainFrame.this.rsrc.getString("MainFrame.xtfFileFilter"), "xtf"));
                    if (fileDialog.showOpenDialog((Component)MainFrame.this) == 0) {
                        MainFrame.this.setWorkingDirectory(fileDialog.getCurrentDirectory().getAbsolutePath());
                        file = fileDialog.getSelectedFile().getAbsolutePath();
                        MainFrame.this.setRefMappingFile(file);
                    }
                }
            });
        }
        return this.doRefMappingFileBtn;
    }

    private GenericFileFilter createConfigFileFilter() {
        return new GenericFileFilter(this.rsrc.getString("MainFrame.configFileFilter"), "ini");
    }

    private GenericFileFilter createMetaConfigFileFilter() {
        return new GenericFileFilter(this.rsrc.getString("MainFrame.metaConfigFileFilter"), "ini");
    }

    private String getWorkingDirectory() {
        String wd = this.settings.getValue("WORKING_DIRECTORY");
        if (wd == null) {
            wd = new File(".").getAbsolutePath();
        }
        return wd;
    }

    private void setWorkingDirectory(String workingDirectory) {
        this.settings.setValue("WORKING_DIRECTORY", workingDirectory);
    }
}

